/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkClearLinkReference$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.TaskDescription;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u0011#\u0001%B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!IA\n\u0001B\u0001B\u0003%Q\n\u0015\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!!\u0007A!A!\u0002\u0013)\u0007\"C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027s\u0011%\u0019\bA!A!\u0002\u0013!\b\u0010C\u0005z\u0001\t\u0005\t\u0015!\u0003{{\"Aq\u0010\u0001B\u0001B\u0003%!\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u0013\u0005u\u0001A1A\u0005\n\u0005}\u0001\u0002CA\u0017\u0001\u0001\u0006I!!\t\t\u0013\u0005=\u0002\u00011A\u0005\n\u0005E\u0002\"CA\u001d\u0001\u0001\u0007I\u0011BA\u001e\u0011!\t\t\u0005\u0001Q!\n\u0005M\u0002bBA\"\u0001\u0011E\u0013Q\t\u0005\b\u00037\u0002A\u0011BA#\u0011\u001d\ti\u0006\u0001C\u0005\u0003?Bq!!\u0018\u0001\t\u0013\t)\bC\u0004\u0002\u0002\u0002!I!!\u0012\t\u000f\u0005\u0005\u0005\u0001\"\u0015\u0002\u0004\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0002bBAI\u0001\u0011\u0005\u00131S\u0004\b\u0003;\u0013\u0003\u0012AAP\r\u0019\t#\u0005#\u0001\u0002\"\"9\u0011\u0011A\u000e\u0005\u0002\u0005M\u0006\u0002CA[7\u0011\u0005!%a.\t\u0011\u0005u6\u0004\"\u0001#\u0003\u007fC\u0011\"a3\u001c#\u0003%\t!!4\t\u0013\u0005\r8$%A\u0005\u0002\u00055'!H\"mkN$XM\u001d'j].\u001cE.Z1s\u0019&t7NU3gKJ,gnY3\u000b\u0005\r\"\u0013\u0001\u00027j].T!!\n\u0014\u0002\rM,'O^3s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"aK\u0018\u000f\u00051jS\"\u0001\u0012\n\u00059\u0012\u0013\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u00021c\ta\u0001+\u001a:j_\u0012L7\rV1tW*\u0011aFI\u0001\u0007Y&t7.\u00133\u0011\u0005QbT\"A\u001b\u000b\u0005Y:\u0014AB2p[6|gN\u0003\u0002(q)\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h\u0013\tiTG\u0001\u0003Vk&$\u0017\u0001\u00037j].t\u0015-\\3\u0011\u0005\u0001KeBA!H!\t\u0011U)D\u0001D\u0015\t!\u0005&\u0001\u0004=e>|GO\u0010\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*R\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002I\u000b\u0006I1o\u00195fIVdWM\u001d\t\u0003Y9K!a\u0014\u0012\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\tau&A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s!\ta3+\u0003\u0002UE\tQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006Q\u0011-\u001e;i_JL'0\u001a:\u0011\u0007]C&,D\u0001F\u0013\tIVI\u0001\u0004PaRLwN\u001c\t\u00037zk\u0011\u0001\u0018\u0006\u0003+vS!!J\u001c\n\u0005}c&AC!vi\"|'/\u001b>fe\u0006yAn\\2bY\n\u000bGo\u00195BI6Lg\u000e\u0005\u0002-E&\u00111M\t\u0002\u0016\u00072,8\u000f^3s\u0019&t7NQ1uG\"\fE-\\5o\u0003I\u0019w.\u001c9mKRLwN\\\"bY2\u0014\u0017mY6\u0011\u0007]3\u0007.\u0003\u0002h\u000b\nIa)\u001e8di&|g\u000e\r\t\u0003/&L!A[#\u0003\tUs\u0017\u000e^\u0001\u0005i&lW\r\u0005\u0002na6\taN\u0003\u0002pk\u0005)Q\u000f^5mg&\u0011\u0011O\u001c\u0002\u0005)&lW-\u0003\u0002l_\u0005)\u0011/^8uCB\u0011QO^\u0007\u0002I%\u0011q\u000f\n\u0002\u0018\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cH/U;pi\u0006L!a]\u0018\u0002\u0015%tG/\u001a:wC2l5\u000f\u0005\u0002Xw&\u0011A0\u0012\u0002\u0004\u0013:$\u0018B\u0001@0\u0003E\u0011Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u0001\re\u0016$(/\u001f#fY\u0006LXj]\u0001\u0007y%t\u0017\u000e\u001e \u00151\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\u0002\u0005\u0002-\u0001!)!\u0007\u0004a\u0001g!)a\b\u0004a\u0001\u007f!)A\n\u0004a\u0001\u001b\")\u0011\u000b\u0004a\u0001%\")Q\u000b\u0004a\u0001-\")\u0001\r\u0004a\u0001C\")A\r\u0004a\u0001K\")1\u000e\u0004a\u0001Y\")1\u000f\u0004a\u0001i\"9\u0011\u0010\u0004I\u0001\u0002\u0004Q\bbB@\r!\u0003\u0005\rA_\u0001\u000bY&t7NR5mi\u0016\u0014XCAA\u0011!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014k\u0005\u0019\u0011m\u00197\n\t\u0005-\u0012Q\u0005\u0002\u0019\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018PR5mi\u0016\u0014\u0018a\u00037j].4\u0015\u000e\u001c;fe\u0002\n1\"\u001e9eCR,G-Q2mgV\u0011\u00111\u0007\t\u0004/\u0006U\u0012bAA\u001c\u000b\n9!i\\8mK\u0006t\u0017aD;qI\u0006$X\rZ!dYN|F%Z9\u0015\u0007!\fi\u0004C\u0005\u0002@A\t\t\u00111\u0001\u00024\u0005\u0019\u0001\u0010J\u0019\u0002\u0019U\u0004H-\u0019;fI\u0006\u001bGn\u001d\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0002HA!\u0011\u0011JA,\u001d\r\tY%\f\b\u0005\u0003\u001b\n)F\u0004\u0003\u0002P\u0005Mcb\u0001\"\u0002R%\tq%\u0003\u0002&M%\u00111\u0005J\u0005\u0004\u00033\n$A\u0003+bg.\u0014Vm];mi\u0006Y\u0001O]8dKN\u001c\u0018i\u00197t\u0003U\u0019G.Z1s\u0019&t7.Q2mg\u000e{W\u000e\u001d7fi\u0016$B!a\u0012\u0002b!9\u00111\r\u000bA\u0002\u0005\u0015\u0014\u0001E2sK\u0006$X-Q2mgJ+7/\u001e7u!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nQ!\u00193nS:T1!a\u001c8\u0003\u001d\u0019G.[3oiNLA!a\u001d\u0002j\t\u00012I]3bi\u0016\f5\r\\:SKN,H\u000e\u001e\u000b\u0005\u0003\u000f\n9\bC\u0004\u0002zU\u0001\r!a\u001f\u0002!\u0011,G.\u001a;f\u0003\u000ed7OU3tk2$\b\u0003BA4\u0003{JA!a \u0002j\t\u0001B)\u001a7fi\u0016\f5\r\\:SKN,H\u000e^\u0001\r_:\u001cu.\u001c9mKRLwN\u001c\u000b\u0004Q\u0006\u0015\u0005bBAD/\u0001\u0007\u0011\u0011R\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0007-\nY)C\u0002\u0002\u000eF\u00121cQ8na2,G/\u001a3UCN\\'+Z:vYR\fabZ3u+B$\u0017\r^3e\u0003\u000ed7/A\buCN\\G)Z:de&\u0004H/[8o)\t\t)\n\u0005\u0003X1\u0006]\u0005c\u0001\u0017\u0002\u001a&\u0019\u00111\u0014\u0012\u0003\u001fQ\u000b7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQd\u00117vgR,'\u000fT5oW\u000ecW-\u0019:MS:\\'+\u001a4fe\u0016t7-\u001a\t\u0003Ym\u0019RaGAR\u0003S\u00032aVAS\u0013\r\t9+\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005-\u0016qV\u0007\u0003\u0003[S!a\u001c\u0014\n\t\u0005E\u0016Q\u0016\u0002\b\u0019><w-\u001b8h)\t\ty*\u0001\fiC:$G.\u001a#fY\u0016$X-Q2mgJ+7/\u001e7u)\u0019\t\u0019$!/\u0002<\"9\u0011\u0011P\u000fA\u0002\u0005m\u0004\"\u0002 \u001e\u0001\u0004y\u0014A\u00065b]\u0012dWm\u0011:fCR,\u0017i\u00197t%\u0016\u001cX\u000f\u001c;\u0015\r\u0005\u0005\u0017qYAe!\u00199\u00161YA\u001au&\u0019\u0011QY#\u0003\rQ+\b\u000f\\33\u0011\u001d\t\u0019G\ba\u0001\u0003KBQA\u0010\u0010A\u0002}\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0002P*\u001a!0!5,\u0005\u0005M\u0007\u0003BAk\u0003?l!!a6\u000b\t\u0005e\u00171\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!8F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\f9NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014\u0007")
public class ClusterLinkClearLinkReference
extends ClusterLinkScheduler.PeriodicTask {
    private final String linkName;
    private final ClusterLinkMetadataManager metadataManager;
    private final Option<Authorizer> authorizer;
    private final ClusterLinkBatchAdmin localBatchAdmin;
    private final Function0<BoxedUnit> completionCallback;
    private final int retryDelayMs;
    private final AccessControlEntryFilter linkFilter;
    private boolean updatedAcls;

    public static int $lessinit$greater$default$11() {
        return ClusterLinkClearLinkReference$.MODULE$.$lessinit$greater$default$11();
    }

    public static int $lessinit$greater$default$10() {
        return ClusterLinkClearLinkReference$.MODULE$.$lessinit$greater$default$10();
    }

    private AccessControlEntryFilter linkFilter() {
        return this.linkFilter;
    }

    private boolean updatedAcls() {
        return this.updatedAcls;
    }

    private void updatedAcls_$eq(boolean x$1) {
        this.updatedAcls = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkMetadataManager clusterLinkMetadataManager = this.metadataManager;
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithKRaftSupport) {
            if (!this.updatedAcls() && this.authorizer.nonEmpty()) {
                return this.processAcls();
            }
            this.updatedAcls_$eq(true);
            return this.onCompletion();
        }
        if (clusterLinkMetadataManager != null) {
            throw new IllegalStateException("Unsupported type of ClusterLinkMetadataManager");
        }
        throw new MatchError(clusterLinkMetadataManager);
    }

    private ClusterLinkScheduler.TaskResult processAcls() {
        this.authorizer.foreach((Function1<Authorizer, Object> & Serializable)authz -> {
            Iterable<AclBinding> linkAcls = CollectionConverters$.MODULE$.IterableHasAsScala(authz.acls(new AclBindingFilter(ResourcePatternFilter.ANY, this.linkFilter()))).asScala();
            Iterable aclsToAdd = (Iterable)linkAcls.filterNot((Function1<AclBinding, Object> & Serializable)acl -> BoxesRunTime.boxToBoolean(ClusterLinkClearLinkReference.$anonfun$processAcls$2(acl)));
            if (linkAcls.isEmpty()) {
                this.updatedAcls_$eq(true);
                return this.onCompletion();
            }
            if (aclsToAdd.nonEmpty()) {
                List<AclBinding> localAcls = CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)aclsToAdd.map((Function1<AclBinding, AclBinding> & Serializable)acl -> {
                    AccessControlEntry ace = new AccessControlEntry(acl.entry().principal(), acl.entry().host(), acl.entry().operation(), acl.entry().permissionType());
                    return new AclBinding(acl.pattern(), ace);
                })).toList()).asJava();
                CreateAclsResult createAclResult = $this.localBatchAdmin.createAcls(localAcls);
                Iterable createAclsFuture = CollectionConverters$.MODULE$.MapHasAsScala(createAclResult.values()).asScala().values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])createAclsFuture.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)x$1 -> this.clearLinkAclsComplete(createAclResult), new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty())));
                return BoxedUnit.UNIT;
            }
            List<AclBindingFilter> aclsToRemove = CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)linkAcls.map((Function1<AclBinding, AclBindingFilter> & Serializable)acl -> SecurityUtils.aclWithClusterLinkIds(acl, this.linkFilter().clusterLinkIds()).toFilter())).toList()).asJava();
            DeleteAclsResult deleteAclsResult = $this.localBatchAdmin.deleteAcls(aclsToRemove);
            Iterable deleteAclsResultFutures = CollectionConverters$.MODULE$.MapHasAsScala(deleteAclsResult.values()).asScala().values();
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)x$2 -> this.clearLinkAclsComplete(deleteAclsResult), new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty())));
            return BoxedUnit.UNIT;
        });
        if (this.updatedAcls()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
        }
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult clearLinkAclsComplete(CreateAclsResult createAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleCreateAclsResult(createAclsResult, this.linkName)._1$mcZ$sp();
        this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)x$3 -> this.processAcls(), new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty())), success ? 0L : (long)this.retryDelayMs);
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult clearLinkAclsComplete(DeleteAclsResult deleteAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult, this.linkName);
        this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)x$4 -> this.processAcls(), new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty())), success ? 0L : (long)this.retryDelayMs);
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult onCompletion() {
        this.shutdown();
        super.scheduler().scheduleOnce("ClearLinkReferenceCompleted", () -> $this.completionCallback.apply$mcV$sp());
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
    }

    public boolean getUpdatedAcls() {
        return this.updatedAcls();
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$processAcls$2(AclBinding acl) {
        return acl.entry().clusterLinkIds().contains(Uuid.ZERO_UUID);
    }

    public ClusterLinkClearLinkReference(Uuid linkId, String linkName, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Option<Authorizer> authorizer, ClusterLinkBatchAdmin localBatchAdmin, Function0<BoxedUnit> completionCallback, Time time, ClusterLinkRequestQuota quota, int intervalMs, int retryDelayMs) {
        this.linkName = linkName;
        this.metadataManager = metadataManager;
        this.authorizer = authorizer;
        this.localBatchAdmin = localBatchAdmin;
        this.completionCallback = completionCallback;
        this.retryDelayMs = retryDelayMs;
        super(scheduler, "ClearLinkReference", intervalMs, time, quota);
        this.linkFilter = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, Collections.singleton(linkId));
        this.updatedAcls = false;
    }
}

