/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.FetcherPool;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkChannelContext;
import kafka.server.link.ClusterLinkClientType$Fetcher$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherWithSharedThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.SharedFetcherTag;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001\u0002\u000e\u001c\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011E\u0003!\u0011!Q\u0001\nIC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005;\")\u0011\u000e\u0001C\u0001U\"9Q\u000f\u0001b\u0001\n\u00031\bbBA\u0006\u0001\u0001\u0006Ia\u001e\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0001\u0004%I!!\u0007\t\u0011\u0005\u0015\u0002\u0001)Q\u0005\u0003#A\u0011\"a\f\u0001\u0001\u0004%I!!\r\t\u0013\u0005M\u0002\u00011A\u0005\n\u0005U\u0002bBA\u001d\u0001\u0001\u0006K!\u0011\u0005\t\u0003{\u0001A\u0011A\u000e\u0002@!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0003bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!!#\u0001\t#\tY\tC\u0004\u0002\u0012\u0002!I!a%\u00039\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM\u001d+ie\u0016\fG\rU8pY*\u0011A$H\u0001\u0005Y&t7N\u0003\u0002\u001f?\u000511/\u001a:wKJT\u0011\u0001I\u0001\u0006W\u000647.Y\u0002\u0001'\r\u00011%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)jS\"A\u0016\u000b\u00051z\u0012!B;uS2\u001c\u0018B\u0001\u0018,\u0005\u001daunZ4j]\u001e\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"!\r\u001a\u000e\u0003uI!aM\u000f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\tY&t7NT1nKB\u0011a'\u0010\b\u0003om\u0002\"\u0001O\u0013\u000e\u0003eR!AO\u0011\u0002\rq\u0012xn\u001c;?\u0013\taT%\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f&\u00035Ig.\u001b;jC2\u001cuN\u001c4jOB\u0011!iQ\u0007\u00027%\u0011Ai\u0007\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017!E2p]:,7\r^5p]6\u000bg.Y4feB\u0011!iR\u0005\u0003\u0011n\u0011Ad\u00117vgR,'\u000fT5oW\u000e{gN\\3di&|g.T1oC\u001e,'/\u0001\ndYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\bC\u0001\"L\u0013\ta5D\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018aF:fY\u0016\u001cGo\u001c:NKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z!\t\u0011u*\u0003\u0002Q7\t\u00113\t\\;ti\u0016\u0014H*\u001b8l'\u0016dWm\u0019;pe6+GO]5dgJ+w-[:uef\fQ!];pi\u0006\u0004\"!M*\n\u0005Qk\"aF\"mkN$XM\u001d'j].\u0014V-];fgR\fVo\u001c;b\u0003e\u0019G.^:uKJd\u0015N\\6DQ\u0006tg.\u001a7D_:$X\r\u001f;\u0011\u0007\u0011:\u0016,\u0003\u0002YK\t1q\n\u001d;j_:\u0004\"A\u0011.\n\u0005m[\"!G\"mkN$XM\u001d'j].\u001c\u0005.\u00198oK2\u001cuN\u001c;fqR\fA\u0001^5nKB\u0011alZ\u0007\u0002?*\u0011A\u0006\u0019\u0006\u0003C\n\faaY8n[>t'B\u0001\u0011d\u0015\t!W-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0006\u0019qN]4\n\u0005!|&\u0001\u0002+j[\u0016\fa\u0001P5oSRtDCC6m[:|\u0007/\u001d:tiB\u0011!\t\u0001\u0005\u0006_)\u0001\r\u0001\r\u0005\u0006i)\u0001\r!\u000e\u0005\u0006\u0001*\u0001\r!\u0011\u0005\u0006\u000b*\u0001\rA\u0012\u0005\u0006\u0013*\u0001\rA\u0013\u0005\u0006\u001b*\u0001\rA\u0014\u0005\u0006#*\u0001\rA\u0015\u0005\u0006+*\u0001\rA\u0016\u0005\u00069*\u0001\r!X\u0001\u000bi\"\u0014X-\u00193Q_>dW#A<\u0011\u000balx0!\u0002\u000e\u0003eT!A_>\u0002\u000f5,H/\u00192mK*\u0011A0J\u0001\u000bG>dG.Z2uS>t\u0017B\u0001@z\u0005\ri\u0015\r\u001d\t\u0004\u0005\u0006\u0005\u0011bAA\u00027\t\u00012\u000b[1sK\u00124U\r^2iKJ$\u0016m\u001a\t\u0004\u0005\u0006\u001d\u0011bAA\u00057\tq2\t\\;ti\u0016\u0014H*\u001b8l'\"\f'/\u001a3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\fi\"\u0014X-\u00193Q_>d\u0007%\u0001\u0005jg\u0006\u001bG/\u001b<f+\t\t\t\u0002E\u0002%\u0003'I1!!\u0006&\u0005\u001d\u0011un\u001c7fC:\fA\"[:BGRLg/Z0%KF$B!a\u0007\u0002\"A\u0019A%!\b\n\u0007\u0005}QE\u0001\u0003V]&$\b\"CA\u0012\u001d\u0005\u0005\t\u0019AA\t\u0003\rAH%M\u0001\nSN\f5\r^5wK\u0002B3aDA\u0015!\r!\u00131F\u0005\u0004\u0003[)#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002#\rdWo\u001d;fe2Kgn[\"p]\u001aLw-F\u0001B\u0003U\u0019G.^:uKJd\u0015N\\6D_:4\u0017nZ0%KF$B!a\u0007\u00028!A\u00111E\t\u0002\u0002\u0003\u0007\u0011)\u0001\ndYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004\u0003f\u0001\n\u0002*\u0005Y!/Z2p]\u001aLw-\u001e:f)\u0019\tY\"!\u0011\u0002F!1\u00111I\nA\u0002\u0005\u000b\u0011B\\3x\u0007>tg-[4\t\u000f\u0005\u001d3\u00031\u0001\u0002J\u0005YQ\u000f\u001d3bi\u0016$7*Z=t!\u0015\tY%!\u00146\u001b\u0005Y\u0018bAA(w\n\u00191+\u001a;\u0002\u0019\u0005\u001c8/[4o)\"\u0014X-\u00193\u0015\u0011\u0005\u0015\u0011QKA0\u0003SBq!a\u0016\u0015\u0001\u0004\tI&A\u0005gKR\u001c\u0007.\u001a:JIB\u0019A%a\u0017\n\u0007\u0005uSEA\u0002J]RDq!!\u0019\u0015\u0001\u0004\t\u0019'A\u0006gKR\u001c\u0007.\u001a:Q_>d\u0007cA\u0019\u0002f%\u0019\u0011qM\u000f\u0003\u0017\u0019+Go\u00195feB{w\u000e\u001c\u0005\b\u0003W\"\u0002\u0019AA-\u00039\u0019x.\u001e:dK\n\u0013xn[3s\u0013\u0012\fQB]3n_Z,g)\u001a;dQ\u0016\u0014H\u0003CA\u000e\u0003c\n\u0019(! \t\u000f\u0005-T\u00031\u0001\u0002Z!9\u0011QO\u000bA\u0002\u0005]\u0014a\u00024fi\u000eDWM\u001d\t\u0004\u0005\u0006e\u0014bAA>7\t\u00113\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s/&$\bn\u00155be\u0016$G\u000b\u001b:fC\u0012Dq!a \u0016\u0001\u0004\t)!\u0001\u0004uQJ,\u0017\rZ\u0001\tg\",H\u000fZ8x]R\u0011\u00111D\u0001\u0010I\u0016\fG\r\u00165sK\u0006$7i\\;oiV\u0011\u0011\u0011L\u0001\u001aGJ,\u0017\r^3TQ\u0006\u0014X\r\u001a$fi\u000eDWM\u001d+ie\u0016\fG\r\u0006\u0003\u0002\u0006\u00055\u0005BBAH1\u0001\u0007q0\u0001\ttQ\u0006\u0014X\r\u001a$fi\u000eDWM\u001d+bO\u0006\u00192M]3bi\u0016tU\r^<pe.\u001cE.[3oiR!\u0011QSAN!\r\u0011\u0015qS\u0005\u0004\u00033[\"\u0001G\"mkN$XM\u001d'j].tU\r^<pe.\u001cE.[3oi\"1\u0011qR\rA\u0002}\u0004")
public class ClusterLinkFetcherThreadPool
implements Logging {
    private final KafkaConfig brokerConfig;
    private final String linkName;
    private final ClusterLinkConnectionManager connectionManager;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry;
    private final ClusterLinkRequestQuota quota;
    private final Option<ClusterLinkChannelContext> clusterLinkChannelContext;
    private final Time time;
    private final scala.collection.mutable.Map<SharedFetcherTag, ClusterLinkSharedFetcherThread> threadPool;
    private volatile boolean isActive;
    private volatile ClusterLinkConfig clusterLinkConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkFetcherThreadPool clusterLinkFetcherThreadPool = this;
        synchronized (clusterLinkFetcherThreadPool) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public scala.collection.mutable.Map<SharedFetcherTag, ClusterLinkSharedFetcherThread> threadPool() {
        return this.threadPool;
    }

    private boolean isActive() {
        return this.isActive;
    }

    private void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return this.clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.clusterLinkConfig = x$1;
    }

    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        this.debug((Function0<String> & Serializable)() -> "Reconfiguring cluster link fetcher thread pool for link " + $this.linkName + " with newConfig " + newConfig + " updatedKeys " + updatedKeys);
        this.clusterLinkConfig_$eq(newConfig);
    }

    public ClusterLinkSharedFetcherThread assignThread(int fetcherId, FetcherPool fetcherPool, int sourceBrokerId) {
        ClusterLinkSharedFetcherThread thread;
        block4: {
            ClusterLinkSharedFetcherThread clusterLinkSharedFetcherThread;
            BooleanRef isNewThread = BooleanRef.create(false);
            SharedFetcherTag sharedFetcherTag = new SharedFetcherTag(fetcherId, fetcherPool);
            ClusterLinkFetcherThreadPool clusterLinkFetcherThreadPool = this;
            synchronized (clusterLinkFetcherThreadPool) {
                if (!this.isActive()) {
                    throw new IllegalStateException("Cluster link thread pool is no longer active");
                }
                clusterLinkSharedFetcherThread = (ClusterLinkSharedFetcherThread)this.threadPool().getOrElseUpdate(sharedFetcherTag, (Function0<ClusterLinkSharedFetcherThread> & Serializable)() -> {
                    isNewThread$1.elem = true;
                    return this.createSharedFetcherThread(sharedFetcherTag);
                });
            }
            thread = clusterLinkSharedFetcherThread;
            this.debug((Function0<String> & Serializable)() -> "Assigned " + (isNewThread$1.elem ? "new" : "existing") + " shared fetcher thread with tag " + sharedFetcherTag + " to source broker " + sourceBrokerId);
            if (!isNewThread.elem) break block4;
            thread.start();
        }
        return thread;
    }

    public void removeFetcher(int sourceBrokerId, ClusterLinkFetcherWithSharedThread fetcher, ClusterLinkSharedFetcherThread thread) {
        boolean bl;
        this.debug((Function0<String> & Serializable)() -> "Removing fetcher " + fetcher);
        thread.removeFetcher(sourceBrokerId, fetcher);
        ClusterLinkFetcherThreadPool clusterLinkFetcherThreadPool = this;
        synchronized (clusterLinkFetcherThreadPool) {
            boolean bl2;
            if (thread.numFetchers() == 0) {
                this.debug((Function0<String> & Serializable)() -> "Removing shared fetcher thread with tag " + thread.sharedFetcherTag() + " for link " + $this.linkName);
                bl2 = this.threadPool().remove(thread.sharedFetcherTag()).nonEmpty();
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean shutdownThread = bl;
        if (shutdownThread) {
            this.debug((Function0<String> & Serializable)() -> "Shutting down shared fetcher thread with tag " + thread.sharedFetcherTag());
            thread.shutdown();
            return;
        }
    }

    public void shutdown() {
        Seq seq;
        this.debug((Function0<String> & Serializable)() -> "Shutting down cluster link fetcher thread pool for link " + $this.linkName);
        ClusterLinkFetcherThreadPool clusterLinkFetcherThreadPool = this;
        synchronized (clusterLinkFetcherThreadPool) {
            this.isActive_$eq(false);
            seq = this.threadPool().values().toSeq();
        }
        Seq threads = seq;
        threads.foreach((Function1<ClusterLinkSharedFetcherThread, Object> & Serializable)thread -> {
            CoreUtils$.MODULE$.swallow(() -> thread.shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public synchronized int deadThreadCount() {
        return this.threadPool().values().count((Function1<ClusterLinkSharedFetcherThread, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isThreadFailed()));
    }

    public ClusterLinkSharedFetcherThread createSharedFetcherThread(SharedFetcherTag sharedFetcherTag) {
        this.debug((Function0<String> & Serializable)() -> "Creating new shared cluster link fetcher thread for link " + $this.linkName + " with id " + sharedFetcherTag);
        ClusterLinkNetworkClient clusterLinkClient = this.createNetworkClient(sharedFetcherTag);
        String threadName = "ClusterLinkSharedFetcherThread-" + this.brokerConfig.brokerId() + "-" + this.linkName + "-" + sharedFetcherTag.fetcherId() + "-" + sharedFetcherTag.fetcherPool().name();
        ClusterLinkSharedFetcherThread thread = new ClusterLinkSharedFetcherThread(threadName, sharedFetcherTag, this.linkName, this, clusterLinkClient, this.quota, this.clusterLinkConfig().replicaFetchBackoff(), this.time);
        this.threadPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(sharedFetcherTag), thread));
        return thread;
    }

    private ClusterLinkNetworkClient createNetworkClient(SharedFetcherTag sharedFetcherTag) {
        int fetcherId = sharedFetcherTag.fetcherId();
        FetcherPool fetcherPool = sharedFetcherTag.fetcherPool();
        LogContext logContext = new LogContext("[ClusterLinkFetcherThread brokerId=" + this.brokerConfig.brokerId() + " fetcherId=" + fetcherId + " fetcherPool=" + fetcherPool.name() + "] link=" + this.linkName + "] ", this.connectionManager.maxLogLevel());
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(this.brokerConfig, this.clusterLinkConfig(), ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(this.linkName), None$.MODULE$, new Some<MetadataUpdater>(new ManualMetadataUpdater()), this.clusterLinkMetrics.metrics(), this.selectorMetricsRegistry, (Map)ClusterLinkFactory$.MODULE$.linkMetricTags(this.linkName).$plus$plus((IterableOnce)scala.collection.Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fetcher-id"), Integer.toString(fetcherId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fetcher-pool"), fetcherPool.name())}))), this.time, "link-" + this.linkName + "-fetcher-" + fetcherId + "-pool-" + fetcherPool.name(), ClusterLinkClientType$Fetcher$.MODULE$, this.clusterLinkChannelContext, logContext, this.connectionManager.maxLogLevel());
        this.connectionManager.enableClusterLink(clusterLinkClient, None$.MODULE$);
        return clusterLinkClient;
    }

    public ClusterLinkFetcherThreadPool(KafkaConfig brokerConfig, String linkName, ClusterLinkConfig initialConfig, ClusterLinkConnectionManager connectionManager, ClusterLinkMetrics clusterLinkMetrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, ClusterLinkRequestQuota quota, Option<ClusterLinkChannelContext> clusterLinkChannelContext, Time time) {
        this.brokerConfig = brokerConfig;
        this.linkName = linkName;
        this.connectionManager = connectionManager;
        this.clusterLinkMetrics = clusterLinkMetrics;
        this.selectorMetricsRegistry = selectorMetricsRegistry;
        this.quota = quota;
        this.clusterLinkChannelContext = clusterLinkChannelContext;
        this.time = time;
        Logging.$init$(this);
        this.threadPool = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.isActive = true;
        this.clusterLinkConfig = initialConfig;
    }
}

