/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.link.ClusterLinkRegionalMetadata$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q3AAC\u0006\u0001%!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003!\u0011!a\u0003A!A!\u0002\u0013\u0001\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bI\u0002A\u0011A\u001a\t\u000fi\u0002!\u0019!C\u0005w!1A\n\u0001Q\u0001\nqBQ!\u0014\u0001\u0005\u00029CQa\u0014\u0001\u0005\nA\u0013Ae\u00117vgR,'\u000fT5oWJ+w-[8oC2lU\r^1eCR\fg*\u001a;x_J\\w\n\u001d\u0006\u0003\u00195\tA\u0001\\5oW*\u0011abD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003A\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u0010\u0003\u0015)H/\u001b7t\u0013\tq2DA\u0004M_\u001e<\u0017N\\4\u0002\u001d=\u0014x-\u00198ju\u0006$\u0018n\u001c8JIB\u0011\u0011\u0005\u000b\b\u0003E\u0019\u0002\"aI\u000b\u000e\u0003\u0011R!!J\t\u0002\rq\u0012xn\u001c;?\u0013\t9S#\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014\u0016\u00035)gN^5s_:lWM\u001c;JI\u0006Ia.\u001a;x_J\\\u0017\nZ\u0001\u0017e\u0016<\u0017n\u001c8bY6+G/\u00193bi\u0006\u001cE.[3oiB\u0011q\u0006M\u0007\u0002\u001b%\u0011\u0011'\u0004\u0002\u0017%\u0016<\u0017n\u001c8bY6+G/\u00193bi\u0006\u001cE.[3oi\u00061A(\u001b8jiz\"R\u0001\u000e\u001c8qe\u0002\"!\u000e\u0001\u000e\u0003-AQaH\u0003A\u0002\u0001BQaK\u0003A\u0002\u0001BQ\u0001L\u0003A\u0002\u0001BQ!L\u0003A\u00029\nAB]3ukJtg)\u001e;ve\u0016,\u0012\u0001\u0010\t\u0004{\u00113U\"\u0001 \u000b\u0005}\u0002\u0015AC2p]\u000e,(O]3oi*\u0011\u0011IQ\u0001\u0005kRLGNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015s$!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0019AcR%\n\u0005!+\"AB(qi&|g\u000e\u0005\u00020\u0015&\u00111*\u0004\u0002\u0018%\u0016<\u0017n\u001c8bY:+Go^8sW6+G/\u00193bi\u0006\fQB]3ukJtg)\u001e;ve\u0016\u0004\u0013aB3yK\u000e,H/\u001a\u000b\u0002y\u0005iR.Y=cK\u001e+Go\u00155be\u0016$g*\u001a;x_J\\W*\u001a;bI\u0006$\u0018\rF\u0001R!\t!\"+\u0003\u0002T+\t9!i\\8mK\u0006t\u0007")
public class ClusterLinkRegionalMetadataNetworkOp
implements Logging {
    private final String organizationId;
    private final String environmentId;
    private final String networkId;
    private final RegionalMetadataClient regionalMetadataClient;
    private final CompletableFuture<Option<RegionalNetworkMetadata>> returnFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkRegionalMetadataNetworkOp clusterLinkRegionalMetadataNetworkOp = this;
        synchronized (clusterLinkRegionalMetadataNetworkOp) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private CompletableFuture<Option<RegionalNetworkMetadata>> returnFuture() {
        return this.returnFuture;
    }

    public CompletableFuture<Option<RegionalNetworkMetadata>> execute() {
        CompletableFuture<Option<RegionalNetworkMetadata>> networkMetadataFuture = this.regionalMetadataClient.getNetworkMetadata(this.organizationId, this.environmentId, this.networkId);
        networkMetadataFuture.whenComplete((networkMetadata, ex) -> {
            if (ex != null) {
                this.error((Function0<String> & Serializable)() -> "Failed to get network metadata with organization " + $this.organizationId + " environment " + $this.environmentId + " and network " + $this.networkId, (Function0<Throwable> & Serializable)() -> ex);
                this.returnFuture().completeExceptionally((Throwable)ex);
                return;
            }
            if (networkMetadata.isEmpty()) {
                this.info((Function0<String> & Serializable)() -> "Network " + $this.networkId + " with organization " + $this.organizationId + " environment " + $this.environmentId + " is unavailable");
                if (!this.maybeGetSharedNetworkMetadata()) {
                    this.returnFuture().complete((Option<RegionalNetworkMetadata>)networkMetadata);
                    return;
                }
                return;
            }
            this.returnFuture().complete((Option<RegionalNetworkMetadata>)networkMetadata);
        });
        return this.returnFuture();
    }

    private boolean maybeGetSharedNetworkMetadata() {
        String string = this.organizationId;
        String string2 = ClusterLinkRegionalMetadata$.MODULE$.confluentOrgId();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = this.environmentId;
            String string4 = ClusterLinkRegionalMetadata$.MODULE$.confluentEnvId();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                return false;
            }
        }
        this.info((Function0<String> & Serializable)() -> "Retry assuming shared network for network " + $this.networkId);
        CompletableFuture<Option<RegionalNetworkMetadata>> sharedNetworkMetadataFuture = this.regionalMetadataClient.getNetworkMetadata(ClusterLinkRegionalMetadata$.MODULE$.confluentOrgId(), ClusterLinkRegionalMetadata$.MODULE$.confluentEnvId(), this.networkId);
        sharedNetworkMetadataFuture.whenComplete((sharedNetworkMetadata, ex) -> {
            if (ex != null) {
                this.error((Function0<String> & Serializable)() -> "Failed to get shared network metadata with organization " + $this.organizationId + " environment " + $this.environmentId + " and network " + $this.networkId, (Function0<Throwable> & Serializable)() -> ex);
                this.returnFuture().completeExceptionally((Throwable)ex);
                return;
            }
            if (sharedNetworkMetadata.isEmpty()) {
                this.info((Function0<String> & Serializable)() -> "Shared network " + $this.networkId + " with organization " + $this.organizationId + " environment " + $this.environmentId + " is unavailable");
            }
            this.returnFuture().complete((Option<RegionalNetworkMetadata>)sharedNetworkMetadata);
        });
        return true;
    }

    public ClusterLinkRegionalMetadataNetworkOp(String organizationId, String environmentId, String networkId, RegionalMetadataClient regionalMetadataClient) {
        this.organizationId = organizationId;
        this.environmentId = environmentId;
        this.networkId = networkId;
        this.regionalMetadataClient = regionalMetadataClient;
        Logging.$init$(this);
        this.returnFuture = new CompletableFuture();
    }
}

