/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.CommittedOffsetTopicPartition;
import kafka.server.link.MatchedGroup;
import kafka.server.link.TopicType$;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005E4A\u0001E\t\u00011!A1\u0005\u0001BC\u0002\u0013\u0005A\u0005\u0003\u00051\u0001\t\u0005\t\u0015!\u0003&\u0011!\t\u0004A!b\u0001\n\u0003\u0011\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011\u0001\u0003!Q1A\u0005\u0002\u0005C\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011)\u0019!C\u0001\u000f\"Aa\u000b\u0001B\u0001B\u0003%\u0001\n\u0003\u0005X\u0001\t\u0015\r\u0011\"\u0001H\u0011!A\u0006A!A!\u0002\u0013A\u0005\u0002C-\u0001\u0005\u000b\u0007I\u0011\u0001.\t\u0011y\u0003!\u0011!Q\u0001\nmCQa\u0018\u0001\u0005\u0002\u0001DQ\u0001\u001b\u0001\u0005B%DQ\u0001\u001d\u0001\u0005B\u0011\u0012\u0011CU3n_R,W*\u001b:s_J$v\u000e]5d\u0015\t\u00112#\u0001\u0003mS:\\'B\u0001\u000b\u0016\u0003\u0019\u0019XM\u001d<fe*\ta#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011!E\u0005\u0003EE\u0011QdQ8n[&$H/\u001a3PM\u001a\u001cX\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\te\u0016lw\u000e^3UaV\tQ\u0005\u0005\u0002']5\tqE\u0003\u0002)S\u000511m\\7n_:T!A\u0006\u0016\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0005\u0003_\u001d\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0005sK6|G/\u001a+qA\u0005)1\u000f^1uKV\t1\u0007\u0005\u00025y9\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003s%\nqa\u00197jK:$8/\u0003\u0002<m\u00051R*\u001b:s_J$v\u000e]5d\t\u0016\u001c8M]5qi&|g.\u0003\u0002>}\t)1\u000b^1uK*\u00111HN\u0001\u0007gR\fG/\u001a\u0011\u0002\u00111Lgn\u001b#bi\u0006,\u0012A\u0011\t\u0003A\rK!\u0001R\t\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u00171|7-\u00197Qe\u00164\u0017\u000e_\u000b\u0002\u0011B\u0019!$S&\n\u0005)[\"AB(qi&|g\u000e\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001dni\u0011a\u0014\u0006\u0003!^\ta\u0001\u0010:p_Rt\u0014B\u0001*\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I[\u0012\u0001\u00047pG\u0006d\u0007K]3gSb\u0004\u0013\u0001\u0004:f[>$X\r\u0015:fM&D\u0018!\u0004:f[>$X\r\u0015:fM&D\b%A\u0003he>,\b/F\u0001\\!\t\u0001C,\u0003\u0002^#\taQ*\u0019;dQ\u0016$wI]8va\u00061qM]8va\u0002\na\u0001P5oSRtDcB1cG\u0012,gm\u001a\t\u0003A\u0001AQaI\u0007A\u0002\u0015BQ!M\u0007A\u0002MBQ\u0001Q\u0007A\u0002\tCQAR\u0007A\u0002!CQaV\u0007A\u0002!CQ!W\u0007A\u0002m\u000b!b\u001d5pk2$7+\u001f8d+\u0005Q\u0007\u0003\u0002\u000el[.K!\u0001\\\u000e\u0003\rQ+\b\u000f\\33!\tQb.\u0003\u0002p7\t9!i\\8mK\u0006t\u0017!\u00033fgR$v\u000e]5d\u0001")
public class RemoteMirrorTopic
implements CommittedOffsetTopicPartition {
    private final TopicPartition remoteTp;
    private final MirrorTopicDescription.State state;
    private final ClusterLinkData linkData;
    private final Option<String> localPrefix;
    private final Option<String> remotePrefix;
    private final MatchedGroup group;

    public TopicPartition remoteTp() {
        return this.remoteTp;
    }

    public MirrorTopicDescription.State state() {
        return this.state;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public Option<String> localPrefix() {
        return this.localPrefix;
    }

    public Option<String> remotePrefix() {
        return this.remotePrefix;
    }

    public MatchedGroup group() {
        return this.group;
    }

    @Override
    public Tuple2<Object, String> shouldSync() {
        if (this.group().topicTypes().contains(TopicType$.MODULE$.REMOTE_MIRROR()) && this.state().equals((Object)MirrorTopicDescription.State.ACTIVE)) {
            return new Tuple2<Boolean, Object>(BoxesRunTime.boxToBoolean(true), null);
        }
        return new Tuple2<Boolean, CallSite>(BoxesRunTime.boxToBoolean(false), (CallSite)((Object)("remote mirror " + this.remoteTp().topic() + " is not active")));
    }

    @Override
    public TopicPartition destTopic() {
        String tenantPrefix = (String)this.linkData().tenantPrefix().getOrElse((Function0<String> & Serializable)() -> "");
        String localName = tenantPrefix + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(this.remoteTp().topic()), tenantPrefix)), (String)this.localPrefix().getOrElse((Function0<String> & Serializable)() -> ""))), (String)this.remotePrefix().getOrElse((Function0<String> & Serializable)() -> ""));
        return new TopicPartition(localName, this.remoteTp().partition());
    }

    public RemoteMirrorTopic(TopicPartition remoteTp, MirrorTopicDescription.State state, ClusterLinkData linkData, Option<String> localPrefix, Option<String> remotePrefix, MatchedGroup group) {
        this.remoteTp = remoteTp;
        this.state = state;
        this.linkData = linkData;
        this.localPrefix = localPrefix;
        this.remotePrefix = remotePrefix;
        this.group = group;
    }
}

