/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kafka.cluster.Partition;
import kafka.server.AbstractLogReadResult;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.LogReadResult;
import kafka.server.PartitionFetchMetadata;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TierLogReadResult;
import kafka.server.share.ShareFetchUtils;
import kafka.server.share.SharePartition;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchMetadata;
import kafka.tier.fetcher.TierFetchResult;
import kafka.tier.fetcher.TierFetcher;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchGroupKey;
import org.apache.kafka.server.share.fetch.PartitionMaxBytesStrategy;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.runtime.BoxedUnit;

public class DelayedShareFetch
extends DelayedOperation {
    private static final Logger log = LoggerFactory.getLogger(DelayedShareFetch.class);
    private final ShareFetch shareFetch;
    private final ReplicaManager replicaManager;
    private final BiConsumer<SharePartitionKey, Throwable> exceptionHandler;
    private final PartitionMaxBytesStrategy partitionMaxBytesStrategy;
    private final LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions;
    private LinkedHashMap<TopicIdPartition, Long> partitionsAcquired;
    private LinkedHashMap<TopicIdPartition, AbstractLogReadResult> localPartitionsAlreadyFetched;
    private Optional<PendingFetch> pendingTierFetchOpt;
    private Optional<Exception> tierStorageFetchException;

    public DelayedShareFetch(ShareFetch shareFetch, ReplicaManager replicaManager, BiConsumer<SharePartitionKey, Throwable> exceptionHandler, LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions) {
        this(shareFetch, replicaManager, exceptionHandler, sharePartitions, PartitionMaxBytesStrategy.type(PartitionMaxBytesStrategy.StrategyType.UNIFORM), Optional.empty());
    }

    DelayedShareFetch(ShareFetch shareFetch, ReplicaManager replicaManager, BiConsumer<SharePartitionKey, Throwable> exceptionHandler, LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions, PartitionMaxBytesStrategy partitionMaxBytesStrategy, Optional<PendingFetch> pendingTierFetchOpt) {
        super(shareFetch.fetchParams().maxWaitMs, Optional.empty());
        this.shareFetch = shareFetch;
        this.replicaManager = replicaManager;
        this.partitionsAcquired = new LinkedHashMap();
        this.localPartitionsAlreadyFetched = new LinkedHashMap();
        this.tierStorageFetchException = Optional.empty();
        this.exceptionHandler = exceptionHandler;
        this.sharePartitions = sharePartitions;
        this.partitionMaxBytesStrategy = partitionMaxBytesStrategy;
        this.pendingTierFetchOpt = pendingTierFetchOpt;
    }

    @Override
    public void onExpiration() {
        this.pendingTierFetchOpt.ifPresent(PendingFetch::markFetchExpired);
    }

    @Override
    public void onComplete() {
        this.lock.lock();
        log.trace("Completing the delayed share fetch request for group {}, member {}, topic partitions {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), this.partitionsAcquired.keySet()});
        try {
            if (this.tierStorageFetchException.isPresent()) {
                this.completeErroneousTierShareFetchRequest();
            } else if (this.pendingTierFetchOpt.isPresent()) {
                Map<TopicPartition, TierFetchResult> tierFetchResultMap = this.pendingTierFetchOpt.get().finish();
                this.completeTierShareFetchRequest(tierFetchResultMap);
            } else {
                this.completeShareFetchRequest();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void completeShareFetchRequest() {
        LinkedHashMap<TopicIdPartition, Long> topicPartitionData = this.partitionsAcquired.isEmpty() ? this.acquirablePartitions(this.sharePartitions) : this.partitionsAcquired;
        if (topicPartitionData.isEmpty()) {
            this.shareFetch.maybeComplete(Map.of());
            return;
        }
        log.trace("Fetchable share partitions data: {} with groupId: {} fetch params: {}", new Object[]{topicPartitionData, this.shareFetch.groupId(), this.shareFetch.fetchParams()});
        this.processAcquiredTopicPartitions(topicPartitionData);
    }

    @Override
    public boolean tryComplete() {
        if (this.pendingTierFetchOpt.isPresent()) {
            return this.maybeCompletePendingTierFetch();
        }
        LinkedHashMap<TopicIdPartition, Long> topicPartitionData = this.acquirablePartitions(this.sharePartitions);
        try {
            if (!topicPartitionData.isEmpty()) {
                LinkedHashMap<TopicIdPartition, AbstractLogReadResult> replicaManagerReadResponse = this.maybeReadFromLog(topicPartitionData);
                LinkedHashMap<TopicIdPartition, TierFetchMetadata> tierFetchMetadataMap = this.maybePrepareTierFetchMetadata(topicPartitionData, replicaManagerReadResponse);
                if (!tierFetchMetadataMap.isEmpty()) {
                    return this.maybeProcessTierFetch(topicPartitionData, tierFetchMetadataMap);
                }
                this.maybeUpdateFetchOffsetMetadata(topicPartitionData, replicaManagerReadResponse);
                if (this.anyPartitionHasLogReadError(replicaManagerReadResponse) || this.isMinBytesSatisfied(topicPartitionData, this.partitionMaxBytesStrategy.maxBytes(this.shareFetch.fetchParams().maxBytes, topicPartitionData.keySet(), topicPartitionData.size()))) {
                    this.partitionsAcquired = topicPartitionData;
                    this.localPartitionsAlreadyFetched = replicaManagerReadResponse;
                    boolean completedByMe = this.forceComplete();
                    if (!completedByMe) {
                        this.releasePartitionLocks(this.partitionsAcquired.keySet());
                    }
                    return completedByMe;
                }
                log.debug("minBytes is not satisfied for the share fetch request for group {}, member {}, topic partitions {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), this.sharePartitions.keySet()});
                this.releasePartitionLocks(topicPartitionData.keySet());
            } else {
                log.trace("Can't acquire records for any partition in the share fetch request for group {}, member {}, topic partitions {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), this.sharePartitions.keySet()});
            }
            return false;
        }
        catch (Exception e) {
            log.error("Error processing delayed share fetch request", (Throwable)e);
            if (this.tierStorageFetchException.isEmpty()) {
                this.releasePartitionLocks(topicPartitionData.keySet());
                this.partitionsAcquired.clear();
                this.localPartitionsAlreadyFetched.clear();
            }
            return this.forceComplete();
        }
    }

    LinkedHashMap<TopicIdPartition, Long> acquirablePartitions(LinkedHashMap<TopicIdPartition, SharePartition> sharePartitionsForAcquire) {
        LinkedHashMap<TopicIdPartition, Long> topicPartitionData = new LinkedHashMap<TopicIdPartition, Long>();
        sharePartitionsForAcquire.forEach((topicIdPartition, sharePartition) -> {
            if (sharePartition.maybeAcquireFetchLock()) {
                try {
                    if (sharePartition.canAcquireRecords()) {
                        topicPartitionData.put((TopicIdPartition)topicIdPartition, sharePartition.nextFetchOffset());
                    } else {
                        sharePartition.releaseFetchLock();
                        log.trace("Record lock partition limit exceeded for SharePartition {}, cannot acquire more records", sharePartition);
                    }
                }
                catch (Exception e) {
                    log.error("Error checking condition for SharePartition: {}", sharePartition, (Object)e);
                    sharePartition.releaseFetchLock();
                }
            }
        });
        return topicPartitionData;
    }

    private LinkedHashMap<TopicIdPartition, AbstractLogReadResult> maybeReadFromLog(LinkedHashMap<TopicIdPartition, Long> topicPartitionData) {
        LinkedHashMap<TopicIdPartition, Long> partitionsNotMatchingFetchOffsetMetadata = new LinkedHashMap<TopicIdPartition, Long>();
        topicPartitionData.forEach((topicIdPartition, fetchOffset) -> {
            SharePartition sharePartition = this.sharePartitions.get(topicIdPartition);
            if (sharePartition.fetchOffsetMetadata((long)fetchOffset).isEmpty()) {
                partitionsNotMatchingFetchOffsetMetadata.put((TopicIdPartition)topicIdPartition, (Long)fetchOffset);
            }
        });
        if (partitionsNotMatchingFetchOffsetMetadata.isEmpty()) {
            return new LinkedHashMap<TopicIdPartition, AbstractLogReadResult>();
        }
        return this.readFromLog(partitionsNotMatchingFetchOffsetMetadata, this.partitionMaxBytesStrategy.maxBytes(this.shareFetch.fetchParams().maxBytes, partitionsNotMatchingFetchOffsetMetadata.keySet(), topicPartitionData.size()));
    }

    private void maybeUpdateFetchOffsetMetadata(LinkedHashMap<TopicIdPartition, Long> topicPartitionData, LinkedHashMap<TopicIdPartition, AbstractLogReadResult> replicaManagerReadResponseData) {
        for (Map.Entry<TopicIdPartition, AbstractLogReadResult> entry : replicaManagerReadResponseData.entrySet()) {
            TopicIdPartition topicIdPartition = entry.getKey();
            SharePartition sharePartition = this.sharePartitions.get(topicIdPartition);
            LogReadResult replicaManagerLogReadResult = (LogReadResult)entry.getValue();
            if (replicaManagerLogReadResult.error().code() != Errors.NONE.code()) {
                log.debug("Replica manager read log result {} errored out for topic partition {}", (Object)replicaManagerLogReadResult, (Object)topicIdPartition);
                continue;
            }
            sharePartition.updateFetchOffsetMetadata(topicPartitionData.get(topicIdPartition), replicaManagerLogReadResult.info().fetchOffsetMetadata);
        }
    }

    private boolean isMinBytesSatisfied(LinkedHashMap<TopicIdPartition, Long> topicPartitionData, LinkedHashMap<TopicIdPartition, Integer> partitionMaxBytes) {
        long accumulatedSize = 0L;
        for (Map.Entry<TopicIdPartition, Long> entry : topicPartitionData.entrySet()) {
            SharePartition sharePartition;
            Optional<LogOffsetMetadata> optionalFetchOffsetMetadata;
            LogOffsetMetadata endOffsetMetadata;
            TopicIdPartition topicIdPartition = entry.getKey();
            long fetchOffset = entry.getValue();
            try {
                endOffsetMetadata = this.endOffsetMetadataForTopicPartition(topicIdPartition);
            }
            catch (Exception e) {
                this.shareFetch.addErroneous(topicIdPartition, e);
                this.exceptionHandler.accept(new SharePartitionKey(this.shareFetch.groupId(), topicIdPartition), e);
                continue;
            }
            if (endOffsetMetadata == LogOffsetMetadata.UNKNOWN_OFFSET_METADATA || (optionalFetchOffsetMetadata = (sharePartition = this.sharePartitions.get(topicIdPartition)).fetchOffsetMetadata(fetchOffset)).isEmpty() || optionalFetchOffsetMetadata.get() == LogOffsetMetadata.UNKNOWN_OFFSET_METADATA) continue;
            LogOffsetMetadata fetchOffsetMetadata = optionalFetchOffsetMetadata.get();
            if (fetchOffsetMetadata.messageOffset > endOffsetMetadata.messageOffset) {
                log.debug("Satisfying delayed share fetch request for group {}, member {} since it is fetching later segments of topicIdPartition {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), topicIdPartition});
                return true;
            }
            if (fetchOffsetMetadata.messageOffset >= endOffsetMetadata.messageOffset) continue;
            if (fetchOffsetMetadata.onOlderSegment(endOffsetMetadata)) {
                log.debug("Satisfying delayed share fetch request for group {}, member {} immediately since it is fetching older segments of topicIdPartition {}", new Object[]{this.shareFetch.groupId(), this.shareFetch.memberId(), topicIdPartition});
                return true;
            }
            if (!fetchOffsetMetadata.onSameSegment(endOffsetMetadata)) continue;
            long bytesAvailable = Math.min(endOffsetMetadata.positionDiff(fetchOffsetMetadata), partitionMaxBytes.get(topicIdPartition));
            accumulatedSize += bytesAvailable;
        }
        return accumulatedSize >= (long)this.shareFetch.fetchParams().minBytes;
    }

    private LogOffsetMetadata endOffsetMetadataForTopicPartition(TopicIdPartition topicIdPartition) {
        Partition partition = ShareFetchUtils.partition(this.replicaManager, topicIdPartition.topicPartition());
        LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(Optional.empty(), true);
        FetchIsolation isolationType = this.shareFetch.fetchParams().isolation;
        if (isolationType == FetchIsolation.LOG_END) {
            return offsetSnapshot.logEndOffset;
        }
        if (isolationType == FetchIsolation.HIGH_WATERMARK) {
            return offsetSnapshot.highWatermark;
        }
        return offsetSnapshot.lastStableOffset;
    }

    private LinkedHashMap<TopicIdPartition, AbstractLogReadResult> readFromLog(LinkedHashMap<TopicIdPartition, Long> topicPartitionFetchOffsets, LinkedHashMap<TopicIdPartition, Integer> partitionMaxBytes) {
        Set<TopicIdPartition> partitionsToFetch = this.shareFetch.filterErroneousTopicPartitions(topicPartitionFetchOffsets.keySet());
        if (partitionsToFetch.isEmpty()) {
            return new LinkedHashMap<TopicIdPartition, AbstractLogReadResult>();
        }
        LinkedHashMap topicPartitionData = new LinkedHashMap();
        topicPartitionFetchOffsets.forEach((topicIdPartition, fetchOffset) -> topicPartitionData.put(topicIdPartition, new FullPartitionFetchMetadata(topicIdPartition.topicId(), (long)fetchOffset, 0L, (Integer)partitionMaxBytes.get(topicIdPartition), Optional.empty(), Optional.empty(), -1L)));
        Seq<Tuple2<TopicIdPartition, AbstractLogReadResult>> responseLogResult = this.replicaManager.readFromLog(this.shareFetch.fetchParams(), CollectionConverters.asScala(partitionsToFetch.stream().map(topicIdPartition -> new Tuple2<TopicIdPartition, PartitionFetchMetadata>((TopicIdPartition)topicIdPartition, (PartitionFetchMetadata)topicPartitionData.get(topicIdPartition))).collect(Collectors.toList())), QuotaFactory.UNBOUNDED_QUOTA, true, false);
        LinkedHashMap<TopicIdPartition, AbstractLogReadResult> responseData = new LinkedHashMap<TopicIdPartition, AbstractLogReadResult>();
        responseLogResult.foreach(tpLogResult -> {
            responseData.put((TopicIdPartition)tpLogResult._1(), (AbstractLogReadResult)tpLogResult._2());
            return BoxedUnit.UNIT;
        });
        log.trace("Data successfully retrieved by replica manager: {}", responseData);
        return responseData;
    }

    private boolean anyPartitionHasLogReadError(LinkedHashMap<TopicIdPartition, AbstractLogReadResult> replicaManagerReadResponse) {
        return replicaManagerReadResponse.values().stream().anyMatch(logReadResult -> logReadResult.error().code() != Errors.NONE.code());
    }

    private void handleFetchException(ShareFetch shareFetch, Set<TopicIdPartition> topicIdPartitions, Throwable throwable) {
        topicIdPartitions.forEach(topicIdPartition -> this.exceptionHandler.accept(new SharePartitionKey(shareFetch.groupId(), (TopicIdPartition)topicIdPartition), throwable));
        shareFetch.maybeCompleteWithException(topicIdPartitions, throwable);
    }

    LinkedHashMap<TopicIdPartition, AbstractLogReadResult> combineLogReadResponse(LinkedHashMap<TopicIdPartition, Long> topicPartitionData, LinkedHashMap<TopicIdPartition, AbstractLogReadResult> existingFetchedData) {
        LinkedHashMap<TopicIdPartition, Long> missingLogReadTopicPartitions = new LinkedHashMap<TopicIdPartition, Long>();
        topicPartitionData.forEach((topicIdPartition, fetchOffset) -> {
            if (!existingFetchedData.containsKey(topicIdPartition)) {
                missingLogReadTopicPartitions.put((TopicIdPartition)topicIdPartition, (Long)fetchOffset);
            }
        });
        if (missingLogReadTopicPartitions.isEmpty()) {
            return existingFetchedData;
        }
        LinkedHashMap<TopicIdPartition, AbstractLogReadResult> missingTopicPartitionsLogReadResponse = this.readFromLog(missingLogReadTopicPartitions, this.partitionMaxBytesStrategy.maxBytes(this.shareFetch.fetchParams().maxBytes, missingLogReadTopicPartitions.keySet(), topicPartitionData.size()));
        missingTopicPartitionsLogReadResponse.putAll(existingFetchedData);
        return missingTopicPartitionsLogReadResponse;
    }

    void releasePartitionLocks(Set<TopicIdPartition> topicIdPartitions) {
        topicIdPartitions.forEach(tp -> {
            SharePartition sharePartition = this.sharePartitions.get(tp);
            sharePartition.releaseFetchLock();
        });
    }

    Lock lock() {
        return this.lock;
    }

    PendingFetch pendingFetch() {
        return this.pendingTierFetchOpt.orElse(null);
    }

    void updatePartitionsAcquired(LinkedHashMap<TopicIdPartition, Long> partitionsAcquired) {
        this.partitionsAcquired = partitionsAcquired;
    }

    void updatePartitionsAlreadyFetched(LinkedHashMap<TopicIdPartition, AbstractLogReadResult> partitionsAlreadyFetched) {
        this.localPartitionsAlreadyFetched = partitionsAlreadyFetched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAcquiredTopicPartitions(LinkedHashMap<TopicIdPartition, Long> topicPartitionData) {
        try {
            LinkedHashMap<TopicIdPartition, AbstractLogReadResult> responseData = this.localPartitionsAlreadyFetched.isEmpty() ? this.readFromLog(topicPartitionData, this.partitionMaxBytesStrategy.maxBytes(this.shareFetch.fetchParams().maxBytes, topicPartitionData.keySet(), topicPartitionData.size())) : this.combineLogReadResponse(topicPartitionData, this.localPartitionsAlreadyFetched);
            LinkedHashMap<TopicIdPartition, FetchPartitionData> fetchPartitionsData = new LinkedHashMap<TopicIdPartition, FetchPartitionData>();
            for (Map.Entry<TopicIdPartition, AbstractLogReadResult> entry : responseData.entrySet()) {
                if (!(entry.getValue() instanceof LogReadResult)) continue;
                fetchPartitionsData.put(entry.getKey(), entry.getValue().toFetchPartitionData(false, 0L, 0L));
            }
            this.shareFetch.maybeComplete(ShareFetchUtils.processFetchResponse(this.shareFetch, fetchPartitionsData, this.sharePartitions, this.replicaManager, this.exceptionHandler));
        }
        catch (Exception e) {
            log.error("Error processing delayed share fetch request", (Throwable)e);
            this.handleFetchException(this.shareFetch, topicPartitionData.keySet(), e);
        }
        finally {
            this.releasePartitionLocksAndAddToActionQueue(topicPartitionData.keySet());
        }
    }

    private void releasePartitionLocksAndAddToActionQueue(Set<TopicIdPartition> topicIdPartitions) {
        this.releasePartitionLocks(topicIdPartitions);
        this.replicaManager.addToActionQueue(() -> topicIdPartitions.forEach(topicIdPartition -> this.replicaManager.completeDelayedShareFetchRequest(new DelayedShareFetchGroupKey(this.shareFetch.groupId(), topicIdPartition.topicId(), topicIdPartition.partition()))));
    }

    private void completeErroneousTierShareFetchRequest() {
        try {
            this.handleFetchException(this.shareFetch, this.partitionsAcquired.keySet(), this.tierStorageFetchException.get());
        }
        finally {
            this.releasePartitionLocksAndAddToActionQueue(this.partitionsAcquired.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeTierShareFetchRequest(Map<TopicPartition, TierFetchResult> tierFetchResultMap) {
        LinkedHashMap<Object, Object> nonTierFetchTopicPartitionData = new LinkedHashMap();
        try {
            LinkedHashMap<TopicIdPartition, FetchPartitionData> fetchPartitionData = new LinkedHashMap<TopicIdPartition, FetchPartitionData>();
            int readableBytes = 0;
            for (Map.Entry<TopicIdPartition, AbstractLogReadResult> entry : this.localPartitionsAlreadyFetched.entrySet()) {
                LogReadResult logReadResult;
                TopicIdPartition topicIdPartition2 = entry.getKey();
                if (entry.getValue() instanceof LogReadResult) {
                    logReadResult = (LogReadResult)entry.getValue();
                } else {
                    TierFetchResult tierFetchResult;
                    TierLogReadResult tierLogReadResult = (TierLogReadResult)entry.getValue();
                    logReadResult = tierLogReadResult.intoLogReadResult(tierFetchResult, !(tierFetchResult = tierFetchResultMap.getOrDefault(topicIdPartition2.topicPartition(), TierFetchResult.emptyFetchResult())).isEmpty());
                }
                fetchPartitionData.put(topicIdPartition2, logReadResult.toFetchPartitionData(false, 0L, 0L));
                readableBytes += logReadResult.info().records.sizeInBytes();
            }
            if (readableBytes < this.shareFetch.fetchParams().maxBytes) {
                LinkedHashMap<TopicIdPartition, SharePartition> nonTierSharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
                this.sharePartitions.forEach((topicIdPartition, sharePartition) -> {
                    if (!this.partitionsAcquired.containsKey(topicIdPartition)) {
                        nonTierSharePartitions.put((TopicIdPartition)topicIdPartition, (SharePartition)sharePartition);
                    }
                });
                nonTierFetchTopicPartitionData = this.acquirablePartitions(nonTierSharePartitions);
                if (!nonTierFetchTopicPartitionData.isEmpty()) {
                    log.trace("Fetchable share partitions for a tier share fetch request data: {} with groupId: {} fetch params: {}", new Object[]{nonTierFetchTopicPartitionData, this.shareFetch.groupId(), this.shareFetch.fetchParams()});
                    LinkedHashMap<TopicIdPartition, AbstractLogReadResult> responseData = this.readFromLog(nonTierFetchTopicPartitionData, this.partitionMaxBytesStrategy.maxBytes(this.shareFetch.fetchParams().maxBytes - readableBytes, nonTierFetchTopicPartitionData.keySet(), nonTierFetchTopicPartitionData.size()));
                    for (Map.Entry<TopicIdPartition, AbstractLogReadResult> entry : responseData.entrySet()) {
                        if (!(entry.getValue() instanceof LogReadResult)) continue;
                        fetchPartitionData.put(entry.getKey(), entry.getValue().toFetchPartitionData(false, 0L, 0L));
                    }
                }
            }
            Map<TopicIdPartition, ShareFetchResponseData.PartitionData> tierFetchResponse = ShareFetchUtils.processFetchResponse(this.shareFetch, fetchPartitionData, this.sharePartitions, this.replicaManager, this.exceptionHandler);
            this.shareFetch.maybeComplete(tierFetchResponse);
            log.trace("Tiered share fetch request completed successfully, response: {}", tierFetchResponse);
        }
        catch (Exception e) {
            log.error("Error processing delayed share fetch request", (Throwable)e);
            LinkedHashSet<TopicIdPartition> topicIdPartitions = new LinkedHashSet<TopicIdPartition>(this.partitionsAcquired.keySet());
            topicIdPartitions.addAll(nonTierFetchTopicPartitionData.keySet());
            this.handleFetchException(this.shareFetch, topicIdPartitions, e);
        }
        finally {
            LinkedHashSet<TopicIdPartition> topicIdPartitions = new LinkedHashSet<TopicIdPartition>(this.partitionsAcquired.keySet());
            topicIdPartitions.addAll(nonTierFetchTopicPartitionData.keySet());
            this.releasePartitionLocksAndAddToActionQueue(topicIdPartitions);
        }
    }

    private LinkedHashMap<TopicIdPartition, TierFetchMetadata> maybePrepareTierFetchMetadata(LinkedHashMap<TopicIdPartition, Long> topicPartitionData, LinkedHashMap<TopicIdPartition, AbstractLogReadResult> replicaManagerReadResponse) {
        LinkedHashMap<TopicIdPartition, TierFetchMetadata> tierFetchMetadataMap = new LinkedHashMap<TopicIdPartition, TierFetchMetadata>();
        replicaManagerReadResponse.forEach((topicIdPartition, abstractLogReadResult) -> {
            if (abstractLogReadResult instanceof TierLogReadResult) {
                TierLogReadResult tierLogReadResult = (TierLogReadResult)abstractLogReadResult;
                tierFetchMetadataMap.put((TopicIdPartition)topicIdPartition, tierLogReadResult.info().fetchMetadata());
                this.partitionsAcquired.put((TopicIdPartition)topicIdPartition, (Long)topicPartitionData.get(topicIdPartition));
                this.localPartitionsAlreadyFetched.put((TopicIdPartition)topicIdPartition, (AbstractLogReadResult)abstractLogReadResult);
            }
        });
        return tierFetchMetadataMap;
    }

    private boolean maybeProcessTierFetch(LinkedHashMap<TopicIdPartition, Long> topicPartitionData, LinkedHashMap<TopicIdPartition, TierFetchMetadata> tierFetchMetadataMap) throws IllegalStateException {
        LinkedHashSet<TopicIdPartition> localFetchTopicPartitions = new LinkedHashSet<TopicIdPartition>();
        topicPartitionData.keySet().forEach(topicIdPartition -> {
            if (!tierFetchMetadataMap.containsKey(topicIdPartition)) {
                localFetchTopicPartitions.add((TopicIdPartition)topicIdPartition);
            }
        });
        this.releasePartitionLocks(localFetchTopicPartitions);
        this.processTierFetch(tierFetchMetadataMap);
        return this.maybeCompletePendingTierFetch();
    }

    private boolean maybeCompletePendingTierFetch() {
        if (this.pendingTierFetchOpt.get().isComplete()) {
            boolean completedByMe = this.forceComplete();
            if (!completedByMe) {
                this.releasePartitionLocks(this.partitionsAcquired.keySet());
            }
            return completedByMe;
        }
        return false;
    }

    private void processTierFetch(LinkedHashMap<TopicIdPartition, TierFetchMetadata> tierFetchMetadataMap) throws IllegalStateException {
        if (!this.replicaManager.tierReplicaComponents().fetcherOpt().isDefined()) {
            IllegalStateException exception = new IllegalStateException("Attempted to initiate fetch for tiered data but there is no TierFetcher present");
            this.tierStorageFetchException = Optional.of(exception);
            throw exception;
        }
        TierFetcher tierFetcher = this.replicaManager.tierReplicaComponents().fetcherOpt().get();
        int tierFetchBytesOverride = ReplicaManager$.MODULE$.tierFetchPartitionMaxBytesOverride(this.shareFetch.fetchParams().maxBytes, this.shareFetch.fetchParams().maxBytes, 0);
        PendingFetch pendingFetch = tierFetcher.fetch(tierFetchMetadataMap.values().stream().toList(), this.shareFetch.fetchParams().isolation.level, ignored -> tierFetchMetadataMap.keySet().forEach(topicIdPartition -> this.replicaManager.completeDelayedShareFetchRequest(new DelayedShareFetchGroupKey(this.shareFetch.groupId(), topicIdPartition.topicId(), topicIdPartition.partition()))), tierFetchBytesOverride);
        this.pendingTierFetchOpt = Optional.of(pendingFetch);
    }
}

