/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.PartitionDeleteInitiate;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.OffsetAndEpoch;

public class TierPartitionDeleteInitiate
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 48;
    private final TopicIdPartition topicIdPartition;
    private final PartitionDeleteInitiate metadata;

    public TierPartitionDeleteInitiate(TopicIdPartition topicIdPartition, int controllerEpoch, UUID messageId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(48).forceDefaults(true);
        PartitionDeleteInitiate.startPartitionDeleteInitiate(builder);
        PartitionDeleteInitiate.addVersion(builder, (byte)0);
        PartitionDeleteInitiate.addControllerEpoch(builder, controllerEpoch);
        int messageIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder, messageId.getMostSignificantBits(), messageId.getLeastSignificantBits());
        PartitionDeleteInitiate.addMessageId(builder, messageIdOffset);
        int entryId = PartitionDeleteInitiate.endPartitionDeleteInitiate(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionDeleteInitiate.getRootAsPartitionDeleteInitiate(builder.dataBuffer());
    }

    public TierPartitionDeleteInitiate(TopicIdPartition topicIdPartition, PartitionDeleteInitiate metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 48;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionDeleteInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public int tierEpoch() {
        return this.metadata.controllerEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return OffsetAndEpoch.EMPTY;
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    public String toString() {
        return "TierPartitionDeleteInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + String.valueOf(this.topicIdPartition()) + ", controllerEpoch=" + this.metadata.controllerEpoch() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ")";
    }
}

