/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.serdes.SegmentUploadComplete;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierSegmentUploadInitiate;

public class TierSegmentUploadComplete
extends AbstractTierSegmentMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 64;
    private final TopicIdPartition topicIdPartition;
    private final SegmentUploadComplete metadata;

    public TierSegmentUploadComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, kafka.tier.state.OffsetAndEpoch stateOffset) {
        FlatBufferBuilder builder = new FlatBufferBuilder(64).forceDefaults(true);
        int entryId = TierSegmentUploadComplete.buildSegmentUploadComplete(builder, tierEpoch, objectId, stateOffset);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentUploadComplete.getRootAsSegmentUploadComplete(builder.dataBuffer());
    }

    public TierSegmentUploadComplete(TierSegmentUploadInitiate uploadInitiate) {
        this(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), uploadInitiate.objectId(), uploadInitiate.stateOffsetAndEpoch());
    }

    public TierSegmentUploadComplete(TopicIdPartition topicIdPartition, SegmentUploadComplete metadata) {
        if (metadata.version() >= 1 && metadata.stateOffsetAndEpoch() == null) {
            throw new IllegalArgumentException(String.format("TierSegmentUploadComplete version %d must contain a stateOffsetAndEpoch.", metadata.version()));
        }
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    static int buildSegmentUploadComplete(FlatBufferBuilder builder, int tierEpoch, UUID objectId, kafka.tier.state.OffsetAndEpoch stateOffset) {
        SegmentUploadComplete.startSegmentUploadComplete(builder);
        SegmentUploadComplete.addVersion(builder, (byte)1);
        SegmentUploadComplete.addTierEpoch(builder, tierEpoch);
        int offsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        SegmentUploadComplete.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        int objectIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        SegmentUploadComplete.addObjectId(builder, objectIdOffset);
        return SegmentUploadComplete.endSegmentUploadComplete(builder);
    }

    public static int initialBufferSize() {
        return 64;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentUploadComplete;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? kafka.tier.state.OffsetAndEpoch.EMPTY : new kafka.tier.state.OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
    }

    @Override
    public UUID messageId() {
        io.confluent.kafka.storage.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public String toString() {
        return "TierSegmentUploadComplete(version=" + this.metadata.version() + ", topicIdPartition=" + String.valueOf(this.topicIdPartition()) + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", stateOffsetAndEpoch=" + String.valueOf(this.stateOffsetAndEpoch()) + ")";
    }
}

