/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTierPartitionStateSnapshotObject {
    public static final String TIER_PARTITION_STATE_METADATA_SNAPSHOTS_DIR = "snapshots";
    private static final Logger log = LoggerFactory.getLogger(FileTierPartitionStateSnapshotObject.class);
    private static final String DELIMITER = "_";
    private final UUID snapshotId;
    private final long snapshotTimestampMs;
    private final OffsetAndEpoch lastMaterializedEventOffsetAndEpoch;
    private final int tierEpoch;
    private final String baseName;
    private final Algorithm checksumAlgorithm;

    public FileTierPartitionStateSnapshotObject(UUID snapshotId, long snapshotTimestampMs, OffsetAndEpoch lastMaterializedEventOffsetAndEpoch, int tierEpoch, String baseName, Algorithm checksumAlgorithm) {
        this.snapshotId = snapshotId;
        this.snapshotTimestampMs = snapshotTimestampMs;
        this.lastMaterializedEventOffsetAndEpoch = lastMaterializedEventOffsetAndEpoch;
        this.tierEpoch = tierEpoch;
        this.baseName = baseName;
        this.checksumAlgorithm = checksumAlgorithm;
    }

    public Path encodeSnapshotName() {
        String fileName = String.join((CharSequence)DELIMITER, this.snapshotId.toString(), Long.toString(this.snapshotTimestampMs), Long.toString(this.lastMaterializedEventOffsetAndEpoch.offset()), Integer.toString(this.lastMaterializedEventOffsetAndEpoch.epoch().orElse(-1)), Integer.toString(this.tierEpoch), this.baseName);
        return FileTierPartitionState.snapshotFileName(fileName, this.checksumAlgorithm);
    }

    public static FileTierPartitionStateSnapshotObject decodeSnapshotName(String fileName) {
        if (!FileTierPartitionStateSnapshotObject.isSnapshotFile(fileName)) {
            throw new IllegalArgumentException(fileName + " does not contain `.tierstate.snapshot` as part of name");
        }
        String[] suffixArr = fileName.split(FileTierPartitionState.StateFileType.SNAPSHOT.suffix);
        if (suffixArr.length >= 3) {
            throw new IllegalArgumentException(fileName + " contains multiple `.snapshot` as part of name");
        }
        String checksumSuffix = "";
        if (suffixArr.length == 2) {
            checksumSuffix = suffixArr[1];
        }
        Algorithm checksumAlgorithm = Algorithm.toAlgorithm(checksumSuffix);
        String[] fileNameArr = suffixArr[0].split(DELIMITER);
        if (fileNameArr.length != 6) {
            throw new IllegalArgumentException(fileName + " is not formatted correctly");
        }
        int epoch = Integer.parseInt(fileNameArr[3]);
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(Long.parseLong(fileNameArr[2]), epoch == -1 ? Optional.empty() : Optional.of(epoch));
        return new FileTierPartitionStateSnapshotObject(UUID.fromString(fileNameArr[0]), Long.parseLong(fileNameArr[1]), offsetAndEpoch, Integer.parseInt(fileNameArr[4]), fileNameArr[5], checksumAlgorithm);
    }

    public static boolean isSnapshotFile(String fileName) {
        return fileName.contains(MergedLog.TierStateSuffix() + FileTierPartitionState.StateFileType.SNAPSHOT.suffix);
    }

    public static void maybeCreateAndCleanupSnapshotsDir(String basePath) throws IOException {
        Path basePathInst = Paths.get(basePath, new String[0]);
        Path snapshotsDir = basePathInst.getParent().resolve(TIER_PARTITION_STATE_METADATA_SNAPSHOTS_DIR);
        if (!FilesWrapper.exists(snapshotsDir, new LinkOption[0])) {
            FilesWrapper.createDirectories(snapshotsDir, new FileAttribute[0]);
        }
        try (DirectoryStream<Path> stream = FilesWrapper.newDirectoryStream(snapshotsDir);){
            for (Path path : stream) {
                if (!FileTierPartitionStateSnapshotObject.isSnapshotFile(path.getFileName().toString())) continue;
                log.info("Deleting tier state metadata snapshot file" + String.valueOf(path));
                FilesWrapper.delete(path);
            }
        }
    }

    public UUID snapshotId() {
        return this.snapshotId;
    }

    public long snapshotTimestampMs() {
        return this.snapshotTimestampMs;
    }

    public OffsetAndEpoch lastMaterializedEventOffsetAndEpoch() {
        return this.lastMaterializedEventOffsetAndEpoch;
    }

    public int tierEpoch() {
        return this.tierEpoch;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public String baseName() {
        return this.baseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTierPartitionStateSnapshotObject that = (FileTierPartitionStateSnapshotObject)o;
        return this.snapshotTimestampMs == that.snapshotTimestampMs && this.tierEpoch == that.tierEpoch && this.snapshotId.equals(that.snapshotId) && this.lastMaterializedEventOffsetAndEpoch.equals(that.lastMaterializedEventOffsetAndEpoch) && this.baseName.equals(that.baseName) && this.checksumAlgorithm == that.checksumAlgorithm;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotId, this.snapshotTimestampMs, this.lastMaterializedEventOffsetAndEpoch, this.tierEpoch, this.baseName, this.checksumAlgorithm});
    }

    public String toString() {
        return "FileTierPartitionStateSnapshotObject{snapshotId=" + String.valueOf(this.snapshotId) + ", snapshotTimestampMs=" + this.snapshotTimestampMs + ", lastMaterializedEventOffsetAndEpoch=" + String.valueOf(this.lastMaterializedEventOffsetAndEpoch) + ", tierEpoch=" + this.tierEpoch + ", baseName=" + this.baseName + ", checksumAlgorithm=" + String.valueOf((Object)this.checksumAlgorithm) + "}";
    }
}

