/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.store.OpaqueData;
import kafka.utils.CoreUtils;

public class SegmentState {
    private final TierObjectMetadata.State state;
    private final UUID objectId;
    private final long keyBaseOffset;
    private final int virtualBaseOffsetDelta;
    private final int endOffsetDelta;
    private final long maxTimestamp;
    private final long firstBatchTimestamp;
    private final int size;
    private final int tierEpoch;
    private final boolean hasAbortedTxns;
    private final boolean hasEpochState;
    private final boolean hasProducerState;
    private final TierUploadType uploadType;
    private final int filePosition;
    private final OpaqueData opaqueData;
    private final TierObjectMetadata.State stateBeforeDeletion;
    @Nullable
    private final SegmentAndMetadataLayout segmentAndMetadataLayout;

    public SegmentState(TierObjectMetadata metadata, long filePosition) {
        this(metadata.tierEpoch(), metadata.objectId(), metadata.virtualBaseOffset(), metadata.baseOffset(), metadata.endOffset(), metadata.maxTimestamp(), metadata.firstBatchTimestamp(), metadata.size(), metadata.state(), metadata.hasEpochState(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.uploadType(), metadata.opaqueData(), metadata.stateBeforeDeletion(), filePosition, Optional.ofNullable(metadata.segmentAndMetadataLayout()));
    }

    public SegmentState(int tierEpoch, UUID objectId, long baseOffset, long keyBaseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, TierObjectMetadata.State state, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, OpaqueData opaqueData, TierObjectMetadata.State stateBeforeDeletion, long filePosition, Optional<SegmentAndMetadataLayout> segmentAndMetadataLayoutOpt) {
        if (filePosition > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("We can't support tier-state files larger than 2147483647");
        }
        this.state = state;
        this.objectId = objectId;
        this.keyBaseOffset = keyBaseOffset;
        this.virtualBaseOffsetDelta = (int)(baseOffset - keyBaseOffset);
        this.endOffsetDelta = (int)(endOffset - keyBaseOffset);
        this.maxTimestamp = maxTimestamp;
        this.firstBatchTimestamp = firstBatchTimestamp;
        this.size = size;
        this.tierEpoch = tierEpoch;
        this.hasAbortedTxns = hasAbortedTxns;
        this.hasEpochState = hasEpochState;
        this.hasProducerState = hasProducerState;
        this.uploadType = uploadType;
        this.opaqueData = opaqueData;
        this.stateBeforeDeletion = stateBeforeDeletion;
        this.filePosition = (int)filePosition;
        this.segmentAndMetadataLayout = segmentAndMetadataLayoutOpt.orElse(null);
    }

    public long endOffset() {
        return this.keyBaseOffset + (long)this.endOffsetDelta;
    }

    public long baseOffset() {
        return this.keyBaseOffset + (long)this.virtualBaseOffsetDelta;
    }

    public long keyBaseOffset() {
        return this.keyBaseOffset;
    }

    public OpaqueData opaqueData() {
        return this.opaqueData;
    }

    public SegmentState updateState(TierObjectMetadata.State updatedState) {
        this.state.canTransitionTo(updatedState);
        TierObjectMetadata.State updatedStateBeforeDeletion = this.stateBeforeDeletion;
        if (updatedState == TierObjectMetadata.State.SEGMENT_DELETE_INITIATE) {
            updatedStateBeforeDeletion = this.state();
        }
        return new SegmentState(this.tierEpoch(), this.objectId(), this.baseOffset(), this.keyBaseOffset, this.endOffset(), this.maxTimestamp(), this.firstBatchTimestamp(), this.size(), updatedState, this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState(), this.uploadType(), this.opaqueData, updatedStateBeforeDeletion, this.filePosition(), this.segmentAndMetadataLayout());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentState that = (SegmentState)o;
        return this.tierEpoch() == that.tierEpoch() && this.objectId().equals(that.objectId()) && this.virtualBaseOffsetDelta == that.virtualBaseOffsetDelta && this.keyBaseOffset == that.keyBaseOffset && this.endOffsetDelta == that.endOffsetDelta && this.maxTimestamp() == that.maxTimestamp() && this.firstBatchTimestamp() == that.firstBatchTimestamp() && this.size() == that.size() && this.state() == that.state() && this.hasEpochState() == that.hasEpochState() && this.hasAbortedTxns() == that.hasAbortedTxns() && this.hasProducerState() == that.hasProducerState() && this.uploadType() == that.uploadType() && this.filePosition() == that.filePosition() && this.stateBeforeDeletion() == that.stateBeforeDeletion() && this.opaqueData().equals(that.opaqueData) && Objects.equals(this.segmentAndMetadataLayout, that.segmentAndMetadataLayout);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierEpoch(), this.objectId(), this.virtualBaseOffsetDelta, this.keyBaseOffset, this.endOffsetDelta, this.maxTimestamp(), this.firstBatchTimestamp(), this.size(), this.state(), this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState(), this.uploadType(), this.filePosition(), this.stateBeforeDeletion(), this.opaqueData(), this.segmentAndMetadataLayout()});
    }

    public String toString() {
        return "SegmentState(state: " + String.valueOf((Object)this.state()) + ", tierEpoch: " + this.tierEpoch() + ", objectId: " + CoreUtils.uuidToBase64(this.objectId()) + ", baseOffset: " + this.baseOffset() + ", keyBaseOffset: " + this.keyBaseOffset + ", endOffset: " + this.endOffset() + ", maxTimestamp: " + this.maxTimestamp() + ", firstBatchTimestamp: " + this.firstBatchTimestamp() + ", size: " + this.size() + ", hasEpochState: " + this.hasEpochState() + ", hasAbortedTxns: " + this.hasAbortedTxns() + ", hasProducerState: " + this.hasProducerState() + ", uploadType: " + String.valueOf((Object)this.uploadType()) + ", filePosition: " + this.filePosition() + ", stateBeforeDeletion: " + String.valueOf((Object)this.stateBeforeDeletion()) + ", opaqueData: " + String.valueOf(this.opaqueData()) + ", segmentAndMetadataLayout: " + String.valueOf(this.segmentAndMetadataLayout()) + ")";
    }

    public TierObjectMetadata.State state() {
        return this.state;
    }

    public UUID objectId() {
        return this.objectId;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public long firstBatchTimestamp() {
        return this.firstBatchTimestamp;
    }

    public int size() {
        return this.size;
    }

    public int tierEpoch() {
        return this.tierEpoch;
    }

    public boolean hasAbortedTxns() {
        return this.hasAbortedTxns;
    }

    public boolean hasEpochState() {
        return this.hasEpochState;
    }

    public boolean hasProducerState() {
        return this.hasProducerState;
    }

    public TierUploadType uploadType() {
        return this.uploadType;
    }

    public TierObjectMetadata.State stateBeforeDeletion() {
        return this.stateBeforeDeletion;
    }

    public int filePosition() {
        return this.filePosition;
    }

    public Optional<SegmentAndMetadataLayout> segmentAndMetadataLayout() {
        return Optional.ofNullable(this.segmentAndMetadataLayout);
    }
}

