/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.SyncPoller;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobBeginCopyOptions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.AzureBlockBlobAutoAbortingInputStream;
import kafka.tier.store.AzureBlockBlobTierObjectStoreConfig;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.CombinedObjectStream;
import kafka.tier.store.ThrottledFileInputStream;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreByokUtils;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.AzureTenantAwareEncryptionManager;
import kafka.tier.store.encryption.EncryptionKeyCacheRefiller;
import kafka.tier.store.encryption.FtpsEncryptionKeyCacheRefiller;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.ThrottledSegmentUpload;
import kafka.tier.store.objects.TierSegmentUpload;
import kafka.tier.store.objects.metadata.HealthMetadata;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.CoreUtils;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.utils.Throttler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class AzureBlockBlobTierObjectStore
extends TierObjectStore {
    private static final Logger log = LoggerFactory.getLogger(AzureBlockBlobTierObjectStore.class);
    private final BlobServiceClient blobServiceClient;
    public final BlobContainerClient blobContainerClient;
    private final BlobServiceAsyncClient blobServiceAsyncClient;
    public final BlobContainerAsyncClient blobContainerAsyncClient;
    private final Optional<String> clusterIdOpt;
    private final Optional<Integer> brokerIdOpt;
    private final String container;
    private final String prefix;
    private final int drainThreshold;
    private final AzureBlockBlobTierObjectStoreConfig config;
    private Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt = Optional.empty();
    private Optional<EncryptionKeyCacheRefiller> encryptionKeyCacheRefillerOpt = Optional.empty();
    private final Time time;
    private final Metrics metrics;
    private static final long DEFAULT_TIMEOUT_IN_SECS = 30L;

    public AzureBlockBlobTierObjectStore(AzureBlockBlobTierObjectStoreConfig config, Time time, Metrics metrics) {
        this.clusterIdOpt = config.clusterIdOpt;
        this.brokerIdOpt = config.brokerIdOpt;
        this.container = config.container;
        this.prefix = config.azureBlobPrefix;
        this.drainThreshold = config.drainThreshold;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.blobServiceClient = AzureBlockBlobTierObjectStore.createServiceClient(config);
        this.blobContainerClient = AzureBlockBlobTierObjectStore.createContainerClient(this.blobServiceClient, config);
        this.blobServiceAsyncClient = AzureBlockBlobTierObjectStore.createServiceAsyncClient(config);
        this.blobContainerAsyncClient = AzureBlockBlobTierObjectStore.createContainerAsyncClient(this.blobServiceAsyncClient, config);
    }

    public AzureBlockBlobTierObjectStore(AzureBlockBlobTierObjectStoreConfig config, Time time, Metrics metrics, BlobServiceClient blobServiceClient, BlobContainerClient blobContainerClient, BlobServiceAsyncClient blobServiceAsyncClient, BlobContainerAsyncClient blobContainerAsyncClient) {
        this.clusterIdOpt = config.clusterIdOpt;
        this.brokerIdOpt = config.brokerIdOpt;
        this.container = config.container;
        this.prefix = config.azureBlobPrefix;
        this.drainThreshold = config.drainThreshold;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.blobServiceClient = blobServiceClient;
        this.blobContainerClient = blobContainerClient;
        this.blobServiceAsyncClient = blobServiceAsyncClient;
        this.blobContainerAsyncClient = blobContainerAsyncClient;
    }

    @Override
    public String keyPrefix() {
        return this.prefix;
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.AzureBlockBlob;
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        HashMap<String, List<VersionInformation>> results = new HashMap<String, List<VersionInformation>>();
        Duration timeout = Duration.ofSeconds(30L);
        try {
            ListBlobsOptions options = new ListBlobsOptions().setPrefix(keyPrefix).setDetails(new BlobListDetails().setRetrieveVersions(getVersionInfo));
            PagedIterable<BlobItem> blobItems = this.blobContainerClient.listBlobs(options, timeout);
            for (BlobItem blobItem : blobItems) {
                results.putIfAbsent(blobItem.getName(), new ArrayList());
                if (!getVersionInfo) continue;
                ((List)results.get(blobItem.getName())).add(new VersionInformation(blobItem.getVersionId()));
            }
            if (log.isDebugEnabled()) {
                StringBuilder allBlobs = new StringBuilder();
                results.forEach((key, versions) -> allBlobs.append("[").append((String)key).append("->").append(Arrays.toString(versions.toArray())).append("] "));
                log.debug("TierObjectStore listObjects versions: " + getVersionInfo + " prefix: " + keyPrefix + " " + String.valueOf(allBlobs));
            }
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to list objects with keyPrefix: %s, getVersionInfo: %b", keyPrefix, getVersionInfo), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to list objects with keyPrefix: %s, getVersionInfo: %b", keyPrefix, getVersionInfo), e);
        }
        return results;
    }

    @Override
    public CompletableFuture<Map<String, List<VersionInformation>>> listObjectAsync(String keyPrefix, boolean getVersionInfo) {
        CompletableFuture<Map<String, List<VersionInformation>>> future = new CompletableFuture<Map<String, List<VersionInformation>>>();
        try {
            HashMap results = new HashMap();
            ListBlobsOptions options = new ListBlobsOptions().setPrefix(keyPrefix).setDetails(new BlobListDetails().setRetrieveVersions(getVersionInfo));
            this.blobContainerAsyncClient.listBlobs(options).subscribe(blobItem -> {
                results.putIfAbsent(blobItem.getName(), new ArrayList());
                if (getVersionInfo) {
                    ((List)results.get(blobItem.getName())).add(new VersionInformation(blobItem.getVersionId()));
                }
            }, e -> future.completeExceptionally(this.convertOperationException((Throwable)e, String.format("list object (getVersionInfo: %b)", getVersionInfo), keyPrefix, null, null, null, null)), () -> future.complete(results));
        }
        catch (Exception e2) {
            log.error("Failed to send async list request, keyPrefix: {}, getVersionInfo: {}", new Object[]{keyPrefix, getVersionInfo, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    @Override
    public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        ByteBuffer buffer;
        if (FragmentType.checkGetSnapshotSupported(fragmentType)) {
            throw new IllegalArgumentException("getSnapshot does not support the given fragmentType: " + String.valueOf((Object)fragmentType));
        }
        try (TierObjectStoreResponse response = this.getObjectStoreFragment(metadata, fragmentType);){
            buffer = ByteBuffer.wrap(Utils.readFullyToArray(response.getInputStream(), estimatedBufferSize));
        }
        catch (Exception e) {
            for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                if (!(cause instanceof BlobStorageException) || !BlobErrorCode.BLOB_NOT_FOUND.equals(((BlobStorageException)cause).getErrorCode())) continue;
                throw new TierObjectStoreFatalException("Snapshot object not found in object store.", cause);
            }
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", e);
        }
        return buffer;
    }

    @Override
    public CompletableFuture<ByteBuffer> getSnapshotAsync(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        if (FragmentType.checkGetSnapshotSupported(fragmentType)) {
            CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
            future.completeExceptionally(new IllegalArgumentException("getSnapshotAsync does not support the given fragmentType: " + String.valueOf((Object)fragmentType)));
            return future;
        }
        return ((CompletableFuture)this.getObjectStoreFragmentAsync(metadata, fragmentType).thenApply(response -> {
            try {
                return ByteBuffer.wrap(Utils.readFullyToArray(response.getInputStream(), estimatedBufferSize));
            }
            catch (IOException e) {
                throw new TierObjectStoreRetriableException("Failed to read snapshot from object store.", e);
            }
        })).exceptionally(e -> {
            for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                if (!(cause instanceof BlobStorageException) || !BlobErrorCode.BLOB_NOT_FOUND.equals(((BlobStorageException)cause).getErrorCode())) continue;
                throw new TierObjectStoreFatalException("Snapshot object not found in object store.", cause);
            }
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", (Throwable)e);
        });
    }

    private CustomerProvidedKey maybeGetCustomerProvidedKeyForObject(String key, ObjectType objectType, ObjectStoreMetadata objectMetadata) {
        byte[] rawEncryptionKey = TierObjectStoreByokUtils.maybeGetRawEncryptionKeyForObject(key, objectType, objectMetadata, this.encryptionKeyManagerOpt, this.encryptionKeyCacheRefillerOpt, log);
        if (rawEncryptionKey == null) {
            return null;
        }
        return new CustomerProvidedKey(rawEncryptionKey);
    }

    @Override
    public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        InputStream inputStream;
        String key = this.keyPath(objectMetadata, objectType);
        CustomerProvidedKey customerProvidedKey = this.maybeGetCustomerProvidedKeyForObject(key, objectType, objectMetadata);
        BlobClient blob = this.getBlobClient(key, customerProvidedKey, versionInformation);
        AzureBlockBlobTierObjectStore.checkOffsets(byteOffsetStart, byteOffsetEndExclusive);
        log.debug("Fetching object from {}/{}, with range of {} to {}", new Object[]{this.container, key, byteOffsetStart, byteOffsetEndExclusive});
        long byteOffsetStartLong = byteOffsetStart != null ? byteOffsetStart : 0L;
        BlobRange range = byteOffsetEndExclusive != null ? new BlobRange(byteOffsetStartLong, byteOffsetEndExclusive - byteOffsetStartLong) : new BlobRange(byteOffsetStartLong);
        try {
            inputStream = this.getInputStreamFromBlobClient(blob, range);
        }
        catch (Exception e) {
            throw this.convertOperationException(e, "fetch object", key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive);
        }
        Long streamSize = range.getCount();
        return new AzureBlockBlobTierObjectStoreResponse(inputStream, this.drainThreshold, streamSize == null ? Long.MAX_VALUE : streamSize);
    }

    @Override
    protected CompletableFuture<TierObjectStoreResponse> getObjectAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        CompletableFuture<TierObjectStoreResponse> future = new CompletableFuture<TierObjectStoreResponse>();
        try {
            String key = this.keyPath(objectMetadata, objectType);
            CustomerProvidedKey customerProvidedKey = this.maybeGetCustomerProvidedKeyForObject(key, objectType, objectMetadata);
            BlobAsyncClient blob = this.getBlobAsyncClient(key, customerProvidedKey, versionInformation);
            AzureBlockBlobTierObjectStore.checkOffsets(byteOffsetStart, byteOffsetEndExclusive);
            log.debug("Fetching object async from {}/{}, with range of {} to {}", new Object[]{this.container, key, byteOffsetStart, byteOffsetEndExclusive});
            long byteOffsetStartLong = byteOffsetStart == null ? 0L : byteOffsetStart;
            BlobRange range = byteOffsetEndExclusive != null ? new BlobRange(byteOffsetStartLong, byteOffsetEndExclusive - byteOffsetStartLong) : new BlobRange(byteOffsetStartLong);
            Long streamSize = range.getCount();
            blob.getBlockBlobAsyncClient().downloadStreamWithResponse(range, null, new BlobRequestConditions(), false).flatMap(response -> streamSize == null ? FluxUtil.collectBytesInByteBufferStream((Flux)response.getValue()) : FluxUtil.collectBytesInByteBufferStream((Flux)response.getValue(), streamSize.intValue())).subscribe(bytes -> future.complete(new AzureBlockBlobTierObjectStoreResponse(new ByteArrayInputStream((byte[])bytes), this.drainThreshold, ((byte[])bytes).length)), e -> future.completeExceptionally(this.convertOperationException((Throwable)e, "fetch object", key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive)));
        }
        catch (Exception e2) {
            log.error("Failed to send async fetch request, metadata: {}, type: {}", new Object[]{objectMetadata, objectType, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private RuntimeException convertOperationException(Throwable e, String action, String key, ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive) {
        if (e instanceof BlobStorageException) {
            if (BlobErrorCode.BLOB_NOT_FOUND.equals(((BlobStorageException)e).getErrorCode())) {
                return new TierObjectStoreFatalException(String.format("Failed %s with key: %s, metadata: %s type: %s range %s-%s. Object not found.", new Object[]{action, key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
            }
            return new TierObjectStoreRetriableException(String.format("Failed %s with key: %s, metadata: %s type: %s range %s-%s", new Object[]{action, key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
        }
        if (e instanceof RuntimeException) {
            return new TierObjectStoreRetriableException(String.format("Runtime exception when %s with key: %s, metadata: %s type: %s range %s-%s", new Object[]{action, key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
        }
        return new TierObjectStoreFatalException(String.format("Unknown exception when %s with key: %s, metadata: %s type: %s range %s-%s", new Object[]{action, key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
    }

    private static void checkOffsets(Long byteOffsetStartOpt, Long byteOffsetEndExclusiveOpt) {
        if (byteOffsetStartOpt != null && byteOffsetEndExclusiveOpt != null && byteOffsetStartOpt > byteOffsetEndExclusiveOpt) {
            throw new IllegalStateException(String.format("Invalid range of byteOffsetStart=%d and byteOffsetEndExclusive=%d", byteOffsetStartOpt, byteOffsetEndExclusiveOpt));
        }
        if (byteOffsetStartOpt == null && byteOffsetEndExclusiveOpt != null) {
            throw new IllegalStateException(String.format("Cannot specify a byteOffsetEndExclusive=%d without specifying a byteOffsetStart", byteOffsetEndExclusiveOpt));
        }
    }

    InputStream getInputStreamFromBlobClient(BlobClient blob, BlobRange range) {
        return blob.getBlockBlobClient().openInputStream(range, new BlobRequestConditions());
    }

    private CustomerProvidedKey generateCustomerProvidedKey(TopicIdPartition topicIdPartition, KeySha keySha) {
        byte[] rawEncryptionKey = TierObjectStoreByokUtils.generateRawEncryptionKeyForObject(topicIdPartition, keySha, this.encryptionKeyManagerOpt);
        return new CustomerProvidedKey(rawEncryptionKey);
    }

    private BlobClient getBlobClientWithCustomerProvidedKeyGeneration(ObjectMetadata objectMetadata, String key) {
        if (TierObjectStoreByokUtils.shouldUploadEncrypted(objectMetadata, key, this.encryptionKeyManagerOpt)) {
            KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
            CustomerProvidedKey customerProvidedKey = this.generateCustomerProvidedKey(objectMetadata.topicIdPartition(), keySha);
            return this.getBlobClient(key, customerProvidedKey);
        }
        return this.blobContainerClient.getBlobClient(key);
    }

    private BlobClient getBlobClient(String key, CustomerProvidedKey customerProvidedKey) {
        return this.getBlobClient(key, customerProvidedKey, null);
    }

    private BlobClient getBlobClient(String key, CustomerProvidedKey customerProvidedKey, VersionInformation versionInformation) {
        BlobClient blob = versionInformation != null ? this.blobContainerClient.getBlobVersionClient(key, versionInformation.getVersionId()) : this.blobContainerClient.getBlobClient(key);
        return customerProvidedKey != null ? blob.getCustomerProvidedKeyClient(customerProvidedKey) : blob;
    }

    private BlobAsyncClient getBlobAsyncClient(String key, CustomerProvidedKey customerProvidedKey) {
        return this.getBlobAsyncClient(key, customerProvidedKey, null);
    }

    private BlobAsyncClient getBlobAsyncClient(String key, CustomerProvidedKey customerProvidedKey, VersionInformation versionInformation) {
        BlobAsyncClient blob = versionInformation != null ? this.blobContainerAsyncClient.getBlobVersionAsyncClient(key, versionInformation.getVersionId()) : this.blobContainerAsyncClient.getBlobAsyncClient(key);
        return customerProvidedKey != null ? blob.getCustomerProvidedKeyAsyncClient(customerProvidedKey) : blob;
    }

    @Override
    public TierObjectStore.ByokKeyHolder prepPutSegment(TopicIdPartition topicIdPartition) throws TierObjectStoreRetriableException, IOException {
        return TierObjectStoreByokUtils.getByokKeyHolderForTopicIdPartition(topicIdPartition, this.encryptionKeyManagerOpt, log);
    }

    private void putSegmentAsMultiObject(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        ObjectMetadata objectMetadata = tierSegmentUpload.objectMetadata();
        if (tierSegmentUpload.throttlerOpt().isPresent() && tierSegmentUpload instanceof ThrottledSegmentUpload) {
            ThrottledSegmentUpload upload = (ThrottledSegmentUpload)tierSegmentUpload;
            this.putFileEncryptedWithThrottling(this.keyPath(upload.objectMetadata(), ObjectType.SEGMENT), objectMetadata, upload.segment(), upload.throttlerOpt().get());
            this.putFileEncryptedWithThrottling(this.keyPath(upload.objectMetadata(), ObjectType.OFFSET_INDEX), objectMetadata, upload.offsetIdx(), upload.throttlerOpt().get());
            this.putFileEncryptedWithThrottling(this.keyPath(upload.objectMetadata(), ObjectType.TIMESTAMP_INDEX), objectMetadata, upload.timestampIdx(), upload.throttlerOpt().get());
            if (upload.producerStateSnapshotOpt().isPresent()) {
                this.putFileEncryptedWithThrottling(this.keyPath(upload.objectMetadata(), ObjectType.PRODUCER_STATE), objectMetadata, (File)upload.producerStateSnapshotOpt().get(), upload.throttlerOpt().get());
            }
        } else {
            this.putFileEncrypted(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT), objectMetadata, tierSegmentUpload.segment());
            this.putFileEncrypted(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.OFFSET_INDEX), objectMetadata, tierSegmentUpload.offsetIdx());
            this.putFileEncrypted(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TIMESTAMP_INDEX), objectMetadata, tierSegmentUpload.timestampIdx());
            if (tierSegmentUpload.producerStateSnapshotOpt().isPresent()) {
                Object producerState = tierSegmentUpload.producerStateSnapshotOpt().get();
                if (producerState instanceof File) {
                    this.putFileEncrypted(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), objectMetadata, (File)producerState);
                } else if (producerState instanceof ByteBuffer) {
                    this.putBufEncrypted(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), objectMetadata, (ByteBuffer)producerState);
                }
            }
        }
        if (tierSegmentUpload.txnIdxOpt().isPresent()) {
            this.putBufEncrypted(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TRANSACTION_INDEX), objectMetadata, tierSegmentUpload.txnIdxOpt().get());
        }
        if (tierSegmentUpload.epochStateOpt().isPresent()) {
            this.putBufEncrypted(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.EPOCH_STATE), objectMetadata, tierSegmentUpload.epochStateOpt().get());
        }
    }

    private void putSegmentAsCombinedObject(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        try (CombinedObjectStream combinedObjectStream = tierSegmentUpload.makeCombinedObjectStream();){
            String combinedObjectKeyPath = this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT_WITH_METADATA);
            this.putInputStream(combinedObjectKeyPath, tierSegmentUpload.objectMetadata(), combinedObjectStream, combinedObjectStream.length());
        }
    }

    private void putInputStream(String key, ObjectMetadata objectMetadata, InputStream stream, long contentLength) {
        if (!stream.markSupported()) {
            log.warn("[{}] InputStream does not support mark/reset, wrapping in BufferedInputStream", (Object)key);
            stream = new BufferedInputStream(stream);
        }
        BlobClient blobClient = this.getBlobClientWithCustomerProvidedKeyGeneration(objectMetadata, key);
        blobClient.getBlockBlobClient().uploadWithResponse(stream, contentLength, new BlobHttpHeaders(), objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), AccessTier.HOT, null, new BlobRequestConditions(), null, null);
    }

    @Override
    public void putSegment(TierSegmentUpload<?> tierSegmentUpload) {
        try {
            switch (tierSegmentUpload.putMode()) {
                case LegacyMultiObject: {
                    this.putSegmentAsMultiObject(tierSegmentUpload);
                    break;
                }
                case CombinedObject: {
                    this.putSegmentAsCombinedObject(tierSegmentUpload);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported segment PUT mode: " + String.valueOf((Object)tierSegmentUpload.putMode()));
                }
            }
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException("Failed to upload segment " + String.valueOf(tierSegmentUpload.objectMetadata()), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when uploading segment: " + String.valueOf(tierSegmentUpload.objectMetadata()), e);
        }
    }

    @Override
    public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try {
            String key = this.keyPath(objectMetadata, objectType);
            this.putFile(key, metadata, file);
            return key;
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to upload object %s, file %s, type %s", new Object[]{objectMetadata, file, objectType}), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to upload object %s, file %s, type %s", new Object[]{objectMetadata, file, objectType}), e);
        }
    }

    @Override
    public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try {
            String key = this.keyPath(objectMetadata, objectType);
            this.putBuf(key, metadata, buffer);
            return key;
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to upload object %s, buffer %s, type %s", new Object[]{objectMetadata, buffer, objectType}), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to upload object %s, buffer %s, type %s", new Object[]{objectMetadata, buffer, objectType}), e);
        }
    }

    @Override
    public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        String lastLiveVersionId = lastLiveVersion.getVersionId();
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try {
            BlobClient blobSource = this.blobContainerClient.getBlobVersionClient(key, lastLiveVersionId);
            String copySource = blobSource.getBlobUrl();
            log.debug(String.format("Azure restore key: %s lastLiveVersionId: %s copySource: %s", key, lastLiveVersionId, copySource));
            BlobClient blobDest = this.blobContainerClient.getBlobClient(key);
            BlobBeginCopyOptions options = new BlobBeginCopyOptions(copySource).setMetadata(metadata).setTier(AccessTier.HOT);
            SyncPoller<BlobCopyInfo, Void> syncPoller = blobDest.beginCopy(options);
            PollResponse<BlobCopyInfo> pollResponse = syncPoller.waitUntil(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED);
            log.debug(String.format("Azure restore key: %s response status: %s", key, pollResponse.getStatus()));
        }
        catch (BlobStorageException e) {
            if (BlobErrorCode.BLOB_NOT_FOUND.equals(e.getErrorCode())) {
                throw new TierObjectStoreFatalException(String.format("Failed to restore object %s (version: %s) as blob not found", key, lastLiveVersionId), e);
            }
            throw new TierObjectStoreRetriableException(String.format("Failed to restore object %s (version: %s)", key, lastLiveVersionId), e);
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to restore object %s (version: %s)", key, lastLiveVersionId), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Unknown exception when restoring object %s (version: %s)", key, lastLiveVersionId), e);
        }
    }

    @Override
    public CompletableFuture<Void> restoreObjectByCopyAsync(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            String lastLiveVersionId = lastLiveVersion.getVersionId();
            Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
            BlobAsyncClient blobSource = this.blobContainerAsyncClient.getBlobVersionAsyncClient(key, lastLiveVersionId);
            String copySource = blobSource.getBlobUrl();
            log.debug(String.format("Azure restore (async) key: %s lastLiveVersionId: %s copySource: %s", key, lastLiveVersionId, copySource));
            BlobAsyncClient blobDest = this.blobContainerAsyncClient.getBlobAsyncClient(key);
            BlobBeginCopyOptions options = new BlobBeginCopyOptions(copySource).setMetadata(metadata).setTier(AccessTier.HOT);
            blobDest.beginCopy(options).subscribe(response -> log.debug(String.format("Azure restore (async) key: %s response status: %s", key, response.getStatus())), e -> future.completeExceptionally(this.convertOperationException((Throwable)e, String.format("restore object (version %s)", lastLiveVersionId), key, objectMetadata, null, null, null)), () -> future.complete(null));
        }
        catch (Exception e2) {
            log.error("Failed to send async restore request, metadata: {}, key: {}", new Object[]{objectMetadata, key, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    @Override
    public void deleteSegment(ObjectMetadata objectMetadata) {
        List<String> keys = this.keysForSegment(objectMetadata);
        for (String key : keys) {
            try {
                BlobClient blob = this.blobContainerClient.getBlobClient(key);
                log.debug("Deleting " + key);
                blob.delete();
            }
            catch (BlobStorageException be) {
                if (BlobErrorCode.BLOB_NOT_FOUND.equals(be.getErrorCode())) continue;
                throw new TierObjectStoreRetriableException("Failed to delete file " + key, be);
            }
            catch (RuntimeException e) {
                throw new TierObjectStoreRetriableException("Failed to delete file " + key, e);
            }
            catch (Exception e) {
                throw new TierObjectStoreFatalException("Unknown exception when deleting segment " + String.valueOf(objectMetadata), e);
            }
        }
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        Duration timeout = Duration.ofSeconds(30L);
        for (TierObjectStore.KeyAndVersion key : keys) {
            BlobClient blobClient = key.versionId() == null ? this.blobContainerClient.getBlobClient(key.key()) : this.blobContainerClient.getBlobVersionClient(key.key(), key.versionId());
            try {
                Response<Void> response = blobClient.deleteWithResponse(null, null, timeout, Context.NONE);
                log.debug("TierObjectStore delete request for " + String.valueOf(key) + " statusCode: " + response.getStatusCode());
            }
            catch (RuntimeException e) {
                throw new TierObjectStoreRetriableException("Failed to delete versioned objects: " + String.valueOf(key), e);
            }
            catch (Exception e) {
                throw new TierObjectStoreFatalException("Unknown exception when deleting versioned objects: " + String.valueOf(key), e);
            }
        }
    }

    @Override
    public CompletableFuture<Void> deleteVersionsAsync(List<TierObjectStore.KeyAndVersion> keys) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            ArrayList futures = new ArrayList();
            for (TierObjectStore.KeyAndVersion key : keys) {
                CompletableFuture deleteFuture = new CompletableFuture();
                BlobAsyncClient blobClient = key.versionId() == null ? this.blobContainerAsyncClient.getBlobAsyncClient(key.key()) : this.blobContainerAsyncClient.getBlobVersionAsyncClient(key.key(), key.versionId());
                futures.add(deleteFuture);
                blobClient.deleteWithResponse(null, null).subscribe(response -> log.debug("TierObjectStore delete request (async) for " + String.valueOf(key) + " statusCode: " + response.getStatusCode()), e -> deleteFuture.completeExceptionally(this.convertOperationException((Throwable)e, "delete versioned objects", key.key(), null, null, null, null)), () -> deleteFuture.complete(null));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((response, e) -> {
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                } else {
                    future.complete(null);
                }
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async delete request, keys: {}", keys, (Object)e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    @Override
    public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType type) throws IOException, TierObjectStoreRetriableException {
        String key = this.keyPath(objectMetadata, type);
        TierObjectAttribute result = new TierObjectAttribute(false);
        CustomerProvidedKey customerProvidedKey = this.maybeGetCustomerProvidedKeyForObject(key, type, objectMetadata);
        try {
            BlobClient client = this.getBlobClient(key, customerProvidedKey);
            if (client.exists().booleanValue()) {
                result.size = client.getProperties().getBlobSize();
                result.exist = true;
                log.trace("objectExists at {}/{} with size {}", new Object[]{this.container, key, result.size});
            }
        }
        catch (Exception e) {
            throw this.convertCheckObjectAttributeException(e, key, objectMetadata);
        }
        return result;
    }

    @Override
    public CompletableFuture<TierObjectAttribute> objectExistsAsync(ObjectStoreMetadata objectMetadata, ObjectType type) {
        CompletableFuture<TierObjectAttribute> future = new CompletableFuture<TierObjectAttribute>();
        try {
            String key = this.keyPath(objectMetadata, type);
            CustomerProvidedKey customerProvidedKey = this.maybeGetCustomerProvidedKeyForObject(key, type, objectMetadata);
            BlobAsyncClient client = this.getBlobAsyncClient(key, customerProvidedKey);
            client.exists().subscribe(clientExists -> {
                if (clientExists.booleanValue()) {
                    client.getProperties().subscribe(properties -> {
                        log.trace("objectExists (async) at {}/{} with size {}", new Object[]{this.container, key, properties.getBlobSize()});
                        future.complete(new TierObjectAttribute(true, properties.getBlobSize()));
                    }, e -> future.completeExceptionally(this.convertCheckObjectAttributeException((Throwable)e, key, objectMetadata)));
                } else {
                    future.complete(new TierObjectAttribute(false));
                }
            }, e -> future.completeExceptionally(this.convertCheckObjectAttributeException((Throwable)e, key, objectMetadata)));
        }
        catch (Exception e2) {
            log.error("Failed to send objectExistsAsync request, metadata: {}, type: {}", new Object[]{objectMetadata, type, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private RuntimeException convertCheckObjectAttributeException(Throwable e, String key, ObjectStoreMetadata objectMetadata) {
        if (e instanceof RuntimeException) {
            return new TierObjectStoreRetriableException("Failed to check for object attributes with metadata " + String.valueOf(objectMetadata) + " @ " + key, e);
        }
        return new TierObjectStoreFatalException("Unknown exception while checking for object attributes with metadata " + String.valueOf(objectMetadata) + " @ " + key, e);
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        try {
            ByteBuffer payload = TierObjectStoreUtils.timeHealthPayload();
            HealthMetadata metadata = new HealthMetadata(this.clusterIdOpt, this.brokerIdOpt);
            String key = metadata.toFragmentLocation(this.prefix, FragmentType.HEALTH_CHECK).get().objectPath();
            this.putBuf(key, metadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), payload);
            try (InputStream inputStream = this.getObjectStoreFragment(metadata, FragmentType.HEALTH_CHECK).getInputStream();){
                int read;
                while ((read = inputStream.read()) > 0) {
                    log.trace("Bucket probe read {} bytes", (Object)read);
                }
            }
            BlobClient blob = this.blobContainerClient.getBlobClient(key);
            log.debug("Deleting " + key);
            blob.delete();
            return BucketHealthResult.HEALTHY;
        }
        catch (Exception e) {
            log.error("Bucket health checker returned unclassified error", (Throwable)e);
            return BucketHealthResult.UNCLASSIFIED;
        }
    }

    @Override
    public void initMultiTenantEncryptionSupport(MultiTenantMetadata multiTenantMetadata, ReplicaManager replicaManager, KafkaScheduler kafkaScheduler) {
        if (this.config.tenantAwareEncryptionKeyManagerEnable) {
            log.info("Initializing AzureTenantAwareEncryptionManager");
            this.encryptionKeyManagerOpt = Optional.of(new AzureTenantAwareEncryptionManager(this.blobContainerClient, this.config, kafkaScheduler, multiTenantMetadata, this.time, this.metrics));
            this.encryptionKeyCacheRefillerOpt = Optional.of(new FtpsEncryptionKeyCacheRefiller(replicaManager));
        } else {
            log.info("Skipping initialization of AzureTenantAwareEncryptionManager");
        }
    }

    void setEncryptionKeyManagerOpt(AzureTenantAwareEncryptionManager tenantAwareEncryptionManager) {
        this.encryptionKeyManagerOpt = Optional.of(tenantAwareEncryptionManager);
    }

    void setEncryptionKeyCacheRefillerOpt(EncryptionKeyCacheRefiller encryptionKeyCacheRefiller) {
        this.encryptionKeyCacheRefillerOpt = Optional.of(encryptionKeyCacheRefiller);
    }

    private void putFile(String key, Map<String, String> metadata, File file) {
        this.uploadFile(this.blobContainerClient.getBlobClient(key), key, metadata, file);
    }

    private void putFileEncrypted(String key, ObjectMetadata objectMetadata, File file) {
        this.uploadFile(this.getBlobClientWithCustomerProvidedKeyGeneration(objectMetadata, key), key, objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), file);
    }

    private void uploadFile(BlobClient blobClient, String key, Map<String, String> metadata, File file) {
        blobClient.uploadFromFile(file.getPath(), new ParallelTransferOptions(), new BlobHttpHeaders(), metadata, AccessTier.HOT, new BlobRequestConditions(), null);
        log.debug("Uploaded file to {}/{}", (Object)this.container, (Object)key);
    }

    private void putFileEncryptedWithThrottling(String key, ObjectMetadata objectMetadata, File file, Throttler throttler) throws IOException {
        BlobClient blobClient = this.getBlobClientWithCustomerProvidedKeyGeneration(objectMetadata, key);
        try (BufferedInputStream inputStream = new BufferedInputStream(new ThrottledFileInputStream(file, throttler));){
            blobClient.getBlockBlobClient().uploadWithResponse(inputStream, file.length(), new BlobHttpHeaders(), objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), AccessTier.HOT, null, new BlobRequestConditions(), null, null);
        }
        log.debug("Uploaded file with throttling to {}/{}", (Object)this.container, (Object)key);
    }

    public void putBuf(String key, Map<String, String> metadata, ByteBuffer buf) throws IOException {
        this.uploadBuffer(this.blobContainerClient.getBlobClient(key), key, metadata, buf);
    }

    public void putBufEncrypted(String key, ObjectMetadata objectMetadata, ByteBuffer buf) throws IOException {
        this.uploadBuffer(this.getBlobClientWithCustomerProvidedKeyGeneration(objectMetadata, key), key, objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), buf);
    }

    private void uploadBuffer(BlobClient blobClient, String key, Map<String, String> metadata, ByteBuffer buf) throws IOException {
        byte[] md5 = CoreUtils.md5hash(buf);
        try (BufferedInputStream inputStream = new BufferedInputStream(new ByteBufferInputStream(buf.duplicate()));){
            blobClient.getBlockBlobClient().uploadWithResponse(inputStream, buf.limit() - buf.position(), new BlobHttpHeaders().setContentMd5(md5), metadata, AccessTier.HOT, md5, new BlobRequestConditions(), null, null);
        }
        log.debug("Uploaded buffer to {}/{}", (Object)this.container, (Object)key);
    }

    private List<String> keysForSegment(ObjectMetadata objectMetadata) {
        if (objectMetadata.isCombinedObject(this.prefix)) {
            return Collections.singletonList(this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA));
        }
        ArrayList<String> keys = new ArrayList<String>();
        block5: for (ObjectType objectType : TierObjectStore.getObjectTypesPerSegment()) {
            switch (objectType) {
                case TRANSACTION_INDEX: {
                    if (!objectMetadata.hasAbortedTxns()) continue block5;
                    keys.add(this.keyPath(objectMetadata, objectType));
                    continue block5;
                }
                case EPOCH_STATE: {
                    if (!objectMetadata.hasEpochState()) continue block5;
                    keys.add(this.keyPath(objectMetadata, objectType));
                    continue block5;
                }
                case PRODUCER_STATE: {
                    if (!objectMetadata.hasProducerState()) continue block5;
                    keys.add(this.keyPath(objectMetadata, objectType));
                    continue block5;
                }
            }
            keys.add(this.keyPath(objectMetadata, objectType));
        }
        return keys;
    }

    private static BlobServiceClientBuilder createServiceClientBuilder(AzureBlockBlobTierObjectStoreConfig config) {
        BlobServiceClientBuilder blobServiceClientBuilder;
        if (config.azureCredentialsConfig.isPresent()) {
            AzureBlockBlobTierObjectStoreConfig.AzureCredentialsConfig azureCredentialsConfig = config.azureCredentialsConfig.get();
            if (azureCredentialsConfig.connectionStringAuthMethod().booleanValue()) {
                blobServiceClientBuilder = new BlobServiceClientBuilder().connectionString(azureCredentialsConfig.connectionString());
            } else {
                ClientSecretCredential credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(azureCredentialsConfig.azureClientId())).tenantId(azureCredentialsConfig.azureTenantId())).clientSecret(azureCredentialsConfig.azureClientSecret()).build();
                blobServiceClientBuilder = new BlobServiceClientBuilder().endpoint(config.endpoint.get()).credential(credential);
            }
        } else {
            DefaultAzureCredential credential = new DefaultAzureCredentialBuilder().build();
            blobServiceClientBuilder = new BlobServiceClientBuilder().endpoint(config.endpoint.get()).credential(credential);
        }
        return blobServiceClientBuilder;
    }

    private static BlobServiceClient createServiceClient(AzureBlockBlobTierObjectStoreConfig config) {
        return AzureBlockBlobTierObjectStore.createServiceClientBuilder(config).buildClient();
    }

    private static BlobServiceAsyncClient createServiceAsyncClient(AzureBlockBlobTierObjectStoreConfig config) {
        return AzureBlockBlobTierObjectStore.createServiceClientBuilder(config).buildAsyncClient();
    }

    private static BlobContainerClient createContainerClient(BlobServiceClient blobServiceClient, AzureBlockBlobTierObjectStoreConfig config) {
        BlobContainerClient blobContainerClient = blobServiceClient.getBlobContainerClient(config.container);
        if (!blobContainerClient.exists()) {
            throw new TierObjectStoreFatalException("Container " + config.container + " does not exist or could not be found");
        }
        return blobContainerClient;
    }

    private static BlobContainerAsyncClient createContainerAsyncClient(BlobServiceAsyncClient blobServiceAsyncClient, AzureBlockBlobTierObjectStoreConfig config) {
        BlobContainerAsyncClient blobContainerAsyncClient = blobServiceAsyncClient.getBlobContainerAsyncClient(config.container);
        if (!blobContainerAsyncClient.exists().blockOptional().orElse(false).booleanValue()) {
            throw new TierObjectStoreFatalException("Container " + config.container + " does not exist or could not be found");
        }
        return blobContainerAsyncClient;
    }

    private String keyPath(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        return TierObjectStoreUtils.keyPath(this.prefix, objectMetadata, objectType);
    }

    private static class AzureBlockBlobTierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final InputStream inputStream;

        AzureBlockBlobTierObjectStoreResponse(InputStream inputStream, int drainThreshold, long streamSize) {
            this.inputStream = new AzureBlockBlobAutoAbortingInputStream(inputStream, drainThreshold, streamSize);
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

