/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.common.utils.Interner;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public final class OpaqueData {
    public static final OpaqueData ZEROED = new OpaqueData(new byte[32]);
    private static final Interner<OpaqueData> INTERNER = new Interner();
    private final byte[] buffer = new byte[32];

    private OpaqueData(@JsonProperty(value="buffer") byte[] bytes) {
        if (bytes.length > 32) {
            throw new IllegalArgumentException("OpaqueData limited to 32 bytes in length");
        }
        System.arraycopy(bytes, 0, this.buffer, 0, Math.min(this.buffer.length, bytes.length));
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.equals(ZEROED);
    }

    public static OpaqueData fromLongArray(long[] arr) {
        if (arr.length > 4) {
            throw new IllegalArgumentException("Input array must be fit in 32 bytes of space");
        }
        byte[] bytes = new byte[32];
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        int pos = 0;
        for (long elem : arr) {
            bb.putLong(pos, elem);
            pos += 8;
        }
        return INTERNER.intern(new OpaqueData(bytes));
    }

    public static OpaqueData fromByteArray(byte[] arr) {
        if (arr.length > 32) {
            throw new IllegalArgumentException("Input array must be <= 32 bytes");
        }
        byte[] bytes = new byte[32];
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        bb.put(arr);
        return INTERNER.intern(new OpaqueData(bytes));
    }

    public long[] intoLongArray() {
        ByteBuffer bb = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
        long[] ret = new long[]{bb.getLong(0), bb.getLong(8), bb.getLong(16), bb.getLong(24)};
        return ret;
    }

    @JsonProperty(value="buffer", required=true)
    public byte[] intoByteArray() {
        return (byte[])this.buffer.clone();
    }

    public String toString() {
        return "OpaqueData{len=" + this.buffer.length + ", zeroed=" + this.equals(ZEROED) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpaqueData that = (OpaqueData)o;
        return Arrays.equals(this.buffer, that.buffer);
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer);
    }
}

