/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.encryption.EncryptionKeyCacheRefiller;

public class FtpsEncryptionKeyCacheRefiller
implements EncryptionKeyCacheRefiller {
    private final ReplicaManager replicaManager;

    public FtpsEncryptionKeyCacheRefiller(ReplicaManager replicaManager) {
        this.replicaManager = replicaManager;
    }

    @Override
    public ByteBuffer get(TopicIdPartition topicIdPartition, UUID objectId) {
        Optional<ByteBuffer> encryptedDataKeyOpt;
        TierPartitionState tierPartitionState = (TierPartitionState)this.replicaManager.logManager().getLog(topicIdPartition.topicPartition(), false).map(AbstractLog::tierPartitionState).getOrElse(null);
        if (tierPartitionState != null && (encryptedDataKeyOpt = tierPartitionState.getEncryptedDek(objectId)).isPresent()) {
            return encryptedDataKeyOpt.get();
        }
        return null;
    }
}

