/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\t=b!\u0002\u000e\u001c\u0003\u0003\u0011\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000b\u0001\u0003A\u0011A!\t\u00115\u0003\u0001\u0019!C\u0001;9C\u0001B\u0015\u0001A\u0002\u0013\u0005Qd\u0015\u0005\u00073\u0002\u0001\u000b\u0015B(\t\u000fy\u0003\u0001\u0019!C\u0005?\"9\u0011\u000e\u0001a\u0001\n\u0013Q\u0007B\u00027\u0001A\u0003&\u0001\rC\u0004o\u0001\t\u0007I\u0011B8\t\u000f\u0005\u0015\u0001\u0001)A\u0005a\"9\u0011q\u0001\u0001\u0007\u0002\u0005%\u0001bBA\n\u0001\u0019\u0005\u0011Q\u0003\u0005\b\u0003G\u0001a\u0011AA\u0013\u0011\u0019\ty\u000b\u0001C\u0001?\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBA^\u0001\u0011\u00051d\u001c\u0005\b\u0003{\u0003A\u0011AA`\u0011!\tI\r\u0001C\t7\u0005-\u0007\u0002CAe\u0001\u0011E1$a9\t\u000f\u0005-\b\u0001\"\u0005\u0002n\"A\u0011Q\u001f\u0001\u0005\u0012m\t9\u0010\u0003\u0005\u0002|\u0002!\tbGA\u007f\u0011!\u0011i\u0002\u0001C\t7\t}\u0001b\u0002B\u0012\u0001\u0011E!Q\u0005\u0005\b\u0005O\u0001A\u0011\u0003B\u0015\u0005!!\u0016.\u001a:UCN\\'B\u0001\u000f\u001e\u0003\u0015!\u0018m]6t\u0015\tqr$\u0001\u0003uS\u0016\u0014(\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001U\u00111ER\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,]5\tAF\u0003\u0002.?\u0005)Q\u000f^5mg&\u0011q\u0006\f\u0002\b\u0019><w-\u001b8h\u00031\u0011X\r\u001e:z%\u0006$Xm\u00149u!\r)#\u0007N\u0005\u0003g\u0019\u0012aa\u00149uS>t\u0007CA\u001b?\u001b\u00051$BA\u001c9\u0003\u0011\u0019wN]3\u000b\u0005eR\u0014aB7fiJL7m\u001d\u0006\u0003wq\na!_1n[\u0016\u0014(\"A\u001f\u0002\u0007\r|W.\u0003\u0002@m\t)Q*\u001a;fe\u00061A(\u001b8jiz\"\"A\u0011'\u0011\u0007\r\u0003A)D\u0001\u001c!\t)e\t\u0004\u0001\u0005\u000b\u001d\u0003!\u0019\u0001%\u0003\u0003Q\u000b\"!\u0013\"\u0011\u0005\u0015R\u0015BA&'\u0005\u001dqu\u000e\u001e5j]\u001eDQ\u0001\r\u0002A\u0002E\n!B]3uef\u001cu.\u001e8u+\u0005y\u0005CA\u0013Q\u0013\t\tfEA\u0002J]R\faB]3uef\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002U/B\u0011Q%V\u0005\u0003-\u001a\u0012A!\u00168ji\"9\u0001\fBA\u0001\u0002\u0004y\u0015a\u0001=%c\u0005Y!/\u001a;ss\u000e{WO\u001c;!Q\t)1\f\u0005\u0002&9&\u0011QL\n\u0002\tm>d\u0017\r^5mK\u0006aq\f]1vg\u0016$WK\u001c;jYV\t\u0001\rE\u0002&e\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\tQLW.\u001a\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7MA\u0004J]N$\u0018M\u001c;\u0002!}\u0003\u0018-^:fIVsG/\u001b7`I\u0015\fHC\u0001+l\u0011\u001dAv!!AA\u0002\u0001\fQb\u00189bkN,G-\u00168uS2\u0004\u0003F\u0001\u0005\\\u0003\u001dyVM\u001d:peN,\u0012\u0001\u001d\t\u0004cR4X\"\u0001:\u000b\u0005M,\u0017\u0001B;uS2L!!\u001e:\u0003\u0007M+G\u000f\u0005\u0002x\u007f:\u0011\u00010 \b\u0003srl\u0011A\u001f\u0006\u0003w\u0006\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005y4\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\t\u0019AA\u0005UQJ|w/\u00192mK*\u0011aPJ\u0001\t?\u0016\u0014(o\u001c:tA\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00105\tQ$C\u0002\u0002\u0012u\u0011\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\u0007\r$\b0\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001eu\tqAZ3uG\",'/\u0003\u0003\u0002\"\u0005m!aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018A\u0003;sC:\u001c\u0018\u000e^5p]Rq\u0011qEA \u00033\nI'!\u001f\u0002\n\u0006]E\u0003BA\u0015\u0003k\u0001R!a\u000b\u00022\u0011k!!!\f\u000b\u0007\u0005=b%\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\r\u0002.\t1a)\u001e;ve\u0016Dq!a\u000e\u000e\u0001\b\tI$\u0001\u0002fGB!\u00111FA\u001e\u0013\u0011\ti$!\f\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bB\u00023\u000e\u0001\u0004\t\t\u0005\u0005\u0003\u0002D\u0005USBAA#\u0015\ri\u0013q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0004d_6lwN\u001c\u0006\u0004A\u00055#\u0002BA(\u0003#\na!\u00199bG\",'BAA*\u0003\ry'oZ\u0005\u0005\u0003/\n)E\u0001\u0003US6,\u0007bBA.\u001b\u0001\u0007\u0011QL\u0001\u0012i&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\b\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rT$A\u0003u_BL7-\u0003\u0003\u0002h\u0005\u0005$!\u0005+jKJ$v\u000e]5d\u0003B\u0004XM\u001c3fe\"9\u00111N\u0007A\u0002\u00055\u0014a\u0004;jKJ|%M[3diN#xN]3\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d\u001e\u0003\u0015\u0019Ho\u001c:f\u0013\u0011\t9(!\u001d\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016Dq!a\u001f\u000e\u0001\u0004\ti(\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a! \u0003\u0019\u0019XM\u001d<fe&!\u0011qQAA\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!a#\u000e\u0001\u0004\ti)\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u001f\u000b\u0019*\u0004\u0002\u0002\u0012*\u0019\u00111R\u000e\n\t\u0005U\u0015\u0011\u0013\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\"9\u0011\u0011T\u0007A\u0002\u0005m\u0015!\u0003;ie>$H\u000f\\3s!\u0011)#'!(\u0011\t\u0005}\u00151V\u0007\u0003\u0003CS1!LAR\u0015\u0011\t)+a*\u0002\u0013%tG/\u001a:oC2\u001c(\u0002BAU\u0003\u0017\nqa\u001d;pe\u0006<W-\u0003\u0003\u0002.\u0006\u0005&!\u0003+ie>$H\u000f\\3s\u0003-\u0001\u0018-^:fIVsG/\u001b7\u0002\u0019%\u001cXI\u001d:peN#\u0018\r^3\u0016\u0005\u0005U\u0006cA\u0013\u00028&\u0019\u0011\u0011\u0018\u0014\u0003\u000f\t{w\u000e\\3b]\u0006YQM\u001d:peN#\u0018\r^3t\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!!1\u0011\t\u0005\r\u0017QY\u0007\u0003\u0003\u000fJA!a2\u0002H\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u0004:fiJLH+Y:l\u0019\u0006$XM\u001d\u000b\n)\u00065\u0017\u0011[Ak\u0003?Da!a4\u0013\u0001\u0004y\u0015!E7bqJ+GO]=CC\u000e\\wN\u001a4Ng\"1\u00111\u001b\nA\u0002=\u000b\u0011#\\5o%\u0016$(/\u001f\"bG.|gMZ't\u0011\u001d\t9N\u0005a\u0001\u00033\fQA\\8x\u001bN\u00042!JAn\u0013\r\tiN\n\u0002\u0005\u0019>tw\r\u0003\u0004\u0002bJ\u0001\rA^\u0001\u0002iR9A+!:\u0002h\u0006%\bBBAh'\u0001\u0007q\nC\u0004\u0002XN\u0001\r!!7\t\r\u0005\u00058\u00031\u0001w\u0003%!W\r\\1z)\u0006\u001c8\u000eF\u0003U\u0003_\f\u0019\u0010\u0003\u0004\u0002rR\u0001\raT\u0001\bI\u0016d\u0017-_'t\u0011\u001d\t9\u000e\u0006a\u0001\u00033\fQb]3u\u000bJ\u0014xN]*uCR,Gc\u0001+\u0002z\"1\u0011\u0011]\u000bA\u0002Y\fqb\u00197fCJ,%O]8s'R\fG/\u001a\u000b\u0004)\u0006}\bb\u0002B\u0001-\u0001\u0007!1A\u0001\u000fi\"\u0014xn^1cY\u0016\u001cE.Y:ta\u0011\u0011)Aa\u0006\u0011\r\t\u001d!q\u0002B\u000b\u001d\u0011\u0011IAa\u0003\u0011\u0005e4\u0013b\u0001B\u0007M\u00051\u0001K]3eK\u001aLAA!\u0005\u0003\u0014\t)1\t\\1tg*\u0019!Q\u0002\u0014\u0011\u0007\u0015\u00139\u0002\u0002\u0007\u0003\u001a\u0005}\u0018\u0011!A\u0001\u0006\u0003\u0011YBA\u0002`IE\n\"!\u0013<\u0002-\r\fgnY3m\u0003:$7+\u001a;FeJ|'o\u0015;bi\u0016$2\u0001\u0016B\u0011\u0011\u0019\t\to\u0006a\u0001m\u00061rN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000eF\u0001U\u0003}ygnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>tw+\u001b;i\t\u0016d\u0017-\u001f\u000b\u0006)\n-\"Q\u0006\u0005\b\u0003cL\u0002\u0019AAm\u0011\u001d\t9.\u0007a\u0001\u00033\u0004")
public abstract class TierTask<T extends TierTask<T>>
implements Logging {
    private final Option<Meter> retryRateOpt;
    private volatile int retryCount;
    private volatile Option<Instant> _pausedUntil;
    private final Set<Throwable> _errors;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierTask tierTask = this;
        synchronized (tierTask) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    private Option<Instant> _pausedUntil() {
        return this._pausedUntil;
    }

    private void _pausedUntil_$eq(Option<Instant> x$1) {
        this._pausedUntil = x$1;
    }

    private Set<Throwable> _errors() {
        return this._errors;
    }

    public abstract TopicIdPartition topicIdPartition();

    public abstract CancellationContext ctx();

    public abstract Future<T> transition(Time var1, TierTopicAppender var2, TierObjectStore var3, ReplicaManager var4, TierTasksConfig var5, Option<Throttler> var6, ExecutionContext var7);

    public Option<Instant> pausedUntil() {
        return this._pausedUntil();
    }

    public boolean isErrorState() {
        return !this._errors().isEmpty();
    }

    public Set<Throwable> errorStates() {
        return this._errors();
    }

    public TopicPartition topicPartition() {
        return this.topicIdPartition().topicPartition();
    }

    public void retryTaskLater(int maxRetryBackoffMs, int minRetryBackoffMs, long nowMs, Throwable t) {
        this.retryCount_$eq(this.retryCount() + 1);
        this.retryRateOpt.foreach((Function1<Meter, Object> & Serializable)x$1 -> {
            x$1.mark();
            return BoxedUnit.UNIT;
        });
        Instant now = Instant.ofEpochMilli(nowMs);
        int pauseMs = Math.max(Math.min(maxRetryBackoffMs, (Random$.MODULE$.nextInt(this.retryCount()) + 1) * 1000), minRetryBackoffMs);
        this.info((Function0<String> & Serializable)() -> "retrying " + this + " after " + pauseMs + "ms", (Function0<Throwable> & Serializable)() -> t);
        this._pausedUntil_$eq(new Some<Instant>(now.plusMillis(pauseMs)));
    }

    public void retryTaskLater(int maxRetryBackoffMs, long nowMs, Throwable t) {
        this.retryTaskLater(maxRetryBackoffMs, 0, nowMs, t);
    }

    public void delayTask(int delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.info((Function0<String> & Serializable)() -> "retrying " + this + " after " + delayMs + "ms");
        this._pausedUntil_$eq(new Some<Instant>(now.plusMillis(delayMs)));
    }

    public void setErrorState(Throwable t) {
        this._errors().add(t);
    }

    public void clearErrorState(Class<? extends Throwable> throwableClass) {
        this._errors().removeIf(error -> {
            Class<?> clazz = error.getClass();
            Class clazz2 = throwableClass;
            return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        });
    }

    public void cancelAndSetErrorState(Throwable t) {
        this.setErrorState(t);
        this.ctx().cancel();
    }

    public void onSuccessfulTransition() {
        this.retryCount_$eq(0);
        this._pausedUntil_$eq(None$.MODULE$);
    }

    public void onSuccessfulTransitionWithDelay(long delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.onSuccessfulTransition();
        this._pausedUntil_$eq(new Some<Instant>(now.plusMillis(delayMs)));
    }

    public TierTask(Option<Meter> retryRateOpt) {
        this.retryRateOpt = retryRateOpt;
        Logging.$init$(this);
        this.retryCount = 0;
        this._pausedUntil = None$.MODULE$;
        this._errors = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

