/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.nio.ByteBuffer;
import kafka.log.LogSegmentReadAdapter;
import kafka.log.TierLogSegment;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreRetryPolicy;
import kafka.tier.tasks.compaction.TierLogCompactionUtils$;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055q!B\u000b\u0017\u0011\u0003yb!B\u0011\u0017\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0016\u0002\t\u0003ac\u0001B\u0011\u0017\u00019B\u0001\"\u000e\u0003\u0003\u0006\u0004%\tA\u000e\u0005\tu\u0011\u0011\t\u0011)A\u0005o!A1\b\u0002BC\u0002\u0013\u0005A\b\u0003\u0005D\t\t\u0005\t\u0015!\u0003>\u0011!!EA!b\u0001\n\u0003)\u0005\u0002\u0003'\u0005\u0005\u0003\u0005\u000b\u0011\u0002$\t\u00115#!\u0011!Q\u0001\n9CQ!\u000b\u0003\u0005\u0002ECqA\u0016\u0003C\u0002\u0013%q\u000b\u0003\u0004\\\t\u0001\u0006I\u0001\u0017\u0005\u00069\u0012!\t%\u0018\u0005\u0006C\u0012!\t%\u0018\u0005\u0006E\u0012!\te\u0016\u0005\u0006G\u0012!\te\u0016\u0005\u0006I\u0012!\t%\u001a\u0005\u0006k\u0012!\tE^\u0001\u001a)&,'\u000fT8h'\u0016<W.\u001a8u%\u0016\fG-\u00113baR,'O\u0003\u0002\u00181\u0005Q1m\\7qC\u000e$\u0018n\u001c8\u000b\u0005eQ\u0012!\u0002;bg.\u001c(BA\u000e\u001d\u0003\u0011!\u0018.\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002!\u00035\taCA\rUS\u0016\u0014Hj\\4TK\u001elWM\u001c;SK\u0006$\u0017\tZ1qi\u0016\u00148CA\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aH\u0001\u0006CB\u0004H.\u001f\u000b\n[\u0005\u0015\u0011qAA\u0005\u0003\u0017\u0001\"\u0001\t\u0003\u0014\u0007\u0011\u0019s\u0006\u0005\u00021g5\t\u0011G\u0003\u000239\u0005\u0019An\\4\n\u0005Q\n$!\u0006'pON+w-\\3oiJ+\u0017\rZ!eCB$XM]\u0001\bg\u0016<W.\u001a8u+\u00059\u0004C\u0001\u00199\u0013\tI\u0014G\u0001\bUS\u0016\u0014Hj\\4TK\u001elWM\u001c;\u0002\u0011M,w-\\3oi\u0002\nq\u0002^5fe>\u0013'.Z2u'R|'/Z\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IG\u0001\u0006gR|'/Z\u0005\u0003\u0005~\u0012q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0011i&,'o\u00142kK\u000e$8\u000b^8sK\u0002\n1cY1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013j\tqAZ3uG\",'/\u0003\u0002L\u0011\n\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006!2-\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0002\n1B]3uef\u0004v\u000e\\5dsB\u0011ahT\u0005\u0003!~\u0012!\u0004V5fe>\u0013'.Z2u'R|'/\u001a*fiJL\bk\u001c7jGf$R!\f*T)VCQ!\u000e\u0007A\u0002]BQa\u000f\u0007A\u0002uBQ\u0001\u0012\u0007A\u0002\u0019CQ!\u0014\u0007A\u00029\u000b\u0001b\u001d;beR\u0004vn]\u000b\u00021B\u0011A%W\u0005\u00035\u0016\u00121!\u00138u\u0003%\u0019H/\u0019:u!>\u001c\b%\u0001\u0006cCN,wJ\u001a4tKR,\u0012A\u0018\t\u0003I}K!\u0001Y\u0013\u0003\t1{gnZ\u0001\nK:$wJ\u001a4tKR\fQb\u001d;beR\u0004vn]5uS>t\u0017aC3oIB{7/\u001b;j_:\f\u0011B]3bI\nKH/Z:\u0015\u0007\u0019L7\u000f\u0005\u0002%O&\u0011\u0001.\n\u0002\u0005+:LG\u000fC\u0003k'\u0001\u00071.\u0001\u0004ck\u001a4WM\u001d\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f1A\\5p\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003u'\u0001\u0007\u0001,\u0001\u0005q_NLG/[8o\u0003!!xn\u0015;sS:<G#A<\u0011\u0005a|hBA=~!\tQX%D\u0001|\u0015\tah$\u0001\u0004=e>|GOP\u0005\u0003}\u0016\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@&\u0011\u0015)4\u00011\u00018\u0011\u0015Y4\u00011\u0001>\u0011\u0015!5\u00011\u0001G\u0011\u0015i5\u00011\u0001O\u0001")
public class TierLogSegmentReadAdapter
implements LogSegmentReadAdapter {
    private final TierLogSegment segment;
    private final TierObjectStore tierObjectStore;
    private final CancellationContext cancellationContext;
    private final TierObjectStoreRetryPolicy retryPolicy;
    private final int startPos;

    public static TierLogSegmentReadAdapter apply(TierLogSegment segment, TierObjectStore tierObjectStore, CancellationContext cancellationContext, TierObjectStoreRetryPolicy retryPolicy) {
        return TierLogSegmentReadAdapter$.MODULE$.apply(segment, tierObjectStore, cancellationContext, retryPolicy);
    }

    public TierLogSegment segment() {
        return this.segment;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public CancellationContext cancellationContext() {
        return this.cancellationContext;
    }

    private int startPos() {
        return this.startPos;
    }

    @Override
    public long baseOffset() {
        return this.segment().baseOffset();
    }

    @Override
    public long endOffset() {
        return this.segment().endOffset();
    }

    @Override
    public int startPosition() {
        return this.startPos();
    }

    @Override
    public int endPosition() {
        return this.segment().size();
    }

    @Override
    public void readBytes(ByteBuffer buffer, int position) {
        if (position < this.startPosition() || position > this.endPosition()) {
            throw new IllegalArgumentException("Invalid position: " + position + ". Valid position range is [" + this.startPosition() + ", " + this.endPosition() + "]");
        }
        TierLogCompactionUtils$.MODULE$.readSegment(this.segment(), this.tierObjectStore(), position, buffer, this.cancellationContext(), this.retryPolicy);
    }

    public String toString() {
        return "TierLogSegmentReadAdapter(log segment: " + this.segment() + ", startPosition: " + this.startPosition() + ", endPosition: " + this.endPosition() + ", baseOffset: " + this.baseOffset() + ", endOffset: " + this.endOffset() + ")";
    }

    public TierLogSegmentReadAdapter(TierLogSegment segment, TierObjectStore tierObjectStore, CancellationContext cancellationContext, TierObjectStoreRetryPolicy retryPolicy) {
        this.segment = segment;
        this.tierObjectStore = tierObjectStore;
        this.cancellationContext = cancellationContext;
        this.retryPolicy = retryPolicy;
        this.startPos = segment.baseOffset() == segment.objectBaseOffset() ? 0 : TierLogCompactionUtils$.MODULE$.startingPosition(segment, tierObjectStore, cancellationContext, retryPolicy);
    }
}

