/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.tier.tools.TierRecoveryConfig;
import kafka.tier.tools.TierTopicMaterializationToolConfig;
import kafka.tier.tools.TierTopicMaterializationUtils;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.server.util.KafkaScheduler;

public class TierMetadataDebugger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        KafkaScheduler scheduler = new KafkaScheduler(1, true, "tier-metadata-debugger-scheduler-", false);
        scheduler.startup();
        try {
            Properties props = TierMetadataDebugger.fetchPropertiesFromArgs(args);
            TierTopicMaterializationToolConfig config = new TierTopicMaterializationToolConfig(props);
            String consumerConfig = props.getProperty("consumer-config");
            Properties consumerConfigProps = new Properties();
            if (!consumerConfig.isEmpty()) {
                try (FileInputStream input = new FileInputStream(consumerConfig);){
                    consumerConfigProps.load(input);
                }
                consumerConfigProps = TierRecoveryConfig.toConsumerProps(consumerConfigProps);
            }
            TierTopicMaterializationUtils consumer = new TierTopicMaterializationUtils(config, consumerConfigProps, null, scheduler);
            consumer.run();
        }
        catch (AuthenticationException ae) {
            System.out.println(ae.getMessage());
            ae.printStackTrace();
            System.exit(1);
        }
        catch (IOException ie) {
            System.out.println(ie.getMessage());
            ie.printStackTrace();
            System.exit(1);
        }
        finally {
            scheduler.shutdown();
        }
    }

    public static Properties fetchPropertiesFromArgs(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> userTopicIdSpec = parser.accepts("source-topic-id", "source topic id. If selected all the processing will be limited for this id").withRequiredArg().describedAs("source-topic-id").ofType(String.class).defaultsTo("00000000-0000-0000-0000-000000000000", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Integer> userPartitionSpec = parser.accepts("source-partition", "source partition id. If selected, all the processing will be limited for this partition.").withRequiredArg().describedAs("source-partition").ofType(Integer.class).defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> partitionSpec = parser.accepts("tier-state-topic-partition", "tier topic partition. If selected all the processing will be limited from this partition.").withRequiredArg().describedAs("tier-state-topic-partition").ofType(Integer.class).defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> startOffsetSpec = parser.accepts("start-offset", "start offset from where the events will be processed.This will be ignored if tier-topic-partition is not set.").withRequiredArg().describedAs("start-offset").ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> endOffsetSpec = parser.accepts("end-offset", "end offset from where the events will be processed. This will be ignored if tier-topic-partition is not set.").withRequiredArg().describedAs("end-offset").ofType(Integer.class).defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<String> bootstrapServerSpec = parser.accepts("bootstrap-server", "The broker server and port string in form host:port").withRequiredArg().describedAs("bootstrap-server").ofType(String.class).defaultsTo("localhost:9092", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Boolean> dumpSpec = parser.accepts("dump-metadata", "dump-metadata will dump entire metadata of tier topic partitions on the std output.").withRequiredArg().describedAs("dump-metadata").ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> dumpHeaderSpec = parser.accepts("dump-metadata-header", "dump-metadata-header will dump only header of the tier topic partition's state.").withRequiredArg().describedAs("dump-metadata-header").ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> workingDirSpec = parser.accepts("working-dir", "working-dir is the directory path where the tool will generate its data").withRequiredArg().describedAs("working-dir is the directory path where the tool will generate its data").ofType(String.class).defaultsTo("/tmp/workDir", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Boolean> materializeSpec = parser.accepts("materialize", "if set, then only materialize the events to generate state file.").withOptionalArg().describedAs("working-dir is the directory path where the tool will generate its data").ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> tierCompactionEnabledSpec = parser.accepts("tier-compact-feature-flag", "should be set to true if tier compaction is enabled for this cluster.").withRequiredArg().describedAs("should be set to true if tier compaction is enabled for this cluster.").ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> tierPartitionStateCleanupEnabledSpec = parser.accepts("tier-partition-state-cleanup-feature-flag", "should be set to true if tier state file cleanup is enabled.").withRequiredArg().describedAs("should be set to true if tier state file cleanup is enabled.").ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Long> tierPartitionStateCleanupDelaySpec = parser.accepts("tier-partition-state-cleanup-delay", "FTPS cleanup only removes deleted segment entries which are deleted this amount of time ago. It is in millisecond time unit.").withRequiredArg().describedAs("FTPS cleanup only removes deleted segment entries which are deleted this amount of time ago. It is in millisecond time unit.").ofType(Long.class).defaultsTo(2592000000L, (Long[])new Long[0]);
        ArgumentAcceptingOptionSpec<Long> tierPartitionStateCleanupIntervalSpec = parser.accepts("tier-partition-state-cleanup-interval", "FTPS cleanup is triggered periodically during flush. This config is the interval in millisecond time unit.").withRequiredArg().describedAs("FTPS cleanup is triggered periodically during flush. This config is the interval in millisecond time unit.").ofType(Long.class).defaultsTo(86400000L, (Long[])new Long[0]);
        ArgumentAcceptingOptionSpec<String> consumerConfigSpec = parser.accepts("consumer-config", "Additional KafkaConsumer configuration properties file.").withOptionalArg().describedAs("Additional KafkaConsumer configuration properties file.").ofType(String.class).defaultsTo("", (String[])new String[0]);
        OptionSet options = parser.parse(args);
        Properties props = new Properties();
        props.put("source-partition", options.valueOf(userPartitionSpec));
        props.put("source-topic-id", options.valueOf(userTopicIdSpec));
        props.put("tier-state-topic-partition", options.valueOf(partitionSpec));
        props.put("start-offset", options.valueOf(startOffsetSpec));
        props.put("end-offset", options.valueOf(endOffsetSpec));
        props.put("bootstrap-server", options.valueOf(bootstrapServerSpec));
        props.put("dump-metadata", options.valueOf(dumpSpec));
        props.put("dump-metadata-header", options.valueOf(dumpHeaderSpec));
        props.put("working-dir", options.valueOf(workingDirSpec));
        props.put("materialize", options.valueOf(materializeSpec));
        props.put("tier-compact-feature-flag", options.valueOf(tierCompactionEnabledSpec));
        props.put("tier-partition-state-cleanup-feature-flag", options.valueOf(tierPartitionStateCleanupEnabledSpec));
        props.put("tier-partition-state-cleanup-delay", options.valueOf(tierPartitionStateCleanupDelaySpec));
        props.put("tier-partition-state-cleanup-interval", options.valueOf(tierPartitionStateCleanupIntervalSpec));
        props.put("consumer-config", options.valueOf(consumerConfigSpec));
        return props;
    }
}

