/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kafka.log.MergedLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionStateJsonWrapper;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.TopicPartition;

public class TierPartitionStateJsonConvert {
    private static final String INPUT_FTPS_FILE = "input.ftps";
    private static final String INPUT_FTPS_FILE_DOC = "Input ftps file";
    private static final String OUTPUT_JSON_FILE = "output.json";
    private static final String OUTPUT_JSON_FILE_DOC = "Output json file";
    private static final String INPUT_JSON_FILE = "input.json";
    private static final String INPUT_JSON_FILE_DOC = "Input json file";
    private static final String OUTPUT_FTPS_FILE = "output.ftps";
    private static final String OUTPUT_FTPS_FILE_DOC = "Output ftps file";

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(TierPartitionStateJsonConvert.class.getName()).defaultHelp(true).description("Provides facilities to fix/manipulate/compare/validate FTPS files \nNote: \n1. This tool by default generates the output file in adler format \n2. Parent directory name of the updated FTPS file should be of the form topic-partition");
        Subparsers subparsers = parser.addSubparsers().dest("option").help("Valid options: ftps-to-json, json-to-ftps");
        Subparser ftpsToJsonParser = subparsers.addParser("ftps-to-json").help("Convert FTPS file to json for manual editing");
        ftpsToJsonParser.addArgument(RecoveryUtils.makeArgument(INPUT_FTPS_FILE)).dest(INPUT_FTPS_FILE).type(String.class).required(true).help(INPUT_FTPS_FILE_DOC);
        ftpsToJsonParser.addArgument(RecoveryUtils.makeArgument(OUTPUT_JSON_FILE)).dest(OUTPUT_JSON_FILE).type(String.class).required(false).setDefault("jsonFtps.json").help(OUTPUT_JSON_FILE_DOC);
        Subparser jsonToFtpsParser = subparsers.addParser("json-to-ftps").help("Convert modified json file back to FTPS");
        jsonToFtpsParser.addArgument(RecoveryUtils.makeArgument(INPUT_JSON_FILE)).dest(INPUT_JSON_FILE).type(String.class).required(true).help(INPUT_JSON_FILE_DOC);
        jsonToFtpsParser.addArgument(RecoveryUtils.makeArgument(OUTPUT_FTPS_FILE)).dest(OUTPUT_FTPS_FILE).type(String.class).required(false).setDefault("newFtps.adler").help(OUTPUT_FTPS_FILE_DOC);
        return parser;
    }

    public static void verifyFtpsFile(String ftpsFile) throws IOException {
        Path inputFtpsPath = Paths.get(ftpsFile, new String[0]);
        File inputFtpsFile = new File(ftpsFile);
        File inputFtpsDir = inputFtpsFile.getParentFile();
        TopicPartition topicPartition = MergedLog.parseTopicPartitionName(inputFtpsDir);
        System.out.println("topic-partition parsed from given input directory: " + String.valueOf(topicPartition));
        CheckedFileIO channel = CheckedFileIO.open(inputFtpsPath, StandardOpenOption.READ);
        Optional<Header> ftpsHeader = FileTierPartitionState.readHeader(channel);
        if (!ftpsHeader.isPresent()) {
            throw new IllegalStateException(String.format("TierPartitionState being opened does not contain a valid header, aborting. Topic-Partition %s ", topicPartition));
        }
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), ftpsHeader.get().topicId(), topicPartition.partition());
        FileTierPartitionIterator iterator = new FileTierPartitionIterator(topicIdPartition, channel, ftpsHeader.get().size(), false);
        int entriesCount = 0;
        TierObjectMetadata prevEntry = null;
        TierObjectMetadata curEntry = null;
        TierObjectMetadata firstEntry = null;
        while (iterator.hasNext()) {
            curEntry = (TierObjectMetadata)iterator.next();
            ++entriesCount;
            if (curEntry.baseOffset() >= curEntry.endOffset()) {
                throw new IllegalStateException("At TierPartitionState entry \n" + String.valueOf(curEntry) + "\n base offset should be less than the end offset");
            }
            if (firstEntry == null && curEntry.state() == TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE) {
                firstEntry = curEntry;
            }
            if (prevEntry != null) {
                if (curEntry.baseOffset() < prevEntry.endOffset() + 1L) {
                    throw new IllegalStateException("TierPartitionState entries \n" + String.valueOf(prevEntry) + "\nand\n" + String.valueOf(curEntry) + "\nhave overlapping offsets");
                }
                if (curEntry.baseOffset() != prevEntry.endOffset() + 1L) {
                    throw new IllegalStateException("TierPartitionState entries \n" + String.valueOf(prevEntry) + "\nand\n" + String.valueOf(curEntry) + "\nhave gaps in the offsets");
                }
            }
            prevEntry = curEntry;
        }
        if (firstEntry != null && ftpsHeader.get().startOffset() != firstEntry.baseOffset()) {
            throw new IllegalStateException("Start offsets are not matching in the Header and the first entry");
        }
        if (curEntry != null && ftpsHeader.get().endOffset() != curEntry.endOffset()) {
            throw new IllegalStateException("End offsets are not matching in the Header and the last entry");
        }
        System.out.println("FTPS file containing " + entriesCount + " entries is verified!");
    }

    public static File convertFtpsToJson(String inputFtps, String outputJson) throws IOException {
        Path inputFtpsPath = Paths.get(inputFtps, new String[0]);
        File inputFtpsFile = new File(inputFtps);
        File inputFtpsDir = inputFtpsFile.getParentFile();
        TopicPartition topicPartition = MergedLog.parseTopicPartitionName(inputFtpsDir);
        System.out.println("topic-partition parsed from given input directory: " + String.valueOf(topicPartition));
        CheckedFileIO channel = CheckedFileIO.open(inputFtpsPath, StandardOpenOption.READ);
        Optional<Header> ftpsHeader = FileTierPartitionState.readHeader(channel);
        if (!ftpsHeader.isPresent()) {
            throw new IllegalStateException(String.format("TierPartitionState being opened does not contain a valid header, aborting. Topic-Partition %s ", topicPartition));
        }
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), ftpsHeader.get().topicId(), topicPartition.partition());
        FileTierPartitionIterator iterator = new FileTierPartitionIterator(topicIdPartition, channel, ftpsHeader.get().size(), false);
        ArrayList<TierObjectMetadata> ftpsListEntries = new ArrayList<TierObjectMetadata>();
        while (iterator.hasNext()) {
            TierObjectMetadata entry = (TierObjectMetadata)iterator.next();
            ftpsListEntries.add(entry);
        }
        Path outputJsonPath = Paths.get(outputJson, new String[0]).toAbsolutePath();
        Files.deleteIfExists(outputJsonPath);
        TierPartitionStateJsonWrapper.writeToJson(outputJsonPath, ftpsHeader.get(), ftpsListEntries);
        return outputJsonPath.toFile();
    }

    public static File convertJsonToFtps(String inputJson, String outputFtps) throws IOException {
        Path inputJsonPath = Paths.get(inputJson, new String[0]);
        TierPartitionStateJsonWrapper wrapper = TierPartitionStateJsonWrapper.readFromJson(inputJsonPath);
        Header jsonHeader = wrapper.header();
        List<TierObjectMetadata> jsonListEntries = wrapper.entries();
        Path outputFtpsPath = Paths.get(outputFtps, new String[0]);
        Path validOutputFtpsPath = CheckedFileIO.validPath(Algorithm.ADLER, outputFtpsPath);
        Files.deleteIfExists(validOutputFtpsPath);
        CheckedFileIO channel = CheckedFileIO.openOrCreate(validOutputFtpsPath, Algorithm.ADLER, (short)512, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        FileTierPartitionState.writeHeader(channel, jsonHeader);
        channel.position(channel.size());
        for (TierObjectMetadata entry : jsonListEntries) {
            ByteBuffer buffer = entry.payloadBuffer();
            FileTierPartitionState.State.appendWithSizePrefixStatic(buffer, channel);
        }
        channel.close();
        TierPartitionStateJsonConvert.verifyFtpsFile(outputFtps);
        System.out.println("Modified ftps file created successfully at " + outputFtps);
        return outputFtpsPath.toFile();
    }

    private static void run(Namespace args) throws IOException {
        switch (args.getString("option")) {
            case "ftps-to-json": {
                String inputFtps = args.getString(INPUT_FTPS_FILE).trim();
                String outputJson = args.getString(OUTPUT_JSON_FILE).trim();
                File ftpsJson = TierPartitionStateJsonConvert.convertFtpsToJson(inputFtps, outputJson);
                System.out.println("file converted to json: " + ftpsJson.getPath());
                break;
            }
            case "json-to-ftps": {
                String inputJson = args.getString(INPUT_JSON_FILE).trim();
                String outputFtps = args.getString(OUTPUT_FTPS_FILE).trim();
                File outputFtpsFile = TierPartitionStateJsonConvert.convertJsonToFtps(inputJson, outputFtps);
                System.out.println("file converted to ftps: " + outputFtpsFile.getPath());
                break;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = TierPartitionStateJsonConvert.createArgParser();
            try {
                TierPartitionStateJsonConvert.run(parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }
}

