/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Arrays;
import kafka.tier.TopicIdPartition;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.CoreUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;

public class TierTopicPartitionId {
    private static final String TOPIC_ID_CONFIG = "topic_id";
    private static final String TOPIC_ID_DOC = "Base-64 encoded topic id";
    private static final String TOPIC_NAME_CONFIG = "topic_name";
    private static final String TOPIC_NAME_DOC = "Topic name";
    private static final String PARTITION_CONFIG = "partition";
    private static final String PARTITION_DOC = "Partition id";
    private static final String TIER_TOPIC_PARTITION_COUNT_CONFIG = "tier_topic_partition_count";
    private static final String TIER_TOPIC_PARTITION_COUNT_DOC = "Number of partitions of tier state topic";

    public static void main(String[] args) throws Exception {
        System.out.println("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = TierTopicPartitionId.createArgumentParser();
        Namespace res = cliParser.parseArgs(args);
        String topicId = res.getString(TOPIC_ID_CONFIG);
        String topicName = res.getString(TOPIC_NAME_CONFIG);
        Integer partition = res.getInt(PARTITION_CONFIG);
        TopicIdPartition tip = new TopicIdPartition(topicName, CoreUtils.uuidFromBase64(topicId), partition);
        Integer tierTopicNumPartitions = res.getInt(TIER_TOPIC_PARTITION_COUNT_CONFIG);
        TierTopicPartitioner partitioner = new TierTopicPartitioner(tierTopicNumPartitions);
        System.out.println("Tier topic partition id for " + String.valueOf(tip) + ": " + partitioner.partitionId(tip));
    }

    static ArgumentParser createArgumentParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(TierTopicPartitionId.class.getName()).defaultHelp(true).description("Calculate tier topic partition id for specified topic partition");
        parser.addArgument(RecoveryUtils.makeArgument(TOPIC_ID_CONFIG)).dest(TOPIC_ID_CONFIG).type(String.class).required(true).help(TOPIC_ID_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(TOPIC_NAME_CONFIG)).dest(TOPIC_NAME_CONFIG).type(String.class).required(true).help(TOPIC_NAME_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(PARTITION_CONFIG)).dest(PARTITION_CONFIG).type(Integer.class).required(true).help(PARTITION_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(TIER_TOPIC_PARTITION_COUNT_CONFIG)).dest(TIER_TOPIC_PARTITION_COUNT_CONFIG).type(Integer.class).required(true).help(TIER_TOPIC_PARTITION_COUNT_DOC);
        return parser;
    }
}

