/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.Header;
import kafka.tier.tools.common.FenceEventInfo;

public class ComparatorInfo {
    public static final String REMATERIALIZED_REPLICA_ID = "rematerialized";
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();

    private ComparatorInfo() {
    }

    static {
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }

    public static class ComparatorReplicaInfo {
        private final String replicaId;
        private final Path tierStateFile;
        private final TopicIdPartition topicIdPartition;
        public Header header;
        private boolean validationSuccess;
        private Exception exception;

        public ComparatorReplicaInfo(String replicaId, Path tierStateFile, TopicIdPartition topicIdPartition) {
            this.replicaId = replicaId;
            this.tierStateFile = tierStateFile;
            this.topicIdPartition = topicIdPartition;
        }

        public String getHeader() {
            if (this.header == null) {
                return "";
            }
            return this.header.toString();
        }

        public long lastOffset() {
            if (this.header == null) {
                return -1L;
            }
            return this.header.localMaterializedOffsetAndEpoch().offset();
        }

        public TopicIdPartition topicIdPartition() {
            return this.topicIdPartition;
        }

        public Path tierStateFile() {
            return this.tierStateFile;
        }

        public void setHeader(Header header) {
            this.header = header;
        }

        public String getReplica() {
            return this.replicaId;
        }

        public String getPath() {
            return this.tierStateFile.toString();
        }

        public boolean isValidationSuccess() {
            return this.validationSuccess;
        }

        public void setValidationSuccess(boolean validationSuccess) {
            this.validationSuccess = validationSuccess;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public String toString() {
            return "ComparatorReplicaInfo{header=" + String.valueOf(this.header) + ", replicaId='" + this.replicaId + "', tierStateFile=" + String.valueOf(this.tierStateFile) + ", topicIdPartition=" + String.valueOf(this.topicIdPartition) + ", validationSuccess=" + this.validationSuccess + ", exception=" + String.valueOf(this.exception) + "}";
        }

        public String toJson() {
            try {
                return JSON_SERDE.writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ComparatorOutput {
        private final Map<String, ComparatorReplicaInfo> replicas;
        private final ComparatorReplicaInfo choice;
        private final FenceEventInfo input;

        public String toJson() {
            try {
                return JSON_SERDE.writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "ComparatorOutput{replicas=" + String.valueOf(this.replicas) + ", choice=" + String.valueOf(this.choice) + ", input=" + String.valueOf(this.input) + "}";
        }

        public ComparatorOutput(Map<String, ComparatorReplicaInfo> replicas, ComparatorReplicaInfo choice, FenceEventInfo input) {
            this.replicas = replicas;
            this.choice = choice;
            this.input = input;
        }

        public FenceEventInfo getInput() {
            return this.input;
        }

        public Map<String, ComparatorReplicaInfo> getReplicas() {
            HashMap<String, ComparatorReplicaInfo> copiedInfoMap = new HashMap<String, ComparatorReplicaInfo>(this.replicas);
            copiedInfoMap.remove(ComparatorInfo.REMATERIALIZED_REPLICA_ID);
            return copiedInfoMap;
        }

        public ComparatorReplicaInfo getChoice() {
            return this.choice;
        }

        public ComparatorReplicaInfo getRematerialized() {
            return this.replicas.get(ComparatorInfo.REMATERIALIZED_REPLICA_ID);
        }

        public static void writeJsonToFile(List<ComparatorOutput> outputList, Path outputJsonFile) throws IOException {
            JSON_SERDE.writeValue(outputJsonFile.toFile(), outputList);
        }

        public static List<ComparatorOutput> readJsonFromFile(Path inputJsonFile) throws IOException {
            return JSON_SERDE.readValue(inputJsonFile.toFile(), new TypeReference<List<ComparatorOutput>>(){});
        }
    }
}

