/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.rest.TierTopicHeadDataLossDetectionRequest;
import io.confluent.rest.TierTopicHeadDataLossDetectionResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.log.AbstractLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.LeaderEndpointSupplier;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreFunctionUtils;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.TierTopicHeadDataLossReportMetadata;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicDataLossValidatorMetrics;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.tier.topic.recovery.AffectedTierTopicPartitionInfo;
import kafka.tier.topic.recovery.AffectedUserTopicPartitionInfo;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.ValidationSource;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Set;
import scala.jdk.javaapi.CollectionConverters;

public class TierTopicDataLossValidator
implements BrokerReconfigurable {
    private static final Logger log = LoggerFactory.getLogger(TierTopicDataLossValidator.class);
    private static final long DATA_LOSS_DETECTION_RETRY_SLEEP_TIME_MS = Duration.ofSeconds(15L).toMillis();
    private static final int DATA_LOSS_DETECTION_THREAD_POOL_SIZE_MAX = 10;
    public static final Set<String> RECONFIGURABLE_CONFIGS = CollectionConverters.asScala(new HashSet<String>(Collections.singletonList(KafkaConfig.TierTopicDataLossDetectionMaxTimeoutMsProp())));
    private final TierTopicManagerConfig config;
    private final TierTopic tierTopic;
    private final TierObjectStore tierObjectStore;
    private final ReplicaManager replicaManager;
    private final Supplier<ConfluentAdmin> adminClientSupplier;
    private final LeaderEndpointSupplier leaderEndpointSupplier;
    private final Time time;
    public final TierTopicDataLossValidatorMetrics dataLossMetrics;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private volatile long dataLossDetectionMaxTimeoutMs;
    private static final Map<TierTopicHeadDataLossReport.CompletionStatus, TierTopicHeadDataLossDetectionResponse.CompletionStatus> COMPLETION_STATUS_CONVERSION_MAP = Map.of(TierTopicHeadDataLossReport.CompletionStatus.SUCCESS, TierTopicHeadDataLossDetectionResponse.CompletionStatus.SUCCESS, TierTopicHeadDataLossReport.CompletionStatus.PARTIAL_SUCCESS, TierTopicHeadDataLossDetectionResponse.CompletionStatus.PARTIAL_SUCCESS, TierTopicHeadDataLossReport.CompletionStatus.FAILURE, TierTopicHeadDataLossDetectionResponse.CompletionStatus.FAILURE);

    public TierTopicDataLossValidator(TierTopicManagerConfig config, TierTopic tierTopic, TierObjectStore tierObjectStore, ReplicaManager replicaManager, Supplier<ConfluentAdmin> adminClientSupplier, LeaderEndpointSupplier leaderEndpointSupplier, Time time, Metrics metrics) {
        this.config = config;
        this.tierTopic = tierTopic;
        this.tierObjectStore = tierObjectStore;
        this.replicaManager = replicaManager;
        this.adminClientSupplier = adminClientSupplier;
        this.leaderEndpointSupplier = leaderEndpointSupplier;
        this.time = time;
        this.dataLossMetrics = new TierTopicDataLossValidatorMetrics(metrics);
        this.dataLossDetectionMaxTimeoutMs = config.tierTopicDataLossDetectionMaxTimeoutMs();
    }

    private void checkDataLossValidationEnabled() {
        if (!this.config.enableTierTopicDataLossDetection().booleanValue()) {
            throw new UnsupportedOperationException(String.format("Can't run data loss detection in tier topic as %s is disabled.", KafkaConfig.TierTopicDataLossDetectionEnableProp()));
        }
    }

    private void checkValidationSource(ValidationSource validationSource) {
        if (validationSource == ValidationSource.UNCLEAN_RESTART_VALIDATION) {
            throw new UnsupportedOperationException("Unsupported validation source: " + String.valueOf((Object)validationSource));
        }
    }

    private boolean isUserPartitionFencingNeeded(ValidationSource validationSource) {
        return validationSource == ValidationSource.BOOTSTRAP_VALIDATION && this.config.enableTierTopicFencingDuringDataLoss != false;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (newConfig.confluentConfig().tierTopicDataLossDetectionMaxTimeoutMs() < 0L) {
            throw new ConfigException(String.format("%s must have a value at least >= 0.", KafkaConfig.TierTopicDataLossDetectionMaxTimeoutMsProp()));
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        long newValue;
        long oldValue = oldConfig.confluentConfig().tierTopicDataLossDetectionMaxTimeoutMs();
        if (oldValue != (newValue = newConfig.confluentConfig().tierTopicDataLossDetectionMaxTimeoutMs().longValue())) {
            log.info("Reconfigure {} from {} to {}", new Object[]{KafkaConfig.TierTopicDataLossDetectionMaxTimeoutMsProp(), oldValue, newValue});
            this.dataLossDetectionMaxTimeoutMs = newValue;
        }
    }

    public long dataLossDetectionMaxTimeoutMs() {
        return this.dataLossDetectionMaxTimeoutMs;
    }

    public TierTopicHeadDataLossDetectionResponse detectDataLossInTierTopicHead(TierTopicHeadDataLossDetectionRequest request, ValidationSource validationSource, Producer<byte[], byte[]> producer, long timeoutMs) throws InterruptedException, ExecutionException {
        return this.detectDataLossInTierTopicHead(request, validationSource, producer, timeoutMs, DATA_LOSS_DETECTION_RETRY_SLEEP_TIME_MS);
    }

    public void shutdown() {
        this.shutdown.compareAndSet(false, true);
    }

    public TierTopicHeadDataLossDetectionResponse detectDataLossInTierTopicHead(TierTopicHeadDataLossDetectionRequest request, ValidationSource validationSource, Producer<byte[], byte[]> producer, long requestTimeoutMs, long retryBackoffSleepTimeMs) throws InterruptedException {
        TierTopicHeadDataLossReport report;
        if (this.shutdown.get()) {
            throw new UnsupportedOperationException("Can't detect data loss in tier topic head because the broker is already shutting down.");
        }
        long startTimeMs = this.time.milliseconds();
        this.checkDataLossValidationEnabled();
        this.checkValidationSource(validationSource);
        boolean shouldFenceUserPartitions = this.isUserPartitionFencingNeeded(validationSource);
        log.info("Detecting data loss in tier topic head with fencing {} (ValidationSource={}).", (Object)(shouldFenceUserPartitions ? "enabled" : "disabled"), (Object)validationSource);
        try {
            report = this.detectDataLossInTierTopicHead(startTimeMs, request, validationSource, shouldFenceUserPartitions ? producer : null, requestTimeoutMs, retryBackoffSleepTimeMs);
        }
        catch (Exception e) {
            this.dataLossMetrics.recordDataLossDetectionFailure(validationSource, true);
            throw e;
        }
        if (report == null) {
            return new TierTopicHeadDataLossDetectionResponse("", TierTopicHeadDataLossDetectionResponse.CompletionStatus.SUCCESS, Collections.emptyList());
        }
        String reportPath = "";
        if (report.hasDataLoss() || report.hasFailures() || report.hasPendingPartitions() && validationSource == ValidationSource.ON_DEMAND_VALIDATION) {
            reportPath = this.uploadReport(request.identifier(), report);
        }
        return new TierTopicHeadDataLossDetectionResponse(reportPath, COMPLETION_STATUS_CONVERSION_MAP.get((Object)report.completionStatus()), report.errorMessages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TierTopicHeadDataLossReport detectDataLossInTierTopicHead(long startTimeMs, TierTopicHeadDataLossDetectionRequest request, ValidationSource validationSource, Producer<byte[], byte[]> producer, long requestTimeoutMs, long retryBackoffSleepTimeMs) throws InterruptedException {
        HashMap<TopicPartition, Boolean> utpLeaderInfo = new HashMap<TopicPartition, Boolean>();
        this.replicaManager.leaderPartitionsIterator().foreach(partition -> {
            utpLeaderInfo.put(partition.topicPartition(), true);
            return null;
        });
        Map<TopicPartition, AffectedTierTopicPartitionInfo> ttpToValidate = this.getTierTopicMaxMaterializedInfoByUserPartition(request.tierTopicPartitionsAllowList(), utpLeaderInfo);
        if (ttpToValidate.isEmpty()) {
            log.info("Skip data loss detection in tier topic as there are no tier topic partitions to validate.");
            this.dataLossMetrics.clearAll();
            return null;
        }
        ConfluentAdmin adminClient = this.adminClientSupplier.get();
        ExecutorService executorService = null;
        ConcurrentHashMap<Integer, LeaderEndPoint> brokerToLeaderEndPointCache = new ConcurrentHashMap<Integer, LeaderEndPoint>();
        try {
            HashMap<TopicPartition, AffectedTierTopicPartitionInfo> ttpDataLossInfo = new HashMap<TopicPartition, AffectedTierTopicPartitionInfo>();
            Map<TopicPartition, PartitionResult> leaderInfo = this.getTierTopicPartitionLeaderInfo(adminClient, ttpToValidate.keySet());
            String timeoutErrorMsg = "";
            int trial = 0;
            while (!ttpToValidate.isEmpty() && (timeoutErrorMsg = this.checkTimeOut(startTimeMs, requestTimeoutMs, ttpToValidate)).isEmpty() && !this.hasBeenShutdown(ttpToValidate)) {
                timeoutErrorMsg = "";
                if (++trial != 1) {
                    log.info("Sleeping for {}ms before retrying data loss detection", (Object)retryBackoffSleepTimeMs);
                    Thread.sleep(retryBackoffSleepTimeMs);
                }
                log.info("[Trial={}] Trying to detect data loss on {} tier topic partitions (ValidationSource={})", new Object[]{trial, ttpToValidate.size(), validationSource});
                Map<Integer, Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>> requestByLeader = this.buildOffsetForLeaderEpochRequests(ttpToValidate, leaderInfo);
                if (executorService == null && !requestByLeader.isEmpty()) {
                    executorService = Executors.newFixedThreadPool(Math.min(requestByLeader.size(), 10));
                }
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> epochEndOffsetsResults = this.sendOffsetForLeaderEpochRequests(requestByLeader, brokerToLeaderEndPointCache, executorService);
                Map<TopicPartition, PartitionResult> latestLeaderInfo = this.getTierTopicPartitionLeaderInfo(adminClient, ttpToValidate.keySet());
                Map<TopicPartition, AffectedTierTopicPartitionInfo> ttpDataLossInfoSubset = this.findDataLoss(ttpToValidate, epochEndOffsetsResults, leaderInfo, latestLeaderInfo);
                ttpDataLossInfo.putAll(ttpDataLossInfoSubset);
                ttpToValidate.keySet().removeAll(epochEndOffsetsResults.keySet());
                leaderInfo = latestLeaderInfo;
            }
            Map<TopicIdPartition, AffectedUserTopicPartitionInfo> utpDataLossInfo = this.getAffectedUserPartitions(ttpDataLossInfo, utpLeaderInfo);
            long endTimeMs = this.time.milliseconds();
            TierTopicHeadDataLossReport.CompletionStatus completionStatus = TierTopicHeadDataLossReport.CompletionStatus.SUCCESS;
            ArrayList<String> errorMessages = new ArrayList<String>();
            HashSet<TopicPartition> failedTtps = new HashSet();
            if (!timeoutErrorMsg.isEmpty()) {
                completionStatus = TierTopicHeadDataLossReport.CompletionStatus.FAILURE;
                errorMessages.add(timeoutErrorMsg);
                failedTtps = new HashSet<TopicPartition>(ttpToValidate.keySet());
                ttpToValidate.clear();
            } else if (!ttpToValidate.isEmpty()) {
                completionStatus = TierTopicHeadDataLossReport.CompletionStatus.PARTIAL_SUCCESS;
            }
            java.util.Set<TopicIdPartition> userPartitionsWithFencingFailures = new HashSet<TopicIdPartition>();
            if (producer == null) {
                log.warn("Skipping fencing of {} user topic partitions that were found to have data loss in tier topic", (Object)utpDataLossInfo.size());
            } else {
                Optional<FencingError> fencingError = this.fenceUserTopicPartitions(utpDataLossInfo.keySet(), producer);
                if (fencingError.isPresent()) {
                    completionStatus = TierTopicHeadDataLossReport.CompletionStatus.FAILURE;
                    errorMessages.add(fencingError.get().errorMessage());
                    userPartitionsWithFencingFailures = fencingError.get().failedUserPartitions;
                }
            }
            TierTopicHeadDataLossReport report = TierTopicHeadDataLossReport.createReport(completionStatus, this.config.brokerId, validationSource, startTimeMs, endTimeMs, utpDataLossInfo, ttpDataLossInfo, failedTtps, ttpToValidate.keySet(), userPartitionsWithFencingFailures, errorMessages);
            report.log();
            if (report.hasDataLoss() || report.hasFailures()) {
                this.dataLossMetrics.recordDataLossReport(report);
            }
            TierTopicHeadDataLossReport tierTopicHeadDataLossReport = report;
            return tierTopicHeadDataLossReport;
        }
        finally {
            for (LeaderEndPoint leaderEndPoint : brokerToLeaderEndPointCache.values()) {
                leaderEndPoint.initiateClose();
                leaderEndPoint.close();
            }
            if (executorService != null) {
                executorService.shutdown();
            }
            adminClient.close();
        }
    }

    private String checkTimeOut(long startTimeMs, long requestTimeoutMs, Map<TopicPartition, AffectedTierTopicPartitionInfo> ttpToValidate) {
        long chosenTimeoutMs = this.dataLossDetectionMaxTimeoutMs;
        if (requestTimeoutMs >= 0L) {
            chosenTimeoutMs = Math.min(requestTimeoutMs, this.dataLossDetectionMaxTimeoutMs);
        }
        if (this.time.milliseconds() - startTimeMs <= chosenTimeoutMs) {
            return "";
        }
        String errorMsg = String.format("Tier topic data loss detection timed out after %d ms. Validation could not be completed for %d tier topic partitions: %s.", chosenTimeoutMs, ttpToValidate.size(), ttpToValidate.keySet());
        log.error(errorMsg);
        return errorMsg;
    }

    private boolean hasBeenShutdown(Map<TopicPartition, AffectedTierTopicPartitionInfo> ttpToValidate) {
        if (this.shutdown.get()) {
            log.info("Tier topic data loss detection was interrupted due to broker shutdown. Validation could not be completed for {} tier topic partitions: {}.", (Object)ttpToValidate.size(), ttpToValidate.keySet());
            return true;
        }
        return false;
    }

    private Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> sendOffsetForLeaderEpochRequests(Map<Integer, Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>> requestByLeader, Map<Integer, LeaderEndPoint> brokerToLeaderEndPointCache, ExecutorService executorService) {
        ArrayList<OffsetForLeaderEpochTask> tasks = new ArrayList<OffsetForLeaderEpochTask>();
        ArrayList<Future<Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>>> futures = new ArrayList<Future<Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>>>();
        for (Map.Entry<Integer, Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>> entry : requestByLeader.entrySet()) {
            OffsetForLeaderEpochTask task = new OffsetForLeaderEpochTask(entry.getKey(), entry.getValue(), brokerToLeaderEndPointCache);
            futures.add(executorService.submit(task));
            tasks.add(task);
        }
        HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> epochEndOffsetsResults = new HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>();
        for (int index = 0; index < futures.size(); ++index) {
            Map epochEndOffsetsResMap;
            Future future = (Future)futures.get(index);
            OffsetForLeaderEpochTask task = (OffsetForLeaderEpochTask)tasks.get(index);
            try {
                epochEndOffsetsResMap = (Map)future.get();
            }
            catch (Exception e) {
                log.error("Failed to successfully execute the OffsetForLeaderEpoch task for leader: {}", (Object)task.leaderId, (Object)e);
                continue;
            }
            epochEndOffsetsResMap.forEach((ttp, epochEndOffset) -> {
                if (epochEndOffset.errorCode() == Errors.NONE.code()) {
                    epochEndOffsetsResults.put((TopicPartition)ttp, (OffsetForLeaderEpochResponseData.EpochEndOffset)epochEndOffset);
                } else {
                    log.error("Can't validate data loss for tier topic partition {} because OffsetForLeaderEpoch request to leader {} returned error code {} in the response {}", new Object[]{ttp, task.leaderId, Errors.forCode(epochEndOffset.errorCode()), epochEndOffset});
                }
            });
        }
        return epochEndOffsetsResults;
    }

    private String uploadReport(String identifier, TierTopicHeadDataLossReport report) {
        try {
            TierTopicHeadDataLossReportMetadata metadata = new TierTopicHeadDataLossReportMetadata(identifier, report.brokerId(), report.creationTimestamp());
            String reportJson = TierTopicHeadDataLossReport.getJsonString(report);
            ByteBuffer buffer = ByteBuffer.wrap(reportJson.getBytes());
            String reportPath = TierObjectStoreFunctionUtils.putBuffer(() -> false, this.tierObjectStore, metadata, buffer, ObjectType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT);
            this.dataLossMetrics.recordDataLossReportUploadStatus(report.source(), true);
            log.info("Successfully uploaded tier topic head data loss report to the object store at the path {}. Identifier: {}.", (Object)reportPath, (Object)identifier);
            return reportPath;
        }
        catch (Exception e) {
            this.dataLossMetrics.recordDataLossReportUploadStatus(report.source(), false);
            throw new RuntimeException(String.format("Could not upload data loss report to object store. Identifier: %s.", identifier), e);
        }
    }

    private static String leaderAsString(PartitionResult leader) {
        return leader == null ? "null" : String.format("(leaderId:%d, leaderEpoch:%s)", leader.leaderId(), leader.leaderEpoch());
    }

    private static boolean hasSameLeader(TopicPartition ttp, PartitionResult leaderBefore, PartitionResult leaderAfter) {
        boolean sameLeader;
        if (leaderBefore == null) {
            throw new IllegalArgumentException("leaderBefore can't be null for tier topic partition: " + String.valueOf(ttp));
        }
        boolean bl = sameLeader = leaderAfter != null && leaderBefore.leaderId() == leaderAfter.leaderId() && leaderBefore.leaderEpoch().getAsInt() == leaderAfter.leaderEpoch().getAsInt();
        if (!sameLeader) {
            log.info("For tier topic partition: {} previous leader: {} is different from current leader: {}", new Object[]{ttp, TierTopicDataLossValidator.leaderAsString(leaderBefore), TierTopicDataLossValidator.leaderAsString(leaderAfter)});
        }
        return sameLeader;
    }

    private static boolean isValidPartitionResult(PartitionResult leader) {
        return leader != null && leader.leaderId() >= 0 && leader.leaderEpoch().isPresent() && leader.leaderEpoch().getAsInt() >= 0;
    }

    private Map<TopicPartition, AffectedTierTopicPartitionInfo> findDataLoss(Map<TopicPartition, AffectedTierTopicPartitionInfo> ttpToValidate, Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> epochEndOffsetsResMap, Map<TopicPartition, PartitionResult> leaderInfoBefore, Map<TopicPartition, PartitionResult> leaderInfoAfter) {
        HashMap<TopicPartition, AffectedTierTopicPartitionInfo> ttpWithDataLoss = new HashMap<TopicPartition, AffectedTierTopicPartitionInfo>();
        epochEndOffsetsResMap.forEach((ttp, epochEndOffset) -> {
            PartitionResult leaderBefore = (PartitionResult)leaderInfoBefore.get(ttp);
            PartitionResult leaderAfter = (PartitionResult)leaderInfoAfter.get(ttp);
            AffectedTierTopicPartitionInfo entry = (AffectedTierTopicPartitionInfo)ttpToValidate.get(ttp);
            OffsetAndEpoch offsetAndEpochByFtps = entry.maxLastMaterializedOffsetAndEpoch();
            OffsetAndEpoch ttpLeaderOffsetAndEpoch = new OffsetAndEpoch(epochEndOffset.endOffset(), Optional.of(epochEndOffset.leaderEpoch()));
            if (TierTopicDataLossValidator.hasSameLeader(ttp, leaderBefore, leaderAfter)) {
                boolean hasDataLoss;
                AffectedTierTopicPartitionInfo ttpInfo = (AffectedTierTopicPartitionInfo)ttpToValidate.get(ttp);
                boolean bl = hasDataLoss = ttpLeaderOffsetAndEpoch.epoch().orElse(-1).intValue() != offsetAndEpochByFtps.epoch().orElse(-1).intValue() || epochEndOffset.endOffset() <= offsetAndEpochByFtps.offset();
                if (hasDataLoss) {
                    AffectedTierTopicPartitionInfo affectedTtpInfo = new AffectedTierTopicPartitionInfo(ttpInfo.maxLastMaterializedOffsetAndEpoch(), ttpInfo.maxLastMaterializedPartition(), ttpInfo.ftpsStatus(), ttpInfo.isLeader(), this.config.brokerId, new OffsetAndEpoch(epochEndOffset.endOffset(), Optional.of(epochEndOffset.leaderEpoch())));
                    ttpWithDataLoss.put((TopicPartition)ttp, affectedTtpInfo);
                    log.error("Data loss detected in tier topic partition: {}. User partition where data loss was detected: {} with FTPS last materialized OffsetAndEpoch: {}, leader's response: {}", new Object[]{ttp, entry.maxLastMaterializedPartition(), offsetAndEpochByFtps, ttpLeaderOffsetAndEpoch});
                } else {
                    log.info("No data loss detected in tier topic partition: {}", ttp);
                }
            } else {
                log.warn("Can't validata data loss on tier topic partition: {} because leader has changed.", ttp);
            }
        });
        return ttpWithDataLoss;
    }

    private boolean shouldProcessLog(AbstractLog log, java.util.Set<TopicPartition> ttpAllowList) {
        if (!log.isStray() && !log.isDeleted() && log.topicIdPartition().isDefined()) {
            TierPartitionState ftps = log.tierPartitionState();
            Optional<TopicIdPartition> utp = ftps.topicIdPartition();
            OffsetAndEpoch lastMaterializedOffsetAndEpoch = ftps.lastLocalMaterializedSrcOffsetAndEpoch();
            if (utp.isPresent() && lastMaterializedOffsetAndEpoch.epoch().isPresent() && lastMaterializedOffsetAndEpoch.offset() >= 0L) {
                TopicPartition ttp = this.tierTopic.toTierTopicPartition(utp.get());
                return ttpAllowList.isEmpty() || ttpAllowList.contains(ttp);
            }
        }
        return false;
    }

    private Map<TopicPartition, AffectedTierTopicPartitionInfo> getTierTopicMaxMaterializedInfoByUserPartition(java.util.Set<TopicPartition> ttpAllowList, Map<TopicPartition, Boolean> utpLeaderInfo) {
        HashMap<TopicPartition, AffectedTierTopicPartitionInfo> ttpToMaxMaterializedUtpInfo = new HashMap<TopicPartition, AffectedTierTopicPartitionInfo>();
        this.replicaManager.logManager().allLogs().foreach(log -> {
            TierPartitionState ftps;
            Optional<TopicIdPartition> utp;
            TopicPartition ttp;
            AffectedTierTopicPartitionInfo prevEntry;
            if (this.shouldProcessLog((AbstractLog)log, ttpAllowList) && ((prevEntry = (AffectedTierTopicPartitionInfo)ttpToMaxMaterializedUtpInfo.get(ttp = this.tierTopic.toTierTopicPartition((utp = (ftps = log.tierPartitionState()).topicIdPartition()).get()))) == null || ftps.lastLocalMaterializedSrcOffsetAndEpoch().offset() > prevEntry.maxLastMaterializedOffsetAndEpoch().offset())) {
                boolean isLeader = utpLeaderInfo.containsKey(utp.get().topicPartition());
                ttpToMaxMaterializedUtpInfo.put(ttp, new AffectedTierTopicPartitionInfo(ftps.lastLocalMaterializedSrcOffsetAndEpoch(), utp.get(), ftps.status(), isLeader, this.config.brokerId, OffsetAndEpoch.EMPTY));
            }
            return null;
        });
        return ttpToMaxMaterializedUtpInfo;
    }

    private Map<TopicPartition, PartitionResult> getTierTopicPartitionLeaderInfo(ConfluentAdmin adminClient, java.util.Set<TopicPartition> targetTtpSet) {
        HashMap<TopicPartition, PartitionResult> partitionResults = new HashMap<TopicPartition, PartitionResult>();
        ReplicaStatusResult replicaStatusResult = adminClient.replicaStatus(targetTtpSet, new ReplicaStatusOptions());
        replicaStatusResult.partitionResults().forEach((topicPartition, result) -> {
            PartitionResult partitionResult;
            try {
                partitionResult = (PartitionResult)result.get();
                int leaderId = partitionResult.leaderId();
                OptionalInt leaderEpoch = partitionResult.leaderEpoch();
                if (!TierTopicDataLossValidator.isValidPartitionResult(partitionResult)) {
                    log.warn("Can't get leader info for tier topic partition {} due to unexpected PartitionResult with leaderId: {} and leaderEpoch: {}", new Object[]{topicPartition, leaderId, leaderEpoch.orElse(-1)});
                    partitionResult = null;
                }
            }
            catch (Exception e) {
                log.warn("Can't get leader info for tier topic partition {}", topicPartition, (Object)e);
                partitionResult = null;
            }
            if (partitionResult != null) {
                partitionResults.put((TopicPartition)topicPartition, partitionResult);
            }
        });
        return partitionResults;
    }

    private Map<Integer, Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>> buildOffsetForLeaderEpochRequests(Map<TopicPartition, AffectedTierTopicPartitionInfo> partitionToValidate, Map<TopicPartition, PartitionResult> ttpLeaderInfo) {
        HashMap<Integer, Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>> requests = new HashMap<Integer, Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>>();
        ttpLeaderInfo.forEach((ttp, partitionResult) -> {
            AffectedTierTopicPartitionInfo entry = (AffectedTierTopicPartitionInfo)partitionToValidate.get(ttp);
            if (entry != null) {
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition request = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(ttp.partition()).setLeaderEpoch(entry.maxLastMaterializedOffsetAndEpoch().epoch().get());
                requests.computeIfAbsent(partitionResult.leaderId(), v -> new HashMap()).put(ttp, request);
            }
        });
        return requests;
    }

    private Map<TopicIdPartition, AffectedUserTopicPartitionInfo> getAffectedUserPartitions(Map<TopicPartition, AffectedTierTopicPartitionInfo> dataLossPartitionEndOffset, Map<TopicPartition, Boolean> utpLeaderInfo) {
        if (dataLossPartitionEndOffset.isEmpty()) {
            TierTopicDataLossValidator.log.debug("No tier topic partition has data loss, so no user partitions got affected.");
            return new HashMap<TopicIdPartition, AffectedUserTopicPartitionInfo>();
        }
        HashMap<TopicIdPartition, AffectedUserTopicPartitionInfo> affectedUtps = new HashMap<TopicIdPartition, AffectedUserTopicPartitionInfo>();
        this.replicaManager.logManager().allLogs().foreach(log -> {
            if (this.shouldProcessLog((AbstractLog)log, (java.util.Set<TopicPartition>)new HashSet<TopicPartition>())) {
                TierPartitionState ftps = log.tierPartitionState();
                OffsetAndEpoch lastMaterializedOffsetAndEpoch = ftps.lastLocalMaterializedSrcOffsetAndEpoch();
                Optional<TopicIdPartition> utp = ftps.topicIdPartition();
                TopicPartition ttp = this.tierTopic.toTierTopicPartition(utp.get());
                AffectedTierTopicPartitionInfo ttpInfo = (AffectedTierTopicPartitionInfo)dataLossPartitionEndOffset.get(ttp);
                boolean isLeader = utpLeaderInfo.containsKey(utp.get().topicPartition());
                if (ttpInfo != null && lastMaterializedOffsetAndEpoch.offset() >= ttpInfo.tierTopicEndOffsetAndEpoch().offset()) {
                    affectedUtps.put(utp.get(), new AffectedUserTopicPartitionInfo(ttp.partition(), lastMaterializedOffsetAndEpoch, ftps.status(), isLeader));
                }
            }
            return null;
        });
        return affectedUtps;
    }

    private Optional<FencingError> fenceUserTopicPartitions(java.util.Set<TopicIdPartition> utpToFence, Producer<byte[], byte[]> producer) {
        if (utpToFence.isEmpty()) {
            log.info("No user topic partitions to be fenced");
            return Optional.empty();
        }
        log.info("Fencing {} user topic partitions", (Object)utpToFence.size());
        HashSet<TopicIdPartition> remainingUtps = new HashSet<TopicIdPartition>(utpToFence);
        Exception sampleException = null;
        for (TopicIdPartition utp : utpToFence) {
            if (this.shutdown.get()) {
                log.warn("Can't fence user partition: {} because broker is shutting down.", (Object)utp);
                break;
            }
            try {
                RecoveryUtils.injectTierTopicEvent(producer, new TierPartitionFence(utp, UUID.randomUUID(), false), this.tierTopic.topicName(), this.tierTopic.numPartitions().getAsInt());
            }
            catch (Exception e) {
                if (sampleException != null) continue;
                sampleException = e;
                continue;
            }
            remainingUtps.remove(utp);
        }
        if (sampleException != null) {
            return Optional.of(new FencingError(sampleException, remainingUtps));
        }
        return Optional.empty();
    }

    private LeaderEndPoint getLeaderEndPoint(int nodeId, int leaderId, Map<Integer, LeaderEndPoint> brokerToLeaderEndPointCache) {
        LeaderEndPoint leaderEndPoint = brokerToLeaderEndPointCache.get(leaderId);
        if (leaderEndPoint != null) {
            return leaderEndPoint;
        }
        leaderEndPoint = this.leaderEndpointSupplier.get(nodeId, leaderId, this.getClass().getSimpleName());
        brokerToLeaderEndPointCache.put(leaderId, leaderEndPoint);
        return leaderEndPoint;
    }

    private static class FencingError {
        final Exception exception;
        final java.util.Set<TopicIdPartition> failedUserPartitions;

        FencingError(Exception e, java.util.Set<TopicIdPartition> partitionsNotFenced) {
            this.exception = e;
            this.failedUserPartitions = partitionsNotFenced;
        }

        String errorMessage() {
            return String.format("Tier topic data loss fencing failed. Sample error: %s. Partitions not fenced: %s", this.exception == null ? "<none>" : this.exception.getMessage(), this.failedUserPartitions);
        }
    }

    class OffsetForLeaderEpochTask
    implements Callable<Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>> {
        final int leaderId;
        final Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> request;
        final Map<Integer, LeaderEndPoint> brokerToLeaderEndPointCache;

        OffsetForLeaderEpochTask(int leaderId, Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> request, Map<Integer, LeaderEndPoint> brokerToLeaderEndPointCache) {
            this.leaderId = leaderId;
            this.request = request;
            this.brokerToLeaderEndPointCache = brokerToLeaderEndPointCache;
        }

        @Override
        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> call() throws Exception {
            LeaderEndPoint leaderEndPoint = TierTopicDataLossValidator.this.getLeaderEndPoint(TierTopicDataLossValidator.this.config.brokerId, this.leaderId, this.brokerToLeaderEndPointCache);
            log.debug("Sending OffsetForLeaderEpoch request to node {} for {} partitions: {}", new Object[]{this.leaderId, this.request.size(), this.request});
            Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> result = CollectionConverters.asJava(leaderEndPoint.fetchEpochEndOffsets(CollectionConverters.asScala(this.request)));
            log.debug("Completed OffsetForLeaderEpoch request to node {} for {} partitions: {}", new Object[]{this.leaderId, result.size(), result});
            return result;
        }
    }
}

