/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.RequestLogger;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.RequestLocal;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\b\u0010\u0001QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015I\b\u0001\"\u0003{\u0011\u0015a\b\u0001\"\u0003~\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0001bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003#\u0001A\u0011BA\n\u0011\u0019q\u0006\u0001\"\u0003\u0002\u0018\t1B+Z:u%\u00064GOU3rk\u0016\u001cH\u000fS1oI2,'O\u0003\u0002\u0011#\u0005)Ao\\8mg*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001)2$\t\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qyR\"A\u000f\u000b\u0005y\t\u0012AB:feZ,'/\u0003\u0002!;\t\t\u0012\t]5SKF,Xm\u001d;IC:$G.\u001a:\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\n\u0012!B;uS2\u001c\u0018B\u0001\u0014$\u0005\u001daunZ4j]\u001e\f1B]1gi6\u000bg.Y4feB\u0012\u0011&\r\t\u0004U5zS\"A\u0016\u000b\u00051\n\u0012\u0001\u0002:bMRL!AL\u0016\u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0003aEb\u0001\u0001B\u00053\u0003\u0005\u0005\t\u0011!B\u0001g\t\u0019q\fJ\u0019\u0012\u0005Q:\u0004C\u0001\f6\u0013\t1tCA\u0004O_RD\u0017N\\4\u0011\u0005YA\u0014BA\u001d\u0018\u0005\r\te._\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\tat(D\u0001>\u0015\tq\u0014#A\u0004oKR<xN]6\n\u0005\u0001k$A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0005i&lW\r\u0005\u0002D\u00196\tAI\u0003\u0002%\u000b*\u0011aiR\u0001\u0007G>lWn\u001c8\u000b\u0005IA%BA%K\u0003\u0019\t\u0007/Y2iK*\t1*A\u0002pe\u001eL!!\u0014#\u0003\tQKW.Z\u0001\u0012CBLg+\u001a:tS>tW*\u00198bO\u0016\u0014\bC\u0001\u000fQ\u0013\t\tVDA\tBa&4VM]:j_:l\u0015M\\1hKJ\fa\u0001P5oSRtD#\u0002+W7rk\u0006CA+\u0001\u001b\u0005y\u0001\"B\u0014\u0006\u0001\u00049\u0006G\u0001-[!\rQS&\u0017\t\u0003ai#\u0011B\r,\u0002\u0002\u0003\u0005)\u0011A\u001a\t\u000bi*\u0001\u0019A\u001e\t\u000b\u0005+\u0001\u0019\u0001\"\t\u000b9+\u0001\u0019A(\u0002\r!\fg\u000e\u001a7f)\u0011\u00017\r\\9\u0011\u0005Y\t\u0017B\u00012\u0018\u0005\u0011)f.\u001b;\t\u000b\u00114\u0001\u0019A3\u0002\u000fI,\u0017/^3tiB\u0011a-\u001b\b\u0003y\u001dL!\u0001[\u001f\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011!n\u001b\u0002\b%\u0016\fX/Z:u\u0015\tAW\bC\u0003n\r\u0001\u0007a.A\u0007sKF,Xm\u001d;M_\u001e<WM\u001d\t\u00039=L!\u0001]\u000f\u0003\u001bI+\u0017/^3ti2{wmZ3s\u0011\u0015\u0011h\u00011\u0001t\u00031\u0011X-];fgRdunY1m!\t!x/D\u0001v\u0015\t1eO\u0003\u0002\u001f\u000f&\u0011\u00010\u001e\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\u0001\u0012Q\u0006tG\r\\3Ba&4VM]:j_:\u001cHC\u00011|\u0011\u0015!w\u00011\u0001f\u0003)A\u0017M\u001c3mKZ{G/\u001a\u000b\u0003AzDQ\u0001\u001a\u0005A\u0002\u0015\fa\u0003[1oI2,')Z4j]F+xN];n\u000bB|7\r\u001b\u000b\u0004A\u0006\r\u0001\"\u00023\n\u0001\u0004)\u0017\u0001\u00065b]\u0012dW-\u00128e#V|'/^7Fa>\u001c\u0007\u000eF\u0002a\u0003\u0013AQ\u0001\u001a\u0006A\u0002\u0015\f1\u0002[1oI2,g)\u001a;dQR\u0019\u0001-a\u0004\t\u000b\u0011\\\u0001\u0019A3\u0002'!\fg\u000e\u001a7f\r\u0016$8\r[*oCB\u001c\bn\u001c;\u0015\u0007\u0001\f)\u0002C\u0003e\u0019\u0001\u0007Q\rF\u0003a\u00033\tY\u0002C\u0003e\u001b\u0001\u0007Q\rC\u0004\u0002\u001e5\u0001\r!a\b\u0002\u001b\t,\u0018\u000e\u001c3SKN\u0004xN\\:f!\u001d1\u0012\u0011EA\u0013\u0003cI1!a\t\u0018\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY#R\u0001\taJ|Go\\2pY&!\u0011qFA\u0015\u0005)\t\u0005/['fgN\fw-\u001a\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011qG#\u0002\u0011I,\u0017/^3tiNLA!a\u000f\u00026\t\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/\u001a")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final RaftManager<?> raftManager;
    private final RequestChannel requestChannel;
    private final Time time;
    private final ApiVersionManager apiVersionManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TestRaftRequestHandler testRaftRequestHandler = this;
        synchronized (testRaftRequestHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLogger requestLogger, RequestLocal requestLocal) {
        block13: {
            try {
                try {
                    this.trace((Function0<String> & Serializable)() -> "Handling request:" + request.requestDesc(true) + " with context " + request.context());
                    ApiKeys apiKeys = request.header().apiKey();
                    if (((Object)((Object)ApiKeys.API_VERSIONS)).equals((Object)apiKeys)) {
                        this.handleApiVersions(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.VOTE)).equals((Object)apiKeys)) {
                        this.handleVote(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.BEGIN_QUORUM_EPOCH)).equals((Object)apiKeys)) {
                        this.handleBeginQuorumEpoch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.END_QUORUM_EPOCH)).equals((Object)apiKeys)) {
                        this.handleEndQuorumEpoch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.FETCH)).equals((Object)apiKeys)) {
                        this.handleFetch(request);
                        break block13;
                    }
                    if (((Object)((Object)ApiKeys.FETCH_SNAPSHOT)).equals((Object)apiKeys)) {
                        this.handleFetchSnapshot(request);
                        break block13;
                    }
                    throw new IllegalArgumentException("Unsupported api key: " + request.header().apiKey());
                }
                catch (FatalExitError e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.error((Function0<String> & Serializable)() -> "Unexpected error handling request " + request.requestDesc(true) + " with context " + request.context(), (Function0<Throwable> & Serializable)() -> e);
                    AbstractResponse errorResponse = ((AbstractRequest)request.body(ClassTag$.MODULE$.apply(AbstractRequest.class))).getErrorResponse(e);
                    this.requestChannel.sendResponse(request, errorResponse, None$.MODULE$);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleApiVersions(RequestChannel.Request request) {
        this.requestChannel.sendResponse(request, this.apiVersionManager.apiVersionResponse(0, request.header().apiVersion() < 4, this.apiVersionManager.apiVersionResponse$default$3()), None$.MODULE$);
    }

    private void handleVote(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, VoteResponse> & Serializable)response -> new VoteResponse((VoteResponseData)response));
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, BeginQuorumEpochResponse> & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response));
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, EndQuorumEpochResponse> & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response));
    }

    private void handleFetch(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, FetchResponse> & Serializable)response -> new FetchResponse((FetchResponseData)response));
    }

    private void handleFetchSnapshot(RequestChannel.Request request) {
        this.handle(request, (Function1<ApiMessage, AbstractResponse>)(Function1<ApiMessage, FetchSnapshotResponse> & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response));
    }

    private void handle(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        CompletableFuture<ApiMessage> future = this.raftManager.handleRequest(request.context(), request.header(), requestBody.data(), this.time.milliseconds());
        future.whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? requestBody.getErrorResponse((Throwable)exception) : (AbstractResponse)buildResponse.apply((ApiMessage)response);
            $this.requestChannel.sendResponse(request, res, None$.MODULE$);
        });
    }

    public TestRaftRequestHandler(RaftManager<?> raftManager, RequestChannel requestChannel, Time time, ApiVersionManager apiVersionManager) {
        this.raftManager = raftManager;
        this.requestChannel = requestChannel;
        this.time = time;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
    }
}

