/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Logging;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.SocketServerConfigs;
import org.apache.kafka.server.util.Csv;
import org.slf4j.event.Level;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class CoreUtils$ {
    public static final CoreUtils$ MODULE$ = new CoreUtils$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());
    private static final InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();

    private Logger logger() {
        return logger;
    }

    private InetAddressValidator inetAddressValidator() {
        return inetAddressValidator;
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable e) {
            Level level = logLevel;
            if (Level.ERROR.equals(level)) {
                logging.error((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            if (Level.WARN.equals(level)) {
                logging.warn((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            if (Level.INFO.equals(level)) {
                logging.info((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            if (Level.DEBUG.equals(level)) {
                logging.debug((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            if (Level.TRACE.equals(level)) {
                logging.trace((Function0<String> & Serializable)() -> e.getMessage(), (Function0<Throwable> & Serializable)() -> e);
            }
            throw new MatchError(level);
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1<String, Object> & Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public void tryAll(Seq<Function0<BoxedUnit>> all) {
        ObjectRef<Object> exception = ObjectRef.create(null);
        all.foreach((Function1<Function0, Object> & Serializable)element -> {
            CoreUtils$.$anonfun$tryAll$1(exception, element);
            return BoxedUnit.UNIT;
        });
        if ((Throwable)exception.elem != null) {
            throw (Throwable)exception.elem;
        }
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to register Mbean " + name, (Throwable)e);
                v2 = BoxedUnit.UNIT;
            } else {
                v2 = BoxedUnit.UNIT;
            }
            bl = false;
        }
        return bl;
    }

    public <T> T createObject(String className, scala.collection.immutable.Seq<Object> args) {
        Class<Object> klass = Utils.loadClass(className, Object.class);
        Constructor<Object> constructor = klass.getConstructor((Class[])((IterableOnceOps)args.map((Function1<Object, Class> & Serializable)x$1 -> x$1.getClass())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        return (T)constructor.newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        T t;
        boolean locked = true;
        try {
            lock.lock();
            try {
                t = fun.apply();
            }
            finally {
                lock.unlock();
                locked = false;
            }
        }
        catch (Exception e) {
            if (locked) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Potential lock issue: exception before unlocking lock " + lock + ":", (Throwable)e);
                    v1 = BoxedUnit.UNIT;
                } else {
                    v1 = BoxedUnit.UNIT;
                }
            } else {
                v1 = BoxedUnit.UNIT;
            }
            throw e;
        }
        return t;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        return this.inLock(lock.readLock(), fun);
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        T t;
        block7: {
            boolean wasAlreadyHoldingWriteLock = CoreUtils$.isWriteLockedByCurrentThread$1(lock);
            try {
                t = this.inLock(lock.writeLock(), fun);
            }
            catch (Throwable throwable) {
                if (wasAlreadyHoldingWriteLock != CoreUtils$.isWriteLockedByCurrentThread$1(lock)) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Potential lock issue: write lock / unlock didn't restore lock " + lock.writeLock() + " into holding=" + wasAlreadyHoldingWriteLock + "\n\tat " + Predef$.MODULE$.wrapRefArray((Object[])Thread.currentThread().getStackTrace()).mkString("\n\tat "));
                        v1 = BoxedUnit.UNIT;
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
            if (wasAlreadyHoldingWriteLock == CoreUtils$.isWriteLockedByCurrentThread$1(lock)) break block7;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Potential lock issue: write lock / unlock didn't restore lock " + lock.writeLock() + " into holding=" + wasAlreadyHoldingWriteLock + "\n\tat " + Predef$.MODULE$.wrapRefArray((Object[])Thread.currentThread().getStackTrace()).mkString("\n\tat "));
                v2 = BoxedUnit.UNIT;
            } else {
                v2 = BoxedUnit.UNIT;
            }
        }
        return t;
    }

    public <T> Iterable<T> duplicates(Iterable<T> s) {
        return ((MapOps)s.groupBy((Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x)).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Iterable l = (Iterable)tuple2._2();
                return new Tuple2(k, BoxesRunTime.boxToInteger(l.size()));
            }
            throw new MatchError(tuple2);
        }).filter((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$duplicates$3(x0$2)))).keys();
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        return this.listenerListToEndPoints(listeners, securityProtocolMap, true);
    }

    public Map<String, String> clusterLinkLocalReverseConnectionListenerMap(String listenerToListenerConfigVal, Seq<ListenerName> listeners) {
        Set listenersSet = ((IterableOnceOps)listeners.map((Function1<ListenerName, String> & Serializable)x$2 -> x$2.value())).toSet();
        if (listenerToListenerConfigVal != null) {
            scala.collection.immutable.Map<String, String> listenerToListener = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(Csv.parseCsvList(listenerToListenerConfigVal)).asScala().map((Function1<String, Tuple2> & Serializable)listenerToListenerStr -> {
                String key = listenerToListenerStr.substring(0, listenerToListenerStr.lastIndexOf(":")).trim();
                String value = listenerToListenerStr.substring(listenerToListenerStr.lastIndexOf(":") + 1).trim();
                if (listenersSet.contains(key) && !listenersSet.contains(value)) {
                    throw new IllegalArgumentException("Listener " + value + " does not exist in the brokers configured listeners " + listenersSet);
                }
                return new Tuple2<String, String>(key, value);
            })).toMap($less$colon$less$.MODULE$.refl());
            listenersSet.foreach((Function1<String, Object> & Serializable)l -> {
                CoreUtils$.$anonfun$clusterLinkLocalReverseConnectionListenerMap$3(listenerToListener, listenerToListenerConfigVal, l);
                return BoxedUnit.UNIT;
            });
            return listenerToListener;
        }
        return ((IterableOnceOps)listeners.map((Function1<ListenerName, Tuple2> & Serializable)l -> new Tuple2<String, String>(l.value(), l.value()))).toMap($less$colon$less$.MODULE$.refl());
    }

    private void checkDuplicateListenerPorts(Seq<EndPoint> endpoints, String listeners) {
        Seq distinctPorts = (Seq)((SeqOps)endpoints.map((Function1<EndPoint, Object> & Serializable)x$3 -> BoxesRunTime.boxToInteger(x$3.port()))).distinct();
        Predef$.MODULE$.require(distinctPorts.size() == ((SeqOps)endpoints.map((Function1<EndPoint, Object> & Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.port()))).size(), (Function0<Object>)(Function0<String> & Serializable)() -> "Each listener must have a different port, listeners: " + listeners);
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap, boolean requireDistinctPorts) {
        Buffer buffer;
        try {
            buffer = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(SocketServerConfigs.listenerListToEndPoints(listeners, CollectionConverters$.MODULE$.MapHasAsJava(securityProtocolMap).asJava())).asScala().map((Function1<Endpoint, EndPoint> & Serializable)x$7 -> EndPoint$.MODULE$.fromJava((Endpoint)x$7));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating broker listeners from '" + listeners + "': " + e.getMessage(), e);
        }
        Buffer endPoints = buffer;
        this.validate$1(endPoints, listeners, requireDistinctPorts);
        return endPoints;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return this.uuidToBase64(uuid);
    }

    public String uuidToBase64(UUID uuid) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public UUID uuidFromBase64(String str) {
        byte[] bytes = Base64.getUrlDecoder().decode(str);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        return new UUID(bb.getLong(), bb.getLong());
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Uuid toKafkaUUID(UUID uuid) {
        return new Uuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public UUID toJavaUUID(Uuid uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public Uuid toKafkaUuidFromJavaUUIDString(String id) {
        return this.toKafkaUUID(UUID.fromString(id));
    }

    public String toJavaUUIDStringFromKafkaUuidString(String id) {
        return this.toJavaUUID(Uuid.fromString(id)).toString();
    }

    public byte[] md5hash(ByteBuffer buf) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buf.duplicate());
        return md5.digest();
    }

    public String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, String>(key, value)}));
    }

    public Properties propsWith(scala.collection.immutable.Seq<Tuple2<String, String>> props) {
        Properties properties = new Properties();
        props.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return properties.put(k, v);
            }
            throw new MatchError(tuple2);
        });
        return properties;
    }

    public Map<Object, Seq<Object>> replicaToBrokerAssignmentAsScala(java.util.Map<Integer, List<Integer>> map) {
        return (Map)CollectionConverters$.MODULE$.MapHasAsScala(map).asScala().map((Function1<Tuple2, Tuple2> & Serializable)e -> new Tuple2(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(e._1())), CollectionConverters$.MODULE$.ListHasAsScala((List)e._2()).asScala().map((Function1<Integer, Object> & Serializable)x$8 -> BoxesRunTime.boxToInteger(CoreUtils$.$anonfun$replicaToBrokerAssignmentAsScala$2(x$8)))));
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete(new File(f));
    }

    public static final /* synthetic */ void $anonfun$tryAll$1(ObjectRef exception$1, Function0 element) {
        block3: {
            try {
                element.apply$mcV$sp();
            }
            catch (Throwable e) {
                if ((Throwable)exception$1.elem != null) {
                    ((Throwable)exception$1.elem).addSuppressed(e);
                    break block3;
                }
                exception$1.elem = e;
            }
        }
    }

    private static final boolean isWriteLockedByCurrentThread$1(ReadWriteLock lock$1) {
        return lock$1 instanceof ReentrantReadWriteLock && ((ReentrantReadWriteLock)lock$1).isWriteLockedByCurrentThread();
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int l = tuple2._2$mcI$sp();
            return l > 1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$clusterLinkLocalReverseConnectionListenerMap$3(scala.collection.immutable.Map listenerToListener$1, String listenerToListenerConfigVal$1, String l) {
        if (!listenerToListener$1.contains(l)) {
            throw new IllegalArgumentException(listenerToListenerConfigVal$1 + " does not contain a mapping for listener " + l + ".");
        }
    }

    private final boolean validateOneIsIpv4AndOtherIpv6$1(String first, String second) {
        return this.inetAddressValidator().isValidInet4Address(first) && this.inetAddressValidator().isValidInet6Address(second) || this.inetAddressValidator().isValidInet6Address(first) && this.inetAddressValidator().isValidInet4Address(second);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$3(EndPoint ep) {
        return ep.port() != 0;
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq endpoints = (Seq)tuple2._2();
            return endpoints.size() > 1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$7(EndPoint ep) {
        return ep.host() != null && MODULE$.inetAddressValidator().isValid(ep.host());
    }

    public static final /* synthetic */ void $anonfun$listenerListToEndPoints$8(CoreUtils$ $this, boolean requireDistinctPorts$1, String listeners$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            int port = tuple2._1$mcI$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                SeqOps seqOps;
                Seq seq;
                Seq duplicatesWithIpHosts = (Seq)tuple22._1();
                Seq duplicatesWithoutIpHosts = (Seq)tuple22._2();
                if (requireDistinctPorts$1) {
                    MODULE$.checkDuplicateListenerPorts(duplicatesWithoutIpHosts, listeners$2);
                }
                if ((seq = duplicatesWithIpHosts).isEmpty()) {
                } else if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    EndPoint ep1 = (EndPoint)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    EndPoint ep2 = (EndPoint)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (requireDistinctPorts$1) {
                        String errorMessage = "If you have two listeners on the same port then one needs to be IPv4 and the other IPv6, listeners: " + listeners$2 + ", port: " + port;
                        Predef$.MODULE$.require($this.validateOneIsIpv4AndOtherIpv6$1(ep1.host(), ep2.host()), (Function0<Object>)(Function0<String> & Serializable)() -> errorMessage);
                        if (duplicatesWithoutIpHosts.nonEmpty()) {
                            throw new IllegalArgumentException(errorMessage);
                        }
                    }
                } else if (requireDistinctPorts$1) {
                    throw new IllegalArgumentException("Each listener must have a different port unless exactly one listener has an IPv4 address and the other IPv6 address, listeners: " + listeners$2 + ", port: " + port);
                }
                return;
            }
        }
        throw new MatchError(tuple2);
    }

    private final void validate$1(Seq endPoints, String listeners$2, boolean requireDistinctPorts$1) {
        Seq distinctListenerNames = (Seq)((SeqOps)endPoints.map((Function1<EndPoint, ListenerName> & Serializable)x$5 -> x$5.listenerName())).distinct();
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0<Object>)(Function0<String> & Serializable)() -> "Each listener must have a different name, listeners: " + listeners$2);
        Tuple2 tuple2 = ((IterableOps)endPoints.filter((Function1<EndPoint, Object> & Serializable)ep -> BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$listenerListToEndPoints$3(ep)))).groupBy((Function1<EndPoint, Object> & Serializable)x$6 -> BoxesRunTime.boxToInteger(x$6.port())).partition((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$listenerListToEndPoints$5(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map duplicatePorts = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map duplicatePorts2 = duplicatePorts;
        scala.collection.immutable.Map duplicatePortsPartitionedByValidIps = (scala.collection.immutable.Map)duplicatePorts2.map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int port = tuple2._1$mcI$sp();
                Seq eps = (Seq)tuple2._2();
                return new Tuple2(BoxesRunTime.boxToInteger(port), eps.partition((Function1<EndPoint, Object> & Serializable)ep -> BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$listenerListToEndPoints$7(ep))));
            }
            throw new MatchError(tuple2);
        });
        duplicatePortsPartitionedByValidIps.foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> {
            CoreUtils$.$anonfun$listenerListToEndPoints$8(this, requireDistinctPorts$1, listeners$2, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$replicaToBrokerAssignmentAsScala$2(Integer x$8) {
        return BoxesRunTime.unboxToInt(x$8);
    }

    private CoreUtils$() {
    }
}

