/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.grapher.BindingEdge;
import com.google.inject.grapher.DependencyEdge;
import com.google.inject.grapher.Edge;
import com.google.inject.grapher.EdgeCreator;
import com.google.inject.grapher.NodeId;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import java.util.ArrayList;
import java.util.Collection;

final class DefaultEdgeCreator
implements EdgeCreator {
    DefaultEdgeCreator() {
    }

    @Override
    public Iterable<Edge> getEdges(Iterable<Binding<?>> bindings) {
        ArrayList edges = Lists.newArrayList();
        EdgeVisitor visitor = new EdgeVisitor();
        for (Binding<?> binding : bindings) {
            edges.addAll((Collection)binding.acceptTargetVisitor((BindingTargetVisitor)visitor));
        }
        return edges;
    }

    private static final class EdgeVisitor
    extends DefaultBindingTargetVisitor<Object, Collection<Edge>> {
        private EdgeVisitor() {
        }

        private <T extends Binding<?> & HasDependencies> Collection<Edge> newDependencyEdges(NodeId nodeId, T binding) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Dependency dependency : ((HasDependencies)binding).getDependencies()) {
                NodeId to = NodeId.newTypeId(dependency.getKey());
                builder.add((Object)new DependencyEdge(nodeId, to, dependency.getInjectionPoint()));
            }
            return builder.build();
        }

        public Collection<Edge> visit(ConstructorBinding<?> binding) {
            return this.newDependencyEdges(NodeId.newTypeId(binding.getKey()), (Binding<?> & HasDependencies)binding);
        }

        public Collection<Edge> visit(ConvertedConstantBinding<?> binding) {
            return ImmutableList.of((Object)new BindingEdge(NodeId.newTypeId(binding.getKey()), NodeId.newTypeId(binding.getSourceKey()), BindingEdge.Type.CONVERTED_CONSTANT));
        }

        public Collection<Edge> visit(InstanceBinding<?> binding) {
            return new ImmutableList.Builder().add((Object)new BindingEdge(NodeId.newTypeId(binding.getKey()), NodeId.newInstanceId(binding.getKey()), BindingEdge.Type.NORMAL)).addAll(this.newDependencyEdges(NodeId.newInstanceId(binding.getKey()), (Binding<?> & HasDependencies)binding)).build();
        }

        public Collection<Edge> visit(LinkedKeyBinding<?> binding) {
            return ImmutableList.of((Object)new BindingEdge(NodeId.newTypeId(binding.getKey()), NodeId.newTypeId(binding.getLinkedKey()), BindingEdge.Type.NORMAL));
        }

        public Collection<Edge> visit(ProviderBinding<?> binding) {
            return ImmutableList.of((Object)new BindingEdge(NodeId.newTypeId(binding.getKey()), NodeId.newTypeId(binding.getProvidedKey()), BindingEdge.Type.PROVIDER));
        }

        public Collection<Edge> visit(ProviderInstanceBinding<?> binding) {
            return new ImmutableList.Builder().add((Object)new BindingEdge(NodeId.newTypeId(binding.getKey()), NodeId.newInstanceId(binding.getKey()), BindingEdge.Type.PROVIDER)).addAll(this.newDependencyEdges(NodeId.newInstanceId(binding.getKey()), (Binding<?> & HasDependencies)binding)).build();
        }

        public Collection<Edge> visit(ProviderKeyBinding<?> binding) {
            return ImmutableList.of((Object)new BindingEdge(NodeId.newTypeId(binding.getKey()), NodeId.newTypeId(binding.getProviderKey()), BindingEdge.Type.PROVIDER));
        }

        public Collection<Edge> visitOther(Binding<?> binding) {
            return ImmutableList.of();
        }
    }
}

