/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.crypto.SecretKey;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.runtime.distributed.Crypto;
import org.apache.kafka.connect.runtime.rest.InternalRequestSignature;
import org.apache.kafka.connect.runtime.rest.entities.ErrorMessage;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.runtime.rest.util.AuthorizationHeaderUtils;
import org.apache.kafka.connect.runtime.rest.util.SSLUtils;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.StringRequestContent;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    private final AbstractConfig config;

    public RestClient(AbstractConfig config) {
        this.config = config;
    }

    HttpClient httpClient(SslContextFactory.Client sslContextFactory) {
        HttpClient client;
        if (sslContextFactory != null) {
            ClientConnector clientConnector = new ClientConnector();
            clientConnector.setSslContextFactory(sslContextFactory);
            client = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
        } else {
            client = new HttpClient();
        }
        return client;
    }

    public <T> HttpResponse<T> httpRequest(String url, String method, HttpHeaders headers, Object requestBodyData, TypeReference<T> responseFormat) {
        return this.httpRequest(url, method, headers, requestBodyData, responseFormat, null, null);
    }

    public void httpRequest(String url, String method, HttpHeaders headers, Object requestBodyData, SecretKey sessionKey, String requestSignatureAlgorithm) {
        this.httpRequest(url, method, headers, requestBodyData, new TypeReference<Void>(){}, sessionKey, requestSignatureAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> HttpResponse<T> httpRequest(String url, String method, HttpHeaders headers, Object requestBodyData, TypeReference<T> responseFormat, SecretKey sessionKey, String requestSignatureAlgorithm) {
        Objects.requireNonNull(url, "url must be non-null");
        Objects.requireNonNull(method, "method must be non-null");
        Objects.requireNonNull(responseFormat, "response format must be non-null");
        SslContextFactory.Client sslContextFactory = url.startsWith("https://") ? SSLUtils.createClientSideSslContextFactory(this.config) : null;
        HttpClient client = this.httpClient(sslContextFactory);
        client.setFollowRedirects(false);
        try {
            client.start();
        }
        catch (Exception e) {
            log.error("Failed to start RestClient: ", (Throwable)e);
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to start RestClient: " + e.getMessage(), (Throwable)e);
        }
        try {
            HttpResponse<T> httpResponse = this.httpRequest(client, url, method, headers, requestBodyData, responseFormat, sessionKey, requestSignatureAlgorithm);
            return httpResponse;
        }
        finally {
            try {
                client.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop HTTP client", (Throwable)e);
            }
        }
    }

    private <T> HttpResponse<T> httpRequest(HttpClient client, String url, String method, HttpHeaders headers, Object requestBodyData, TypeReference<T> responseFormat, SecretKey sessionKey, String requestSignatureAlgorithm) {
        try {
            String serializedBody = requestBodyData == null ? null : JSON_SERDE.writeValueAsString(requestBodyData);
            log.trace("Sending {} with input {} to {}", new Object[]{method, serializedBody, url});
            Request req = client.newRequest(url);
            req.method(method);
            req.accept(new String[]{"application/json"});
            req.agent("kafka-connect");
            this.addHeadersToRequest(headers, req);
            if (serializedBody != null) {
                req.body((Request.Content)new StringRequestContent("application/json", serializedBody, StandardCharsets.UTF_8));
            }
            if (sessionKey != null && requestSignatureAlgorithm != null) {
                InternalRequestSignature.addToRequest(Crypto.SYSTEM, sessionKey, serializedBody != null ? serializedBody.getBytes(StandardCharsets.UTF_8) : null, requestSignatureAlgorithm, req);
            }
            ContentResponse res = req.send();
            int responseCode = res.getStatus();
            log.debug("Request's response code: {}", (Object)responseCode);
            if (responseCode == 204) {
                return new HttpResponse<Object>(responseCode, RestClient.convertHttpFieldsToMap(res.getHeaders()), null);
            }
            if (responseCode >= 400) {
                ErrorMessage errorMessage = (ErrorMessage)JSON_SERDE.readValue(res.getContentAsString(), ErrorMessage.class);
                throw new ConnectRestException(responseCode, errorMessage.errorCode(), errorMessage.message());
            }
            if (responseCode >= 200 && responseCode < 300) {
                Object result = JSON_SERDE.readValue(res.getContentAsString(), responseFormat);
                return new HttpResponse<Object>(responseCode, RestClient.convertHttpFieldsToMap(res.getHeaders()), result);
            }
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Unexpected status code when handling forwarded request: " + responseCode);
        }
        catch (IOException | ExecutionException | TimeoutException e) {
            log.error("IO error forwarding REST request to {} :", (Object)url, (Object)e);
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, "IO Error trying to forward REST request: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("Thread was interrupted forwarding REST request to {} :", (Object)url, (Object)e);
            Thread.currentThread().interrupt();
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, "Thread was interrupted trying to forward REST request: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectRestException e) {
            log.error("Error forwarding REST request to {} :", (Object)url, (Object)e);
            throw e;
        }
        catch (Throwable t) {
            log.error("Error forwarding REST request to {} :", (Object)url, (Object)t);
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR, "Error trying to forward REST request: " + t.getMessage(), t);
        }
    }

    private void addHeadersToRequest(HttpHeaders headers, Request req) {
        String credentialAuthorization = null;
        boolean shouldAddAuthZHeader = false;
        try {
            shouldAddAuthZHeader = this.config != null && this.config.getBoolean("confluent.rest.request.authorization.enable") != false;
        }
        catch (ConfigException e) {
            log.warn("confluent.rest.request.authorization.enable config is not present in worker propertiesauthZ headers will not be attached on request originating from connect runtime", (Throwable)e);
        }
        if (headers != null && headers.getHeaderString("Authorization") != null) {
            credentialAuthorization = headers.getHeaderString("Authorization");
        } else if (shouldAddAuthZHeader) {
            log.debug("Attaching authZ header for inter-worker communication");
            try {
                String secretPath = this.config.getString("confluent.rest.request.authorization.secret.path");
                credentialAuthorization = AuthorizationHeaderUtils.getAuthorizationHeaderFromFile(secretPath);
            }
            catch (RuntimeException e) {
                log.error("Failed to get authorization header for inter-worker communication", (Throwable)e);
            }
        }
        if (credentialAuthorization != null) {
            String finalCredentialAuthorization = credentialAuthorization;
            req.headers(field -> field.add("Authorization", finalCredentialAuthorization));
        }
    }

    private static Map<String, String> convertHttpFieldsToMap(HttpFields httpFields) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (httpFields == null || httpFields.size() == 0) {
            return headers;
        }
        for (HttpField field : httpFields) {
            headers.put(field.getName(), field.getValue());
        }
        return headers;
    }

    public static class HttpResponse<T> {
        private final int status;
        private final Map<String, String> headers;
        private final T body;

        public HttpResponse(int status, Map<String, String> headers, T body) {
            this.status = status;
            this.headers = headers;
            this.body = body;
        }

        public int status() {
            return this.status;
        }

        public Map<String, String> headers() {
            return this.headers;
        }

        public T body() {
            return this.body;
        }
    }
}

