/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import com.yammer.metrics.core.Histogram;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public final class BrokerServerMetrics
implements AutoCloseable {
    private static final String METRIC_GROUP_NAME = "broker-metadata-metrics";
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup("kafka.server", "BrokerMetadataListener");
    private final com.yammer.metrics.core.MetricName batchProcessingTimeHistName = this.metricsGroup.metricName("MetadataBatchProcessingTimeUs", Collections.emptyMap());
    private final Time time;
    private final Histogram batchProcessingTimeHist = KafkaYammerMetrics.defaultRegistry().newHistogram(this.batchProcessingTimeHistName, true);
    private final com.yammer.metrics.core.MetricName batchSizeHistName = this.metricsGroup.metricName("MetadataBatchSizes", Collections.emptyMap());
    private final Histogram batchSizeHist = KafkaYammerMetrics.defaultRegistry().newHistogram(this.batchSizeHistName, true);
    final AtomicReference<MetadataProvenance> lastAppliedImageProvenance = new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY);
    private final AtomicLong metadataLoadErrorCount = new AtomicLong(0L);
    private final AtomicLong metadataApplyErrorCount = new AtomicLong(0L);
    private final AtomicBoolean ignoredStaticVoters = new AtomicBoolean(false);
    private final Metrics metrics;
    private final MetricName lastAppliedRecordOffsetName;
    private final MetricName lastAppliedRecordTimestampName;
    private final MetricName lastAppliedRecordLagMsName;
    private final MetricName metadataLoadErrorCountName;
    private final MetricName metadataApplyErrorCountName;
    private final MetricName ignoredStaticVotersName;
    final MetricName lastAppliedImageLatencyMsMaxName;
    final MetricName lastAppliedImageLatencyMs999PercentileName;
    final MetricName lastAppliedImageLatencyMs99PercentileName;
    final MetricName lastAppliedImageLatencyMs50PercentileName;
    private final Sensor lastAppliedImageLatencySensor;

    public BrokerServerMetrics(Metrics metrics) {
        this(metrics, Time.SYSTEM);
    }

    public BrokerServerMetrics(Metrics metrics, Time time) {
        this.metrics = metrics;
        this.time = time;
        this.lastAppliedRecordOffsetName = metrics.metricName("last-applied-record-offset", METRIC_GROUP_NAME, "The offset of the last record from the cluster metadata partition that was applied by the broker");
        this.lastAppliedRecordTimestampName = metrics.metricName("last-applied-record-timestamp", METRIC_GROUP_NAME, "The timestamp of the last record from the cluster metadata partition that was applied by the broker");
        this.lastAppliedRecordLagMsName = metrics.metricName("last-applied-record-lag-ms", METRIC_GROUP_NAME, "The difference between now and the timestamp of the last record from the cluster metadata partition that was applied by the broker");
        this.metadataLoadErrorCountName = metrics.metricName("metadata-load-error-count", METRIC_GROUP_NAME, "The number of errors encountered by the BrokerMetadataListener while loading the metadata log and generating a new MetadataDelta based on it.");
        this.metadataApplyErrorCountName = metrics.metricName("metadata-apply-error-count", METRIC_GROUP_NAME, "The number of errors encountered by the BrokerMetadataPublisher while applying a new MetadataImage based on the latest MetadataDelta.");
        this.ignoredStaticVotersName = metrics.metricName("ignored-static-voters", METRIC_GROUP_NAME, "1 if controller.quorum.voters is set but was not used by the broker, 0 otherwise.");
        this.lastAppliedImageLatencyMsMaxName = metrics.metricName("last-applied-image-latency-ms-max", METRIC_GROUP_NAME, "The max apply latency of the last image from the cluster metadata partition.");
        this.lastAppliedImageLatencyMs999PercentileName = metrics.metricName("last-applied-image-latency-ms-999percentile", METRIC_GROUP_NAME, "The p999 apply latency of the last image from the cluster metadata partition.");
        this.lastAppliedImageLatencyMs99PercentileName = metrics.metricName("last-applied-image-latency-ms-99percentile", METRIC_GROUP_NAME, "The p99 apply latency of the last image from the cluster metadata partition.");
        this.lastAppliedImageLatencyMs50PercentileName = metrics.metricName("last-applied-image-latency-ms-50percentile", METRIC_GROUP_NAME, "The p50 apply latency of the last image from the cluster metadata partition.");
        this.lastAppliedImageLatencySensor = metrics.sensor("last-applied-image-latency");
        this.lastAppliedImageLatencySensor.add(this.lastAppliedImageLatencyMsMaxName, (MeasurableStat)new Max());
        int maxTotalTimeMs = 30000;
        int totalBucketSizeInBytes = maxTotalTimeMs * 4;
        Percentiles lastAppliedRecordLatencyMsPercentiles = new Percentiles(totalBucketSizeInBytes, (double)maxTotalTimeMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.lastAppliedImageLatencyMs50PercentileName, 50.0), new Percentile(this.lastAppliedImageLatencyMs99PercentileName, 99.0), new Percentile(this.lastAppliedImageLatencyMs999PercentileName, 99.9)});
        this.lastAppliedImageLatencySensor.add((CompoundStat)lastAppliedRecordLatencyMsPercentiles);
        metrics.addMetric(this.lastAppliedRecordOffsetName, (config, now) -> this.lastAppliedImageProvenance.get().lastContainedOffset());
        metrics.addMetric(this.lastAppliedRecordTimestampName, (config, now) -> this.lastAppliedImageProvenance.get().lastContainedLogTimeMs());
        metrics.addMetric(this.lastAppliedRecordLagMsName, (config, now) -> now - this.lastAppliedImageProvenance.get().lastContainedLogTimeMs());
        metrics.addMetric(this.metadataLoadErrorCountName, (config, now) -> this.metadataLoadErrorCount.get());
        metrics.addMetric(this.metadataApplyErrorCountName, (config, now) -> this.metadataApplyErrorCount.get());
        metrics.addMetric(this.ignoredStaticVotersName, (MetricValueProvider)((Gauge)(config, now) -> this.ignoredStaticVoters.get() ? 1 : 0));
    }

    @Override
    public void close() throws Exception {
        KafkaYammerMetrics.defaultRegistry().removeMetric(this.batchProcessingTimeHistName);
        KafkaYammerMetrics.defaultRegistry().removeMetric(this.batchSizeHistName);
        Stream.of(this.lastAppliedRecordOffsetName, this.lastAppliedRecordTimestampName, this.lastAppliedRecordLagMsName, this.metadataLoadErrorCountName, this.metadataApplyErrorCountName, this.ignoredStaticVotersName, this.lastAppliedImageLatencyMsMaxName, this.lastAppliedImageLatencyMs999PercentileName, this.lastAppliedImageLatencyMs99PercentileName, this.lastAppliedImageLatencyMs50PercentileName).forEach(arg_0 -> ((Metrics)this.metrics).removeMetric(arg_0));
    }

    public MetricName lastAppliedRecordOffsetName() {
        return this.lastAppliedRecordOffsetName;
    }

    public MetricName lastAppliedRecordTimestampName() {
        return this.lastAppliedRecordTimestampName;
    }

    public MetricName lastAppliedRecordLagMsName() {
        return this.lastAppliedRecordLagMsName;
    }

    public MetricName metadataLoadErrorCountName() {
        return this.metadataLoadErrorCountName;
    }

    public MetricName metadataApplyErrorCountName() {
        return this.metadataApplyErrorCountName;
    }

    public MetricName ignoredStaticVotersName() {
        return this.ignoredStaticVotersName;
    }

    public AtomicReference<MetadataProvenance> lastAppliedImageProvenance() {
        return this.lastAppliedImageProvenance;
    }

    public AtomicLong metadataLoadErrorCount() {
        return this.metadataLoadErrorCount;
    }

    public AtomicLong metadataApplyErrorCount() {
        return this.metadataApplyErrorCount;
    }

    public void updateBatchProcessingTime(long elapsedNs) {
        this.batchProcessingTimeHist.update(TimeUnit.NANOSECONDS.toMicros(elapsedNs));
    }

    public void updateBatchSize(int size) {
        this.batchSizeHist.update(size);
    }

    void updateLastAppliedImageProvenance(MetadataProvenance provenance) {
        this.lastAppliedImageProvenance.set(provenance);
        long now = this.time.milliseconds();
        this.lastAppliedImageLatencySensor.record((double)(now - provenance.lastContainedLogTimeMs()), now);
    }

    long lastAppliedOffset() {
        return this.lastAppliedImageProvenance.get().lastContainedOffset();
    }

    long lastAppliedTimestamp() {
        return this.lastAppliedImageProvenance.get().lastContainedLogTimeMs();
    }

    public void setIgnoredStaticVoters(boolean ignored) {
        this.ignoredStaticVoters.set(ignored);
    }

    public boolean ignoredStaticVoters() {
        return this.ignoredStaticVoters.get();
    }
}

