/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.license;

import io.confluent.common.security.license.LicenseEventListener;
import io.confluent.common.security.license.MultiLicenseBrokerHandler;
import io.confluent.common.security.license.MultiLicenseInitializer;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.kafka.BrokerDetectionException;
import io.confluent.license.kafka.BrokerType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComponentBrokerCompatibilityLogger
implements LicenseEventListener {
    private static final Logger log = LoggerFactory.getLogger(ComponentBrokerCompatibilityLogger.class);
    private final MultiLicenseBrokerHandler multiLicenseBrokerHandler;

    protected ComponentBrokerCompatibilityLogger(MultiLicenseBrokerHandler multiLicenseBrokerHandler) {
        this.multiLicenseBrokerHandler = multiLicenseBrokerHandler;
    }

    @Override
    public synchronized void onLicenseValidated(List<License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            this.onLicenseValidationFailure(new InvalidLicenseException("No licenses found."));
            return;
        }
        if (this.brokerType() == BrokerType.CONFLUENT_PLATFORM && MultiLicenseInitializer.hasOnlyValidCpForCcLicense(licenses)) {
            log.warn("Detected Enterprise CP_FOR_CC license and CP broker");
            this.onIncompatibleLicenseDetected(licenses, this.brokerType());
        } else if (this.brokerType() == BrokerType.UNKNOWN && !MultiLicenseInitializer.hasValidCpLicense(licenses)) {
            this.onBrokerDetectionException(new BrokerDetectionException("Detected a legacy version of broker which does not report broker type"));
        }
    }

    public abstract void onBrokerDetectionException(BrokerDetectionException var1);

    public abstract void onIncompatibleLicenseDetected(List<License> var1, BrokerType var2);

    protected BrokerType brokerType() {
        return this.multiLicenseBrokerHandler.brokerType();
    }
}

