/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.transaction;

import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public final class AddPartitionsToTxnConfig {
    public static final String ADD_PARTITIONS_TO_TXN_RETRY_BACKOFF_MAX_MS_CONFIG = "add.partitions.to.txn.retry.backoff.max.ms";
    public static final int ADD_PARTITIONS_TO_TXN_RETRY_BACKOFF_MAX_MS_DEFAULT = 100;
    public static final String ADD_PARTITIONS_TO_TXN_RETRY_BACKOFF_MAX_MS_DOC = "The maximum allowed timeout for adding partitions to transactions on the server side. It only applies to the actual add partition operations, not the verification. It will not be effective if it is larger than request.timeout.ms";
    public static final String ADD_PARTITIONS_TO_TXN_RETRY_BACKOFF_MS_CONFIG = "add.partitions.to.txn.retry.backoff.ms";
    public static final int ADD_PARTITIONS_TO_TXN_RETRY_BACKOFF_MS_DEFAULT = 20;
    public static final String ADD_PARTITIONS_TO_TXN_RETRY_BACKOFF_MS_DOC = "The server-side retry backoff when the server attempts to add the partition to the transaction";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("add.partitions.to.txn.retry.backoff.max.ms", ConfigDef.Type.INT, (Object)100, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, "The maximum allowed timeout for adding partitions to transactions on the server side. It only applies to the actual add partition operations, not the verification. It will not be effective if it is larger than request.timeout.ms").define("add.partitions.to.txn.retry.backoff.ms", ConfigDef.Type.INT, (Object)20, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The server-side retry backoff when the server attempts to add the partition to the transaction");
    private final int addPartitionsToTxnRetryBackoffMaxMs;
    private final int addPartitionsToTxnRetryBackoffMs;

    public AddPartitionsToTxnConfig(AbstractConfig config) {
        this.addPartitionsToTxnRetryBackoffMaxMs = config.getInt(ADD_PARTITIONS_TO_TXN_RETRY_BACKOFF_MAX_MS_CONFIG);
        this.addPartitionsToTxnRetryBackoffMs = config.getInt(ADD_PARTITIONS_TO_TXN_RETRY_BACKOFF_MS_CONFIG);
    }

    public int addPartitionsToTxnRetryBackoffMaxMs() {
        return this.addPartitionsToTxnRetryBackoffMaxMs;
    }

    public int addPartitionsToTxnRetryBackoffMs() {
        return this.addPartitionsToTxnRetryBackoffMs;
    }
}

