/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import com.linkedin.kafka.cruisecontrol.ConfigFetchErrorHandler;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.common.BatchedConfigsFetcher;
import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import io.confluent.kafka.clients.CloudAdmin;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.BalancerOperationFailedException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Csv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCruiseControlUtils {
    public static final double MAX_BALANCEDNESS_SCORE = 100.0;
    public static final long KAFKA_ZK_CLIENT_CLOSE_TIMEOUT_MS = 10000L;
    public static final long ADMIN_CLIENT_CLOSE_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    public static final String DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss z";
    public static final String DATE_FORMAT2 = "dd/MM/yyyy HH:mm:ss";
    public static final String TIME_ZONE = "UTC";
    public static final int SEC_TO_MS = 1000;
    public static final int BYTES_IN_MIB = 0x100000;
    public static final double MIB_IN_GB = 953.674;
    private static final int MIN_TO_MS = 60000;
    private static final int HOUR_TO_MS = 3600000;
    private static final int DAY_TO_MS = 86400000;
    public static final long RETRY_BACKOFF_MS_CONFIG = 500L;
    public static final long RECONNECT_BACKOFF_MS_CONFIG = 500L;
    public static final long RECONNECT_BACKOFF_MAX_MS_CONFIG = 5000L;
    private static final String NONE_TIMESTRING_PLACEHOLDER = "<none>";
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCruiseControlUtils.class);

    private KafkaCruiseControlUtils() {
    }

    public static double gigabytesToMebibytes(double gb) {
        return gb * 953.674;
    }

    public static String currentUtcDate() {
        return KafkaCruiseControlUtils.utcDateFor(System.currentTimeMillis());
    }

    public static String utcDateFor(long timeMs) {
        Date date = new Date(timeMs);
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        formatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
        return formatter.format(date);
    }

    public static String toDateString(long time) {
        return KafkaCruiseControlUtils.toDateString(time, DATE_FORMAT2, "");
    }

    public static String toDateString(long time, String dateFormat, String timeZone) {
        if (time < 0L) {
            throw new IllegalArgumentException(String.format("Attempt to convert negative time %d to date.", time));
        }
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        if (!timeZone.isEmpty()) {
            formatter.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        return formatter.format(new Date(time));
    }

    public static String toTimeString(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException(String.format("Attempt to convert negative time %d to date.", time));
        }
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
        return formatter.format(Instant.ofEpochMilli(time));
    }

    public static String toTimeStringOrNonePlaceholder(long time) {
        if (time < 0L) {
            return NONE_TIMESTRING_PLACEHOLDER;
        }
        return KafkaCruiseControlUtils.toTimeString(time);
    }

    public static String convertEmptyToNull(String value) {
        if (value != null && value.isEmpty()) {
            return null;
        }
        return value;
    }

    public static String toPrettyDuration(double durationMs) {
        if (durationMs < 0.0) {
            throw new IllegalArgumentException(String.format("Duration cannot be negative value, get %f", durationMs));
        }
        if (durationMs < 1000.0) {
            return String.format("%.2f milliseconds", durationMs);
        }
        if (durationMs < 60000.0) {
            return String.format("%.2f seconds", durationMs / 1000.0);
        }
        if (durationMs < 3600000.0) {
            return String.format("%.2f minutes", durationMs / 60000.0);
        }
        if (durationMs < 8.64E7) {
            return String.format("%.2f hours", durationMs / 3600000.0);
        }
        return String.format("%.2f days", durationMs / 8.64E7);
    }

    public static String getRequiredConfig(Map<String, ?> configs, String configName) {
        String value = (String)configs.get(configName);
        if (value == null || value.isEmpty()) {
            throw new ConfigException(String.format("Configuration %s must be provided.", configName));
        }
        return value;
    }

    public static InputStream getRequiredInputStreamConfig(Map<String, ?> configs, String configName) {
        InputStream value = (InputStream)configs.get(configName);
        if (value == null) {
            throw new ConfigException(String.format("Configuration %s must be provided.", configName));
        }
        return value;
    }

    private static void closeClientWithTimeout(Runnable clientCloseTask, long timeoutMs) {
        Thread t = new Thread(clientCloseTask);
        t.setDaemon(true);
        t.start();
        try {
            t.join(timeoutMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t.isAlive()) {
            t.interrupt();
        }
    }

    public static boolean containsAny(Set<Integer> a, Set<Integer> b) {
        return b.stream().mapToInt(i -> i).anyMatch(a::contains);
    }

    public static CloudAdmin createAdmin(Map<String, ?> adminClientConfigs) {
        return CloudAdmin.create(KafkaCruiseControlUtils.filterAdminClientConfigs(adminClientConfigs));
    }

    public static void closeAdminClientWithTimeout(Admin adminClient) {
        KafkaCruiseControlUtils.closeAdminClientWithTimeout(adminClient, ADMIN_CLIENT_CLOSE_TIMEOUT_MS);
    }

    public static void closeAdminClientWithTimeout(Admin adminClient, long timeoutMs) {
        KafkaCruiseControlUtils.closeClientWithTimeout(() -> adminClient.close(Duration.ofMillis(timeoutMs)), timeoutMs);
    }

    public static Map<String, Object> filterAdminClientConfigs(Map<String, ?> configs) {
        HashMap<String, Object> adminClientConfig = new HashMap<String, Object>(configs);
        Set validAdminClientProps = AdminClientConfig.configNames();
        adminClientConfig.keySet().retainAll(validAdminClientProps);
        adminClientConfig.remove("metric.reporters");
        adminClientConfig.put("enable.metrics.push", false);
        adminClientConfig.put("retry.backoff.ms", 500L);
        adminClientConfig.put("reconnect.backoff.ms", 500L);
        adminClientConfig.put("reconnect.backoff.max.ms", 5000L);
        return adminClientConfig;
    }

    public static Map<String, Object> filterConsumerConfigs(Map<String, ?> configs) {
        HashMap<String, Object> consumerConfig = new HashMap<String, Object>(configs);
        Set validConsumerProps = ConsumerConfig.configNames();
        consumerConfig.keySet().retainAll(validConsumerProps);
        consumerConfig.put("enable.metrics.push", "false");
        consumerConfig.remove("metric.reporters");
        return consumerConfig;
    }

    public static Map<String, Object> filterProducerConfigs(Map<String, ?> configs) {
        HashMap<String, Object> producerConfig = new HashMap<String, Object>(configs);
        Set validProducerProps = ProducerConfig.configNames();
        producerConfig.keySet().retainAll(validProducerProps);
        producerConfig.put("enable.metrics.push", "false");
        producerConfig.remove("metric.reporters");
        return producerConfig;
    }

    public static boolean isPartitionUnderReplicated(Cluster cluster, TopicPartition tp) {
        PartitionInfo partitionInfo = cluster.partition(tp);
        return partitionInfo.inSyncReplicas().length != partitionInfo.replicas().length;
    }

    public static void sanityCheckNonExistingGoal(List<String> goals, Map<String, Goal> supportedGoals) {
        HashSet nonExistingGoals = new HashSet();
        goals.stream().filter(goalName -> supportedGoals.get(goalName) == null).forEach(nonExistingGoals::add);
        if (!nonExistingGoals.isEmpty()) {
            throw new IllegalArgumentException("Goals " + String.valueOf(nonExistingGoals) + " are not supported. Supported: " + String.valueOf(supportedGoals.keySet()));
        }
    }

    public static Map<String, Double> balancednessCostByGoal(List<Goal> goals, double priorityWeight, double strictnessWeight) {
        if (goals.isEmpty()) {
            throw new IllegalArgumentException("At least one goal must be provided to get the balancedness cost.");
        }
        if (priorityWeight <= 0.0 || strictnessWeight <= 0.0) {
            throw new IllegalArgumentException(String.format("Balancedness weights must be positive (priority:%f, strictness:%f).", priorityWeight, strictnessWeight));
        }
        HashMap<String, Double> balancednessCostByGoal = new HashMap<String, Double>(goals.size());
        double weightSum = 0.0;
        double previousGoalPriorityWeight = 1.0 / priorityWeight;
        for (int i = goals.size() - 1; i >= 0; --i) {
            Goal goal = goals.get(i);
            double currentGoalPriorityWeight = priorityWeight * previousGoalPriorityWeight;
            double cost = currentGoalPriorityWeight * (goal.isHardGoal() ? strictnessWeight : 1.0);
            weightSum += cost;
            balancednessCostByGoal.put(goal.name(), cost);
            previousGoalPriorityWeight = currentGoalPriorityWeight;
        }
        for (Map.Entry entry : balancednessCostByGoal.entrySet()) {
            entry.setValue(100.0 * (Double)entry.getValue() / weightSum);
        }
        return balancednessCostByGoal;
    }

    public static void backoff(Supplier<Boolean> f, int maxRetries, long initialWaitMs, long maxWaitMs, Time time) throws TimeoutException {
        long waitMsBound = maxWaitMs > 0L ? maxWaitMs : Integer.MAX_VALUE;
        long currentWaitMs = initialWaitMs;
        if (f.get().booleanValue()) {
            return;
        }
        for (int currentRetry = 1; currentRetry < maxRetries; ++currentRetry) {
            time.sleep(currentWaitMs);
            currentWaitMs = Math.min(2L * currentWaitMs, waitMsBound);
            if (!f.get().booleanValue()) continue;
            return;
        }
        throw new TimeoutException(String.format("Exceeded max retry count (%d)", maxRetries));
    }

    public static void preventExecutionWithDeadBroker(String uuid, Set<Integer> brokersWithOfflineReplicas, boolean failureDetectorIsEnabled) {
        if (!failureDetectorIsEnabled) {
            LOG.warn("Skipping the execution of proposals for operation id: {} as there are failed brokers in the cluster: {}}. If you still wish to balance the cluster, please run the broker removal command first.", (Object)uuid, brokersWithOfflineReplicas);
            throw new BalancerOperationFailedException(String.format("Skipping the execution of proposals as there are failed brokers in the cluster: %s. If you still wish to balance the cluster, please run the broker removal command first.", brokersWithOfflineReplicas));
        }
        LOG.warn("Skipping the execution of proposals for operation id: {} as there is an ongoing fix for failed brokers in the cluster: {}}. Please try later.", (Object)uuid, brokersWithOfflineReplicas);
        throw new BalancerOperationFailedException(String.format("Skipping the execution of proposals as there is an ongoing fix for failed brokers in the cluster: %s. Please try later.", brokersWithOfflineReplicas));
    }

    public static <T> void executeSilently(T resource, MaybeThrowingConsumer<T> action) {
        KafkaCruiseControlUtils.executeSilently(resource, action, () -> "Unable to release resource.");
    }

    public static <T> void executeSilently(T entity, MaybeThrowingConsumer<T> action, Supplier<String> errorMessageSupplier) {
        try {
            Optional.ofNullable(entity).ifPresent(action);
        }
        catch (Exception ex) {
            LOG.error(errorMessageSupplier.get(), (Throwable)ex);
        }
    }

    public static void closeSilently(AutoCloseable resource) {
        KafkaCruiseControlUtils.executeSilently(resource, AutoCloseable::close);
    }

    public static MaybeThrowingConsumer<ExecutorService> getExecutorShutdownConsumerWithTimeout(long shutdownTimeout) {
        return es -> {
            es.shutdown();
            es.awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS);
            if (!es.isTerminated()) {
                LOG.warn("Executor service failed to shutdown in " + shutdownTimeout + " ms.");
            }
        };
    }

    public static MaybeThrowingConsumer<ExecutorService> getExecutorShutdownNowConsumerWithTimeout(long shutdownTimeout) {
        return es -> {
            es.shutdownNow();
            es.awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS);
            if (!es.isTerminated()) {
                LOG.warn("Executor service failed to shutdown in " + shutdownTimeout + " ms.");
            }
        };
    }

    public static Config getEntityConfigs(Admin adminClient, KafkaCruiseControlConfig config, ConfigResource.Type resourceType, Time time, String resourceName, ConfigFetchErrorHandler errorHandler) {
        ConfigResource configResource = new ConfigResource(resourceType, resourceName);
        BatchedConfigsFetcher batchedConfigsFetcher = BatchedConfigsFetcher.of(adminClient, config, resourceType, time).entities(Collections.singleton(resourceName)).includeSynonyms(true).errorHandler(errorHandler).build();
        try {
            return batchedConfigsFetcher.getConfigs().get(configResource);
        }
        catch (RuntimeException e) {
            throw SbkAdminUtils.handleAdminClientException(e);
        }
    }

    public static Map<ConfigResource, Config> getEntityConfigs(Admin adminClient, KafkaCruiseControlConfig config, ConfigResource.Type resourceType, Time time, Collection<String> resourceNames, boolean ignoreUnknownTopicOrPartitionException) {
        BatchedConfigsFetcher batchedConfigsFetcher = BatchedConfigsFetcher.of(adminClient, config, resourceType, time).entities(resourceNames).includeSynonyms(true).ignoreUnknownTopicOrPartitionException(ignoreUnknownTopicOrPartitionException).build();
        try {
            return batchedConfigsFetcher.getConfigs();
        }
        catch (RuntimeException e) {
            throw SbkAdminUtils.handleAdminClientException(e);
        }
    }

    public static void setEntityConfigs(Admin adminClient, ConfigResource.Type resourceType, Collection<String> resourceNames, AlterConfigOp.OpType opType, Map<String, String> newConfigs, long timeoutMs) {
        Collection alterConfigOps = newConfigs.entrySet().stream().map(e -> new AlterConfigOp(new ConfigEntry((String)e.getKey(), (String)e.getValue()), opType)).collect(Collectors.toList());
        KafkaCruiseControlUtils.setEntityConfigs(adminClient, resourceType, resourceNames, alterConfigOps, timeoutMs);
    }

    public static void setEntityConfigs(Admin adminClient, ConfigResource.Type resourceType, Collection<String> resourceNames, Collection<AlterConfigOp> alterConfigOps, long timeoutMs) {
        try {
            Map<ConfigResource, Collection> configs = resourceNames.stream().collect(Collectors.toMap(resourceName -> new ConfigResource(resourceType, resourceName), __ -> alterConfigOps));
            adminClient.incrementalAlterConfigs(configs).all().get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            LOG.info("Timed out altering config for resource type {} and name {}. If this is a broker resource it may be down.", (Object)resourceType, resourceNames);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(e);
        }
    }

    public static Optional<ConfigEntry> getConfigEntry(Config config, String configName) {
        if (config != null) {
            ConfigEntry entry = config.get(configName);
            return Optional.ofNullable(entry);
        }
        return Optional.empty();
    }

    public static Map<String, String> parsePropAsMap(String propName, String propValue) {
        try {
            return Csv.parseCsvMap((String)propValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error parsing configuration property '%s': %s", propName, e.getMessage()));
        }
    }

    public static Collection<Integer> getAllBrokersInCluster(Admin adminClient) {
        try {
            Collection nodes = (Collection)adminClient.describeCluster().nodes().get();
            return nodes.stream().map(Node::id).collect(Collectors.toSet());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(e);
        }
    }

    public static Collection<String> getAllTopicsInCluster(Admin adminClient) {
        ListTopicsOptions options = new ListTopicsOptions().listInternal(true);
        try {
            return (Collection)adminClient.listTopics(options).names().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface MaybeThrowingConsumer<T>
    extends Consumer<T> {
        public void execute(T var1) throws Exception;

        @Override
        default public void accept(T resource) {
            try {
                this.execute(resource);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SbkAdminUtils.sneakyThrow(e);
            }
            catch (Exception e) {
                LOG.error("Unable to close resource {}", resource, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }
}

