/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopicGoal
extends AbstractGoal<String> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTopicGoal.class);

    @Override
    protected List<String> entitiesToRebalance(ClusterModel clusterModel, Set<String> excludedTopics) {
        return this.topicsToRebalance(clusterModel, excludedTopics);
    }

    @Override
    protected void rebalanceForEntity(String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        this.rebalanceForTopic(topic, clusterModel, optimizedGoals, optimizationOptions);
    }

    protected List<String> topicsToRebalance(ClusterModel clusterModel, Set<String> excludedTopics) {
        if (clusterModel.topics().isEmpty()) {
            LOG.warn("No topic present in cluster to rebalance.");
            return Collections.emptyList();
        }
        LOG.debug("Excluded topics from rebalance: {}", excludedTopics);
        List<String> topicsToRebalance = clusterModel.topics().stream().filter(topic -> !excludedTopics.contains(topic)).distinct().toList();
        if (topicsToRebalance.isEmpty()) {
            LOG.warn("All topics present in cluster model are excluded from {}.", (Object)this.name());
        }
        return topicsToRebalance.stream().filter(topic -> !this.shouldExcludeTopic((String)topic, clusterModel)).distinct().sorted(Comparator.comparingDouble(topic -> this.getTopicImbalanceScore((String)topic, clusterModel)).reversed()).collect(Collectors.toUnmodifiableList());
    }

    protected abstract double getTopicImbalanceScore(String var1, ClusterModel var2);

    protected boolean shouldExcludeTopic(String topic, ClusterModel clusterModel) {
        return false;
    }

    protected abstract void rebalanceForTopic(String var1, ClusterModel var2, Set<Goal> var3, OptimizationOptions var4) throws OptimizationFailureException;
}

