/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.TopicStats;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellTopicStats
implements TopicStats {
    private static final Logger LOG = LoggerFactory.getLogger(CellTopicStats.class);
    private final int cellId;
    private List<String> eligibleTopicsForRebalance;
    private Map<String, Double> eligibleTopicsForRebalanceInitialScores;
    private final Map<String, Double> averageLeadersPerBrokerForTopic;
    private final Map<String, Double> averageFollowersPerBrokerForTopic;
    Map<String, Integer> brokersPerRack;
    private Map<String, Integer> currentTopicLeadersPerRack;
    private final Map<String, Integer> expectedTopicLeadersLowerLimitPerRack;
    private final Map<String, Integer> expectedTopicLeadersUpperLimitPerRack;

    public CellTopicStats(int cellId) {
        this.cellId = cellId;
        this.averageLeadersPerBrokerForTopic = new HashMap<String, Double>();
        this.averageFollowersPerBrokerForTopic = new HashMap<String, Double>();
        this.eligibleTopicsForRebalance = new ArrayList<String>();
        this.eligibleTopicsForRebalanceInitialScores = new HashMap<String, Double>();
        this.brokersPerRack = new HashMap<String, Integer>();
        this.currentTopicLeadersPerRack = new HashMap<String, Integer>();
        this.expectedTopicLeadersLowerLimitPerRack = new HashMap<String, Integer>();
        this.expectedTopicLeadersUpperLimitPerRack = new HashMap<String, Integer>();
    }

    CellTopicStats(int cellId, List<String> eligibleTopicsForRebalance, Map<String, Double> eligibleTopicsForRebalanceInitialScores, Map<String, Double> averageLeadersPerBrokerForTopic, Map<String, Double> averageFollowersPerBrokerForTopic, Map<String, Integer> brokersPerRack, Map<String, Integer> currentTopicLeadersPerRack, Map<String, Integer> expectedTopicLeadersLowerLimitPerRack, Map<String, Integer> expectedTopicLeadersUpperLimitPerRack) {
        this.cellId = cellId;
        this.eligibleTopicsForRebalance = eligibleTopicsForRebalance;
        this.eligibleTopicsForRebalanceInitialScores = eligibleTopicsForRebalanceInitialScores;
        this.averageLeadersPerBrokerForTopic = averageLeadersPerBrokerForTopic;
        this.averageFollowersPerBrokerForTopic = averageFollowersPerBrokerForTopic;
        this.brokersPerRack = brokersPerRack;
        this.currentTopicLeadersPerRack = currentTopicLeadersPerRack;
        this.expectedTopicLeadersLowerLimitPerRack = expectedTopicLeadersLowerLimitPerRack;
        this.expectedTopicLeadersUpperLimitPerRack = expectedTopicLeadersUpperLimitPerRack;
    }

    @Override
    public double getAverageLeadersForBrokerForTopic(String topic, Broker broker, double defaultValue) {
        this.validateBrokerCell(broker, "Can't get average leaders per broker for a broker in a different cell");
        return this.averageLeadersPerBrokerForTopic.getOrDefault(topic, defaultValue);
    }

    @Override
    public void initializeAverageLeadersForBrokersForTopic(ClusterModel clusterModel, String topic) {
        int numEligibleDestinationBrokers = clusterModel.eligibleDestinationBrokers(this.cellId).size();
        int allLeadersForTopic = clusterModel.eligibleDestinationBrokers(this.cellId).stream().mapToInt(broker -> broker.leaderReplicasOfTopicInBroker(topic).size()).sum();
        double avgLeaderReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)allLeadersForTopic / (double)numEligibleDestinationBrokers : 0.0;
        LOG.debug("Average Leader replicas per broker for topic {}: {}", (Object)topic, (Object)avgLeaderReplicasPerBrokerForTopic);
        this.averageLeadersPerBrokerForTopic.put(topic, avgLeaderReplicasPerBrokerForTopic);
    }

    @Override
    public double getAverageFollowersForBrokerForTopic(String topic, Broker broker, double defaultValue) {
        this.validateBrokerCell(broker, "Can't get average followers per broker for a broker in a different cell");
        return this.averageFollowersPerBrokerForTopic.getOrDefault(topic, defaultValue);
    }

    @Override
    public void initializeAverageFollowersForBrokersForTopic(ClusterModel clusterModel, String topic) {
        int numEligibleDestinationBrokers = clusterModel.eligibleDestinationBrokers(this.cellId).size();
        int allFollowersForTopic = clusterModel.eligibleDestinationBrokers(this.cellId).stream().mapToInt(broker -> broker.followerReplicasOfTopicInBroker(topic).size()).sum();
        double avgFollowerReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)allFollowersForTopic / (double)numEligibleDestinationBrokers : 0.0;
        LOG.debug("Average Follower replicas per broker for topic {}: {}", (Object)topic, (Object)avgFollowerReplicasPerBrokerForTopic);
        this.averageFollowersPerBrokerForTopic.put(topic, avgFollowerReplicasPerBrokerForTopic);
    }

    @Override
    public List<Integer> replicaDistributionForTopic(ClusterModel clusterModel, String topic, Boolean isLeader, Broker hostBroker) {
        this.validateBrokerCell(hostBroker, "Can't calculate replica distribution for a broker in a different cell");
        return clusterModel.replicaDistributionForTopic(topic, isLeader, this.cellId);
    }

    @Override
    public List<Integer> replicaDistributionAfterAction(ClusterModel clusterModel, ReplicaBalancingAction action, Boolean isLeader) {
        this.validateBrokerCell(clusterModel.broker(action.sourceBrokerId()), "Can't calculate replica distribution after action for a broker in a different cell");
        String topic = action.topic();
        int limitNumberOfBrokers = isLeader != false ? clusterModel.numLeaderReplicasForTopicOnEligibleDestinationBrokers(topic, this.cellId) : clusterModel.numFollowerReplicasForTopicOnEligibleDestinationBrokers(topic, this.cellId);
        return clusterModel.eligibleDestinationBrokers(this.cellId).stream().mapToInt(broker -> {
            int numOfReplica;
            int n = numOfReplica = isLeader != false ? broker.numLeaderReplicasOfTopicInBroker(topic) : broker.numFollowerReplicasOfTopicInBroker(topic);
            if (broker.id() == action.sourceBrokerId().intValue()) {
                return numOfReplica - 1;
            }
            if (broker.id() == action.destinationBrokerId().intValue()) {
                return numOfReplica + 1;
            }
            return numOfReplica;
        }).boxed().sorted(Comparator.reverseOrder()).limit(limitNumberOfBrokers).collect(Collectors.toList());
    }

    @Override
    public List<String> getEligibleTopicsForRebalance() {
        return this.eligibleTopicsForRebalance;
    }

    @Override
    public void setEligibleTopicsForRebalance(List<String> topics) {
        LOG.debug("Setting eligible topics for rebalance: {}", topics);
        this.eligibleTopicsForRebalance = topics;
    }

    @Override
    public Double getEligibleTopicsForRebalanceInitialScore(String topic) {
        return this.eligibleTopicsForRebalanceInitialScores.get(topic);
    }

    @Override
    public double getTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        return clusterModel.topicImbalanceScore(topic, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED, this.cellId);
    }

    @Override
    public double getTopicImbalanceScore(String topic, ClusterModel clusterModel, Broker broker) {
        this.validateBrokerCell(broker, "Can't get topic imbalance score for topic for host broker in a different cell");
        return clusterModel.topicImbalanceScore(topic, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED, this.cellId);
    }

    @Override
    public void logChangeInTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        LOG.debug("For topic: {}, for cell: {}, imbalance score changed from {} to {}", new Object[]{this.cellId, topic, this.getEligibleTopicsForRebalanceInitialScore(topic), this.getTopicImbalanceScore(topic, clusterModel)});
    }

    @Override
    public Set<Broker> getEligibleDestinationBrokers(ClusterModel clusterModel, Broker sourceBroker) {
        this.validateBrokerCell(sourceBroker, "Can't get eligible destination brokers for a broker in a different cell");
        return clusterModel.eligibleDestinationBrokers(this.cellId);
    }

    @Override
    public Set<Broker> getEligibleSourceBrokers(ClusterModel clusterModel, Broker destinationBroker) {
        this.validateBrokerCell(destinationBroker, "Can't get eligible source brokers for a broker in a different cell");
        return clusterModel.eligibleSourceBrokers(this.cellId);
    }

    @Override
    public boolean hasMoreTopicLeadersForRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) > this.expectedTopicLeadersUpperLimitPerRack.get(rack) || Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersUpperLimitPerRack.get(rack)) && this.expectedTopicLeadersUpperLimitPerRack.get(rack) > this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean hasLessTopicLeadersForRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean canAccommodateMoreTopicLeadersForRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersUpperLimitPerRack.get(rack);
    }

    @Override
    public boolean canAccommodateMoreTopicLeadersForRack(String rack, Broker broker) {
        this.validateBrokerCell(broker, "Can't check if more topic leaders can be accommodated for a broker in a different cell");
        return this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersUpperLimitPerRack.get(rack);
    }

    @Override
    public int numTopicLeadersThatCanBeMovedToRack(String rack) {
        return this.expectedTopicLeadersUpperLimitPerRack.get(rack) - this.currentTopicLeadersPerRack.get(rack);
    }

    @Override
    public boolean metRackTopicLeadersUpperBound(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersUpperLimitPerRack.get(rack) || Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersUpperLimitPerRack.get(rack)) && Objects.equals(this.expectedTopicLeadersUpperLimitPerRack.get(rack), this.expectedTopicLeadersLowerLimitPerRack.get(rack));
    }

    @Override
    public boolean canReleaseMoreTopicLeadersForRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) > this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean canReleaseMoreTopicLeadersForRack(String rack, Broker broker) {
        this.validateBrokerCell(broker, "Can't check if more topic leaders can be released for a broker in a different cell");
        return this.currentTopicLeadersPerRack.get(rack) > this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public int numTopicLeadersThatCanBeMovedFromRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) - this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean metRackTopicLeadersLowerBound(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) >= this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean isCurrentTopicLeadersCountAtUpperBoundForRack(String rack, Broker broker) {
        this.validateBrokerCell(broker, "Can't check topic leaders count upper bound for a broker in a different cell");
        return Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersUpperLimitPerRack.get(rack));
    }

    @Override
    public boolean isCurrentTopicLeadersCountAtLowerBoundForRack(String rack, Broker broker) {
        this.validateBrokerCell(broker, "Can't check topic leaders count lower bound for a broker in a different cell");
        return Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersLowerLimitPerRack.get(rack));
    }

    @Override
    public void incrementCurrentTopicLeadersPerRack(String rack, Broker broker, Integer count) {
        this.validateBrokerCell(broker, "Can't increment current topic leaders per rack for a broker in a different cell");
        this.currentTopicLeadersPerRack.put(rack, this.currentTopicLeadersPerRack.get(rack) + count);
    }

    @Override
    public void decrementCurrentTopicLeadersPerRack(String rack, Broker broker, Integer count) {
        this.validateBrokerCell(broker, "Can't decrement current topic leaders per rack for a broker in a different cell");
        this.currentTopicLeadersPerRack.put(rack, this.currentTopicLeadersPerRack.get(rack) - count);
    }

    @Override
    public void initializeRackRelatedTopicLeaderDistribution(ClusterModel clusterModel, String topic) {
        this.currentTopicLeadersPerRack.clear();
        this.expectedTopicLeadersLowerLimitPerRack.clear();
        this.expectedTopicLeadersUpperLimitPerRack.clear();
        this.currentTopicLeadersPerRack = clusterModel.aliveRackIds().stream().collect(Collectors.toMap(rack -> rack, rack -> 0));
        int leadersForTopicOnEligibleBrokers = (int)clusterModel.eligibleDestinationBrokers(this.cellId).stream().mapToLong(broker -> broker.leaderReplicasOfTopicInBroker(topic).size()).sum();
        int eligibleBrokersCount = clusterModel.eligibleDestinationBrokers(this.cellId).size();
        for (Broker broker2 : clusterModel.eligibleDestinationBrokers(this.cellId)) {
            int replicaCount = broker2.numLeaderReplicasOfTopicInBroker(topic);
            this.currentTopicLeadersPerRack.compute(broker2.rack().id(), (k, v) -> v == null ? replicaCount : v + replicaCount);
        }
        for (String rack2 : clusterModel.aliveRackIds()) {
            int numBrokersInRack = this.brokersPerRack.get(rack2);
            double avgLeaderReplicasForRack = (double)(numBrokersInRack * leadersForTopicOnEligibleBrokers) / (double)eligibleBrokersCount;
            this.expectedTopicLeadersLowerLimitPerRack.put(rack2, (int)Math.floor(avgLeaderReplicasForRack));
            this.expectedTopicLeadersUpperLimitPerRack.put(rack2, (int)Math.ceil(avgLeaderReplicasForRack));
        }
        LOG.debug("For cell {}, Leaders per rack for topic {}: {}, expected lower limit per rack: {}, expected upper limit per rack: {}", new Object[]{this.cellId, topic, this.currentTopicLeadersPerRack, this.expectedTopicLeadersLowerLimitPerRack, this.expectedTopicLeadersUpperLimitPerRack});
    }

    @Override
    public void initializeBrokersCountPerRack(ClusterModel clusterModel) {
        this.brokersPerRack = clusterModel.aliveRackIds().stream().collect(Collectors.toMap(rack -> rack, rack -> 0));
        clusterModel.eligibleDestinationBrokers(this.cellId).forEach(broker -> this.brokersPerRack.compute(broker.rack().id(), (k, v) -> v + 1));
    }

    @Override
    public void initializeTopicsToRebalanceInitialScores(ClusterModel clusterModel, TopicImbalanceScoreType scoreType) {
        this.eligibleTopicsForRebalanceInitialScores = this.eligibleTopicsForRebalance.stream().distinct().collect(Collectors.toMap(topic -> topic, topic -> clusterModel.topicImbalanceScore((String)topic, scoreType, this.cellId)));
    }

    private void validateBrokerCell(Broker broker, String errorMsg) {
        if (broker.cell().id() != this.cellId) {
            throw new IllegalArgumentException(errorMsg);
        }
    }
}

