/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.CellTopicStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.TopicStats;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CellsTopicStats
implements TopicStats {
    private final Map<Integer, CellTopicStats> cellTopicStatsMap;
    private List<String> eligibleTopicsForRebalance;
    private Map<String, Double> eligibleTopicsForRebalanceInitialScores;

    public CellsTopicStats(ClusterModel clusterModel) {
        this.cellTopicStatsMap = clusterModel.cells().stream().map(Cell::id).collect(Collectors.toMap(cell -> cell, CellTopicStats::new));
        this.eligibleTopicsForRebalance = new ArrayList<String>();
        this.eligibleTopicsForRebalanceInitialScores = new HashMap<String, Double>();
    }

    CellsTopicStats(Map<Integer, CellTopicStats> cellTopicStatsMap, List<String> eligibleTopicsForRebalance, Map<String, Double> eligibleTopicsForRebalanceInitialScores) {
        this.cellTopicStatsMap = cellTopicStatsMap;
        this.eligibleTopicsForRebalance = eligibleTopicsForRebalance;
        this.eligibleTopicsForRebalanceInitialScores = eligibleTopicsForRebalanceInitialScores;
    }

    @Override
    public double getAverageLeadersForBrokerForTopic(String topic, Broker broker, double defaultValue) {
        return this.cellTopicStatsMap.get(broker.cell().id()).getAverageLeadersForBrokerForTopic(topic, broker, defaultValue);
    }

    @Override
    public void initializeAverageLeadersForBrokersForTopic(ClusterModel clusterModel, String topic) {
        for (CellTopicStats cellTopicStats : this.cellTopicStatsMap.values()) {
            cellTopicStats.initializeAverageLeadersForBrokersForTopic(clusterModel, topic);
        }
    }

    @Override
    public double getAverageFollowersForBrokerForTopic(String topic, Broker broker, double defaultValue) {
        return this.cellTopicStatsMap.get(broker.cell().id()).getAverageFollowersForBrokerForTopic(topic, broker, defaultValue);
    }

    @Override
    public void initializeAverageFollowersForBrokersForTopic(ClusterModel clusterModel, String topic) {
        for (CellTopicStats cellTopicStats : this.cellTopicStatsMap.values()) {
            cellTopicStats.initializeAverageFollowersForBrokersForTopic(clusterModel, topic);
        }
    }

    @Override
    public List<Integer> replicaDistributionForTopic(ClusterModel clusterModel, String topic, Boolean isLeader, Broker hostBroker) {
        return this.cellTopicStatsMap.get(hostBroker.cell().id()).replicaDistributionForTopic(clusterModel, topic, isLeader, hostBroker);
    }

    @Override
    public List<Integer> replicaDistributionAfterAction(ClusterModel clusterModel, ReplicaBalancingAction action, Boolean isLeader) {
        int brokerCellId = clusterModel.broker(action.sourceBrokerId()).cell().id();
        return this.cellTopicStatsMap.get(brokerCellId).replicaDistributionAfterAction(clusterModel, action, isLeader);
    }

    @Override
    public List<String> getEligibleTopicsForRebalance() {
        return this.eligibleTopicsForRebalance;
    }

    @Override
    public void setEligibleTopicsForRebalance(List<String> topics) {
        this.eligibleTopicsForRebalance = topics;
        for (CellTopicStats cellTopicStats : this.cellTopicStatsMap.values()) {
            cellTopicStats.setEligibleTopicsForRebalance(topics);
        }
    }

    @Override
    public Double getEligibleTopicsForRebalanceInitialScore(String topic) {
        return this.eligibleTopicsForRebalanceInitialScores.get(topic);
    }

    @Override
    public double getTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        return clusterModel.topicImbalanceScore(topic, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED);
    }

    @Override
    public double getTopicImbalanceScore(String topic, ClusterModel clusterModel, Broker broker) {
        return this.cellTopicStatsMap.get(broker.cell().id()).getTopicImbalanceScore(topic, clusterModel, broker);
    }

    @Override
    public void logChangeInTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        for (CellTopicStats cellTopicStats : this.cellTopicStatsMap.values()) {
            cellTopicStats.logChangeInTopicImbalanceScore(topic, clusterModel);
        }
    }

    @Override
    public Set<Broker> getEligibleDestinationBrokers(ClusterModel clusterModel, Broker sourceBroker) {
        return this.cellTopicStatsMap.get(sourceBroker.cell().id()).getEligibleDestinationBrokers(clusterModel, sourceBroker);
    }

    @Override
    public Set<Broker> getEligibleSourceBrokers(ClusterModel clusterModel, Broker destinationBroker) {
        return this.cellTopicStatsMap.get(destinationBroker.cell().id()).getEligibleSourceBrokers(clusterModel, destinationBroker);
    }

    @Override
    public void incrementCurrentTopicLeadersPerRack(String rack, Broker broker, Integer count) {
        this.cellTopicStatsMap.get(broker.cell().id()).incrementCurrentTopicLeadersPerRack(rack, broker, count);
    }

    @Override
    public void decrementCurrentTopicLeadersPerRack(String rack, Broker broker, Integer count) {
        this.cellTopicStatsMap.get(broker.cell().id()).decrementCurrentTopicLeadersPerRack(rack, broker, count);
    }

    @Override
    public boolean hasMoreTopicLeadersForRack(String rack) {
        return this.cellTopicStatsMap.values().stream().anyMatch(cellTopicStats -> cellTopicStats.hasMoreTopicLeadersForRack(rack));
    }

    @Override
    public boolean hasLessTopicLeadersForRack(String rack) {
        return this.cellTopicStatsMap.values().stream().anyMatch(cellTopicStats -> cellTopicStats.hasLessTopicLeadersForRack(rack));
    }

    @Override
    public boolean canAccommodateMoreTopicLeadersForRack(String rack) {
        return this.cellTopicStatsMap.values().stream().anyMatch(cellTopicStats -> cellTopicStats.canAccommodateMoreTopicLeadersForRack(rack));
    }

    @Override
    public boolean canAccommodateMoreTopicLeadersForRack(String rack, Broker broker) {
        return this.cellTopicStatsMap.get(broker.cell().id()).canAccommodateMoreTopicLeadersForRack(rack);
    }

    @Override
    public int numTopicLeadersThatCanBeMovedToRack(String rack) {
        return this.cellTopicStatsMap.values().stream().mapToInt(cellTopicStats -> cellTopicStats.numTopicLeadersThatCanBeMovedToRack(rack)).filter(value -> value > 0).sum();
    }

    @Override
    public boolean metRackTopicLeadersUpperBound(String rack) {
        return this.cellTopicStatsMap.values().stream().allMatch(cellTopicStats -> cellTopicStats.metRackTopicLeadersUpperBound(rack));
    }

    @Override
    public boolean canReleaseMoreTopicLeadersForRack(String rack) {
        return this.cellTopicStatsMap.values().stream().anyMatch(cellTopicStats -> cellTopicStats.canReleaseMoreTopicLeadersForRack(rack));
    }

    @Override
    public boolean canReleaseMoreTopicLeadersForRack(String rack, Broker broker) {
        return this.cellTopicStatsMap.get(broker.cell().id()).canReleaseMoreTopicLeadersForRack(rack);
    }

    @Override
    public int numTopicLeadersThatCanBeMovedFromRack(String rack) {
        return this.cellTopicStatsMap.values().stream().mapToInt(cellTopicStats -> cellTopicStats.numTopicLeadersThatCanBeMovedFromRack(rack)).filter(value -> value > 0).sum();
    }

    @Override
    public boolean metRackTopicLeadersLowerBound(String rack) {
        return this.cellTopicStatsMap.values().stream().allMatch(cellTopicStats -> cellTopicStats.metRackTopicLeadersLowerBound(rack));
    }

    @Override
    public boolean isCurrentTopicLeadersCountAtUpperBoundForRack(String rack, Broker broker) {
        return this.cellTopicStatsMap.get(broker.cell().id()).isCurrentTopicLeadersCountAtUpperBoundForRack(rack, broker);
    }

    @Override
    public boolean isCurrentTopicLeadersCountAtLowerBoundForRack(String rack, Broker broker) {
        return this.cellTopicStatsMap.get(broker.cell().id()).isCurrentTopicLeadersCountAtLowerBoundForRack(rack, broker);
    }

    @Override
    public void initializeRackRelatedTopicLeaderDistribution(ClusterModel clusterModel, String topic) {
        for (CellTopicStats cellTopicStats : this.cellTopicStatsMap.values()) {
            cellTopicStats.initializeRackRelatedTopicLeaderDistribution(clusterModel, topic);
        }
    }

    @Override
    public void initializeBrokersCountPerRack(ClusterModel clusterModel) {
        for (CellTopicStats cellTopicStats : this.cellTopicStatsMap.values()) {
            cellTopicStats.initializeBrokersCountPerRack(clusterModel);
        }
    }

    @Override
    public void initializeTopicsToRebalanceInitialScores(ClusterModel clusterModel, TopicImbalanceScoreType scoreType) {
        this.eligibleTopicsForRebalanceInitialScores = this.eligibleTopicsForRebalance.stream().distinct().collect(Collectors.toMap(topic -> topic, topic -> clusterModel.topicImbalanceScore((String)topic, scoreType)));
        for (CellTopicStats cellTopicStats : this.cellTopicStatsMap.values()) {
            cellTopicStats.initializeTopicsToRebalanceInitialScores(clusterModel, scoreType);
        }
    }
}

