/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import com.linkedin.kafka.cruisecontrol.common.CircularBuffer;
import java.util.OptionalDouble;

public class NumberCircularBuffer<T extends Number> {
    private final CircularBuffer<T> buffer;

    public NumberCircularBuffer(int size) {
        this.buffer = new CircularBuffer(size);
    }

    public void add(T value) {
        this.buffer.add(value);
    }

    public OptionalDouble average() {
        return this.buffer.values().stream().mapToDouble(Number::doubleValue).average();
    }

    public int size() {
        return this.buffer.values().size();
    }

    public OptionalDouble recencyBiasedAverage() {
        if (this.buffer.values().isEmpty()) {
            return OptionalDouble.empty();
        }
        double alpha = 0.5;
        double weightedSum = 0.0;
        double weight = 1.0;
        double totalWeight = 0.0;
        for (int i = this.buffer.values().size() - 1; i >= 0; --i) {
            Number value = (Number)this.buffer.values().get(i);
            weightedSum += value.doubleValue() * weight;
            totalWeight += weight;
            weight *= 1.0 - alpha;
        }
        return OptionalDouble.of(weightedSum / totalWeight);
    }
}

