/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.utils;

import com.linkedin.kafka.cruisecontrol.detector.utils.CellOverloadOccurrence;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.record.CellOverloadOccurrenceDelta;
import io.confluent.databalancer.record.Cells;
import java.util.Collection;

public class CellOverloadOccurrenceRecorder {
    private final ApiStatePersistenceStore apiStatePersistenceStore;
    private static final int VERSION = 1;

    public CellOverloadOccurrenceRecorder(ApiStatePersistenceStore apiStatePersistenceStore) {
        this.apiStatePersistenceStore = apiStatePersistenceStore;
    }

    public CellOverloadOccurrence cellOverloadOccurrence() {
        return this.apiStatePersistenceStore.getCellOverloadOccurrence();
    }

    public void addOccurrence(int cellId) throws InterruptedException {
        CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto cellOverloadOccurrenceDelta = CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto.newBuilder().setVersion(1).setTimestamp(System.currentTimeMillis()).setOp(CellOverloadOccurrenceDelta.Operation.record_once).setCellId(cellId).build();
        this.apiStatePersistenceStore.save(cellOverloadOccurrenceDelta);
    }

    public void deleteOccurrence(int cellId) throws InterruptedException {
        CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto cellOverloadOccurrenceDelta = CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto.newBuilder().setVersion(1).setTimestamp(System.currentTimeMillis()).setOp(CellOverloadOccurrenceDelta.Operation.delete_once).setCellId(cellId).build();
        this.apiStatePersistenceStore.save(cellOverloadOccurrenceDelta);
    }

    public void clearOccurrence(int cellId) throws InterruptedException {
        CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto cellOverloadOccurrenceDelta = CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto.newBuilder().setVersion(1).setTimestamp(System.currentTimeMillis()).setOp(CellOverloadOccurrenceDelta.Operation.clear).setCellId(cellId).build();
        this.apiStatePersistenceStore.save(cellOverloadOccurrenceDelta);
    }

    public void persistManagedCellIds(Collection<Integer> cellIds) throws InterruptedException {
        Cells.CellsProto cells = Cells.CellsProto.newBuilder().setVersion(1).setTimestamp(System.currentTimeMillis()).addAllCellId(cellIds).build();
        this.apiStatePersistenceStore.save(cells);
    }
}

