/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.executor.AbstractExecutorReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskManager;
import com.linkedin.kafka.cruisecontrol.executor.Executor;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.executor.ReplicationThrottleHelper;
import com.linkedin.kafka.cruisecontrol.model.ReplicaId;
import com.linkedin.kafka.cruisecontrol.monitor.SamplerStateHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;

@NotThreadSafe
public class ExecutorInterBrokerReplicaMovement
extends AbstractExecutorReplicaMovement {
    private final Set<Integer> removedBrokers;
    private final SamplerStateHandle samplerStateHandle;
    private final long retryWaitMs;
    private final Time time;
    private final Cluster cluster;
    private final int numTotalPartitionMovements;
    private final long totalDataToMoveInMB;
    private final boolean isV2ExecutorEnabled;
    private final long sleepIntervalMs = 100L;

    public ExecutorInterBrokerReplicaMovement(String executionUuid, ExecutionTaskManager executionTaskManager, Set<Integer> recentlyRemovedBrokers, ReplicationThrottleHelper throttleHelper, ConfluentAdmin adminClient, SbkAdminUtils adminUtils, AtomicBoolean stopRequested, Set<Integer> removedBrokers, SamplerStateHandle samplerStateHandle, Cluster cluster, Time time, long retryWaitMs, boolean isV2ExecutorEnabled) {
        super(executionUuid, executionTaskManager, recentlyRemovedBrokers, throttleHelper, adminClient, adminUtils, stopRequested);
        this.cluster = cluster;
        this.time = time;
        this.retryWaitMs = retryWaitMs;
        this.samplerStateHandle = samplerStateHandle;
        this.removedBrokers = removedBrokers;
        this.numTotalPartitionMovements = this.executionTaskManager.numPendingInterBrokerPartitionMovements();
        this.totalDataToMoveInMB = this.executionTaskManager.remainingInterBrokerDataToMoveInMB();
        this.isV2ExecutorEnabled = isV2ExecutorEnabled;
    }

    @Override
    ExecutorState.State state() {
        return ExecutorState.State.INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS;
    }

    @Override
    ExecutorState executorState() {
        return ExecutorState.operationInProgress(this.state(), this.executionTaskManager.getExecutionTasksSummary(Collections.singleton(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)), this.executionTaskManager.interBrokerPartitionMovementConcurrency(), this.executionTaskManager.leadershipMovementConcurrency(), this.uuid, this.recentlyRemovedBrokers);
    }

    @Override
    ExecutionTask.TaskType taskType() {
        return ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Executor.ExecutionTaskWaiter taskWaiter) throws InterruptedException {
        LOG.info("Starting {} inter-broker partition movements.", (Object)this.numTotalPartitionMovements);
        List<ExecutionTask> tasksToRetry = this.doMove(this.numTotalPartitionMovements, taskWaiter, true);
        this.maybeRetryTasks(tasksToRetry, taskWaiter);
        Set<ExecutionTask> inExecutionTasks = this.executionTaskManager.inExecutionTasks();
        while (!inExecutionTasks.isEmpty()) {
            LOG.info("Waiting for {} tasks moving {} MB to finish.", (Object)inExecutionTasks.size(), (Object)this.executionTaskManager.inExecutionInterBrokerDataToMoveInMB());
            List<ExecutionTask> completedRemainingTasks = taskWaiter.waitForAnyTaskToFinish(this);
            inExecutionTasks = this.executionTaskManager.inExecutionTasks();
            ReplicationThrottleHelper replicationThrottleHelper = this.throttleHelper;
            synchronized (replicationThrottleHelper) {
                this.throttleHelper.clearThrottles(completedRemainingTasks, new ArrayList<ExecutionTask>(inExecutionTasks), this.removedBrokers);
            }
        }
    }

    private void maybeRetryTasks(List<ExecutionTask> tasksToRetry, Executor.ExecutionTaskWaiter taskWaiter) throws InterruptedException {
        if (tasksToRetry.isEmpty()) {
            LOG.debug("No inter-broker partition movement tasks to retry.");
            return;
        }
        int remainingNumberOfMovements = this.executionTaskManager.numInterBrokerPartitionMovementsToBeRetried();
        if (this.stopRequested.get()) {
            LOG.info("Skipping retry of {} tasks because replica reassignment was interrupted", (Object)remainingNumberOfMovements);
            return;
        }
        LOG.info("Will be retrying {} failed tasks in {} ms", (Object)remainingNumberOfMovements, (Object)this.retryWaitMs);
        boolean stopRequested = this.sleepFor(this.retryWaitMs);
        if (stopRequested) {
            LOG.info("Skipping retry of {} tasks because replica reassignment was interrupted", (Object)remainingNumberOfMovements);
            return;
        }
        this.executionTaskManager.reloadInterBrokerTasksToBeRetried(this.cluster);
        LOG.info("Retrying {} tasks", (Object)this.executionTaskManager.numPendingInterBrokerPartitionMovements());
        this.doMove(remainingNumberOfMovements, taskWaiter, false);
    }

    private boolean sleepFor(long timeoutMs) {
        long now = this.time.hiResClockMs();
        long cutOff = now + timeoutMs;
        while (this.time.hiResClockMs() < cutOff) {
            if (this.stopRequested.get()) {
                return true;
            }
            this.time.sleep(100L);
        }
        return this.stopRequested.get();
    }

    private List<ExecutionTask> doMove(int remainingPartitionsToMove, Executor.ExecutionTaskWaiter taskWaiter, boolean toHandleRetries) throws InterruptedException {
        boolean hasTasksLeft;
        ArrayList<ExecutionTask> tasksToBeRetried = new ArrayList<ExecutionTask>();
        boolean bl = hasTasksLeft = remainingPartitionsToMove > 0 || this.executionTaskManager.inExecutionTasks().size() > 0;
        while (hasTasksLeft) {
            if (this.stopRequested.get()) {
                LOG.info("Stopping inter-broker replica reassignment because it was interrupted.");
                break;
            }
            List<ExecutionTask> toRetry = this.executeBatch(toHandleRetries);
            tasksToBeRetried.addAll(toRetry);
            List<ExecutionTask> completedTasks = taskWaiter.waitForAnyTaskToFinish(this);
            this.logProgress(completedTasks);
            remainingPartitionsToMove = this.executionTaskManager.numPendingInterBrokerPartitionMovements();
            Set<ExecutionTask> inProgressTasks = this.executionTaskManager.inExecutionTasks();
            ArrayList<ExecutionTask> tasksToClearThrottles = new ArrayList<ExecutionTask>(completedTasks);
            tasksToClearThrottles.addAll(toRetry);
            this.clearThrottles(tasksToClearThrottles, inProgressTasks);
            hasTasksLeft = remainingPartitionsToMove > 0 || inProgressTasks.size() > 0;
        }
        return tasksToBeRetried;
    }

    private List<ExecutionTask> executeBatch(boolean toHandleRetries) throws InterruptedException {
        List<ExecutionTask> tasksToExecute = this.executionTaskManager.drainInterBrokerReplicaMovementTasks();
        if (tasksToExecute.isEmpty()) {
            LOG.info("There were no eligible tasks to execute. In execution tasks: {},", this.executionTaskManager.inExecutionTasks().stream().map(ExecutionTask::executionId).collect(Collectors.toList()));
            return Collections.emptyList();
        }
        LOG.info("Executor will execute {} task(s): {} as part of operation {}", new Object[]{tasksToExecute.size(), tasksToExecute, this.uuid});
        this.setThrottles(tasksToExecute);
        this.executionTaskManager.markTasksInProgress(tasksToExecute);
        List<ExecutionTask> tasksToBeRetried = this.executeReplicaReassignmentTasks(tasksToExecute, toHandleRetries);
        if (!tasksToBeRetried.isEmpty()) {
            this.executionTaskManager.markTasksToBeRetried(tasksToBeRetried);
            LOG.info("{} tasks failed with a retriable error. Saving them for later (tasks: {})", (Object)tasksToBeRetried.size(), tasksToBeRetried);
        }
        return tasksToBeRetried;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThrottles(List<ExecutionTask> tasks) throws InterruptedException {
        ReplicationThrottleHelper replicationThrottleHelper = this.throttleHelper;
        synchronized (replicationThrottleHelper) {
            List<PartitionProposal> proposals = tasks.stream().map(ExecutionTask::partitionProposal).collect(Collectors.toList());
            this.throttleHelper.setThrottles(proposals, this.samplerStateHandle, this.removedBrokers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearThrottles(List<ExecutionTask> completedTasks, Set<ExecutionTask> inProgressTasks) {
        ReplicationThrottleHelper replicationThrottleHelper = this.throttleHelper;
        synchronized (replicationThrottleHelper) {
            this.throttleHelper.clearThrottles(completedTasks, new ArrayList<ExecutionTask>(inProgressTasks), this.removedBrokers);
        }
    }

    List<ExecutionTask> executeReplicaReassignmentTasks(List<ExecutionTask> reassignmentTasks, boolean handleRetries) throws InterruptedException {
        if (reassignmentTasks == null || reassignmentTasks.isEmpty()) {
            return Collections.emptyList();
        }
        Map<TopicPartition, ExecutionTask> executionTaskByPartition = reassignmentTasks.stream().collect(Collectors.toMap(task -> task.partitionProposal().topicPartition(), task -> task));
        NewReplicaAssignments result = this.determineReassignmentReplicas(executionTaskByPartition, handleRetries);
        if (result.newReplicaAssignments.isEmpty()) {
            return result.tasksToRetry;
        }
        ArrayList<ExecutionTask> tasksToRetry = new ArrayList<ExecutionTask>(result.tasksToRetry);
        List<ExecutionTask> reassignmentTasksToRetry = this.alterPartitionReassignments(executionTaskByPartition, result.newReplicaAssignments, handleRetries);
        tasksToRetry.addAll(reassignmentTasksToRetry);
        return tasksToRetry;
    }

    private NewReplicaAssignments determineReassignmentReplicas(Map<TopicPartition, ExecutionTask> executionTaskByPartition, boolean handleRetries) throws InterruptedException {
        Set<TopicPartition> partitionsToReassign = executionTaskByPartition.keySet();
        Map<TopicPartition, Executor.PartitionReplicas> inProgressTargetReplicaReassignment = this.adminUtils.listTargetReplicasBeingReassigned(Optional.of(partitionsToReassign));
        Map<TopicPartition, SbkAdminUtils.ReplicaDescription> partitionReplicaAssignments = this.adminUtils.getReplicasForPartitions(partitionsToReassign);
        HashMap<TopicPartition, Optional<NewPartitionReassignment>> newReplicaAssignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
        ArrayList<ExecutionTask> tasksToRetry = new ArrayList<ExecutionTask>();
        for (ExecutionTask task : executionTaskByPartition.values()) {
            Optional<Executor.PartitionReplicas> targetReplicas;
            TopicPartition tp = task.partitionProposal().topicPartition();
            SbkAdminUtils.ReplicaDescription replicaDescription = Objects.requireNonNull(partitionReplicaAssignments.get(tp));
            if (replicaDescription.isFailed()) {
                Throwable throwable = replicaDescription.throwableOpt.get();
                if (handleRetries) {
                    LOG.warn("Describing topic partition {} failed due to {}. Will retry it later.", (Object)tp, (Object)throwable);
                    tasksToRetry.add(task);
                    continue;
                }
                if (throwable instanceof UnknownTopicOrPartitionException) {
                    LOG.info("Topic partition {} could not be found. It is possible that the topic was deleted while the reassignment execution was taking place. Ignoring this exception...", (Object)tp);
                    continue;
                }
                SbkAdminUtils.sneakyThrow(throwable);
            }
            if ((targetReplicas = this.replicasToWrite(task, replicaDescription.replicaSet, Optional.ofNullable(inProgressTargetReplicaReassignment.get(tp)))).isPresent()) {
                NewPartitionReassignment reassignment = NewPartitionReassignment.ofReplicasAndObservers(targetReplicas.get().replicas(), targetReplicas.get().observers());
                newReplicaAssignments.put(tp, Optional.of(reassignment));
                continue;
            }
            LOG.warn("We couldn't find a good partition placement based on the data we received we received from the latest Admin API calls. TopicPartition: {}", (Object)tp);
        }
        return new NewReplicaAssignments(newReplicaAssignments, tasksToRetry);
    }

    private List<ExecutionTask> alterPartitionReassignments(Map<TopicPartition, ExecutionTask> executionTaskByPartition, Map<TopicPartition, Optional<NewPartitionReassignment>> newReplicaAssignments, boolean handleRetries) {
        AlterPartitionReassignmentsResult alterResult = this.adminClient.alterPartitionReassignments(newReplicaAssignments);
        try {
            alterResult.all().get();
        }
        catch (Throwable t) {
            if (handleRetries && this.isInvalidReplicaAssignmentException(t)) {
                return this.filterInvalidReplicaAssignments(alterResult).stream().map(executionTaskByPartition::get).collect(Collectors.toList());
            }
            SbkAdminUtils.sneakyThrow(t);
        }
        return Collections.emptyList();
    }

    private List<TopicPartition> filterInvalidReplicaAssignments(AlterPartitionReassignmentsResult alterPartitionReassignmentsResult) {
        ArrayList<TopicPartition> faultyPartitions = new ArrayList<TopicPartition>();
        for (Map.Entry entry : alterPartitionReassignmentsResult.values().entrySet()) {
            try {
                ((KafkaFuture)entry.getValue()).get();
            }
            catch (Throwable t) {
                if (this.isInvalidReplicaAssignmentException(t)) {
                    faultyPartitions.add((TopicPartition)entry.getKey());
                    continue;
                }
                SbkAdminUtils.sneakyThrow(t);
            }
        }
        return faultyPartitions;
    }

    private boolean isInvalidReplicaAssignmentException(Throwable t) {
        return t instanceof ExecutionException && t.getCause() != null && t.getCause() instanceof InvalidReplicaAssignmentException;
    }

    private Optional<Executor.PartitionReplicas> replicasToWrite(ExecutionTask task, List<Integer> currentReplicaAssignment, Optional<Executor.PartitionReplicas> inProgressTargetReplicasOpt) {
        if (task.state() != ExecutionTask.State.IN_PROGRESS) {
            LOG.warn("The inter-broker movement is trying to place a task which has already been scheduled. Task ID: {} Task state: {}", (Object)task.executionId(), (Object)task.state());
            return Optional.empty();
        }
        if (currentReplicaAssignment == null || currentReplicaAssignment.isEmpty()) {
            LOG.warn("Could not determine the replicas for partition {}. It is possible the topic or partition doesn't exist.", (Object)task.partitionProposal().topicPartition());
            return Optional.empty();
        }
        List<Integer> newReplicas = this.isV2ExecutorEnabled ? task.partitionProposal().proposedReplicas().stream().map(ReplicaId::brokerId).collect(Collectors.toList()) : task.partitionProposal().newReplicas().stream().map(ReplicaId::brokerId).collect(Collectors.toList());
        List<Integer> newObservers = task.partitionProposal().newObservers().stream().map(ReplicaId::brokerId).collect(Collectors.toList());
        newReplicas.addAll(newObservers);
        if (inProgressTargetReplicasOpt.isPresent()) {
            LOG.debug("Task {} is being reassigned already.", (Object)task.executionId());
            List<Integer> inProgressTargetReplicas = inProgressTargetReplicasOpt.get().replicas();
            List<Integer> inProgressTargetObservers = inProgressTargetReplicasOpt.get().observers();
            if (!newReplicas.equals(inProgressTargetReplicas) && !newObservers.equals(inProgressTargetObservers)) {
                throw new RuntimeException("The provided new replica list " + String.valueOf(newReplicas) + " is different from the in progress replica list " + String.valueOf(inProgressTargetReplicas) + " for " + String.valueOf(task.partitionProposal().topicPartition()));
            }
            return Optional.empty();
        }
        return Optional.of(new Executor.PartitionReplicas(newReplicas, newObservers));
    }

    private void logProgress(List<ExecutionTask> freshlyCompletedTasks) {
        int numFinishedPartitionMovements = this.executionTaskManager.numFinishedInterBrokerPartitionMovements();
        long finishedDataMovementInMB = this.executionTaskManager.finishedInterBrokerDataMovementInMB();
        LOG.info("{} execution tasks just completed (IDs: {}). Total: {}/{} ({}%) inter-broker partition movements completed. {}MB/{}MB ({}%) of data has been moved.", new Object[]{freshlyCompletedTasks.size(), freshlyCompletedTasks.stream().map(ExecutionTask::executionId).collect(Collectors.toList()), numFinishedPartitionMovements, this.numTotalPartitionMovements, String.format(Locale.US, "%.2f", (double)numFinishedPartitionMovements * 100.0 / (double)this.numTotalPartitionMovements), finishedDataMovementInMB, this.totalDataToMoveInMB, this.totalDataToMoveInMB == 0L ? Integer.valueOf(100) : String.format(Locale.US, "%.2f", (double)finishedDataMovementInMB * 100.0 / (double)this.totalDataToMoveInMB)});
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remaining data to start moving into destination brokers: {}MB", this.executionTaskManager.remainingInterBrokerDataToMoveByDestinationBroker());
        }
    }

    static class NewReplicaAssignments {
        Map<TopicPartition, Optional<NewPartitionReassignment>> newReplicaAssignments;
        List<ExecutionTask> tasksToRetry;

        public NewReplicaAssignments(Map<TopicPartition, Optional<NewPartitionReassignment>> newReplicaAssignments, List<ExecutionTask> tasksToRetry) {
            this.newReplicaAssignments = newReplicaAssignments;
            this.tasksToRetry = tasksToRetry;
        }
    }
}

