/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import com.linkedin.kafka.cruisecontrol.model.internal.AbstractEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.message.DescribeTenantsResponseData;

public class Tenant
extends AbstractEntity {
    private final String tenantId;
    private final List<Integer> cellIds;
    private final Map<Integer, Load> loadPerCell;
    private final Map<Integer, Utilization> utilizationPerCell;
    private final Map<Integer, Integer> replicaCountPerCell;
    private final PartitionPlacementStrategy placementPolicy;

    public Tenant(String tenantId, List<Integer> cellIds, PartitionPlacementStrategy placementPolicy) {
        Objects.requireNonNull(KafkaCruiseControlUtils.convertEmptyToNull(tenantId));
        this.tenantId = tenantId;
        this.cellIds = new ArrayList<Integer>(cellIds);
        this.placementPolicy = placementPolicy;
        this.loadPerCell = cellIds.stream().collect(Collectors.toMap(cellId -> cellId, cellId -> new Load()));
        this.utilizationPerCell = cellIds.stream().collect(Collectors.toMap(cellId -> cellId, cellId -> Utilization.from(this.loadPerCell.get(cellId))));
        this.replicaCountPerCell = cellIds.stream().collect(Collectors.toMap(cellId -> cellId, cellId -> 0));
    }

    public Tenant(DescribeTenantsResponseData.TenantDescription tenant) {
        this(tenant.tenantId(), tenant.cellIds(), PartitionPlacementStrategy.toEnum((Integer)tenant.partitionPlacementStrategy()));
    }

    public Tenant(Tenant other) {
        this.tenantId = other.tenantId;
        this.cellIds = new ArrayList<Integer>(other.cellIds);
        this.placementPolicy = other.placementPolicy;
        this.loadPerCell = other.loadPerCell.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Load((Load)e.getValue())));
        this.utilizationPerCell = other.utilizationPerCell.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Utilization)e.getValue()).newInstance()));
        this.replicaCountPerCell = new HashMap<Integer, Integer>(other.replicaCountPerCell);
    }

    private void initializeResourceUtil(int cellId) {
        this.loadPerCell.putIfAbsent(cellId, new Load());
        this.utilizationPerCell.putIfAbsent(cellId, Utilization.from(this.loadPerCell.get(cellId)));
        this.replicaCountPerCell.putIfAbsent(cellId, 0);
    }

    private void removeResourceUtil(int cellId) {
        this.loadPerCell.remove(cellId);
        this.utilizationPerCell.remove(cellId);
        this.replicaCountPerCell.remove(cellId);
    }

    public void addReplicaWithGivenLoadAndUtilization(int cellId, Broker.Strategy strategy, AggregatedMetricValues metricValues, List<Long> windows) {
        if (!this.loadPerCell.containsKey(cellId)) {
            this.initializeResourceUtil(cellId);
        }
        this.loadPerCell.get(cellId).addMetricValues(metricValues, windows);
        this.utilizationPerCell.get(cellId).addMetricValues(strategy, metricValues, windows);
        int replicaCount = this.replicaCountPerCell.get(cellId) + 1;
        this.replicaCountPerCell.put(cellId, replicaCount);
    }

    public void addReplicaWithGivenLoadAndUtilization(int cellId, Broker.Strategy strategy, Load load) {
        if (!this.loadPerCell.containsKey(cellId)) {
            this.initializeResourceUtil(cellId);
        }
        this.loadPerCell.get(cellId).addLoad(load);
        this.utilizationPerCell.get(cellId).addLoad(strategy, load);
        this.replicaCountPerCell.put(cellId, this.replicaCountPerCell.get(cellId) + 1);
    }

    public void transferUtilizationOfMovedLeadership(Broker sourceBroker, Broker destinationBroker, AggregatedMetricValues loadToMove) {
        this.utilizationPerCell.get(sourceBroker.cell().id()).subtractLoad(sourceBroker.strategy(), loadToMove);
        this.utilizationPerCell.get(destinationBroker.cell().id()).addLoad(destinationBroker.strategy(), loadToMove);
    }

    public void removeReplicaWithGivenLoadAndUtilization(int cellId, Broker.Strategy strategy, Load load) {
        if (!this.loadPerCell.containsKey(cellId)) {
            throw new IllegalArgumentException("Inconsistent replica movement. Trying to remove replica from cell " + cellId + " that does not contain any replicas for tenant " + this.tenantId);
        }
        this.loadPerCell.get(cellId).subtractLoad(load);
        this.utilizationPerCell.get(cellId).subtractLoad(strategy, load);
        this.replicaCountPerCell.put(cellId, this.replicaCountPerCell.get(cellId) - 1);
        if (this.replicaCountPerCell.getOrDefault(cellId, 0) == 0) {
            this.removeResourceUtil(cellId);
        }
    }

    public void relocate(int sourceCellId, int destinationCellId) {
        if (sourceCellId != destinationCellId) {
            if (!this.cellIds.contains(destinationCellId)) {
                this.cellIds.add(destinationCellId);
                this.initializeResourceUtil(destinationCellId);
            }
            this.utilizationPerCell.get(destinationCellId).addUtilization(this.utilizationPerCell.get(sourceCellId));
            this.replicaCountPerCell.put(destinationCellId, this.replicaCountPerCell.get(destinationCellId) + this.replicaCountPerCell.get(sourceCellId));
            this.removeResourceUtil(sourceCellId);
            this.cellIds.remove((Object)sourceCellId);
        }
    }

    public String tenantId() {
        return this.tenantId;
    }

    public List<Integer> cellIds() {
        return this.cellIds;
    }

    public PartitionPlacementStrategy placementPolicy() {
        return this.placementPolicy;
    }

    public int replicaCount() {
        return this.replicaCountPerCell.values().stream().mapToInt(Integer::intValue).sum();
    }

    @Override
    public Utilization utilization() {
        Utilization utilization = Utilization.from(new Load());
        this.utilizationPerCell.values().forEach(utilization::addUtilization);
        return utilization;
    }

    @Override
    public Load load() {
        Load load = new Load();
        this.loadPerCell.values().forEach(load::addLoad);
        return load;
    }

    @Override
    public double eligibleSourceUtilizationValue(Resource resource) {
        return this.utilization().eligibleSourceUtilization().map(load -> load.expectedUtilizationFor(resource)).orElse(0.0);
    }

    public Map<Integer, Double> eligibleSourceUtilizationValuePerCell(Resource resource) {
        HashMap<Integer, Double> eligibleSourceUtilizationPerCellMap = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, Utilization> entry : this.utilizationPerCell.entrySet()) {
            int cellId = entry.getKey();
            Utilization utilization = entry.getValue();
            eligibleSourceUtilizationPerCellMap.put(cellId, utilization.eligibleSourceUtilization().map(load -> load.expectedUtilizationFor(resource)).orElse(0.0));
        }
        return eligibleSourceUtilizationPerCellMap;
    }

    public Load load(int cellId) {
        return this.loadPerCell.getOrDefault(cellId, new Load());
    }

    public Utilization utilization(int cellId) {
        return this.utilizationPerCell.getOrDefault(cellId, Utilization.from(this.load(cellId)));
    }

    public int replicaCount(int cellId) {
        return this.replicaCountPerCell.getOrDefault(cellId, 0);
    }

    public Map<Integer, Integer> replicaCountPerCell() {
        return new HashMap<Integer, Integer>(this.replicaCountPerCell);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return this.tenantId.equals(tenant.tenantId);
    }

    public int hashCode() {
        return this.tenantId.hashCode();
    }

    public String toString() {
        return "Tenant{tenantId='" + this.tenantId + "', cellIds=" + String.valueOf(this.cellIds) + ", loadByCell=" + String.valueOf(this.loadPerCell) + ", utilizationByCell=" + String.valueOf(this.utilizationPerCell) + ", replicasByCell=" + String.valueOf(this.replicaCountPerCell) + ", placementPolicy=" + String.valueOf(this.placementPolicy) + "}";
    }
}

