/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import java.util.HashMap;
import java.util.Map;

public class ModelCompletenessRequirements {
    private static final String REQUIRED_NUM_SNAPSHOTS = "requiredNumSnapshots";
    private static final String MIN_MONITORED_PARTITION_PERCENTAGE = "minMonitoredPartitionsPercentage";
    private static final String INCLUDE_ALL_TOPICS = "includeAllTopics";
    private static final String FETCH_TOPIC_PLACEMENTS = "fetchTopicPlacements";
    private final int minRequiredNumWindows;
    private final double minMonitoredPartitionsPercentage;
    private final boolean includeAllTopics;
    private final boolean requiresTopicPlacements;

    public ModelCompletenessRequirements(int minNumValidWindows, double minValidPartitionsRatio, boolean includeAllTopics, boolean requiresTopicPlacementData) {
        if (minNumValidWindows <= 0) {
            throw new IllegalArgumentException("Invalid minNumValidWindows " + minNumValidWindows + ". The minNumValidWindows must be positive.");
        }
        if (minValidPartitionsRatio < 0.0 || minValidPartitionsRatio > 1.0) {
            throw new IllegalArgumentException("Invalid minValidPartitionsRatio " + minValidPartitionsRatio + ". The value must be between 0 and 1, both inclusive.");
        }
        this.minRequiredNumWindows = minNumValidWindows;
        this.includeAllTopics = includeAllTopics;
        this.minMonitoredPartitionsPercentage = minValidPartitionsRatio;
        this.requiresTopicPlacements = requiresTopicPlacementData;
    }

    public ModelCompletenessRequirements(int minNumValidWindows, double minValidPartitionsRatio, boolean includeAllTopics) {
        this(minNumValidWindows, minValidPartitionsRatio, includeAllTopics, false);
    }

    public int minRequiredNumWindows() {
        return this.minRequiredNumWindows;
    }

    public double minMonitoredPartitionsPercentage() {
        return this.minMonitoredPartitionsPercentage;
    }

    public boolean includeAllTopics() {
        return this.includeAllTopics;
    }

    public boolean requiresTopicPlacements() {
        return this.requiresTopicPlacements;
    }

    public ModelCompletenessRequirements stronger(ModelCompletenessRequirements other) {
        if (other == null) {
            return this;
        }
        return new ModelCompletenessRequirements(Math.max(this.minRequiredNumWindows, other.minRequiredNumWindows()), Math.max(this.minMonitoredPartitionsPercentage, other.minMonitoredPartitionsPercentage()), this.includeAllTopics || other.includeAllTopics(), this.requiresTopicPlacements || other.requiresTopicPlacements());
    }

    public ModelCompletenessRequirements weaker(ModelCompletenessRequirements other) {
        if (other == null) {
            return this;
        }
        return new ModelCompletenessRequirements(Math.min(this.minRequiredNumWindows, other.minRequiredNumWindows()), Math.min(this.minMonitoredPartitionsPercentage, other.minMonitoredPartitionsPercentage()), this.includeAllTopics && other.includeAllTopics(), this.requiresTopicPlacements && other.requiresTopicPlacements());
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> requirements = new HashMap<String, Object>();
        requirements.put(REQUIRED_NUM_SNAPSHOTS, this.minRequiredNumWindows);
        requirements.put(MIN_MONITORED_PARTITION_PERCENTAGE, this.minMonitoredPartitionsPercentage);
        requirements.put(INCLUDE_ALL_TOPICS, this.includeAllTopics);
        requirements.put(FETCH_TOPIC_PLACEMENTS, this.requiresTopicPlacements);
        return requirements;
    }

    public String toString() {
        return String.format("(requiredNumWindows=%d, minMonitoredPartitionPercentage=%.3f, includedAllTopics=%s, fetchTopicPlacements=%s)", this.minRequiredNumWindows, this.minMonitoredPartitionsPercentage, this.includeAllTopics, this.requiresTopicPlacements);
    }
}

