/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.BasicPartitionInfo;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigFileResolver;
import com.linkedin.kafka.cruisecontrol.config.ClusterBrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.exception.MetricSamplingException;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SampleIngestionResults;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SamplingOptions;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaPartitionMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaReplicaMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionMetricSample;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaMetricSample;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricFetcherManager {
    public static final String BROKER_CAPACITY_CONFIG_RESOLVER_OBJECT_CONFIG = "broker.capacity.config.resolver.object";
    public static final String DEFAULT_BROKER_CAPACITY_CONFIG_RESOLVER_OBJECT_CONFIG = BrokerCapacityConfigFileResolver.class.getCanonicalName();
    private static final Logger LOG = LoggerFactory.getLogger(MetricFetcherManager.class);
    private final Time time;
    private final KafkaReplicaMetricSampleAggregator replicaMetricSampleAggregator;
    private final KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator;
    private MetricSampler metricSampler;
    private Timer samplingFetcherTimer;
    private Meter samplingFetcherFailureRate;
    private final KafkaCruiseControlConfig config;
    private final GeneralSBCMetricsRegistry metricRegistry;
    private final ClusterBrokerCapacityConfigResolver brokerCapacityConfigResolver;

    public MetricFetcherManager(KafkaCruiseControlConfig config, KafkaReplicaMetricSampleAggregator replicaMetricSampleAggregator, KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator, Time time, GeneralSBCMetricsRegistry metricRegistry, ClusterBrokerCapacityConfigResolver brokerCapacityConfigResolver, MetricSampler sampler) {
        this.config = config;
        this.time = time;
        this.replicaMetricSampleAggregator = replicaMetricSampleAggregator;
        this.partitionMetricSampleAggregator = partitionMetricSampleAggregator;
        this.metricRegistry = metricRegistry;
        this.brokerCapacityConfigResolver = brokerCapacityConfigResolver;
        this.metricSampler = sampler;
    }

    public void start() {
        this.samplingFetcherTimer = this.metricRegistry.newTimer(MetricFetcherManager.class, "partition-samples-fetcher-timer");
        this.samplingFetcherFailureRate = this.metricRegistry.newMeter(MetricFetcherManager.class, "partition-samples-fetcher-failure-rate", "partition-samples-fetch-failures", TimeUnit.SECONDS);
        this.metricSampler = this.metricSampler == null ? this.config.getConfiguredInstance("metric.sampler.class", MetricSampler.class, Collections.singletonMap(BROKER_CAPACITY_CONFIG_RESOLVER_OBJECT_CONFIG, this.brokerCapacityConfigResolver)) : this.metricSampler;
    }

    public void shutdown() {
        LOG.info("Shutting down metric fetcher manager.");
        KafkaCruiseControlUtils.closeSilently(this.metricSampler);
        LOG.info("Metric fetcher manager shutdown completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchSamples(SamplingOptions samplingOptions, long timeoutMs) {
        LOG.debug("Kicking off partition metric sampling for time range [{}, {}] ([{}, {}]), duration {} ms with timeout {} ms.", new Object[]{KafkaCruiseControlUtils.toTimeString(samplingOptions.startMs), KafkaCruiseControlUtils.toTimeString(samplingOptions.endMs), samplingOptions.startMs, samplingOptions.endMs, samplingOptions.endMs - samplingOptions.startMs, timeoutMs});
        boolean hasSamplingError = false;
        long samplingActionStartMs = this.time.hiResClockMs();
        long deadlineMs = samplingActionStartMs + timeoutMs;
        TimerContext ctx = this.samplingFetcherTimer.time();
        try {
            MetricSampler.Samples samples = this.metricSampler.getSamples(samplingOptions.cluster, samplingOptions.partitionAssignment, samplingOptions.startMs, samplingOptions.endMs);
            if (samples == null) {
                samples = MetricSampler.EMPTY_SAMPLES;
            }
            SampleIngestionResults replicaIngestionResults = this.addReplicaSamplesToAggregator(samples.replicaMetricSamples(), samplingOptions);
            SampleIngestionResults partitionIngestionResults = this.addPartitionSamplesToAggregator(samples.partitionMetricSamples(), samplingOptions);
            this.logIngestionResults(replicaIngestionResults, "replica");
            this.logIngestionResults(partitionIngestionResults, "partition");
            if (!replicaIngestionResults.isEmpty() && !partitionIngestionResults.isEmpty()) {
                this.replicaMetricSampleAggregator.onSamplingFinish(samplingOptions.endMs);
                this.partitionMetricSampleAggregator.onSamplingFinish(samplingOptions.endMs);
            }
        }
        catch (Exception e) {
            this.samplingFetcherFailureRate.mark();
            hasSamplingError = true;
            if (e instanceof MetricSamplingException) {
                LOG.error("Sampling scheduler received a sampling exception while waiting for sampling to finish.", (Throwable)e);
            } else {
                LOG.error("Sampling scheduler received an unknown exception while waiting for sampling to finish.", (Throwable)e);
            }
        }
        finally {
            ctx.stop();
        }
        long currentHiResTimeMs = this.time.hiResClockMs();
        long timeItTookMs = currentHiResTimeMs - samplingActionStartMs;
        if (currentHiResTimeMs > deadlineMs) {
            LOG.warn("Sampling took too long to finish - {} ms which is above its timeout ms {}. If this is taking multiple times longer than the timeout, there is a chance that no metric windows can be built.", (Object)timeItTookMs, (Object)timeoutMs);
        }
        LOG.debug("Finished sampling in {} ms.", (Object)timeItTookMs);
        return hasSamplingError;
    }

    private void logIngestionResults(SampleIngestionResults ingestionResults, String entity) {
        Object logFormat = "Collected {} ({} discarded, {} added) {} metric samples for {} {}s. Total partition assigned: {}. Total unrecognized {}s: {}";
        Object[] logArgs = new Object[]{ingestionResults.numTotalSamples, ingestionResults.numSamplesDiscarded, ingestionResults.numSamplesAdded, entity, ingestionResults.numEntities, entity, ingestionResults.numAssignedPartitions, entity, ingestionResults.numUnrecognizedEntities};
        if (ingestionResults.isEmpty()) {
            logFormat = String.format("Zero %s samples were added! ", entity) + (String)logFormat;
            LOG.warn((String)logFormat, logArgs);
        } else {
            LOG.info((String)logFormat, logArgs);
        }
        if (!ingestionResults.unrecognizedTopicPartitions.isEmpty()) {
            LOG.warn("Encountered {} unrecognized partitions as part of adding the {} metric samples. This means that the cluster metadata we used did not include them, but the metric samples did. The unrecognized partitions were: {}", new Object[]{ingestionResults.unrecognizedTopicPartitions.size(), entity, ingestionResults.unrecognizedTopicPartitions});
        }
    }

    SampleIngestionResults addReplicaSamplesToAggregator(Set<ReplicaMetricSample> replicaMetricSamples, SamplingOptions samplingOptions) {
        SampleIngestionResults.Builder ingestionResultsBuilder = new SampleIngestionResults.Builder();
        if (replicaMetricSamples == null) {
            return SampleIngestionResults.EMPTY;
        }
        int returnedReplicas = 0;
        int discarded = 0;
        int unknownReplicas = 0;
        int numAdded = 0;
        ArrayList<TopicPartition> unrecognizedTopicPartitions = new ArrayList<TopicPartition>();
        for (ReplicaMetricSample replicaMetricSample : replicaMetricSamples) {
            BasicPartitionInfo tp = ((ReplicaEntity)replicaMetricSample.entity()).tp();
            TopicPartition topicPartition = new TopicPartition(tp.topic(), tp.partition());
            if (!samplingOptions.assignedTopicPartitions.contains(topicPartition)) {
                ++unknownReplicas;
                LOG.debug("Collected replica metric sample for partition {} which is not an assigned partition. The metric sample will be ignored.", (Object)tp);
                unrecognizedTopicPartitions.add(topicPartition);
                continue;
            }
            replicaMetricSample.close(samplingOptions.endMs);
            if (this.replicaMetricSampleAggregator.addSample(replicaMetricSample)) {
                ++numAdded;
                LOG.trace("Enqueued replica metric sample {}", (Object)replicaMetricSample);
            } else {
                ++discarded;
                LOG.debug("Failed to add replica metric sample {}", (Object)replicaMetricSample);
            }
            ++returnedReplicas;
        }
        return ingestionResultsBuilder.numTotalSamples(replicaMetricSamples.size()).numSamplesDiscarded(discarded).numEntities(returnedReplicas).numAssignedPartitions(samplingOptions.assignedTopicPartitions.size()).numUnrecognizedEntities(unknownReplicas).numSamplesAdded(numAdded).unrecognizedTopicPartitions(unrecognizedTopicPartitions).build();
    }

    SampleIngestionResults addPartitionSamplesToAggregator(Set<PartitionMetricSample> partitionMetricSamples, SamplingOptions samplingOptions) {
        SampleIngestionResults.Builder ingestionResultsBuilder = new SampleIngestionResults.Builder();
        if (partitionMetricSamples == null) {
            return SampleIngestionResults.EMPTY;
        }
        int returnedPartitions = 0;
        int discarded = 0;
        int unknownPartitions = 0;
        int numAdded = 0;
        ArrayList<TopicPartition> unrecognizedTopicPartitions = new ArrayList<TopicPartition>();
        for (PartitionMetricSample partitionMetricSample : partitionMetricSamples) {
            TopicPartition tp = ((PartitionEntity)partitionMetricSample.entity()).tp();
            if (!samplingOptions.assignedTopicPartitions.contains(tp)) {
                ++unknownPartitions;
                unrecognizedTopicPartitions.add(tp);
                LOG.debug("Collected partition metric sample for partition {} which is not an assigned partition. The metric sample will be ignored.", (Object)tp);
                continue;
            }
            partitionMetricSample.open(samplingOptions.startMs);
            partitionMetricSample.close(samplingOptions.endMs);
            if (this.partitionMetricSampleAggregator.addSample(partitionMetricSample)) {
                LOG.trace("Enqueued partition metric sample {}", (Object)partitionMetricSample);
                ++numAdded;
            } else {
                ++discarded;
                LOG.debug("Failed to add partition metric sample {}", (Object)partitionMetricSample);
            }
            ++returnedPartitions;
        }
        return ingestionResultsBuilder.numTotalSamples(partitionMetricSamples.size()).numSamplesDiscarded(discarded).numEntities(returnedPartitions).numAssignedPartitions(samplingOptions.assignedTopicPartitions.size()).numUnrecognizedEntities(unknownPartitions).numSamplesAdded(numAdded).unrecognizedTopicPartitions(unrecognizedTopicPartitions).build();
    }
}

