/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaEntity;
import java.util.Date;
import org.apache.kafka.common.PartitionInfo;

public class ReplicaMetricSample
extends MetricSample<ReplicaEntity> {
    public ReplicaMetricSample(int brokerId, PartitionInfo tp, boolean isLeader) {
        super(new ReplicaEntity(tp, brokerId, isLeader));
    }

    public int brokerId() {
        return ((ReplicaEntity)this.entity()).brokerId();
    }

    @Override
    public String toString() {
        MetricDef metricDef = KafkaMetricDef.replicaMetricDef();
        StringBuilder builder = new StringBuilder().append("{");
        int sampled = 0;
        for (short i = 0; i < this.valuesByMetricId.length; i = (short)(i + 1)) {
            if (Float.isNaN(this.valuesByMetricId[i])) continue;
            builder.append((Object)metricDef.metricInfo(i).kafkaMetricDef()).append("=").append(this.valuesByMetricId[i]).append(", ");
            ++sampled;
        }
        if (sampled != 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("}");
        return String.format("[brokerId: %d, Partition: %s, time: [%s, %s], metrics: %s]", ((ReplicaEntity)this.entity).brokerId(), ((ReplicaEntity)this.entity()).tp(), new Date(this.sampleOpenTime), new Date(this.sampleCloseTime), builder);
    }
}

