/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.plan;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlContext;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.plan.PlanComputable;
import io.confluent.databalancer.utils.OperationRetryer;
import io.confluent.databalancer.utils.RetryableResult;
import java.time.Duration;
import org.apache.kafka.common.errors.InsufficientRebalancePlanMetricsException;
import org.apache.kafka.common.errors.RebalanceInProgressDuringPlanComputationException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanComputationUtils {
    private final Duration retryIntervalDuration;
    private final Duration retryTimeoutDuration;
    private Time time;
    private static final Logger LOG = LoggerFactory.getLogger(PlanComputationUtils.class);

    public PlanComputationUtils(KafkaCruiseControlConfig config, Time time) {
        this.retryIntervalDuration = Duration.ofMillis(config.getLong("partition.metrics.window.ms") / 2L);
        this.retryTimeoutDuration = Duration.ofMillis(config.getLong("plan.computation.retry.timeout.ms"));
        if (this.retryTimeoutDuration.toMillis() <= this.retryIntervalDuration.toMillis()) {
            throw new IllegalArgumentException(String.format("The retry timeout %s (%s) cannot be less than the retry interval %s", "plan.computation.retry.timeout.ms", this.retryTimeoutDuration.toMillis(), this.retryIntervalDuration.toMillis()));
        }
        this.time = time;
    }

    public OptimizerResult generatePlanWithRetries(PlanComputable computable, String planDescription) throws Exception {
        OperationRetryer retryer = new OperationRetryer(this.time, this.retryTimeoutDuration, this.retryIntervalDuration, planDescription);
        return (OptimizerResult)retryer.runWithRetries(() -> {
            try {
                return RetryableResult.Success.of(computable.compute());
            }
            catch (NotEnoughValidWindowsException | InsufficientRebalancePlanMetricsException e) {
                LOG.info("Insufficient metric windows to compute {}, will attempt retry", (Object)planDescription);
                LOG.debug("Insufficient metric windows exception:", e);
                return RetryableResult.Incomplete.instance();
            }
            catch (RebalanceInProgressDuringPlanComputationException e) {
                LOG.info("Caught reassignments in progress while trying to compute {}. Inspect the logs to understand which partitions were reassigning. Will attempt retry", (Object)planDescription);
                LOG.debug("Reassignment in progress exception:", (Throwable)e);
                return RetryableResult.Incomplete.instance();
            }
        });
    }

    public OptimizerResult generatePlan(PlanComputable computable, GoalsConfig goalConfig, KafkaCruiseControlContext context, String planDescription) throws Exception {
        try {
            return computable.compute();
        }
        catch (KafkaCruiseControlException kcce) {
            throw kcce;
        }
        catch (NotEnoughValidWindowsException nevwe) {
            long retryIntervalSecs = (long)goalConfig.requirements().minRequiredNumWindows() * context.config().getLong("partition.metrics.window.ms") / 1000L;
            throw new InsufficientRebalancePlanMetricsException("Self-balancing requires a few minutes to collect metrics for rebalancing plans. Metrics collection is in progress. Please try again after " + retryIntervalSecs + " seconds.", (Throwable)nevwe);
        }
        catch (RebalanceInProgressDuringPlanComputationException e) {
            LOG.info("Caught reassignments in progress while trying to compute {}. Inspect the logs to understand which partitions were reassigning. Will attempt retry", (Object)planDescription);
            LOG.debug("Reassignment in progress exception:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new KafkaCruiseControlException(e);
        }
    }
}

