/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.ClusterBrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.BrokerCapacitiesUpdater;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.CruiseControlMetricsProcessor;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricFetcherManager;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.TrailingFanoutTotalCapacityProcessor;
import io.confluent.databalancer.startup.StartupCheckInterruptedException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfluentMetricsSamplerBase
implements MetricSampler {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluentMetricsSamplerBase.class);
    public static final String METRIC_SAMPLER_BOOTSTRAP_SERVERS = "metric.reporter.sampler.bootstrap.servers";
    public static final String TELEMETRY_REPORTER_TOPIC_PATTERN = "confluent.telemetry.reporter.topic";
    public static final String METRIC_SAMPLER_GROUP_ID = "metric.reporter.sampler.group.id";
    private static final String DEFAULT_METRIC_SAMPLER_GROUP_ID = "ConfluentTelemetryReporterSampler";
    private static final Random RANDOM = ThreadLocalRandom.current();
    private static final int ASSIGNMENT_POLL_TIMEOUT = 10;
    private static final int ASSIGNMENT_LOGGING_INTERVAL = 12000;
    private static final long METRICS_POLL_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    protected Consumer<byte[], byte[]> metricConsumer;
    private CruiseControlMetricsProcessor metricsProcessor;

    protected static String getMetricReporterTopic(Map<String, ?> configs) {
        String metricReporterTopic = (String)configs.get(TELEMETRY_REPORTER_TOPIC_PATTERN);
        if (metricReporterTopic == null) {
            metricReporterTopic = "_confluent-telemetry-metrics";
        }
        return metricReporterTopic;
    }

    protected static Properties getMetricConsumerProperties(Map<String, ?> configs) {
        Object groupId;
        String bootstrapServers = (String)configs.get(METRIC_SAMPLER_BOOTSTRAP_SERVERS);
        if (bootstrapServers == null) {
            bootstrapServers = configs.get("bootstrap.servers").toString();
        }
        if ((groupId = (String)configs.get(METRIC_SAMPLER_GROUP_ID)) == null) {
            String configuredSamplerName;
            try {
                configuredSamplerName = ((Class)configs.get("metric.sampler.class")).getSimpleName();
            }
            catch (Exception e) {
                configuredSamplerName = DEFAULT_METRIC_SAMPLER_GROUP_ID;
            }
            groupId = configuredSamplerName + "-" + RANDOM.nextLong();
        }
        Properties consumerProps = new Properties();
        consumerProps.setProperty("bootstrap.servers", bootstrapServers);
        consumerProps.setProperty("group.id", (String)groupId);
        consumerProps.setProperty("client.id", (String)groupId + "-consumer-" + RANDOM.nextInt());
        consumerProps.setProperty("auto.offset.reset", "latest");
        consumerProps.setProperty("enable.auto.commit", "false");
        consumerProps.setProperty("max.poll.records", Integer.toString(Integer.MAX_VALUE));
        consumerProps.setProperty("key.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.setProperty("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.setProperty("max.poll.interval.ms", Integer.toString(Integer.MAX_VALUE));
        consumerProps.putAll(KafkaCruiseControlUtils.filterConsumerConfigs(configs));
        return consumerProps;
    }

    protected static boolean checkIfMetricReporterTopicExist(String metricReporterTopic, Consumer<byte[], byte[]> metricConsumer) {
        Pattern topicPattern = Pattern.compile(metricReporterTopic);
        for (String topic : metricConsumer.listTopics().keySet()) {
            if (!topicPattern.matcher(topic).matches()) continue;
            return true;
        }
        return false;
    }

    protected static Consumer<byte[], byte[]> createConsumerForMetricTopic(Properties consumerProps, String metricReporterTopic) {
        Map<String, Object> filteredConsumerProperties = KafkaCruiseControlUtils.filterConsumerConfigs(consumerProps.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue)));
        KafkaConsumer metricConsumer = new KafkaConsumer(filteredConsumerProperties);
        metricConsumer.subscribe(Pattern.compile(metricReporterTopic), new ConsumerRebalanceListener((Consumer)metricConsumer){
            final /* synthetic */ Consumer val$metricConsumer;
            {
                this.val$metricConsumer = consumer;
            }

            public void onPartitionsRevoked(Collection<TopicPartition> collection) {
                this.val$metricConsumer.commitSync();
            }

            public void onPartitionsAssigned(Collection<TopicPartition> collection) {
            }
        });
        return metricConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public MetricSampler.Samples getSamples(Cluster cluster, Set<PartitionInfo> assignedPartitions, long startTimeMs, long endTimeMs) {
        void var14_15;
        long pollerCount = 0L;
        while (this.metricConsumer.assignment().isEmpty()) {
            this.metricConsumer.poll(Duration.ofMillis(10L));
            if (++pollerCount % 12000L != 0L) continue;
            LOG.warn("metricConsumer Assignment is empty. This is likely due to a problem reporting cluster metrics.");
        }
        HashMap<TopicPartition, Long> timestampToSeek = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : this.metricConsumer.assignment()) {
            timestampToSeek.put(tp, startTimeMs);
        }
        HashSet assignment = new HashSet(this.metricConsumer.assignment());
        Map endOffsets = this.metricConsumer.endOffsets(assignment);
        Map offsetsForTimes = this.metricConsumer.offsetsForTimes(timestampToSeek);
        assignment.removeAll(offsetsForTimes.keySet());
        for (TopicPartition topicPartition : assignment) {
            this.metricConsumer.seek(topicPartition, ((Long)endOffsets.get(topicPartition)).longValue());
        }
        for (Map.Entry entry : offsetsForTimes.entrySet()) {
            TopicPartition tp = (TopicPartition)entry.getKey();
            OffsetAndTimestamp offsetAndTimestamp = (OffsetAndTimestamp)entry.getValue();
            if (offsetAndTimestamp != null) {
                this.metricConsumer.seek(tp, offsetAndTimestamp.offset());
                continue;
            }
            this.metricConsumer.seek(tp, ((Long)endOffsets.get(tp)).longValue());
        }
        LOG.debug("Starting consuming from metrics reporter topic partitions {}", (Object)this.metricConsumer.assignment());
        this.metricConsumer.resume((Collection)this.metricConsumer.paused());
        HashMap<RawMetricType, Long> totalAddedMetricsByType = new HashMap<RawMetricType, Long>(RawMetricType.values().length);
        boolean bl = false;
        int numEarlierTimestamps = 0;
        int numLaterTimestamps = 0;
        int numPolls = 0;
        int numTotalMetrics = 0;
        long deadline = System.currentTimeMillis() + (endTimeMs + 1L - startTimeMs) / 2L;
        do {
            ConsumerRecords records = this.metricConsumer.poll(Duration.ofMillis(METRICS_POLL_TIMEOUT));
            ++numPolls;
            for (ConsumerRecord record : records) {
                if (record == null) {
                    LOG.debug("Cannot parse record.");
                    continue;
                }
                List<CruiseControlMetric> metrics = this.convertMetricRecord((ConsumerRecord<byte[], byte[]>)record);
                numTotalMetrics += metrics.size();
                for (CruiseControlMetric metric : metrics) {
                    if (metric.time() >= startTimeMs && metric.time() <= endTimeMs) {
                        this.metricsProcessor.addMetric(metric);
                        ++var14_15;
                        totalAddedMetricsByType.compute(metric.rawMetricType(), (k, v) -> v == null ? 1L : v + 1L);
                        continue;
                    }
                    if (metric.time() > endTimeMs) {
                        TopicPartition tp = new TopicPartition(record.topic(), record.partition());
                        LOG.debug("Saw metric {} whose timestamp {} ({}) is larger than end time {} ({}). Pausing partition {} at offset {}", new Object[]{metric, KafkaCruiseControlUtils.toTimeString(metric.time()), metric.time(), KafkaCruiseControlUtils.toTimeString(endTimeMs), endTimeMs, tp, record.offset()});
                        this.metricConsumer.pause(Collections.singleton(tp));
                        ++numLaterTimestamps;
                        continue;
                    }
                    LOG.debug("Discarding metric {} because the timestamp {} ({}) is smaller than the start time {} ({})", new Object[]{metric, KafkaCruiseControlUtils.toTimeString(metric.time()), metric.time(), KafkaCruiseControlUtils.toTimeString(startTimeMs), startTimeMs});
                    ++numEarlierTimestamps;
                }
            }
        } while (!this.consumptionDone(endOffsets) && System.currentTimeMillis() < deadline);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished sampling for {} partitions - processed {} metrics over {} polls for the time range [{},{}] ([{} - {}]), with {} of them added to the metrics processor, having the following distribution {},  {} of them being later than the desired end time and {} being earlier than the desired start time. All partitions: {}", new Object[]{this.metricConsumer.assignment().size(), numTotalMetrics, numPolls, KafkaCruiseControlUtils.toTimeString(startTimeMs), KafkaCruiseControlUtils.toTimeString(endTimeMs), startTimeMs, endTimeMs, (int)var14_15, totalAddedMetricsByType, numLaterTimestamps, numEarlierTimestamps, this.metricConsumer.assignment()});
        } else {
            LOG.info("Finished sampling for {} partitions - processed {} metrics over {} polls for the time range [{},{}], with {} of them added to the metrics processor, having the following distribution {},  {} of them being later than the desired end time and {} being earlier than the desired start time.", new Object[]{this.metricConsumer.assignment().size(), numTotalMetrics, numPolls, KafkaCruiseControlUtils.toTimeString(startTimeMs), KafkaCruiseControlUtils.toTimeString(endTimeMs), (int)var14_15, totalAddedMetricsByType, numLaterTimestamps, numEarlierTimestamps});
        }
        try {
            MetricSampler.Samples samples;
            if (var14_15 > 0) {
                samples = this.metricsProcessor.process(cluster, assignedPartitions);
                return samples;
            }
            samples = new MetricSampler.Samples(Collections.emptySet(), Collections.emptySet());
            return samples;
        }
        finally {
            this.metricsProcessor.clear();
        }
    }

    private boolean consumptionDone(Map<TopicPartition, Long> endOffsets) {
        HashSet partitionsNotPaused = new HashSet(this.metricConsumer.assignment());
        partitionsNotPaused.removeAll(this.metricConsumer.paused());
        for (TopicPartition tp : partitionsNotPaused) {
            if (this.metricConsumer.position(tp) >= endOffsets.get(tp)) continue;
            return false;
        }
        return true;
    }

    protected abstract List<CruiseControlMetric> convertMetricRecord(ConsumerRecord<byte[], byte[]> var1);

    @Override
    public void configure(Map<String, ?> configs) {
        ClusterBrokerCapacityConfigResolver capacityResolver = (ClusterBrokerCapacityConfigResolver)configs.get("broker.capacity.config.resolver.object");
        if (capacityResolver == null && (capacityResolver = (ClusterBrokerCapacityConfigResolver)configs.get(MetricFetcherManager.DEFAULT_BROKER_CAPACITY_CONFIG_RESOLVER_OBJECT_CONFIG)) == null) {
            throw new IllegalArgumentException("Metrics reporter sampler configuration is missing broker capacity config resolver object.");
        }
        KafkaCruiseControlConfig kafkaCruiseControlConfig = new KafkaCruiseControlConfig(configs);
        TrailingFanoutTotalCapacityProcessor trailingFanoutTotalCapacityProcessor = new TrailingFanoutTotalCapacityProcessor(kafkaCruiseControlConfig.getLong("flex.fanout.network.capacity.metrics.avg.period.ms"), Time.SYSTEM);
        BrokerCapacitiesUpdater brokerCapacitiesUpdater = new BrokerCapacitiesUpdater(capacityResolver, trailingFanoutTotalCapacityProcessor, kafkaCruiseControlConfig.getDouble("minimum.reported.brokers.with.network.capacity.metrics.percentage"), kafkaCruiseControlConfig.getBoolean("enable.network.capacity.metric.ingestion"), kafkaCruiseControlConfig.getDouble("maximum.allocated.percentage.for.network.in.capacity.bytes"));
        this.metricsProcessor = new CruiseControlMetricsProcessor(brokerCapacitiesUpdater, kafkaCruiseControlConfig);
        Integer numSamplersString = (Integer)configs.get("num.metric.fetchers");
        if (numSamplersString != null && numSamplersString != 1) {
            String className = this.getClass().getSimpleName();
            throw new ConfigException(className + " is not thread safe. Please change num.metric.fetchers to 1");
        }
        String metricReporterTopic = ConfluentMetricsSamplerBase.getMetricReporterTopic(configs);
        Properties consumerProps = ConfluentMetricsSamplerBase.getMetricConsumerProperties(configs);
        this.createMetricConsumer(consumerProps, metricReporterTopic);
        this.validateSamplingTopic(metricReporterTopic);
    }

    void createMetricConsumer(Properties consumerProps, String metricReporterTopic) {
        this.metricConsumer = ConfluentMetricsSamplerBase.createConsumerForMetricTopic(consumerProps, metricReporterTopic);
    }

    void validateSamplingTopic(String metricReporterTopic) {
        if (!ConfluentMetricsSamplerBase.checkIfMetricReporterTopicExist(metricReporterTopic, this.metricConsumer)) {
            throw new IllegalStateException("Cruise Control cannot find sampling topic matches " + metricReporterTopic + " in the target cluster.");
        }
    }

    public static void checkStartupCondition(KafkaCruiseControlConfig config, Semaphore abortStartupCheck) {
        Logger startupLog = LoggerFactory.getLogger(ConfluentMetricsSamplerBase.class);
        Map<String, Object> configPairs = config.mergedConfigValues();
        String metricReporterTopic = ConfluentMetricsSamplerBase.getMetricReporterTopic(configPairs);
        Properties metricConsumerProperties = ConfluentMetricsSamplerBase.getMetricConsumerProperties(configPairs);
        try (Consumer<byte[], byte[]> metricConsumer = ConfluentMetricsSamplerBase.createConsumerForMetricTopic(metricConsumerProperties, metricReporterTopic);){
            long maxTimeoutSec = 60L;
            long currentTimeoutInSec = 1L;
            while (!ConfluentMetricsSamplerBase.checkIfMetricReporterTopicExist(metricReporterTopic, metricConsumer)) {
                startupLog.info("Waiting for {} seconds for metric reporter topic {} to become available.", (Object)currentTimeoutInSec, (Object)metricReporterTopic);
                try {
                    if (abortStartupCheck.tryAcquire(currentTimeoutInSec, TimeUnit.SECONDS)) {
                        throw new StartupCheckInterruptedException();
                    }
                }
                catch (InterruptedException e) {
                    throw new StartupCheckInterruptedException(e);
                }
                currentTimeoutInSec = Math.min(2L * currentTimeoutInSec, maxTimeoutSec);
            }
        }
        startupLog.info("Metric Reporter Sampler ready to start.");
    }

    @Override
    public void close() {
        KafkaCruiseControlUtils.executeSilently(this.metricConsumer, consumer -> consumer.close(Duration.ofSeconds(0L)));
    }
}

