/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter;

import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.BrokerMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.PartitionMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.TopicMetric;
import io.confluent.cruisecontrol.metricsreporter.ConfluentMetricsSamplerBase;
import io.confluent.cruisecontrol.metricsreporter.OpenTelemetryConverter;
import io.confluent.cruisecontrol.metricsreporter.SbcOpenTelemetryConverter;
import io.confluent.cruisecontrol.metricsreporter.TelemetryConverter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentTelemetryReporterSampler
extends ConfluentMetricsSamplerBase {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluentTelemetryReporterSampler.class);
    static final String TOPIC_KEY = "topic";
    static final String PARTITION_KEY = "partition";
    static final String REQUEST_TYPE_KEY = "request";
    static final String PRODUCE_REQUEST_TYPE = "Produce";
    static final String CONSUMER_FETCH_REQUEST_TYPE = "FetchConsumer";
    static final String FOLLOWER_FETCH_REQUEST_TYPE = "FetchFollower";
    static final String PRODUCE_MIRROR_IN_CAPACITY = "io.confluent.kafka.server/produce/broker_quota";
    static final String CONSUME_CAPACITY = "io.confluent.kafka.server/fetch/broker_quota";
    static final String BYTES_IN_PER_SEC = "io.confluent.kafka.server/broker_topic/bytes_in/rate/1_min";
    static final String MIRROR_BYTES_IN_PER_SEC = "io.confluent.kafka.server/broker_topic/mirror_bytes_in/rate/1_min";
    static final String BYTES_OUT_PER_SEC = "io.confluent.kafka.server/broker_topic/bytes_out/rate/1_min";
    static final String FETCH_FROM_FOLLOWER_BYTES_OUT_PER_SEC = "io.confluent.kafka.server/broker_topic/fetch_from_follower_bytes_out/rate/1_min";
    static final String REPLICATION_BYTES_IN_PER_SEC = "io.confluent.kafka.server/broker_topic/replication_bytes_in/rate/1_min";
    static final String REPLICATION_BYTES_OUT_PER_SEC = "io.confluent.kafka.server/broker_topic/replication_bytes_out/rate/1_min";
    static final String TOTAL_FETCH_REQUEST_PER_SEC = "io.confluent.kafka.server/broker_topic/total_fetch_requests/rate/1_min";
    static final String TOTAL_FETCH_FROM_FOLLOWER_REQUEST_PER_SEC = "io.confluent.kafka.server/broker_topic/total_fetch_from_follower_requests/rate/1_min";
    static final String TOTAL_FOLLOWER_FETCH_REQUEST_PER_SEC = "io.confluent.kafka.server/broker_topic/total_follower_fetch_requests/rate/1_min";
    static final String TOTAL_PRODUCE_REQUEST_PER_SEC = "io.confluent.kafka.server/broker_topic/total_produce_requests/rate/1_min";
    static final String MESSAGES_IN_PER_SEC = "io.confluent.kafka.server/broker_topic/messages_in/rate/1_min";
    static final String REQUESTS_PER_SEC = "io.confluent.kafka.server/request/requests/rate/1_min";
    static final String SIZE = "io.confluent.kafka.server/log/size";
    static final String LINUX_CPU_USAGE = "io.confluent.kafka.server/server/linux_system_cpu_utilization_1m";
    static final String JVM_OS_JMX_BEAN_CPU_USAGE = "io.confluent.system/jvm/os/process_cpu_load";
    static final String DISK_TOTAL_BYTES = "io.confluent.system/volume/disk_total_bytes";
    private static final Map<String, TopicAndAllTopicMetricTypes> TOPIC_METRIC_MAP = ConfluentTelemetryReporterSampler.buildTopicMetricMap();
    private static final OpenTelemetryConverter OPENTELEMETRY_CONVERTER = new OpenTelemetryConverter();
    private static final SbcOpenTelemetryConverter SBC_OPENTELEMETRY_CONVERTER = new SbcOpenTelemetryConverter();
    private volatile TelemetryConverter openTelemetryConverter = OPENTELEMETRY_CONVERTER;

    private static int telemetryMessageVersion(ConsumerRecord<byte[], byte[]> record) {
        Header versionHeader = record.headers().lastHeader("v");
        if (versionHeader != null) {
            return ByteBuffer.wrap(versionHeader.value()).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }
        return 0;
    }

    @Override
    public void configure(Map<String, ?> config) {
        super.configure(config);
        Boolean isSbcParserEnabled = (Boolean)config.get("sbc.metrics.parser.enabled");
        this.openTelemetryConverter = isSbcParserEnabled != false ? SBC_OPENTELEMETRY_CONVERTER : OPENTELEMETRY_CONVERTER;
    }

    @Override
    protected List<CruiseControlMetric> convertMetricRecord(ConsumerRecord<byte[], byte[]> record) {
        TelemetryConverter telemetryConverter;
        switch (ConfluentTelemetryReporterSampler.telemetryMessageVersion(record)) {
            case 1: {
                telemetryConverter = this.openTelemetryConverter;
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        final ArrayList<CruiseControlMetric> ccMetrics = new ArrayList<CruiseControlMetric>();
        telemetryConverter.convert((byte[])record.value(), new TelemetryConverter.MetricConsumer<Integer>(){

            @Override
            public Optional<Integer> brokerId(String brokerId) {
                if (brokerId == null || brokerId.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(Integer.parseInt(brokerId));
            }

            @Override
            public void consume(String metricName, Integer brokerId, TelemetryConverter.DataPoint dataPoint) {
                ConfluentTelemetryReporterSampler.createCruiseControlPointMetrics(metricName, brokerId, dataPoint, ccMetrics);
            }

            @Override
            public void consume(String metricName, Integer brokerId, TelemetryConverter.Summary summary) {
                ConfluentTelemetryReporterSampler.createCruiseControlSummaryMetrics(metricName, brokerId, summary, ccMetrics);
            }
        });
        return ccMetrics;
    }

    private static void createCruiseControlPointMetrics(String name, int brokerId, TelemetryConverter.DataPoint point, List<CruiseControlMetric> ccMetrics) {
        String topic = point.labels().get(TOPIC_KEY);
        long timestamp = point.timestamp();
        switch (name) {
            case "io.confluent.kafka.server/broker_topic/bytes_in/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/bytes_out/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/mirror_bytes_in/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/fetch_from_follower_bytes_out/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/replication_bytes_in/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/replication_bytes_out/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/total_fetch_requests/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/total_fetch_from_follower_requests/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/total_follower_fetch_requests/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/total_produce_requests/rate/1_min": 
            case "io.confluent.kafka.server/broker_topic/messages_in/rate/1_min": {
                ccMetrics.add(ConfluentTelemetryReporterSampler.buildTopicOrAllTopicMetric(name, topic, timestamp, brokerId, point.asDouble()));
                break;
            }
            case "io.confluent.kafka.server/request/requests/rate/1_min": {
                switch (point.labels().get(REQUEST_TYPE_KEY)) {
                    case "Produce": {
                        ccMetrics.add(new BrokerMetric(RawMetricType.BROKER_PRODUCE_REQUEST_RATE, timestamp, brokerId, point.asDouble()));
                        break;
                    }
                    case "FetchConsumer": {
                        ccMetrics.add(new BrokerMetric(RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_RATE, timestamp, brokerId, point.asDouble()));
                        break;
                    }
                    case "FetchFollower": {
                        ccMetrics.add(new BrokerMetric(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_RATE, timestamp, brokerId, point.asDouble()));
                    }
                }
                break;
            }
            case "io.confluent.kafka.server/log/size": {
                int partition = Integer.parseInt(point.labels().get(PARTITION_KEY));
                ccMetrics.add(new PartitionMetric(RawMetricType.PARTITION_SIZE, timestamp, brokerId, topic, partition, (double)point.asInt()));
                break;
            }
            case "io.confluent.kafka.server/server/linux_system_cpu_utilization_1m": {
                ccMetrics.add(new BrokerMetric(RawMetricType.BROKER_CPU_UTIL, timestamp, brokerId, point.asDouble()));
                break;
            }
            case "io.confluent.system/jvm/os/process_cpu_load": {
                ccMetrics.add(new BrokerMetric(RawMetricType.BROKER_CPU_UTIL, timestamp, brokerId, point.asDouble() * 100.0));
                break;
            }
            case "io.confluent.kafka.server/produce/broker_quota": {
                ccMetrics.add(new BrokerMetric(RawMetricType.BROKER_PRODUCE_MIRROR_CAPACITY, timestamp, brokerId, point.asDouble()));
                break;
            }
            case "io.confluent.kafka.server/fetch/broker_quota": {
                ccMetrics.add(new BrokerMetric(RawMetricType.BROKER_CONSUME_CAPACITY, timestamp, brokerId, point.asDouble()));
                break;
            }
            case "io.confluent.system/volume/disk_total_bytes": {
                ccMetrics.add(new BrokerMetric(RawMetricType.BROKER_DISK_CAPACITY, timestamp, brokerId, (double)point.asInt()));
            }
        }
    }

    static void createCruiseControlSummaryMetrics(String name, int brokerId, TelemetryConverter.Summary summary, List<CruiseControlMetric> ccMetrics) {
    }

    private static CruiseControlMetric buildTopicOrAllTopicMetric(String name, String topic, long timestamp, int brokerId, double value) {
        if (topic != null) {
            return new TopicMetric(ConfluentTelemetryReporterSampler.TOPIC_METRIC_MAP.get((Object)name).topicMetricType, timestamp, brokerId, topic, value);
        }
        return new BrokerMetric(ConfluentTelemetryReporterSampler.TOPIC_METRIC_MAP.get((Object)name).allTopicMetricType, timestamp, brokerId, value);
    }

    private static Map<String, TopicAndAllTopicMetricTypes> buildTopicMetricMap() {
        HashMap<String, TopicAndAllTopicMetricTypes> map = new HashMap<String, TopicAndAllTopicMetricTypes>();
        map.put(BYTES_IN_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_BYTES_IN, RawMetricType.ALL_TOPIC_BYTES_IN));
        map.put(MIRROR_BYTES_IN_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.MIRROR_TOPIC_BYTES_IN, RawMetricType.ALL_MIRROR_TOPIC_BYTES_IN));
        map.put(BYTES_OUT_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_BYTES_OUT, RawMetricType.ALL_TOPIC_BYTES_OUT));
        map.put(FETCH_FROM_FOLLOWER_BYTES_OUT_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT, RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT));
        map.put(REPLICATION_BYTES_IN_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_REPLICATION_BYTES_IN, RawMetricType.ALL_TOPIC_REPLICATION_BYTES_IN));
        map.put(REPLICATION_BYTES_OUT_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_REPLICATION_BYTES_OUT, RawMetricType.ALL_TOPIC_REPLICATION_BYTES_OUT));
        map.put(TOTAL_FETCH_REQUEST_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_FETCH_REQUEST_RATE, RawMetricType.ALL_TOPIC_FETCH_REQUEST_RATE));
        map.put(TOTAL_FETCH_FROM_FOLLOWER_REQUEST_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE, RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE));
        map.put(TOTAL_FOLLOWER_FETCH_REQUEST_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_FOLLOWER_FETCH_REQUEST_RATE, RawMetricType.ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE));
        map.put(TOTAL_PRODUCE_REQUEST_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_PRODUCE_REQUEST_RATE, RawMetricType.ALL_TOPIC_PRODUCE_REQUEST_RATE));
        map.put(MESSAGES_IN_PER_SEC, new TopicAndAllTopicMetricTypes(RawMetricType.TOPIC_MESSAGES_IN_PER_SEC, RawMetricType.ALL_TOPIC_MESSAGES_IN_PER_SEC));
        return map;
    }

    private static class TopicAndAllTopicMetricTypes {
        RawMetricType topicMetricType;
        RawMetricType allTopicMetricType;

        TopicAndAllTopicMetricTypes(RawMetricType topicMetricType, RawMetricType allTopicMetricType) {
            this.topicMetricType = topicMetricType;
            this.allTopicMetricType = allTopicMetricType;
        }
    }
}

