/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel;

import com.google.api.expr.v1alpha1.Expr;
import com.google.api.expr.v1alpha1.Reference;
import com.google.api.expr.v1alpha1.SourceInfo;
import com.google.api.expr.v1alpha1.Type;
import java.util.HashMap;
import java.util.Map;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.common.Source;

public final class Ast {
    private final Expr expr;
    private final SourceInfo info;
    private final Source source;
    final Map<Long, Reference> refMap;
    final Map<Long, Type> typeMap;

    public Ast(Expr expr, SourceInfo info, Source source) {
        this(expr, info, source, new HashMap<Long, Reference>(), new HashMap<Long, Type>());
    }

    public Ast(Expr expr, SourceInfo info, Source source, Map<Long, Reference> refMap, Map<Long, Type> typeMap) {
        this.expr = expr;
        this.info = info;
        this.source = source;
        this.refMap = refMap;
        this.typeMap = typeMap;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public boolean isChecked() {
        return this.typeMap != null && !this.typeMap.isEmpty();
    }

    public Source getSource() {
        return this.source;
    }

    public SourceInfo getSourceInfo() {
        return this.info;
    }

    public Type getResultType() {
        if (!this.isChecked()) {
            return Decls.Dyn;
        }
        return this.typeMap.get(this.expr.getId());
    }

    public String toString() {
        return this.source.content();
    }
}

