/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AnalyzerState {
    private static final String IS_PROPOSAL_READY = "isProposalReady";
    private static final String READY_GOALS = "readyGoals";
    private static final String STATUS = "status";
    private static final String READY = "ready";
    private static final String NOT_READY = "notReady";
    private static final String NAME = "name";
    private static final String MODEL_COMPLETE_REQUIREMENT = "modelCompleteRequirement";
    private static final String GOAL_READINESS = "goalReadiness";
    private final boolean isProposalReady;
    private final Map<Goal, Boolean> readyGoals;

    public AnalyzerState(boolean isProposalReady, Map<Goal, Boolean> readyGoals) {
        this.isProposalReady = isProposalReady;
        this.readyGoals = readyGoals;
    }

    public boolean proposalReady() {
        return this.isProposalReady;
    }

    public Map<Goal, Boolean> readyGoals() {
        return this.readyGoals;
    }

    public Map<String, Object> getJsonStructure(boolean verbose) {
        HashMap<String, Object> analyzerState = new HashMap<String, Object>(verbose ? 3 : 2);
        HashSet<String> readyGoalNames = new HashSet<String>();
        for (Map.Entry<Goal, Boolean> entry : this.readyGoals.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            readyGoalNames.add(entry.getKey().name());
        }
        analyzerState.put(IS_PROPOSAL_READY, this.isProposalReady);
        analyzerState.put(READY_GOALS, readyGoalNames);
        if (verbose) {
            ArrayList goalReadinessList = new ArrayList(this.readyGoals.size());
            for (Map.Entry<Goal, Boolean> entry : this.readyGoals.entrySet()) {
                Goal goal = entry.getKey();
                HashMap<String, Object> goalReadinessRecord = new HashMap<String, Object>(3);
                goalReadinessRecord.put(NAME, goal.getClass().getSimpleName());
                goalReadinessRecord.put(MODEL_COMPLETE_REQUIREMENT, goal.clusterModelCompletenessRequirements().getJsonStructure());
                goalReadinessRecord.put(STATUS, entry.getValue() != false ? READY : NOT_READY);
                goalReadinessList.add(goalReadinessRecord);
            }
            analyzerState.put(GOAL_READINESS, goalReadinessList);
        }
        return analyzerState;
    }

    public String toString() {
        HashSet<String> readyGoalNames = new HashSet<String>();
        for (Map.Entry<Goal, Boolean> entry : this.readyGoals.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            readyGoalNames.add(entry.getKey().getClass().getSimpleName());
        }
        return String.format("{%s: %s, %s: %s}", IS_PROPOSAL_READY, this.isProposalReady, READY_GOALS, readyGoalNames);
    }
}

