/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.TopicPartitionMovement;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class OptimizationOptions {
    private final Set<String> excludedTopics;
    private final Set<Integer> excludedBrokersForLeadership;
    private final Set<Integer> excludedBrokersForReplicaMove;
    private final boolean isTriggeredByGoalViolation;
    private final Set<TopicPartitionMovement> oscillatingTopicPartitionMovements;
    private boolean wereProposalsGeneratedByHardGoals;

    private OptimizationOptions(Set<String> excludedTopics, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove, boolean isTriggeredByGoalViolation, Set<TopicPartitionMovement> oscillatingTopicPartitionMovements) {
        this.excludedTopics = excludedTopics;
        this.excludedBrokersForLeadership = excludedBrokersForLeadership;
        this.excludedBrokersForReplicaMove = excludedBrokersForReplicaMove;
        this.isTriggeredByGoalViolation = isTriggeredByGoalViolation;
        this.oscillatingTopicPartitionMovements = oscillatingTopicPartitionMovements;
        this.wereProposalsGeneratedByHardGoals = false;
    }

    public Set<String> excludedTopics() {
        return Collections.unmodifiableSet(this.excludedTopics);
    }

    public Set<Integer> excludedBrokersForLeadership() {
        return Collections.unmodifiableSet(this.excludedBrokersForLeadership);
    }

    public Set<Integer> excludedBrokersForReplicaMove() {
        return Collections.unmodifiableSet(this.excludedBrokersForReplicaMove);
    }

    public boolean isTriggeredByGoalViolation() {
        return this.isTriggeredByGoalViolation;
    }

    public void wereProposalsGeneratedByHardGoals(boolean wereProposalsGeneratedByHardGoals) {
        this.wereProposalsGeneratedByHardGoals = wereProposalsGeneratedByHardGoals;
    }

    public boolean wereProposalsGeneratedByHardGoals() {
        return this.wereProposalsGeneratedByHardGoals;
    }

    public Set<TopicPartitionMovement> oscillatingTopicPartitionMovements() {
        return this.oscillatingTopicPartitionMovements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizationOptions that = (OptimizationOptions)o;
        return this.isTriggeredByGoalViolation == that.isTriggeredByGoalViolation && Objects.equals(this.excludedTopics, that.excludedTopics) && Objects.equals(this.excludedBrokersForLeadership, that.excludedBrokersForLeadership) && Objects.equals(this.excludedBrokersForReplicaMove, that.excludedBrokersForReplicaMove) && Objects.equals(this.oscillatingTopicPartitionMovements, that.oscillatingTopicPartitionMovements);
    }

    public int hashCode() {
        return Objects.hash(this.excludedTopics, this.excludedBrokersForLeadership, this.excludedBrokersForReplicaMove, this.isTriggeredByGoalViolation, this.oscillatingTopicPartitionMovements);
    }

    public String toString() {
        return "OptimizationOptions{excludedTopics=" + String.valueOf(this.excludedTopics) + ", excludedBrokersForLeadership=" + String.valueOf(this.excludedBrokersForLeadership) + ", excludedBrokersForReplicaMove=" + String.valueOf(this.excludedBrokersForReplicaMove) + ", isTriggeredByGoalViolation=" + this.isTriggeredByGoalViolation + ", oscillatingTopicPartitionMovements=" + String.valueOf(this.oscillatingTopicPartitionMovements) + "}";
    }

    public static class Builder {
        private Set<String> excludedTopics = Collections.emptySet();
        private Set<Integer> excludedBrokersForLeadership = Collections.emptySet();
        private Set<Integer> excludedBrokersForReplicaMove = Collections.emptySet();
        private boolean isTriggeredByGoalViolation = false;
        private Set<TopicPartitionMovement> oscillatingTopicPartitionMovements = Collections.emptySet();

        public Builder excludedTopics(Set<String> excludedTopics) {
            this.excludedTopics = excludedTopics;
            return this;
        }

        public Builder oscillatingTopicPartitionMovements(Set<TopicPartitionMovement> topicPartitionMovements) {
            this.oscillatingTopicPartitionMovements = topicPartitionMovements;
            return this;
        }

        public Builder excludedBrokersForLeadership(Set<Integer> excludedBrokersForLeadership) {
            this.excludedBrokersForLeadership = excludedBrokersForLeadership;
            return this;
        }

        public Builder excludedBrokersForReplicaMove(Set<Integer> excludedBrokersForReplicaMove) {
            this.excludedBrokersForReplicaMove = excludedBrokersForReplicaMove;
            return this;
        }

        public Builder triggeredByGoalViolation(boolean isTriggeredByGoalViolation) {
            this.isTriggeredByGoalViolation = isTriggeredByGoalViolation;
            return this;
        }

        public OptimizationOptions build() {
            return new OptimizationOptions(this.excludedTopics, this.excludedBrokersForLeadership, this.excludedBrokersForReplicaMove, this.isTriggeredByGoalViolation, this.oscillatingTopicPartitionMovements);
        }
    }
}

