/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.math3.util.Combinations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCombinator {
    private static final Logger LOG = LoggerFactory.getLogger(EntityCombinator.class);

    public static <T> Iterable<List<T>> multiEntityListIterable(LinkedHashMap<List<T>, Integer> entitiesWithCount) {
        if (entitiesWithCount == null) {
            throw new IllegalArgumentException("List of entities passed in cannot be null.");
        }
        if (entitiesWithCount.size() < 2) {
            throw new IllegalArgumentException("Use Collections.emptyIterator or SingleEntityListIterator for single/empty lists.");
        }
        for (Map.Entry<List<T>, Integer> entityList : entitiesWithCount.entrySet()) {
            int entityListSize = entityList.getKey().size();
            Integer count = entityList.getValue();
            if (count == 0) {
                throw new IllegalArgumentException("Count of 0 specified for list " + String.valueOf(entityList.getKey()));
            }
            if (entityListSize >= count) continue;
            throw new IllegalArgumentException("Cannot choose " + count + " elements out of only " + entityListSize + " elements in collection: " + String.valueOf(entityList.getKey()));
        }
        ArrayList<Map.Entry<List<T>, Integer>> entityWithCountList = new ArrayList<Map.Entry<List<T>, Integer>>(entitiesWithCount.entrySet());
        ListIterator reverseIterator = entityWithCountList.listIterator(entityWithCountList.size());
        Map.Entry lastElement = (Map.Entry)reverseIterator.previous();
        Iterable<List<T>> ret = EntityCombinator.singleEntityListIterable((List)lastElement.getKey(), (Integer)lastElement.getValue());
        while (reverseIterator.hasPrevious()) {
            Map.Entry previousElem = (Map.Entry)reverseIterator.previous();
            Iterable<List<T>> previousElemIt = EntityCombinator.singleEntityListIterable((List)previousElem.getKey(), (Integer)previousElem.getValue());
            CyclicIterable<T> innerIterable = new CyclicIterable<T>(ret);
            ret = new CompositeIterable<T>(previousElemIt, innerIterable);
        }
        return ret;
    }

    public static <T> Iterable<List<T>> multiEntityListBalancedIterable(List<List<T>> entities, int totalEntitiesToSelect) {
        List<List> entitiesWithSpace;
        if (entities == null) {
            throw new IllegalArgumentException("List of entities passed in cannot be null.");
        }
        if (entities.size() < 2) {
            throw new IllegalArgumentException("Use EmptyIterator or SingleEntityListIterator for single/empty lists.");
        }
        if (totalEntitiesToSelect < 1) {
            throw new IllegalArgumentException("Invalid number of entities to select specified: " + totalEntitiesToSelect);
        }
        int totalNumEntities = entities.stream().mapToInt(List::size).sum();
        if (totalNumEntities < totalEntitiesToSelect) {
            throw new IllegalArgumentException("Number of entities in list is less than number of entities to select(" + totalEntitiesToSelect + "): " + String.valueOf(entities));
        }
        int minEntitiesSize = entities.stream().mapToInt(List::size).min().orElse(0);
        if (minEntitiesSize < 1) {
            throw new IllegalArgumentException("Empty entities list passed in: " + String.valueOf(entities));
        }
        LinkedHashMap entitiesWithCount = new LinkedHashMap(entities.size());
        int remainingEntitiesToSelect = totalEntitiesToSelect;
        while (true) {
            if ((entitiesWithSpace = entities.stream().filter(entityList -> entityList.size() > entitiesWithCount.getOrDefault(entityList, 0)).collect(Collectors.toList())).size() == 0 || remainingEntitiesToSelect == 0) {
                return EntityCombinator.multiEntityListIterable(entitiesWithCount);
            }
            if (entitiesWithSpace.size() == 1) {
                entitiesWithCount.merge((List)entitiesWithSpace.get(0), remainingEntitiesToSelect, Integer::sum);
                return EntityCombinator.multiEntityListIterable(entitiesWithCount);
            }
            if (remainingEntitiesToSelect < entitiesWithSpace.size()) break;
            entitiesWithSpace.forEach(entityList -> entitiesWithCount.merge((List)entityList, 1, Integer::sum));
            remainingEntitiesToSelect -= entitiesWithSpace.size();
        }
        int overflow = remainingEntitiesToSelect;
        List<List> overflowEntities = entitiesWithSpace;
        return () -> {
            Iterator overflowIt = EntityCombinator.singleEntityListIterable(overflowEntities, overflow).iterator();
            return new ChainIterator(() -> {
                if (!overflowIt.hasNext()) {
                    return Optional.empty();
                }
                List overflowLists = (List)overflowIt.next();
                LinkedHashMap allEntitiesWithCount = new LinkedHashMap(entitiesWithCount);
                overflowLists.forEach(entityList -> allEntitiesWithCount.merge((List)entityList, 1, Integer::sum));
                return Optional.of(EntityCombinator.multiEntityListIterable(allEntitiesWithCount).iterator());
            });
        };
    }

    public static <T> Iterable<List<T>> singleEntityListIterable(List<T> entities, int count) {
        if (entities == null) {
            throw new IllegalArgumentException("List of entities passed in cannot be null.");
        }
        if (count > entities.size()) {
            throw new IllegalArgumentException("Cannot choose " + count + " elements out of collection of size " + entities.size());
        }
        if (!entities.isEmpty() && count < 1) {
            throw new IllegalArgumentException("Invalid value of elements to pick " + count);
        }
        return entities.isEmpty() ? Collections.emptyList() : new SingleEntityListIterator<T>(entities, count);
    }

    static class CyclicIterable<T>
    implements Iterable<List<T>> {
        private final Iterable<List<T>> iteratorToCycle;

        public CyclicIterable(Iterable<List<T>> iteratorToCycle) {
            this.iteratorToCycle = iteratorToCycle;
        }

        @Override
        public Iterator<List<T>> iterator() {
            return new CyclicIterator<T>(this.iteratorToCycle);
        }
    }

    static class CompositeIterable<T>
    implements Iterable<List<T>> {
        private final Iterable<List<T>> outerIterable;
        private final Iterable<List<T>> innerIterable;

        public CompositeIterable(Iterable<List<T>> outerIterable, Iterable<List<T>> innerIterable) {
            this.outerIterable = outerIterable;
            this.innerIterable = innerIterable;
        }

        @Override
        public Iterator<List<T>> iterator() {
            return new CompositeIterator<T>(this.outerIterable.iterator(), this.innerIterable.iterator());
        }
    }

    private static class SingleEntityListIterator<T>
    implements Iterable<List<T>> {
        private final List<T> entities;
        private final int subsetSize;

        private SingleEntityListIterator(List<T> entities, int subsetSize) {
            this.entities = entities;
            this.subsetSize = subsetSize;
        }

        @Override
        @Nonnull
        public Iterator<List<T>> iterator() {
            return new Iterator<List<T>>(){
                private final Iterator<int[]> entitySubsetIterator;
                {
                    this.entitySubsetIterator = new Combinations(entities.size(), subsetSize).iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entitySubsetIterator.hasNext();
                }

                @Override
                public List<T> next() {
                    int[] entitySubset = this.entitySubsetIterator.next();
                    List ret = Arrays.stream(entitySubset).mapToObj(entities::get).collect(Collectors.toList());
                    LOG.debug("Returning {}, this iterator has more elements: {}", ret, (Object)this.hasNext());
                    return ret;
                }
            };
        }
    }

    static class ChainIterator<T>
    implements Iterator<List<T>> {
        private final Supplier<Optional<Iterator<List<T>>>> iterators;
        private Iterator<List<T>> currentIterator;

        public ChainIterator(Supplier<Optional<Iterator<List<T>>>> iterators) {
            if (iterators == null) {
                throw new IllegalArgumentException("Iterator supplier can't be null.");
            }
            this.iterators = iterators;
            this.setCurrentIterator();
        }

        private void setCurrentIterator() {
            Optional<Iterator<List<Iterator>>> nextIterator = this.iterators.get();
            while (nextIterator.map(it -> !it.hasNext()).orElse(false).booleanValue()) {
                nextIterator = this.iterators.get();
            }
            this.currentIterator = nextIterator.orElse(null);
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public List<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements to return.");
            }
            List<T> nextElem = this.currentIterator.next();
            LOG.debug("returning {}", nextElem);
            if (!this.currentIterator.hasNext()) {
                LOG.debug("Done with current iterator, moving to next one.");
                this.setCurrentIterator();
            }
            return nextElem;
        }
    }

    static class CompositeIterator<T>
    implements Iterator<List<T>> {
        private final Iterator<List<T>> innerIterator;
        private final Iterator<List<T>> outerIterator;
        private List<T> currentOuterElement;
        private boolean innerIteratorRolled = false;
        private boolean hasMoreElements = true;

        public CompositeIterator(Iterator<List<T>> outerIterator, Iterator<List<T>> innerIterator) {
            if (!outerIterator.hasNext()) {
                throw new IllegalArgumentException("Outer iterator initialized with empty iterator: " + String.valueOf(outerIterator));
            }
            if (outerIterator instanceof CyclicIterator) {
                throw new IllegalArgumentException("Outer iterator should not be a cyclic iterator.");
            }
            if (!(innerIterator instanceof CyclicIterator)) {
                throw new IllegalArgumentException("Inner iterator need to be able to cycle through its elements: " + String.valueOf(innerIterator));
            }
            this.innerIterator = innerIterator;
            this.outerIterator = outerIterator;
            ((CyclicIterator)innerIterator).addRollCallback(this::onInnerIteratorRoll);
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements;
        }

        @Override
        public List<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements to return.");
            }
            if (this.currentOuterElement == null || this.innerIteratorRolled) {
                this.currentOuterElement = this.outerIterator.next();
                this.innerIteratorRolled = false;
            }
            ArrayList<T> combinedList = new ArrayList<T>(this.currentOuterElement);
            combinedList.addAll((Collection)this.innerIterator.next());
            LOG.debug("Returning {}, outer iterator elements: {}", combinedList, this.currentOuterElement);
            return combinedList;
        }

        private void onInnerIteratorRoll() {
            LOG.debug("Inner iterator rolled. Outer iterator has more elements : {}", (Object)this.outerIterator.hasNext());
            this.innerIteratorRolled = true;
            this.hasMoreElements = this.outerIterator.hasNext();
        }
    }

    static class CyclicIterator<T>
    implements Iterator<List<T>> {
        private final Iterable<List<T>> iteratorToCycle;
        private Iterator<List<T>> currentIterator;
        private final List<Runnable> rollCallbacks;

        public CyclicIterator(Iterable<List<T>> iteratorToCycle) {
            this.iteratorToCycle = iteratorToCycle;
            this.currentIterator = iteratorToCycle.iterator();
            if (!this.currentIterator.hasNext()) {
                throw new IllegalArgumentException("Cyclic iterator initialized with empty iterator.");
            }
            this.rollCallbacks = new ArrayList<Runnable>();
        }

        public void addRollCallback(Runnable callback) {
            this.rollCallbacks.add(callback);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public List<T> next() {
            List<T> nextElem = this.currentIterator.next();
            LOG.debug("Returning element {}, has more elements: {}", nextElem, (Object)this.hasNext());
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = this.iteratorToCycle.iterator();
                if (!this.currentIterator.hasNext()) {
                    throw new IllegalArgumentException("Cyclic iterator initialized with empty iterator.");
                }
                LOG.debug("Rolled iterator when returning element: {}", nextElem);
                LOG.debug("Notifying {} observers of roll event", (Object)this.rollCallbacks.size());
                this.rollCallbacks.forEach(Runnable::run);
            }
            return nextElem;
        }
    }
}

