/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import io.confluent.cruisecontrol.analyzer.goals.AbstractAcceptanceGoal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovementExclusionGoal
extends AbstractAcceptanceGoal {
    private static final Logger LOG = LoggerFactory.getLogger(MovementExclusionGoal.class);
    private Set<String> excludedTopics = new HashSet<String>();
    private Set<Integer> excludedBrokersForLeadership;

    public MovementExclusionGoal() {
    }

    MovementExclusionGoal(BalancingConstraint constraint) {
        this.balancingConstraint = constraint;
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        this.excludedTopics = optimizationOptions.excludedTopics();
        this.excludedBrokersForLeadership = optimizationOptions.excludedBrokersForLeadership();
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        HashMap<Replica, Broker> destinationBrokersByReplicas = new HashMap<Replica, Broker>();
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        if (sourceBroker == null) {
            LOG.warn("Could not find source broker with id {} in cluster model", (Object)action.sourceBrokerId());
            return ActionAcceptance.BROKER_REJECT;
        }
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        if (destinationBroker == null) {
            LOG.warn("Could not find destination broker with id {} in cluster model", (Object)action.destinationBrokerId());
            return ActionAcceptance.BROKER_REJECT;
        }
        Optional<Replica> sourceReplicaOpt = this.replicaOpt(clusterModel, action);
        if (!sourceReplicaOpt.isPresent()) {
            LOG.warn("Could not find source replica for action {}", (Object)action);
            return ActionAcceptance.REPLICA_REJECT;
        }
        destinationBrokersByReplicas.put(sourceReplicaOpt.get(), destinationBroker);
        if (action.balancingAction() == ActionType.INTER_BROKER_REPLICA_SWAP) {
            Optional<Replica> destReplicaOpt = this.destinationReplicaOpt(clusterModel, action);
            if (!destReplicaOpt.isPresent()) {
                LOG.warn("Could not find destination replica for action {}", (Object)action);
                return ActionAcceptance.REPLICA_REJECT;
            }
            destinationBrokersByReplicas.put(destReplicaOpt.get(), sourceBroker);
        }
        return this.actionAcceptance(action, Collections.singletonList(sourceBroker), destinationBrokersByReplicas);
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return this.actionAcceptance(action, Collections.emptyList(), new HashMap<Replica, Broker>(action.replicaMoves()));
    }

    private ActionAcceptance actionAcceptance(BalancingAction balancingAction, List<Broker> sourceBrokers, Map<Replica, Broker> destinationBrokersByReplicas) {
        if (this.shouldRejectMovementDueToLeadership(destinationBrokersByReplicas, balancingAction.balancingAction())) {
            LOG.trace("Rejecting balancing action {} as one of the destination brokers (id: {}) is excluded for leadership. (all excluded leader broker ids: {})", new Object[]{balancingAction, destinationBrokersByReplicas.values(), this.excludedBrokersForLeadership});
            return ActionAcceptance.BROKER_REJECT;
        }
        Set originalBrokers = destinationBrokersByReplicas.keySet().stream().map(replica -> Broker.Strategy.GENESIS.equals((Object)replica.originalBroker().strategy()) ? replica.broker() : replica.originalBroker()).collect(Collectors.toSet());
        if (MovementExclusionGoal.shouldExclude(balancingAction, new ArrayList<Broker>(originalBrokers), this.excludedTopics)) {
            LOG.trace("Rejecting balancing action {} as the topic it's trying to move ({}) is excluded", (Object)balancingAction, (Object)balancingAction.topicPartition().topic());
            return ActionAcceptance.REPLICA_REJECT;
        }
        List destinationBrokerIds = destinationBrokersByReplicas.values().stream().map(Broker::id).collect(Collectors.toList());
        switch (balancingAction.balancingAction()) {
            case LEADERSHIP_MOVEMENT: 
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case INTER_CELL_PARTITION_MOVEMENT: {
                Set inEligibleSourceBrokerIds = sourceBrokers.stream().filter(b -> !b.isEligibleSource()).map(Broker::id).collect(Collectors.toSet());
                Set inEligibleDestinationBrokerIds = destinationBrokersByReplicas.values().stream().filter(b -> !b.isEligibleDestination()).map(Broker::id).collect(Collectors.toSet());
                if (!inEligibleSourceBrokerIds.isEmpty()) {
                    LOG.trace("Rejecting balancing action {} as one of the source brokers is not an eligible source. (ineligible source brokers: {}, all source brokers {})", new Object[]{balancingAction, inEligibleSourceBrokerIds, sourceBrokers});
                    return ActionAcceptance.BROKER_REJECT;
                }
                if (inEligibleDestinationBrokerIds.isEmpty()) break;
                LOG.trace("Rejecting balancing action {} as one of the destination brokers is not an eligible destination. (ineligible destination brokers: {}, all destination brokers {})", new Object[]{balancingAction, inEligibleDestinationBrokerIds, destinationBrokerIds});
                return ActionAcceptance.BROKER_REJECT;
            }
            case INTER_BROKER_REPLICA_SWAP: {
                Set inEligibleSourceAndDestinationOnSourceBrokerIds = sourceBrokers.stream().filter(b -> !b.isEligibleSource() || !b.isEligibleDestination()).map(Broker::id).collect(Collectors.toSet());
                Set inEligibleSourceAndDestinationOnDestinationBrokerIds = destinationBrokersByReplicas.values().stream().filter(b -> !b.isEligibleSource() || !b.isEligibleDestination()).map(Broker::id).collect(Collectors.toSet());
                if (!inEligibleSourceAndDestinationOnSourceBrokerIds.isEmpty()) {
                    List sourceBrokerIds = sourceBrokers.stream().map(Broker::id).collect(Collectors.toList());
                    LOG.trace("Rejecting balancing action {} as one of the source brokers is not eligible source and destination for replica placement. (ineligible brokers: {}, all source brokers {})", new Object[]{balancingAction, inEligibleSourceAndDestinationOnSourceBrokerIds, sourceBrokerIds});
                    return ActionAcceptance.BROKER_REJECT;
                }
                if (inEligibleSourceAndDestinationOnDestinationBrokerIds.isEmpty()) break;
                LOG.trace("Rejecting balancing action {} as one of the destination brokers is not eligible source and destination for replica placement. (ineligible brokers: {}, all destination brokers {})", new Object[]{balancingAction, inEligibleSourceAndDestinationOnDestinationBrokerIds, destinationBrokerIds});
                return ActionAcceptance.BROKER_REJECT;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognized balancing action %s", new Object[]{balancingAction.balancingAction()}));
            }
        }
        return ActionAcceptance.ACCEPT;
    }

    private boolean shouldRejectMovementDueToLeadership(Map<Replica, Broker> destinationBrokersByReplicas, ActionType actionType) {
        for (Map.Entry<Replica, Broker> destinationBrokersByReplica : destinationBrokersByReplicas.entrySet()) {
            ArrayList<Broker> destinationBroker = new ArrayList<Broker>(Collections.singletonList(destinationBrokersByReplica.getValue()));
            Replica replica = destinationBrokersByReplica.getKey();
            GoalUtils.filterOutBrokersExcludedForLeadership(destinationBroker, this.excludedBrokersForLeadership, replica, actionType);
            if (!destinationBroker.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Optional<Replica> replicaOpt(ClusterModel clusterModel, ReplicaBalancingAction action) {
        return clusterModel.partition(action.topicPartition()).replicas().stream().filter(r -> r.broker().id() == action.sourceBrokerId().intValue()).findFirst();
    }

    private Optional<Replica> destinationReplicaOpt(ClusterModel clusterModel, ReplicaBalancingAction action) {
        if (action.destinationTopicPartition() == null || action.destinationBrokerId() == null) {
            return Optional.empty();
        }
        return clusterModel.partition(action.destinationTopicPartition()).replicas().stream().filter(r -> r.broker().id() == action.destinationBrokerId().intValue()).findFirst();
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }
}

