/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.CapacityGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.IncrementalResourceDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ResourceDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.CapacityStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.IncrementalResourceDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ReplicaDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ResourceDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.CapacityGoalMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.IncrementalResourceDistributionGoalMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.ReplicaDistributionGoalMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.ResourceDistributionGoalMetrics;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class OptimizationMetrics {
    private final Map<String, ResourceDistributionGoalMetrics> resourceGoalMetrics = new HashMap<String, ResourceDistributionGoalMetrics>();
    private final Map<String, IncrementalResourceDistributionGoalMetrics> incrementalResourceGoalMetrics = new HashMap<String, IncrementalResourceDistributionGoalMetrics>();
    private final Map<String, ReplicaDistributionGoalMetrics> replicaGoalMetrics = new HashMap<String, ReplicaDistributionGoalMetrics>();
    private final Map<String, CapacityGoalMetrics> capacityGoalMetrics = new HashMap<String, CapacityGoalMetrics>();
    private final GeneralSBCMetricsRegistry metricsRegistry;
    private final Class<?> metricClass;

    public OptimizationMetrics(GeneralSBCMetricsRegistry metricsRegistry, Class<?> metricClass) {
        this.metricsRegistry = metricsRegistry;
        this.metricClass = metricClass;
    }

    public void recordDistributionBalanceStats(ResourceDistributionAbstractGoal goal, Collection<ResourceDistributionStatsSnapshot> distributionStats) {
        String goalName = goal.name();
        this.resourceGoalMetrics.computeIfAbsent(goalName, v -> new ResourceDistributionGoalMetrics(goalName, this.metricsRegistry, this.metricClass));
        ResourceDistributionGoalMetrics metrics = this.resourceGoalMetrics.get(goalName);
        distributionStats.stream().filter(x -> Cell.isDefaultCellId(x.cellId())).forEach(metrics::update);
    }

    public void recordIncrementalDistributionBalanceStats(IncrementalResourceDistributionGoal goal, Collection<IncrementalResourceDistributionStatsSnapshot> distributionStats) {
        String goalName = goal.name();
        IncrementalResourceDistributionGoalMetrics metrics = this.incrementalResourceGoalMetrics.computeIfAbsent(goalName, v -> new IncrementalResourceDistributionGoalMetrics(goalName, this.metricsRegistry, this.metricClass));
        distributionStats.stream().filter(x -> Cell.isDefaultCellId(x.cellId())).forEach(metrics::update);
    }

    public void recordCapacityStats(CapacityGoal goal, CapacityStatsSnapshot capacityStatsSnapshot) {
        String goalName = goal.name();
        this.capacityGoalMetrics.computeIfAbsent(goalName, v -> new CapacityGoalMetrics(goalName, this.metricsRegistry, this.metricClass));
        CapacityGoalMetrics metrics = this.capacityGoalMetrics.get(goalName);
        metrics.update(capacityStatsSnapshot);
    }

    public void recordDistributionBalanceStats(ReplicaDistributionAbstractGoal goal, ReplicaDistributionStatsSnapshot distributionStats) {
        String goalName = goal.name();
        this.replicaGoalMetrics.computeIfAbsent(goalName, v -> new ReplicaDistributionGoalMetrics(goalName, this.metricsRegistry, this.metricClass));
        ReplicaDistributionGoalMetrics metrics = this.replicaGoalMetrics.get(goalName);
        metrics.update(distributionStats);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizationMetrics that = (OptimizationMetrics)o;
        return Objects.equals(this.resourceGoalMetrics, that.resourceGoalMetrics) && Objects.equals(this.replicaGoalMetrics, that.replicaGoalMetrics) && Objects.equals(this.metricsRegistry, that.metricsRegistry) && Objects.equals(this.metricClass, that.metricClass);
    }

    public int hashCode() {
        return Objects.hash(this.resourceGoalMetrics, this.replicaGoalMetrics, this.metricsRegistry, this.metricClass);
    }
}

