/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ResourceDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.BaseDistributionGoalMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.BrokerResourceMetric;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ResourceDistributionGoalMetrics
extends BaseDistributionGoalMetrics {
    static final String NUM_BROKERS_UNDER_LOW_UTIL_METRIC_NAME = "num-brokers-under-low-utilization-threshold";
    static final String LOW_UTILIZATION_THRESHOLD_METRIC_NAME = "low-utilization-threshold";
    private volatile int numBrokersUnderLowUtilizationThreshold;
    private volatile double lowUtilizationThresholdValue;

    public ResourceDistributionGoalMetrics(String goalName, GeneralSBCMetricsRegistry metricsRegistry, Class<?> metricClass) {
        super(goalName, metricsRegistry, metricClass);
    }

    ResourceDistributionGoalMetrics(BrokerResourceMetric.Builder maxBrokerResourceBuilder, BrokerResourceMetric.Builder minBrokerResourceBuilder, String goalName, GeneralSBCMetricsRegistry metricsRegistry, Class<?> metricClass) {
        super(maxBrokerResourceBuilder, minBrokerResourceBuilder, goalName, metricsRegistry, metricClass);
    }

    public synchronized void update(ResourceDistributionStatsSnapshot statsSnapshot) {
        this.update(statsSnapshot.maxBrokerResource(), statsSnapshot.minBrokerResource(), statsSnapshot.resourceValueThresholds().balanceLowerValueThreshold, statsSnapshot.resourceValueThresholds().balanceUpperValueThreshold);
        this.numBrokersUnderLowUtilizationThreshold = statsSnapshot.numBrokersUnderLowUtilizationThreshold();
        this.lowUtilizationThresholdValue = statsSnapshot.resourceValueThresholds().lowUtilizationValueThreshold;
    }

    @Override
    protected void registerMetrics(Class<?> metricClass) {
        super.registerMetrics(metricClass);
        this.metricsRegistry.newGauge(metricClass, NUM_BROKERS_UNDER_LOW_UTIL_METRIC_NAME, () -> this.numBrokersUnderLowUtilizationThreshold, new TreeMap<String, String>(this.tags));
        this.metricsRegistry.newGauge(metricClass, LOW_UTILIZATION_THRESHOLD_METRIC_NAME, () -> this.lowUtilizationThresholdValue, new TreeMap<String, String>(this.tags));
    }
}

