/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.client;

import com.linkedin.kafka.cruisecontrol.client.BlockingSend;
import com.linkedin.kafka.cruisecontrol.client.ConnectionException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitiateShutdownRequest;
import org.apache.kafka.common.requests.InitiateShutdownResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.network.BrokerEndPoint;

@NotThreadSafe
public class BlockingSendClient
implements BlockingSend,
AutoCloseable {
    private final KafkaConfig config;
    private final int socketTimeout;
    private final Time time;
    private final KafkaClient networkClient;
    private final Optional<? extends Reconfigurable> reconfigurableChannelBuilder;
    private final Node targetNode;

    BlockingSendClient(Node targetBroker, KafkaConfig config, int socketTimeout, Time time, KafkaClient networkClient, Optional<? extends Reconfigurable> reconfigurableChannelBuilder) {
        this.config = config;
        this.socketTimeout = socketTimeout;
        this.time = time;
        this.networkClient = networkClient;
        this.reconfigurableChannelBuilder = reconfigurableChannelBuilder;
        this.targetNode = targetBroker;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) throws IOException {
        boolean connected;
        try {
            connected = NetworkClientUtils.awaitReady((KafkaClient)this.networkClient, (Node)this.targetNode, (Time)this.time, (long)this.socketTimeout);
        }
        catch (Exception e) {
            this.networkClient.close(this.targetNode.idString());
            throw new ConnectionException(String.format("Failed to establish connection to node %d", this.targetNode.id()), e);
        }
        if (!connected) {
            this.networkClient.close(this.targetNode.idString());
            throw new ConnectionException(String.format("Failed to connect to node %d within %d ms", this.targetNode.id(), this.socketTimeout), new SocketTimeoutException());
        }
        try {
            ClientRequest clientRequest = this.networkClient.newClientRequest(this.targetNode.idString(), requestBuilder, this.time.milliseconds(), true);
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient, (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (IOException e) {
            this.networkClient.close(this.targetNode.idString());
            throw e;
        }
    }

    public InitiateShutdownResponse sendShutdownRequest(InitiateShutdownRequest.Builder shutdownRequestBuilder) throws IOException {
        return (InitiateShutdownResponse)this.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)shutdownRequestBuilder).responseBody();
    }

    @Override
    public void initiateClose() {
        this.networkClient.initiateClose();
    }

    @Override
    public void close() throws Exception {
        this.reconfigurableChannelBuilder.ifPresent(arg_0 -> ((KafkaConfig)this.config).removeReconfigurable(arg_0));
        this.networkClient.close();
    }

    public static class Builder {
        private static final String METRIC_GROUP_PREFIX = "sbk-internal-broker-client";
        private final KafkaConfig config;
        private final Time time;
        private final String clientId;
        private final LogContext logContext;

        public Builder(KafkaConfig config, Time time, String clientId, LogContext logContext) {
            this.config = config;
            this.time = time;
            this.clientId = clientId;
            this.logContext = logContext;
        }

        public BlockingSendClient build(BrokerEndPoint targetBroker) {
            Optional<Object> reconfigurableChannelBuilder;
            ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.config.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)this.config.interBrokerListenerName(), (String)this.config.saslMechanismInterBrokerProtocol(), (Time)this.time, (LogContext)this.logContext);
            if (channelBuilder instanceof Reconfigurable) {
                Reconfigurable reconfigurableBuilder = (Reconfigurable)channelBuilder;
                this.config.addReconfigurable(reconfigurableBuilder);
                reconfigurableChannelBuilder = Optional.of(reconfigurableBuilder);
            } else {
                reconfigurableChannelBuilder = Optional.empty();
            }
            HashMap<String, String> metricTags = new HashMap<String, String>();
            metricTags.put("broker-id", Integer.toString(targetBroker.id()));
            Selector selector = new Selector(-1, this.config.connectionsMaxIdleMs().longValue(), new Metrics(), this.time, METRIC_GROUP_PREFIX, metricTags, true, channelBuilder, this.logContext);
            int maxInFlightRequestsPerConnection = 1;
            NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), this.clientId, maxInFlightRequestsPerConnection, 0L, 0L, -1, this.config.socketReceiveBufferBytes().intValue(), this.config.requestTimeoutMs().intValue(), this.config.connectionSetupTimeoutMs().longValue(), this.config.connectionSetupTimeoutMaxMs().longValue(), this.time, false, new ApiVersions(), this.logContext, MetadataRecoveryStrategy.NONE);
            Node targetNode = new Node(targetBroker.id(), targetBroker.host(), targetBroker.port());
            return new BlockingSendClient(targetNode, this.config, this.config.controllerSocketTimeoutMs(), this.time, (KafkaClient)networkClient, reconfigurableChannelBuilder);
        }
    }
}

