/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BrokerCapacityConfigFileResolver
implements BrokerCapacityConfigResolver {
    public static final String CAPACITY_CONFIG_FILE = "capacity.config.file";
    public static final int DEFAULT_CAPACITY_BROKER_ID = -1;
    private static final String NUM_CORES_CONFIG = "num.cores";
    public static final double DEFAULT_CPU_CAPACITY_WITH_CORES = 100.0;
    private static Map<Integer, BrokerCapacityInfo> capacitiesForBrokers;

    @Override
    public void configure(Map<String, ?> configs) {
        String configFile = KafkaCruiseControlUtils.getRequiredConfig(configs, CAPACITY_CONFIG_FILE);
        try {
            this.loadCapacities(configFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public BrokerCapacityInfo capacityForBroker(String rack, String host, int brokerId) {
        if (brokerId >= 0) {
            BrokerCapacityInfo capacity = capacitiesForBrokers.get(brokerId);
            if (capacity != null) {
                return capacity;
            }
            String info = String.format("Missing broker id(%d) in capacity config file.", brokerId);
            return BrokerCapacityInfo.builder().capacity(capacitiesForBrokers.get(-1).capacity()).estimationInfo(info).numCpuCores(capacitiesForBrokers.get(-1).numCpuCores()).build();
        }
        throw new IllegalArgumentException("The broker id(" + brokerId + ") should be non-negative.");
    }

    private static Short getUserSpecifiedNumCores(Map<Resource, Object> brokerCapacity) {
        if (brokerCapacity.get((Object)Resource.CPU) instanceof Map) {
            String stringNumCores = (String)((Map)brokerCapacity.get((Object)Resource.CPU)).get(NUM_CORES_CONFIG);
            if (stringNumCores == null) {
                throw new IllegalArgumentException("Missing num.cores config for brokers in capacity config file.");
            }
            return Short.parseShort(stringNumCores);
        }
        return null;
    }

    private static Map<Resource, Double> getTotalCapacity(Map<Resource, Object> brokerCapacity, boolean hasNumCores) {
        HashMap<Resource, Double> totalCapacity = new HashMap<Resource, Double>(brokerCapacity.size());
        brokerCapacity.forEach((key, value) -> totalCapacity.put((Resource)((Object)key), hasNumCores && key == Resource.CPU ? 100.0 : Double.parseDouble((String)value)));
        return totalCapacity;
    }

    private static void numCoresConfigConsistencyChecker(Set<Boolean> numCoresConfigConsistency) {
        if (numCoresConfigConsistency.size() > 1) {
            throw new IllegalArgumentException("Inconsistent num.cores config for brokers in capacity config file. This config must be provided by either all or non of the brokers.");
        }
    }

    private BrokerCapacityInfo getBrokerCapacityInfo(BrokerCapacity bc, Set<Boolean> numCoresConfigConsistency) {
        Short userSpecifiedNumCores = BrokerCapacityConfigFileResolver.getUserSpecifiedNumCores(bc.capacity);
        boolean hasNumCores = userSpecifiedNumCores != null;
        numCoresConfigConsistency.add(hasNumCores);
        BrokerCapacityConfigFileResolver.numCoresConfigConsistencyChecker(numCoresConfigConsistency);
        boolean isDefault = bc.brokerId == -1;
        Map<Resource, Double> totalCapacity = BrokerCapacityConfigFileResolver.getTotalCapacity(bc.capacity, hasNumCores);
        BrokerCapacityInfo.BrokerCapacityInfoBuilder brokerCapacityInfoBuilder = BrokerCapacityInfo.builder().capacity(totalCapacity);
        if (isDefault) {
            brokerCapacityInfoBuilder = brokerCapacityInfoBuilder.estimationInfo("The default broker capacity.");
        }
        if (hasNumCores) {
            brokerCapacityInfoBuilder = brokerCapacityInfoBuilder.numCpuCores(userSpecifiedNumCores);
        }
        return brokerCapacityInfoBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCapacities(String configFile) throws FileNotFoundException {
        InputStream inputStream = null;
        JsonReader reader = null;
        InputStreamReader streamReader = null;
        try {
            if (configFile.startsWith("file:") && configFile.contains("!")) {
                String resourceName = configFile.substring(configFile.lastIndexOf("!") + 1);
                if (resourceName.isEmpty()) {
                    throw new IllegalArgumentException("Invalid JAR path format: " + configFile);
                }
                inputStream = BrokerCapacityConfigFileResolver.class.getResourceAsStream(resourceName);
            } else {
                inputStream = new FileInputStream(configFile);
            }
            streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            reader = new JsonReader((Reader)streamReader);
            this.loadCapacities(reader);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void loadCapacities(JsonReader reader) {
        Gson gson = new Gson();
        Set<BrokerCapacity> brokerCapacities = ((BrokerCapacities)gson.fromJson((JsonReader)reader, BrokerCapacities.class)).brokerCapacities;
        capacitiesForBrokers = new HashMap<Integer, BrokerCapacityInfo>(brokerCapacities.size());
        HashSet<Boolean> numCoresConfigConsistency = new HashSet<Boolean>(1);
        for (BrokerCapacity bc : brokerCapacities) {
            capacitiesForBrokers.put(bc.brokerId, this.getBrokerCapacityInfo(bc, numCoresConfigConsistency));
        }
    }

    private static class BrokerCapacity {
        private final int brokerId;
        private final Map<Resource, Object> capacity;

        BrokerCapacity(int brokerId, Map<Resource, Object> capacity) {
            this.brokerId = brokerId;
            this.capacity = capacity;
        }
    }

    private static class BrokerCapacities {
        private Set<BrokerCapacity> brokerCapacities;

        private BrokerCapacities() {
        }
    }
}

