/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.CircularBuffer;
import com.linkedin.kafka.cruisecontrol.config.GoalConfigChangeNotifier;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyHistoryChecker;
import com.linkedin.kafka.cruisecontrol.detector.BrokerLivenessListener;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelCheckpoint;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.yammer.metrics.core.Meter;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.operation.SelfHealingStateTracker;
import io.confluent.databalancer.operation.V2AdditionChecker;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalViolationDetector
implements BrokerLivenessListener,
AnomalyHistoryChecker {
    private static final Logger LOG = LoggerFactory.getLogger(GoalViolationDetector.class);
    public static final String FIXABLE_GOAL_VIOLATION_DETECTION_METRIC_NAME = "fixable-goal-violation-detection-rate";
    public static final String UNFIXABLE_GOAL_VIOLATION_DETECTION_METRIC_NAME = "unfixable-goal-violation-detection-rate";
    private static final int VIOLATIONS_HISTORY_SIZE = 3;
    private final KafkaCruiseControl kafkaCruiseControl;
    private final LoadMonitor loadMonitor;
    private final SelfHealingStateTracker selfHealingStateTracker;
    private final V2AdditionChecker additionChecker;
    private final Time time;
    private final Queue<Anomaly> anomalies;
    private final CircularBuffer<GoalViolations> violationsHistory;
    private final Pattern excludedTopics;
    private final boolean allowCapacityEstimation;
    private final boolean excludeRecentlyRemovedBrokers;
    private final long deferGoalDetectionOnNewMembersDelayMs;
    private final double balancednessPriorityWeight;
    private final double balancednessStrictnessWeight;
    private final UpdatableSbcGoalsConfig updatableSbcGoalsConfig;
    private final OptimizationMetrics optimizationMetrics;
    private final ConcurrentMap<String, GoalViolationMetrics> goalViolationMetrics;
    private final AtomicReference<Set<Integer>> failedBrokers;
    private static AtomicLong resumeDetectionTimeMs;
    private final ApiStatePersistenceStore persistenceStore;
    private Map<String, Double> balancednessCostByGoal = new HashMap<String, Double>();
    private volatile double balancednessScore;

    public GoalViolationDetector(KafkaCruiseControlConfig kccConfig, LoadMonitor loadMonitor, Queue<Anomaly> anomalies, Time time, KafkaCruiseControl kafkaCruiseControl, UpdatableSbcGoalsConfig updatableSbcGoalsConfig, KafkaCruiseControl.CcStartupMode startupMode, final GeneralSBCMetricsRegistry metricsRegistry, V2AdditionChecker additionChecker, ApiStatePersistenceStore persistenceStore) {
        try {
            this.loadMonitor = loadMonitor;
            this.anomalies = anomalies;
            this.violationsHistory = new CircularBuffer(3);
            this.time = time;
            this.persistenceStore = persistenceStore;
            this.excludedTopics = Pattern.compile(kccConfig.getString("topics.excluded.from.partition.movement"));
            this.allowCapacityEstimation = kccConfig.getBoolean("anomaly.detection.allow.capacity.estimation");
            this.excludeRecentlyRemovedBrokers = kccConfig.getBoolean("goal.violation.exclude.recently.removed.brokers");
            this.deferGoalDetectionOnNewMembersDelayMs = kccConfig.getLong("goal.violation.delay.on.new.brokers.ms");
            this.kafkaCruiseControl = kafkaCruiseControl;
            this.updatableSbcGoalsConfig = updatableSbcGoalsConfig;
            this.balancednessPriorityWeight = kccConfig.getDouble("goal.balancedness.priority.weight");
            this.balancednessStrictnessWeight = kccConfig.getDouble("goal.balancedness.strictness.weight");
            this.optimizationMetrics = new OptimizationMetrics(metricsRegistry, this.getClass());
            this.goalViolationMetrics = new ConcurrentHashMap<String, GoalViolationMetrics>();
            this.failedBrokers = new AtomicReference();
            this.failedBrokers.set(Collections.emptySet());
            this.balancednessScore = 100.0;
            resumeDetectionTimeMs = new AtomicLong(0L);
            updatableSbcGoalsConfig.registerListener(new GoalConfigChangeNotifier.GoalConfigChangeListener("goal-violation-metrics-update-listener"){

                @Override
                public void onChange(SbcGoalsConfig newConfig) {
                    GoalViolationDetector.this.maybeRegisterMetrics(metricsRegistry, newConfig);
                }
            });
            this.maybeRegisterMetrics(metricsRegistry, updatableSbcGoalsConfig.config());
            if (startupMode != KafkaCruiseControl.CcStartupMode.ON_ENABLE) {
                resumeDetectionTimeMs.set(this.time.milliseconds() + this.deferGoalDetectionOnNewMembersDelayMs);
            }
            this.selfHealingStateTracker = new SelfHealingStateTracker(kccConfig);
            this.additionChecker = additionChecker;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while starting GVD.", e);
        }
    }

    public double balancednessScore() {
        return this.balancednessScore;
    }

    @Override
    public void notifyNewAddingBrokers(Set<Integer> newAddingBrokers) {
    }

    @Override
    public void notifyNewlyOnlineBrokers(Set<Integer> newlyOnlineBrokers) {
        if (newlyOnlineBrokers.isEmpty()) {
            return;
        }
        long deferGoalDetectionOnNewMembersDelayMs = this.deferGoalDetectionOnNewMembersDelayMs();
        long nextDetectionTime = this.time.milliseconds() + deferGoalDetectionOnNewMembersDelayMs;
        resumeDetectionTimeMs.set(nextDetectionTime);
        LOG.info("Notified of new brokers {} - pausing goal violation detection for {}ms until {}", new Object[]{newlyOnlineBrokers, deferGoalDetectionOnNewMembersDelayMs, resumeDetectionTimeMs.get()});
    }

    @Override
    public void notifyDeadBrokers(Set<Integer> deadBrokers) {
        Set<Integer> oldDeadBrokers = this.failedBrokers.getAndSet(deadBrokers);
        LOG.info("GoalViolationDetector's view on DEAD brokers are updated from {} to {}.", oldDeadBrokers, deadBrokers);
    }

    boolean shouldSkipGoalViolationDetection(ClusterModel clusterModel) {
        Map<Integer, Long> brokersWithOfflineReplicas = this.persistenceStore.getFailedBrokerIds(this.loadMonitor.maybeRefreshClusterAndGeneration().cluster());
        if (!brokersWithOfflineReplicas.isEmpty()) {
            List prettifiedStringForLogging = brokersWithOfflineReplicas.entrySet().stream().map(x -> String.format("Broker id %s marked dead since %s", x.getKey(), KafkaCruiseControlUtils.toTimeString((Long)x.getValue()))).collect(Collectors.toList());
            LOG.info("Skipping goal violation detection because there are dead brokers in the cluster, flawed brokers: {}", prettifiedStringForLogging);
            this.setBalancednessWithOfflineReplicas();
            return true;
        }
        if (this.skipDueToOfflineReplicas(clusterModel)) {
            return true;
        }
        if (this.shouldSkipGoalViolationDetectionDueToTime()) {
            LOG.info("Skipping goal violation detection due to previous new broker change - will resume at {} ({})", (Object)KafkaCruiseControlUtils.toTimeString(resumeDetectionTimeMs.get()), (Object)resumeDetectionTimeMs.get());
            return true;
        }
        if (clusterModel.hasReassigningPartitions()) {
            LOG.info("Skipping goal violation detection because there are reassigning partitions in the cluster, reassigning partitions count: {}", (Object)clusterModel.reassigningPartitions().size());
            return true;
        }
        return AnomalyDetectorUtils.shouldSkipAnomalyDetection(this.kafkaCruiseControl, AnomalyType.GOAL_VIOLATION);
    }

    public ModelCompletenessRequirements requirements() {
        return this.updatableSbcGoalsConfig.config().effectiveTriggeringGoals().requirements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detect(ClusterModel clusterModel) {
        try {
            if (this.shouldSkipGoalViolationDetection(clusterModel)) {
                return;
            }
            if (!this.additionChecker.pendingBrokerAdditions().isEmpty()) {
                GoalViolations goalViolations = new GoalViolations(this.kafkaCruiseControl, this.selfHealingStateTracker, this.allowCapacityEstimation, this.excludeRecentlyRemovedBrokers, this.updatableSbcGoalsConfig.config().effectiveRebalancingGoals(), this.failedBrokers.get(), this.time.milliseconds());
                this.anomalies.add(goalViolations);
                this.violationsHistory.add(goalViolations);
                LOG.info("Goal violation detector identified broker additions, running self-healing regardless of triggering goal presence.");
                return;
            }
            Optional<GoalViolations> goalViolationsOpt = this.detectViolations(clusterModel);
            if (!goalViolationsOpt.isPresent()) {
                LOG.info("no goal violations detected.");
                return;
            }
            GoalViolations goalViolations = goalViolationsOpt.get();
            Map<Boolean, List<GoalViolations.GoalResult>> violatedGoalsByFixability = goalViolations.violatedGoalsByFixability();
            this.recordViolationMetric(violatedGoalsByFixability);
            if (!violatedGoalsByFixability.isEmpty()) {
                LOG.info("Goal violation detector detected violated goals. (fixable: {}, unfixable: {})", violatedGoalsByFixability.get(true), violatedGoalsByFixability.get(false));
                this.anomalies.add(goalViolations);
                this.violationsHistory.add(goalViolations);
            } else {
                LOG.info("Goal violation detector did not detect any violated goals.");
                this.kafkaCruiseControl.context().evenClusterLoadStateManager().noGoalViolationsFound();
            }
            this.refreshBalancednessScore(violatedGoalsByFixability.values().stream().flatMap(a -> a.stream().map(g -> g.name)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", (Throwable)e);
        }
        finally {
            LOG.info("Goal violation detection finished.");
        }
    }

    public Optional<GoalViolations> detectViolations(ClusterModel clusterModel) {
        SbcGoalsConfig goalConfigSnapshot = this.updatableSbcGoalsConfig.config();
        GoalsConfig triggeringGoalsConfig = goalConfigSnapshot.effectiveTriggeringGoals();
        GoalsConfig rebalancingGoalsConfig = goalConfigSnapshot.effectiveRebalancingGoals();
        this.balancednessCostByGoal = KafkaCruiseControlUtils.balancednessCostByGoal(triggeringGoalsConfig.goals(), this.balancednessPriorityWeight, this.balancednessStrictnessWeight);
        KafkaCruiseControl.sanityCheckCapacityEstimation(this.allowCapacityEstimation, clusterModel.capacityEstimationInfoByBrokerId());
        HashMap<String, LoadMonitor.CompletenessCheck> skippedGoals = new HashMap<String, LoadMonitor.CompletenessCheck>();
        List<Goal> detectionGoals = triggeringGoalsConfig.goals();
        GoalViolations goalViolations = new GoalViolations(this.kafkaCruiseControl, this.selfHealingStateTracker, this.allowCapacityEstimation, this.excludeRecentlyRemovedBrokers, rebalancingGoalsConfig, this.failedBrokers.get(), this.time.milliseconds());
        LOG.debug("Running goal violation detection for the following goals: {}", detectionGoals);
        Set<Integer> excludedBrokersForLeadership = Collections.emptySet();
        Set<Integer> excludedBrokersForReplicaMove = this.excludeRecentlyRemovedBrokers ? KafkaCruiseControl.recentlyRemovedBrokers(this.kafkaCruiseControl.context()) : Collections.emptySet();
        ClusterModelCheckpoint cp = clusterModel.checkpoint();
        for (Goal goal : detectionGoals) {
            clusterModel.rollbackReplicaActionsUntil(cp);
            LoadMonitor.CompletenessCheck completenessCheck = this.loadMonitor.meetCompletenessRequirements(goal.clusterModelCompletenessRequirements());
            if (!completenessCheck.meetsRequirements) {
                skippedGoals.put(goal.name(), completenessCheck);
                continue;
            }
            boolean violated = this.optimizeForGoal(clusterModel, goal, goalViolations, excludedBrokersForLeadership, excludedBrokersForReplicaMove);
            LOG.debug("Goal {} was {}violated.", (Object)goal.name(), (Object)(violated ? "" : "not "));
        }
        clusterModel.rollbackReplicaActionsUntil(cp);
        if (!skippedGoals.isEmpty()) {
            LOG.info("Skipped goal violation detection because load completeness requirement were not met for the following goals: {}.", skippedGoals);
            return Optional.empty();
        }
        return Optional.of(goalViolations);
    }

    Queue<Anomaly> anomalies() {
        return this.anomalies;
    }

    private boolean skipDueToOfflineReplicas(ClusterModel clusterModel) {
        if (!clusterModel.deadBrokers().isEmpty()) {
            LOG.info("Skipping goal violation detection due to dead brokers {}, which are reported by broker failure detector, and fixed if its self healing configuration is enabled.", clusterModel.deadBrokers());
            this.setBalancednessWithOfflineReplicas();
            return true;
        }
        if (!clusterModel.brokersWithBadDisks().isEmpty()) {
            LOG.info("Skipping goal violation detection due to brokers with bad disks {}, which are reported by disk failure detector, and fixed if its self healing configuration is enabled.", clusterModel.brokersWithBadDisks());
            this.setBalancednessWithOfflineReplicas();
            return true;
        }
        return false;
    }

    private boolean shouldSkipGoalViolationDetectionDueToTime() {
        long now = this.time.milliseconds();
        LOG.debug("Checking goal violation skip time: current time {} ({}), resume time {} ({})", new Object[]{KafkaCruiseControlUtils.toTimeString(now), now, KafkaCruiseControlUtils.toTimeString(resumeDetectionTimeMs.get()), resumeDetectionTimeMs.get()});
        return now < resumeDetectionTimeMs.get();
    }

    private void setBalancednessWithOfflineReplicas() {
        this.balancednessScore = 0.0;
    }

    private void refreshBalancednessScore(List<String> violatedGoals) {
        double computedBalancednessScore = 100.0;
        for (String violatedGoal : violatedGoals) {
            computedBalancednessScore -= this.balancednessCostByGoal.get(violatedGoal).doubleValue();
        }
        this.balancednessScore = computedBalancednessScore;
    }

    private Set<String> excludedTopics(ClusterModel clusterModel) {
        return clusterModel.topics().stream().filter(topic -> this.excludedTopics.matcher((CharSequence)topic).matches()).collect(Collectors.toSet());
    }

    private boolean optimizeForGoal(ClusterModel clusterModel, Goal goal, GoalViolations goalViolations, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove) {
        GoalOptimizationResult optimizeResult;
        if (clusterModel.topics().isEmpty()) {
            LOG.info("Skipping goal violation detection because the cluster model does not have any topic.");
            return false;
        }
        try {
            OptimizationOptions optimizationOptions = new OptimizationOptions.Builder().excludedTopics(this.excludedTopics(clusterModel)).excludedBrokersForLeadership(excludedBrokersForLeadership).excludedBrokersForReplicaMove(excludedBrokersForReplicaMove).triggeredByGoalViolation(true).build();
            optimizeResult = goal.optimize(clusterModel, new HashSet<Goal>(), optimizationOptions, Optional.of(this.optimizationMetrics));
        }
        catch (OptimizationFailureException ofe) {
            goalViolations.addViolation(goal.name(), false, ofe);
            return true;
        }
        if (optimizeResult.hasReplicaChange()) {
            goalViolations.addViolation(goal.name(), true);
            return true;
        }
        if (this.selfHealingStateTracker.isInProgress(goal.name())) {
            goalViolations.addViolation(goal.name(), true);
            LOG.info("Goal {} is added to the fixable violations due to being IN_PROGRESS - it hasn't completely reached its desired balancing thresholds.", (Object)goal);
            return true;
        }
        return false;
    }

    SelfHealingStateTracker selfHealingStateTracker() {
        return this.selfHealingStateTracker;
    }

    private long deferGoalDetectionOnNewMembersDelayMs() {
        return Optional.ofNullable(this.kafkaCruiseControl.context()).map(context -> context.config().getLong("goal.violation.delay.on.new.brokers.ms")).orElse(this.deferGoalDetectionOnNewMembersDelayMs);
    }

    public List<GoalViolations> anomaliesHistory() {
        return this.violationsHistory.values();
    }

    private synchronized void maybeRegisterMetrics(GeneralSBCMetricsRegistry metricsRegistry, SbcGoalsConfig sbcGoalsConfig) {
        for (Goal goal : sbcGoalsConfig.effectiveTriggeringGoals().goals()) {
            if (this.goalViolationMetrics.containsKey(goal.name())) continue;
            Map<String, String> metricTags = Collections.singletonMap("goal", goal.name());
            Meter fixableGoalViolationMeter = metricsRegistry.newMeter(GoalViolationDetector.class, FIXABLE_GOAL_VIOLATION_DETECTION_METRIC_NAME, "violation-detected", TimeUnit.SECONDS, metricTags);
            Meter unfixableGoalViolationMeter = metricsRegistry.newMeter(GoalViolationDetector.class, UNFIXABLE_GOAL_VIOLATION_DETECTION_METRIC_NAME, "violation-detected", TimeUnit.SECONDS, metricTags);
            this.goalViolationMetrics.put(goal.name(), new GoalViolationMetrics(fixableGoalViolationMeter, unfixableGoalViolationMeter));
        }
    }

    private void recordViolationMetric(Map<Boolean, List<GoalViolations.GoalResult>> violatedGoalsByFixability) {
        for (Map.Entry<Boolean, List<GoalViolations.GoalResult>> violatedGoals : violatedGoalsByFixability.entrySet()) {
            for (GoalViolations.GoalResult goalResult : violatedGoals.getValue()) {
                GoalViolationMetrics goalViolationMetrics = (GoalViolationMetrics)this.goalViolationMetrics.get(goalResult.name);
                goalViolationMetrics.recordViolationMetrics(violatedGoals.getKey());
            }
        }
    }

    private static class GoalViolationMetrics {
        public final Meter fixableGoalViolationMeter;
        public final Meter unfixableGoalViolationMeter;

        public GoalViolationMetrics(Meter fixableGoalViolationMeter, Meter unfixableGoalViolationMeter) {
            this.fixableGoalViolationMeter = fixableGoalViolationMeter;
            this.unfixableGoalViolationMeter = unfixableGoalViolationMeter;
        }

        private void recordViolationMetrics(Boolean isFixable) {
            if (isFixable.booleanValue()) {
                this.fixableGoalViolationMeter.mark();
            } else {
                this.unfixableGoalViolationMeter.mark();
            }
        }
    }
}

